/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

@ApiModel(description="InspectBlkioWeightDevice holds information about the relative weight of an individual device node. Weights are used in the I/O scheduler to give relative priority to some accesses.")
public class InspectBlkioWeightDevice
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_PATH = "Path";
    @SerializedName(value="Path")
    private String path;
    public static final String SERIALIZED_NAME_WEIGHT = "Weight";
    @SerializedName(value="Weight")
    private Integer weight;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public InspectBlkioWeightDevice path(String path) {
        this.path = path;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Path is the path to the device this applies to.")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public InspectBlkioWeightDevice weight(Integer weight) {
        this.weight = weight;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Weight is the relative weight the scheduler will use when scheduling I/O.")
    public Integer getWeight() {
        return this.weight;
    }

    public void setWeight(Integer weight) {
        this.weight = weight;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InspectBlkioWeightDevice inspectBlkioWeightDevice = (InspectBlkioWeightDevice)o;
        return Objects.equals(this.path, inspectBlkioWeightDevice.path) && Objects.equals(this.weight, inspectBlkioWeightDevice.weight);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.weight);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InspectBlkioWeightDevice {\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    weight: ").append(this.toIndentedString(this.weight)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in InspectBlkioWeightDevice is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `InspectBlkioWeightDevice` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PATH) != null && !jsonObj.get(SERIALIZED_NAME_PATH).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PATH).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Path` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PATH).toString()));
        }
    }

    public static InspectBlkioWeightDevice fromJson(String jsonString) throws IOException {
        return (InspectBlkioWeightDevice)JSON.getGson().fromJson(jsonString, InspectBlkioWeightDevice.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_PATH);
        openapiFields.add(SERIALIZED_NAME_WEIGHT);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!InspectBlkioWeightDevice.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(InspectBlkioWeightDevice.class));
            return new TypeAdapter<InspectBlkioWeightDevice>(){

                public void write(JsonWriter out, InspectBlkioWeightDevice value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public InspectBlkioWeightDevice read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    InspectBlkioWeightDevice.validateJsonObject(jsonObj);
                    return (InspectBlkioWeightDevice)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

