/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.github.pod4dev.libpodj.model.InspectBlkioThrottleDevice;
import io.github.pod4dev.libpodj.model.InspectBlkioWeightDevice;
import io.github.pod4dev.libpodj.model.InspectDevice;
import io.github.pod4dev.libpodj.model.InspectHostPort;
import io.github.pod4dev.libpodj.model.InspectIDMappings;
import io.github.pod4dev.libpodj.model.InspectLogConfig;
import io.github.pod4dev.libpodj.model.InspectRestartPolicy;
import io.github.pod4dev.libpodj.model.InspectUlimit;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.validation.Valid;

@ApiModel(description="nolint:revive,stylecheck // Field names are fixed for compatibility and cannot be changed.")
public class InspectContainerHostConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_ANNOTATIONS = "Annotations";
    @SerializedName(value="Annotations")
    private Map<String, String> annotations = null;
    public static final String SERIALIZED_NAME_AUTO_REMOVE = "AutoRemove";
    @SerializedName(value="AutoRemove")
    private Boolean autoRemove;
    public static final String SERIALIZED_NAME_AUTO_REMOVE_IMAGE = "AutoRemoveImage";
    @SerializedName(value="AutoRemoveImage")
    private Boolean autoRemoveImage;
    public static final String SERIALIZED_NAME_BINDS = "Binds";
    @SerializedName(value="Binds")
    private List<String> binds = null;
    public static final String SERIALIZED_NAME_BLKIO_DEVICE_READ_BPS = "BlkioDeviceReadBps";
    @SerializedName(value="BlkioDeviceReadBps")
    private List<InspectBlkioThrottleDevice> blkioDeviceReadBps = null;
    public static final String SERIALIZED_NAME_BLKIO_DEVICE_READ_I_OPS = "BlkioDeviceReadIOps";
    @SerializedName(value="BlkioDeviceReadIOps")
    private List<InspectBlkioThrottleDevice> blkioDeviceReadIOps = null;
    public static final String SERIALIZED_NAME_BLKIO_DEVICE_WRITE_BPS = "BlkioDeviceWriteBps";
    @SerializedName(value="BlkioDeviceWriteBps")
    private List<InspectBlkioThrottleDevice> blkioDeviceWriteBps = null;
    public static final String SERIALIZED_NAME_BLKIO_DEVICE_WRITE_I_OPS = "BlkioDeviceWriteIOps";
    @SerializedName(value="BlkioDeviceWriteIOps")
    private List<InspectBlkioThrottleDevice> blkioDeviceWriteIOps = null;
    public static final String SERIALIZED_NAME_BLKIO_WEIGHT = "BlkioWeight";
    @SerializedName(value="BlkioWeight")
    private Integer blkioWeight;
    public static final String SERIALIZED_NAME_BLKIO_WEIGHT_DEVICE = "BlkioWeightDevice";
    @SerializedName(value="BlkioWeightDevice")
    private List<InspectBlkioWeightDevice> blkioWeightDevice = null;
    public static final String SERIALIZED_NAME_CAP_ADD = "CapAdd";
    @SerializedName(value="CapAdd")
    private List<String> capAdd = null;
    public static final String SERIALIZED_NAME_CAP_DROP = "CapDrop";
    @SerializedName(value="CapDrop")
    private List<String> capDrop = null;
    public static final String SERIALIZED_NAME_CGROUP = "Cgroup";
    @SerializedName(value="Cgroup")
    private String cgroup;
    public static final String SERIALIZED_NAME_CGROUP_CONF = "CgroupConf";
    @SerializedName(value="CgroupConf")
    private Map<String, String> cgroupConf = null;
    public static final String SERIALIZED_NAME_CGROUP_MANAGER = "CgroupManager";
    @SerializedName(value="CgroupManager")
    private String cgroupManager;
    public static final String SERIALIZED_NAME_CGROUP_MODE = "CgroupMode";
    @SerializedName(value="CgroupMode")
    private String cgroupMode;
    public static final String SERIALIZED_NAME_CGROUP_PARENT = "CgroupParent";
    @SerializedName(value="CgroupParent")
    private String cgroupParent;
    public static final String SERIALIZED_NAME_CGROUPS = "Cgroups";
    @SerializedName(value="Cgroups")
    private String cgroups;
    public static final String SERIALIZED_NAME_CONSOLE_SIZE = "ConsoleSize";
    @SerializedName(value="ConsoleSize")
    private List<Integer> consoleSize = null;
    public static final String SERIALIZED_NAME_CONTAINER_I_D_FILE = "ContainerIDFile";
    @SerializedName(value="ContainerIDFile")
    private String containerIDFile;
    public static final String SERIALIZED_NAME_CPU_COUNT = "CpuCount";
    @SerializedName(value="CpuCount")
    private Integer cpuCount;
    public static final String SERIALIZED_NAME_CPU_PERCENT = "CpuPercent";
    @SerializedName(value="CpuPercent")
    private Integer cpuPercent;
    public static final String SERIALIZED_NAME_CPU_PERIOD = "CpuPeriod";
    @SerializedName(value="CpuPeriod")
    private Integer cpuPeriod;
    public static final String SERIALIZED_NAME_CPU_QUOTA = "CpuQuota";
    @SerializedName(value="CpuQuota")
    private Long cpuQuota;
    public static final String SERIALIZED_NAME_CPU_REALTIME_PERIOD = "CpuRealtimePeriod";
    @SerializedName(value="CpuRealtimePeriod")
    private Integer cpuRealtimePeriod;
    public static final String SERIALIZED_NAME_CPU_REALTIME_RUNTIME = "CpuRealtimeRuntime";
    @SerializedName(value="CpuRealtimeRuntime")
    private Long cpuRealtimeRuntime;
    public static final String SERIALIZED_NAME_CPU_SHARES = "CpuShares";
    @SerializedName(value="CpuShares")
    private Integer cpuShares;
    public static final String SERIALIZED_NAME_CPUSET_CPUS = "CpusetCpus";
    @SerializedName(value="CpusetCpus")
    private String cpusetCpus;
    public static final String SERIALIZED_NAME_CPUSET_MEMS = "CpusetMems";
    @SerializedName(value="CpusetMems")
    private String cpusetMems;
    public static final String SERIALIZED_NAME_DEVICES = "Devices";
    @SerializedName(value="Devices")
    private List<InspectDevice> devices = null;
    public static final String SERIALIZED_NAME_DISK_QUOTA = "DiskQuota";
    @SerializedName(value="DiskQuota")
    private Integer diskQuota;
    public static final String SERIALIZED_NAME_DNS = "Dns";
    @SerializedName(value="Dns")
    private List<String> dns = null;
    public static final String SERIALIZED_NAME_DNS_OPTIONS = "DnsOptions";
    @SerializedName(value="DnsOptions")
    private List<String> dnsOptions = null;
    public static final String SERIALIZED_NAME_DNS_SEARCH = "DnsSearch";
    @SerializedName(value="DnsSearch")
    private List<String> dnsSearch = null;
    public static final String SERIALIZED_NAME_EXTRA_HOSTS = "ExtraHosts";
    @SerializedName(value="ExtraHosts")
    private List<String> extraHosts = null;
    public static final String SERIALIZED_NAME_GROUP_ADD = "GroupAdd";
    @SerializedName(value="GroupAdd")
    private List<String> groupAdd = null;
    public static final String SERIALIZED_NAME_ID_MAPPINGS = "IDMappings";
    @SerializedName(value="IDMappings")
    private InspectIDMappings idMappings;
    public static final String SERIALIZED_NAME_IO_MAXIMUM_BANDWIDTH = "IOMaximumBandwidth";
    @SerializedName(value="IOMaximumBandwidth")
    private Integer ioMaximumBandwidth;
    public static final String SERIALIZED_NAME_IO_MAXIMUM_I_OPS = "IOMaximumIOps";
    @SerializedName(value="IOMaximumIOps")
    private Integer ioMaximumIOps;
    public static final String SERIALIZED_NAME_INIT = "Init";
    @SerializedName(value="Init")
    private Boolean init;
    public static final String SERIALIZED_NAME_INTEL_RDT_CLOS_I_D = "IntelRdtClosID";
    @SerializedName(value="IntelRdtClosID")
    private String intelRdtClosID;
    public static final String SERIALIZED_NAME_IPC_MODE = "IpcMode";
    @SerializedName(value="IpcMode")
    private String ipcMode;
    public static final String SERIALIZED_NAME_ISOLATION = "Isolation";
    @SerializedName(value="Isolation")
    private String isolation;
    public static final String SERIALIZED_NAME_KERNEL_MEMORY = "KernelMemory";
    @SerializedName(value="KernelMemory")
    private Long kernelMemory;
    public static final String SERIALIZED_NAME_LINKS = "Links";
    @SerializedName(value="Links")
    private List<String> links = null;
    public static final String SERIALIZED_NAME_LOG_CONFIG = "LogConfig";
    @SerializedName(value="LogConfig")
    private InspectLogConfig logConfig;
    public static final String SERIALIZED_NAME_MEMORY = "Memory";
    @SerializedName(value="Memory")
    private Long memory;
    public static final String SERIALIZED_NAME_MEMORY_RESERVATION = "MemoryReservation";
    @SerializedName(value="MemoryReservation")
    private Long memoryReservation;
    public static final String SERIALIZED_NAME_MEMORY_SWAP = "MemorySwap";
    @SerializedName(value="MemorySwap")
    private Long memorySwap;
    public static final String SERIALIZED_NAME_MEMORY_SWAPPINESS = "MemorySwappiness";
    @SerializedName(value="MemorySwappiness")
    private Long memorySwappiness;
    public static final String SERIALIZED_NAME_NANO_CPUS = "NanoCpus";
    @SerializedName(value="NanoCpus")
    private Long nanoCpus;
    public static final String SERIALIZED_NAME_NETWORK_MODE = "NetworkMode";
    @SerializedName(value="NetworkMode")
    private String networkMode;
    public static final String SERIALIZED_NAME_OOM_KILL_DISABLE = "OomKillDisable";
    @SerializedName(value="OomKillDisable")
    private Boolean oomKillDisable;
    public static final String SERIALIZED_NAME_OOM_SCORE_ADJ = "OomScoreAdj";
    @SerializedName(value="OomScoreAdj")
    private Long oomScoreAdj;
    public static final String SERIALIZED_NAME_PID_MODE = "PidMode";
    @SerializedName(value="PidMode")
    private String pidMode;
    public static final String SERIALIZED_NAME_PIDS_LIMIT = "PidsLimit";
    @SerializedName(value="PidsLimit")
    private Long pidsLimit;
    public static final String SERIALIZED_NAME_PORT_BINDINGS = "PortBindings";
    @SerializedName(value="PortBindings")
    private Map<String, List<InspectHostPort>> portBindings = null;
    public static final String SERIALIZED_NAME_PRIVILEGED = "Privileged";
    @SerializedName(value="Privileged")
    private Boolean privileged;
    public static final String SERIALIZED_NAME_PUBLISH_ALL_PORTS = "PublishAllPorts";
    @SerializedName(value="PublishAllPorts")
    private Boolean publishAllPorts;
    public static final String SERIALIZED_NAME_READONLY_ROOTFS = "ReadonlyRootfs";
    @SerializedName(value="ReadonlyRootfs")
    private Boolean readonlyRootfs;
    public static final String SERIALIZED_NAME_RESTART_POLICY = "RestartPolicy";
    @SerializedName(value="RestartPolicy")
    private InspectRestartPolicy restartPolicy;
    public static final String SERIALIZED_NAME_RUNTIME = "Runtime";
    @SerializedName(value="Runtime")
    private String runtime;
    public static final String SERIALIZED_NAME_SECURITY_OPT = "SecurityOpt";
    @SerializedName(value="SecurityOpt")
    private List<String> securityOpt = null;
    public static final String SERIALIZED_NAME_SHM_SIZE = "ShmSize";
    @SerializedName(value="ShmSize")
    private Long shmSize;
    public static final String SERIALIZED_NAME_TMPFS = "Tmpfs";
    @SerializedName(value="Tmpfs")
    private Map<String, String> tmpfs = null;
    public static final String SERIALIZED_NAME_UT_S_MODE = "UTSMode";
    @SerializedName(value="UTSMode")
    private String utSMode;
    public static final String SERIALIZED_NAME_ULIMITS = "Ulimits";
    @SerializedName(value="Ulimits")
    private List<InspectUlimit> ulimits = null;
    public static final String SERIALIZED_NAME_USERNS_MODE = "UsernsMode";
    @SerializedName(value="UsernsMode")
    private String usernsMode;
    public static final String SERIALIZED_NAME_VOLUME_DRIVER = "VolumeDriver";
    @SerializedName(value="VolumeDriver")
    private String volumeDriver;
    public static final String SERIALIZED_NAME_VOLUMES_FROM = "VolumesFrom";
    @SerializedName(value="VolumesFrom")
    private List<String> volumesFrom = null;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public InspectContainerHostConfig annotations(Map<String, String> annotations) {
        this.annotations = annotations;
        return this;
    }

    public InspectContainerHostConfig putAnnotationsItem(String key, String annotationsItem) {
        if (this.annotations == null) {
            this.annotations = new HashMap<String, String>();
        }
        this.annotations.put(key, annotationsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Annotations are provided to the runtime when the container is started.")
    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Map<String, String> annotations) {
        this.annotations = annotations;
    }

    public InspectContainerHostConfig autoRemove(Boolean autoRemove) {
        this.autoRemove = autoRemove;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="AutoRemove is whether the container will be automatically removed on exiting. It is not handled directly within libpod and is stored in an annotation.")
    public Boolean getAutoRemove() {
        return this.autoRemove;
    }

    public void setAutoRemove(Boolean autoRemove) {
        this.autoRemove = autoRemove;
    }

    public InspectContainerHostConfig autoRemoveImage(Boolean autoRemoveImage) {
        this.autoRemoveImage = autoRemoveImage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="AutoRemoveImage is whether the container's image will be automatically removed on exiting. It is not handled directly within libpod and is stored in an annotation.")
    public Boolean getAutoRemoveImage() {
        return this.autoRemoveImage;
    }

    public void setAutoRemoveImage(Boolean autoRemoveImage) {
        this.autoRemoveImage = autoRemoveImage;
    }

    public InspectContainerHostConfig binds(List<String> binds) {
        this.binds = binds;
        return this;
    }

    public InspectContainerHostConfig addBindsItem(String bindsItem) {
        if (this.binds == null) {
            this.binds = new ArrayList<String>();
        }
        this.binds.add(bindsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Binds contains an array of user-added mounts. Both volume mounts and named volumes are included. Tmpfs mounts are NOT included. In 'docker inspect' this is separated into 'Binds' and 'Mounts' based on how a mount was added. We do not make this distinction and do not include a Mounts field in inspect. Format: <src>:<destination>[:<comma-separated options>]")
    public List<String> getBinds() {
        return this.binds;
    }

    public void setBinds(List<String> binds) {
        this.binds = binds;
    }

    public InspectContainerHostConfig blkioDeviceReadBps(List<InspectBlkioThrottleDevice> blkioDeviceReadBps) {
        this.blkioDeviceReadBps = blkioDeviceReadBps;
        return this;
    }

    public InspectContainerHostConfig addBlkioDeviceReadBpsItem(InspectBlkioThrottleDevice blkioDeviceReadBpsItem) {
        if (this.blkioDeviceReadBps == null) {
            this.blkioDeviceReadBps = new ArrayList<InspectBlkioThrottleDevice>();
        }
        this.blkioDeviceReadBps.add(blkioDeviceReadBpsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="BlkioDeviceReadBps is an array of I/O throttle parameters for individual device nodes. This specifically sets read rate cap in bytes per second for device nodes. As with BlkioWeightDevice, we pull the path from /sys/dev, and we don't guarantee the path will be identical to the original (though the node will be).")
    public List<InspectBlkioThrottleDevice> getBlkioDeviceReadBps() {
        return this.blkioDeviceReadBps;
    }

    public void setBlkioDeviceReadBps(List<InspectBlkioThrottleDevice> blkioDeviceReadBps) {
        this.blkioDeviceReadBps = blkioDeviceReadBps;
    }

    public InspectContainerHostConfig blkioDeviceReadIOps(List<InspectBlkioThrottleDevice> blkioDeviceReadIOps) {
        this.blkioDeviceReadIOps = blkioDeviceReadIOps;
        return this;
    }

    public InspectContainerHostConfig addBlkioDeviceReadIOpsItem(InspectBlkioThrottleDevice blkioDeviceReadIOpsItem) {
        if (this.blkioDeviceReadIOps == null) {
            this.blkioDeviceReadIOps = new ArrayList<InspectBlkioThrottleDevice>();
        }
        this.blkioDeviceReadIOps.add(blkioDeviceReadIOpsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="BlkioDeviceReadIOps is an array of I/O throttle parameters for individual device nodes. This specifically sets the read rate cap in iops per second for device nodes. As with BlkioWeightDevice, we pull the path from /sys/dev, and we don't guarantee the path will be identical to the original (though the node will be).")
    public List<InspectBlkioThrottleDevice> getBlkioDeviceReadIOps() {
        return this.blkioDeviceReadIOps;
    }

    public void setBlkioDeviceReadIOps(List<InspectBlkioThrottleDevice> blkioDeviceReadIOps) {
        this.blkioDeviceReadIOps = blkioDeviceReadIOps;
    }

    public InspectContainerHostConfig blkioDeviceWriteBps(List<InspectBlkioThrottleDevice> blkioDeviceWriteBps) {
        this.blkioDeviceWriteBps = blkioDeviceWriteBps;
        return this;
    }

    public InspectContainerHostConfig addBlkioDeviceWriteBpsItem(InspectBlkioThrottleDevice blkioDeviceWriteBpsItem) {
        if (this.blkioDeviceWriteBps == null) {
            this.blkioDeviceWriteBps = new ArrayList<InspectBlkioThrottleDevice>();
        }
        this.blkioDeviceWriteBps.add(blkioDeviceWriteBpsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="BlkioDeviceWriteBps is an array of I/O throttle parameters for individual device nodes. this specifically sets write rate cap in bytes per second for device nodes. as with BlkioWeightDevice, we pull the path from /sys/dev, and we don't guarantee the path will be identical to the original (though the node will be).")
    public List<InspectBlkioThrottleDevice> getBlkioDeviceWriteBps() {
        return this.blkioDeviceWriteBps;
    }

    public void setBlkioDeviceWriteBps(List<InspectBlkioThrottleDevice> blkioDeviceWriteBps) {
        this.blkioDeviceWriteBps = blkioDeviceWriteBps;
    }

    public InspectContainerHostConfig blkioDeviceWriteIOps(List<InspectBlkioThrottleDevice> blkioDeviceWriteIOps) {
        this.blkioDeviceWriteIOps = blkioDeviceWriteIOps;
        return this;
    }

    public InspectContainerHostConfig addBlkioDeviceWriteIOpsItem(InspectBlkioThrottleDevice blkioDeviceWriteIOpsItem) {
        if (this.blkioDeviceWriteIOps == null) {
            this.blkioDeviceWriteIOps = new ArrayList<InspectBlkioThrottleDevice>();
        }
        this.blkioDeviceWriteIOps.add(blkioDeviceWriteIOpsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="BlkioDeviceWriteIOps is an array of I/O throttle parameters for individual device nodes. This specifically sets the write rate cap in iops per second for device nodes. As with BlkioWeightDevice, we pull the path from /sys/dev, and we don't guarantee the path will be identical to the original (though the node will be).")
    public List<InspectBlkioThrottleDevice> getBlkioDeviceWriteIOps() {
        return this.blkioDeviceWriteIOps;
    }

    public void setBlkioDeviceWriteIOps(List<InspectBlkioThrottleDevice> blkioDeviceWriteIOps) {
        this.blkioDeviceWriteIOps = blkioDeviceWriteIOps;
    }

    public InspectContainerHostConfig blkioWeight(Integer blkioWeight) {
        this.blkioWeight = blkioWeight;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="BlkioWeight indicates the I/O resources allocated to the container. It is a relative weight in the scheduler for assigning I/O time versus other Cgroups.")
    public Integer getBlkioWeight() {
        return this.blkioWeight;
    }

    public void setBlkioWeight(Integer blkioWeight) {
        this.blkioWeight = blkioWeight;
    }

    public InspectContainerHostConfig blkioWeightDevice(List<InspectBlkioWeightDevice> blkioWeightDevice) {
        this.blkioWeightDevice = blkioWeightDevice;
        return this;
    }

    public InspectContainerHostConfig addBlkioWeightDeviceItem(InspectBlkioWeightDevice blkioWeightDeviceItem) {
        if (this.blkioWeightDevice == null) {
            this.blkioWeightDevice = new ArrayList<InspectBlkioWeightDevice>();
        }
        this.blkioWeightDevice.add(blkioWeightDeviceItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="BlkioWeightDevice is an array of I/O resource priorities for individual device nodes. Unfortunately, the spec only stores the device's Major/Minor numbers and not the path, which is used here. Fortunately, the kernel provides an interface for retrieving the path of a given node by major:minor at /sys/dev/. However, the exact path in use may not be what was used in the original CLI invocation - though it is guaranteed that the device node will be the same, and using the given path will be functionally identical.")
    public List<InspectBlkioWeightDevice> getBlkioWeightDevice() {
        return this.blkioWeightDevice;
    }

    public void setBlkioWeightDevice(List<InspectBlkioWeightDevice> blkioWeightDevice) {
        this.blkioWeightDevice = blkioWeightDevice;
    }

    public InspectContainerHostConfig capAdd(List<String> capAdd) {
        this.capAdd = capAdd;
        return this;
    }

    public InspectContainerHostConfig addCapAddItem(String capAddItem) {
        if (this.capAdd == null) {
            this.capAdd = new ArrayList<String>();
        }
        this.capAdd.add(capAddItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="CapAdd is a list of capabilities added to the container. It is not directly stored by Libpod, and instead computed from the capabilities listed in the container's spec, compared against a set of default capabilities.")
    public List<String> getCapAdd() {
        return this.capAdd;
    }

    public void setCapAdd(List<String> capAdd) {
        this.capAdd = capAdd;
    }

    public InspectContainerHostConfig capDrop(List<String> capDrop) {
        this.capDrop = capDrop;
        return this;
    }

    public InspectContainerHostConfig addCapDropItem(String capDropItem) {
        if (this.capDrop == null) {
            this.capDrop = new ArrayList<String>();
        }
        this.capDrop.add(capDropItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="CapDrop is a list of capabilities removed from the container. It is not directly stored by libpod, and instead computed from the capabilities listed in the container's spec, compared against a set of default capabilities.")
    public List<String> getCapDrop() {
        return this.capDrop;
    }

    public void setCapDrop(List<String> capDrop) {
        this.capDrop = capDrop;
    }

    public InspectContainerHostConfig cgroup(String cgroup) {
        this.cgroup = cgroup;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Cgroup contains the container's cgroup. It is presently not populated. TODO.")
    public String getCgroup() {
        return this.cgroup;
    }

    public void setCgroup(String cgroup) {
        this.cgroup = cgroup;
    }

    public InspectContainerHostConfig cgroupConf(Map<String, String> cgroupConf) {
        this.cgroupConf = cgroupConf;
        return this;
    }

    public InspectContainerHostConfig putCgroupConfItem(String key, String cgroupConfItem) {
        if (this.cgroupConf == null) {
            this.cgroupConf = new HashMap<String, String>();
        }
        this.cgroupConf.put(key, cgroupConfItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="CgroupConf is the configuration for cgroup v2.")
    public Map<String, String> getCgroupConf() {
        return this.cgroupConf;
    }

    public void setCgroupConf(Map<String, String> cgroupConf) {
        this.cgroupConf = cgroupConf;
    }

    public InspectContainerHostConfig cgroupManager(String cgroupManager) {
        this.cgroupManager = cgroupManager;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="CgroupManager is the cgroup manager used by the container. At present, allowed values are either \"cgroupfs\" or \"systemd\".")
    public String getCgroupManager() {
        return this.cgroupManager;
    }

    public void setCgroupManager(String cgroupManager) {
        this.cgroupManager = cgroupManager;
    }

    public InspectContainerHostConfig cgroupMode(String cgroupMode) {
        this.cgroupMode = cgroupMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="CgroupMode is the configuration of the container's cgroup namespace. Populated as follows: private - a cgroup namespace has been created host - No cgroup namespace created container:<id> - Using another container's cgroup namespace ns:<path> - A path to a cgroup namespace has been specified")
    public String getCgroupMode() {
        return this.cgroupMode;
    }

    public void setCgroupMode(String cgroupMode) {
        this.cgroupMode = cgroupMode;
    }

    public InspectContainerHostConfig cgroupParent(String cgroupParent) {
        this.cgroupParent = cgroupParent;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="CgroupParent is the Cgroup parent of the container. Only set if not default.")
    public String getCgroupParent() {
        return this.cgroupParent;
    }

    public void setCgroupParent(String cgroupParent) {
        this.cgroupParent = cgroupParent;
    }

    public InspectContainerHostConfig cgroups(String cgroups) {
        this.cgroups = cgroups;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Cgroups contains the container's Cgroup mode. Allowed values are \"default\" (container is creating Cgroups) and \"disabled\" (container is not creating Cgroups). This is Libpod-specific and not included in `docker inspect`.")
    public String getCgroups() {
        return this.cgroups;
    }

    public void setCgroups(String cgroups) {
        this.cgroups = cgroups;
    }

    public InspectContainerHostConfig consoleSize(List<Integer> consoleSize) {
        this.consoleSize = consoleSize;
        return this;
    }

    public InspectContainerHostConfig addConsoleSizeItem(Integer consoleSizeItem) {
        if (this.consoleSize == null) {
            this.consoleSize = new ArrayList<Integer>();
        }
        this.consoleSize.add(consoleSizeItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ConsoleSize is an array of 2 integers showing the size of the container's console. It is only set if the container is creating a terminal. TODO.")
    public List<Integer> getConsoleSize() {
        return this.consoleSize;
    }

    public void setConsoleSize(List<Integer> consoleSize) {
        this.consoleSize = consoleSize;
    }

    public InspectContainerHostConfig containerIDFile(String containerIDFile) {
        this.containerIDFile = containerIDFile;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ContainerIDFile is a file created during container creation to hold the ID of the created container. This is not handled within libpod and is stored in an annotation.")
    public String getContainerIDFile() {
        return this.containerIDFile;
    }

    public void setContainerIDFile(String containerIDFile) {
        this.containerIDFile = containerIDFile;
    }

    public InspectContainerHostConfig cpuCount(Integer cpuCount) {
        this.cpuCount = cpuCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="CpuCount is Windows-only and not presently implemented.")
    public Integer getCpuCount() {
        return this.cpuCount;
    }

    public void setCpuCount(Integer cpuCount) {
        this.cpuCount = cpuCount;
    }

    public InspectContainerHostConfig cpuPercent(Integer cpuPercent) {
        this.cpuPercent = cpuPercent;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="CpuPercent is Windows-only and not presently implemented.")
    public Integer getCpuPercent() {
        return this.cpuPercent;
    }

    public void setCpuPercent(Integer cpuPercent) {
        this.cpuPercent = cpuPercent;
    }

    public InspectContainerHostConfig cpuPeriod(Integer cpuPeriod) {
        this.cpuPeriod = cpuPeriod;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="CpuPeriod is the length of a CPU period in microseconds. It relates directly to CpuQuota.")
    public Integer getCpuPeriod() {
        return this.cpuPeriod;
    }

    public void setCpuPeriod(Integer cpuPeriod) {
        this.cpuPeriod = cpuPeriod;
    }

    public InspectContainerHostConfig cpuQuota(Long cpuQuota) {
        this.cpuQuota = cpuQuota;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="CpuPeriod is the amount of time (in microseconds) that a container can use the CPU in every CpuPeriod.")
    public Long getCpuQuota() {
        return this.cpuQuota;
    }

    public void setCpuQuota(Long cpuQuota) {
        this.cpuQuota = cpuQuota;
    }

    public InspectContainerHostConfig cpuRealtimePeriod(Integer cpuRealtimePeriod) {
        this.cpuRealtimePeriod = cpuRealtimePeriod;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="CpuRealtimePeriod is the length of time (in microseconds) of the CPU realtime period. If set to 0, no time will be allocated to realtime tasks.")
    public Integer getCpuRealtimePeriod() {
        return this.cpuRealtimePeriod;
    }

    public void setCpuRealtimePeriod(Integer cpuRealtimePeriod) {
        this.cpuRealtimePeriod = cpuRealtimePeriod;
    }

    public InspectContainerHostConfig cpuRealtimeRuntime(Long cpuRealtimeRuntime) {
        this.cpuRealtimeRuntime = cpuRealtimeRuntime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="CpuRealtimeRuntime is the length of time (in microseconds) allocated for realtime tasks within every CpuRealtimePeriod.")
    public Long getCpuRealtimeRuntime() {
        return this.cpuRealtimeRuntime;
    }

    public void setCpuRealtimeRuntime(Long cpuRealtimeRuntime) {
        this.cpuRealtimeRuntime = cpuRealtimeRuntime;
    }

    public InspectContainerHostConfig cpuShares(Integer cpuShares) {
        this.cpuShares = cpuShares;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="CpuShares indicates the CPU resources allocated to the container. It is a relative weight in the scheduler for assigning CPU time versus other Cgroups.")
    public Integer getCpuShares() {
        return this.cpuShares;
    }

    public void setCpuShares(Integer cpuShares) {
        this.cpuShares = cpuShares;
    }

    public InspectContainerHostConfig cpusetCpus(String cpusetCpus) {
        this.cpusetCpus = cpusetCpus;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="CpusetCpus is the set of CPUs that the container will execute on. Formatted as `0-3` or `0,2`. Default (if unset) is all CPUs.")
    public String getCpusetCpus() {
        return this.cpusetCpus;
    }

    public void setCpusetCpus(String cpusetCpus) {
        this.cpusetCpus = cpusetCpus;
    }

    public InspectContainerHostConfig cpusetMems(String cpusetMems) {
        this.cpusetMems = cpusetMems;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="CpusetMems is the set of memory nodes the container will use. Formatted as `0-3` or `0,2`. Default (if unset) is all memory nodes.")
    public String getCpusetMems() {
        return this.cpusetMems;
    }

    public void setCpusetMems(String cpusetMems) {
        this.cpusetMems = cpusetMems;
    }

    public InspectContainerHostConfig devices(List<InspectDevice> devices) {
        this.devices = devices;
        return this;
    }

    public InspectContainerHostConfig addDevicesItem(InspectDevice devicesItem) {
        if (this.devices == null) {
            this.devices = new ArrayList<InspectDevice>();
        }
        this.devices.add(devicesItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Devices is a list of device nodes that will be added to the container. These are stored in the OCI spec only as type, major, minor while we display the host path. We convert this with /sys/dev, but we cannot guarantee that the host path will be identical - only that the actual device will be.")
    public List<InspectDevice> getDevices() {
        return this.devices;
    }

    public void setDevices(List<InspectDevice> devices) {
        this.devices = devices;
    }

    public InspectContainerHostConfig diskQuota(Integer diskQuota) {
        this.diskQuota = diskQuota;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="DiskQuota is the maximum amount of disk space the container may use (in bytes). Presently not populated. TODO.")
    public Integer getDiskQuota() {
        return this.diskQuota;
    }

    public void setDiskQuota(Integer diskQuota) {
        this.diskQuota = diskQuota;
    }

    public InspectContainerHostConfig dns(List<String> dns) {
        this.dns = dns;
        return this;
    }

    public InspectContainerHostConfig addDnsItem(String dnsItem) {
        if (this.dns == null) {
            this.dns = new ArrayList<String>();
        }
        this.dns.add(dnsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Dns is a list of DNS nameservers that will be added to the container's resolv.conf")
    public List<String> getDns() {
        return this.dns;
    }

    public void setDns(List<String> dns) {
        this.dns = dns;
    }

    public InspectContainerHostConfig dnsOptions(List<String> dnsOptions) {
        this.dnsOptions = dnsOptions;
        return this;
    }

    public InspectContainerHostConfig addDnsOptionsItem(String dnsOptionsItem) {
        if (this.dnsOptions == null) {
            this.dnsOptions = new ArrayList<String>();
        }
        this.dnsOptions.add(dnsOptionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="DnsOptions is a list of DNS options that will be set in the container's resolv.conf")
    public List<String> getDnsOptions() {
        return this.dnsOptions;
    }

    public void setDnsOptions(List<String> dnsOptions) {
        this.dnsOptions = dnsOptions;
    }

    public InspectContainerHostConfig dnsSearch(List<String> dnsSearch) {
        this.dnsSearch = dnsSearch;
        return this;
    }

    public InspectContainerHostConfig addDnsSearchItem(String dnsSearchItem) {
        if (this.dnsSearch == null) {
            this.dnsSearch = new ArrayList<String>();
        }
        this.dnsSearch.add(dnsSearchItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="DnsSearch is a list of DNS search domains that will be set in the container's resolv.conf")
    public List<String> getDnsSearch() {
        return this.dnsSearch;
    }

    public void setDnsSearch(List<String> dnsSearch) {
        this.dnsSearch = dnsSearch;
    }

    public InspectContainerHostConfig extraHosts(List<String> extraHosts) {
        this.extraHosts = extraHosts;
        return this;
    }

    public InspectContainerHostConfig addExtraHostsItem(String extraHostsItem) {
        if (this.extraHosts == null) {
            this.extraHosts = new ArrayList<String>();
        }
        this.extraHosts.add(extraHostsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ExtraHosts contains hosts that will be added to the container's etc/hosts.")
    public List<String> getExtraHosts() {
        return this.extraHosts;
    }

    public void setExtraHosts(List<String> extraHosts) {
        this.extraHosts = extraHosts;
    }

    public InspectContainerHostConfig groupAdd(List<String> groupAdd) {
        this.groupAdd = groupAdd;
        return this;
    }

    public InspectContainerHostConfig addGroupAddItem(String groupAddItem) {
        if (this.groupAdd == null) {
            this.groupAdd = new ArrayList<String>();
        }
        this.groupAdd.add(groupAddItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="GroupAdd contains groups that the user inside the container will be added to.")
    public List<String> getGroupAdd() {
        return this.groupAdd;
    }

    public void setGroupAdd(List<String> groupAdd) {
        this.groupAdd = groupAdd;
    }

    public InspectContainerHostConfig idMappings(InspectIDMappings idMappings) {
        this.idMappings = idMappings;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public InspectIDMappings getIdMappings() {
        return this.idMappings;
    }

    public void setIdMappings(InspectIDMappings idMappings) {
        this.idMappings = idMappings;
    }

    public InspectContainerHostConfig ioMaximumBandwidth(Integer ioMaximumBandwidth) {
        this.ioMaximumBandwidth = ioMaximumBandwidth;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="IOMaximumBandwidth is Windows-only and not presently implemented.")
    public Integer getIoMaximumBandwidth() {
        return this.ioMaximumBandwidth;
    }

    public void setIoMaximumBandwidth(Integer ioMaximumBandwidth) {
        this.ioMaximumBandwidth = ioMaximumBandwidth;
    }

    public InspectContainerHostConfig ioMaximumIOps(Integer ioMaximumIOps) {
        this.ioMaximumIOps = ioMaximumIOps;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="IOMaximumIOps is Windows-only and not presently implemented.")
    public Integer getIoMaximumIOps() {
        return this.ioMaximumIOps;
    }

    public void setIoMaximumIOps(Integer ioMaximumIOps) {
        this.ioMaximumIOps = ioMaximumIOps;
    }

    public InspectContainerHostConfig init(Boolean init) {
        this.init = init;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Init indicates whether the container has an init mounted into it.")
    public Boolean getInit() {
        return this.init;
    }

    public void setInit(Boolean init) {
        this.init = init;
    }

    public InspectContainerHostConfig intelRdtClosID(String intelRdtClosID) {
        this.intelRdtClosID = intelRdtClosID;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="IntelRdtClosID defines the Intel RDT CAT Class Of Service (COS) that all processes of the container should run in.")
    public String getIntelRdtClosID() {
        return this.intelRdtClosID;
    }

    public void setIntelRdtClosID(String intelRdtClosID) {
        this.intelRdtClosID = intelRdtClosID;
    }

    public InspectContainerHostConfig ipcMode(String ipcMode) {
        this.ipcMode = ipcMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="IpcMode represents the configuration of the container's IPC namespace. Populated as follows: \"\" (empty string) - Default, an IPC namespace will be created host - No IPC namespace created container:<id> - Using another container's IPC namespace ns:<path> - A path to an IPC namespace has been specified")
    public String getIpcMode() {
        return this.ipcMode;
    }

    public void setIpcMode(String ipcMode) {
        this.ipcMode = ipcMode;
    }

    public InspectContainerHostConfig isolation(String isolation) {
        this.isolation = isolation;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Isolation is presently unused and provided solely for Docker compatibility.")
    public String getIsolation() {
        return this.isolation;
    }

    public void setIsolation(String isolation) {
        this.isolation = isolation;
    }

    public InspectContainerHostConfig kernelMemory(Long kernelMemory) {
        this.kernelMemory = kernelMemory;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="KernelMemory is the maximum amount of memory the kernel will devote to the container.")
    public Long getKernelMemory() {
        return this.kernelMemory;
    }

    public void setKernelMemory(Long kernelMemory) {
        this.kernelMemory = kernelMemory;
    }

    public InspectContainerHostConfig links(List<String> links) {
        this.links = links;
        return this;
    }

    public InspectContainerHostConfig addLinksItem(String linksItem) {
        if (this.links == null) {
            this.links = new ArrayList<String>();
        }
        this.links.add(linksItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Links is unused, and provided purely for Docker compatibility.")
    public List<String> getLinks() {
        return this.links;
    }

    public void setLinks(List<String> links) {
        this.links = links;
    }

    public InspectContainerHostConfig logConfig(InspectLogConfig logConfig) {
        this.logConfig = logConfig;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public InspectLogConfig getLogConfig() {
        return this.logConfig;
    }

    public void setLogConfig(InspectLogConfig logConfig) {
        this.logConfig = logConfig;
    }

    public InspectContainerHostConfig memory(Long memory) {
        this.memory = memory;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Memory indicates the memory resources allocated to the container. This is the limit (in bytes) of RAM the container may use.")
    public Long getMemory() {
        return this.memory;
    }

    public void setMemory(Long memory) {
        this.memory = memory;
    }

    public InspectContainerHostConfig memoryReservation(Long memoryReservation) {
        this.memoryReservation = memoryReservation;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="MemoryReservation is the reservation (soft limit) of memory available to the container. Soft limits are warnings only and can be exceeded.")
    public Long getMemoryReservation() {
        return this.memoryReservation;
    }

    public void setMemoryReservation(Long memoryReservation) {
        this.memoryReservation = memoryReservation;
    }

    public InspectContainerHostConfig memorySwap(Long memorySwap) {
        this.memorySwap = memorySwap;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="MemorySwap is the total limit for all memory available to the container, including swap. 0 indicates that there is no limit to the amount of memory available.")
    public Long getMemorySwap() {
        return this.memorySwap;
    }

    public void setMemorySwap(Long memorySwap) {
        this.memorySwap = memorySwap;
    }

    public InspectContainerHostConfig memorySwappiness(Long memorySwappiness) {
        this.memorySwappiness = memorySwappiness;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="MemorySwappiness is the willingness of the kernel to page container memory to swap. It is an integer from 0 to 100, with low numbers being more likely to be put into swap. 1, the default, will not set swappiness and use the system defaults.")
    public Long getMemorySwappiness() {
        return this.memorySwappiness;
    }

    public void setMemorySwappiness(Long memorySwappiness) {
        this.memorySwappiness = memorySwappiness;
    }

    public InspectContainerHostConfig nanoCpus(Long nanoCpus) {
        this.nanoCpus = nanoCpus;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="NanoCpus indicates number of CPUs allocated to the container. It is an integer where one full CPU is indicated by 1000000000 (one billion). Thus, 2.5 CPUs (fractional portions of CPUs are allowed) would be 2500000000 (2.5 billion). In 'docker inspect' this is set exclusively of two further options in the output (CpuPeriod and CpuQuota) which are both used to implement this functionality. We can't distinguish here, so if CpuQuota is set to the default of 100000, we will set both CpuQuota, CpuPeriod, and NanoCpus. If CpuQuota is not the default, we will not set NanoCpus.")
    public Long getNanoCpus() {
        return this.nanoCpus;
    }

    public void setNanoCpus(Long nanoCpus) {
        this.nanoCpus = nanoCpus;
    }

    public InspectContainerHostConfig networkMode(String networkMode) {
        this.networkMode = networkMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="NetworkMode is the configuration of the container's network namespace. Populated as follows: default - A network namespace is being created and configured via CNI none - A network namespace is being created, not configured via CNI host - No network namespace created container:<id> - Using another container's network namespace ns:<path> - A path to a network namespace has been specified")
    public String getNetworkMode() {
        return this.networkMode;
    }

    public void setNetworkMode(String networkMode) {
        this.networkMode = networkMode;
    }

    public InspectContainerHostConfig oomKillDisable(Boolean oomKillDisable) {
        this.oomKillDisable = oomKillDisable;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="OomKillDisable indicates whether the kernel OOM killer is disabled for the container.")
    public Boolean getOomKillDisable() {
        return this.oomKillDisable;
    }

    public void setOomKillDisable(Boolean oomKillDisable) {
        this.oomKillDisable = oomKillDisable;
    }

    public InspectContainerHostConfig oomScoreAdj(Long oomScoreAdj) {
        this.oomScoreAdj = oomScoreAdj;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="OOMScoreAdj is an adjustment that will be made to the container's OOM score.")
    public Long getOomScoreAdj() {
        return this.oomScoreAdj;
    }

    public void setOomScoreAdj(Long oomScoreAdj) {
        this.oomScoreAdj = oomScoreAdj;
    }

    public InspectContainerHostConfig pidMode(String pidMode) {
        this.pidMode = pidMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="PidMode represents the configuration of the container's PID namespace. Populated as follows: \"\" (empty string) - Default, a PID namespace will be created host - No PID namespace created container:<id> - Using another container's PID namespace ns:<path> - A path to a PID namespace has been specified")
    public String getPidMode() {
        return this.pidMode;
    }

    public void setPidMode(String pidMode) {
        this.pidMode = pidMode;
    }

    public InspectContainerHostConfig pidsLimit(Long pidsLimit) {
        this.pidsLimit = pidsLimit;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="PidsLimit is the maximum number of PIDs that may be created within the container. 0, the default, indicates no limit.")
    public Long getPidsLimit() {
        return this.pidsLimit;
    }

    public void setPidsLimit(Long pidsLimit) {
        this.pidsLimit = pidsLimit;
    }

    public InspectContainerHostConfig portBindings(Map<String, List<InspectHostPort>> portBindings) {
        this.portBindings = portBindings;
        return this;
    }

    public InspectContainerHostConfig putPortBindingsItem(String key, List<InspectHostPort> portBindingsItem) {
        if (this.portBindings == null) {
            this.portBindings = new HashMap<String, List<InspectHostPort>>();
        }
        this.portBindings.put(key, portBindingsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="PortBindings contains the container's port bindings. It is formatted as map[string][]InspectHostPort. The string key here is formatted as <integer port number>/<protocol> and represents the container port. A single container port may be bound to multiple host ports (on different IPs).")
    public Map<String, List<InspectHostPort>> getPortBindings() {
        return this.portBindings;
    }

    public void setPortBindings(Map<String, List<InspectHostPort>> portBindings) {
        this.portBindings = portBindings;
    }

    public InspectContainerHostConfig privileged(Boolean privileged) {
        this.privileged = privileged;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Privileged indicates whether the container is running with elevated privileges. This has a very specific meaning in the Docker sense, so it's very difficult to decode from the spec and config, and so is stored as an annotation.")
    public Boolean getPrivileged() {
        return this.privileged;
    }

    public void setPrivileged(Boolean privileged) {
        this.privileged = privileged;
    }

    public InspectContainerHostConfig publishAllPorts(Boolean publishAllPorts) {
        this.publishAllPorts = publishAllPorts;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="PublishAllPorts indicates whether image ports are being published. This is not directly stored in libpod and is saved as an annotation.")
    public Boolean getPublishAllPorts() {
        return this.publishAllPorts;
    }

    public void setPublishAllPorts(Boolean publishAllPorts) {
        this.publishAllPorts = publishAllPorts;
    }

    public InspectContainerHostConfig readonlyRootfs(Boolean readonlyRootfs) {
        this.readonlyRootfs = readonlyRootfs;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ReadonlyRootfs is whether the container will be mounted read-only.")
    public Boolean getReadonlyRootfs() {
        return this.readonlyRootfs;
    }

    public void setReadonlyRootfs(Boolean readonlyRootfs) {
        this.readonlyRootfs = readonlyRootfs;
    }

    public InspectContainerHostConfig restartPolicy(InspectRestartPolicy restartPolicy) {
        this.restartPolicy = restartPolicy;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public InspectRestartPolicy getRestartPolicy() {
        return this.restartPolicy;
    }

    public void setRestartPolicy(InspectRestartPolicy restartPolicy) {
        this.restartPolicy = restartPolicy;
    }

    public InspectContainerHostConfig runtime(String runtime) {
        this.runtime = runtime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Runtime is provided purely for Docker compatibility. It is set unconditionally to \"oci\" as Podman does not presently support non-OCI runtimes.")
    public String getRuntime() {
        return this.runtime;
    }

    public void setRuntime(String runtime) {
        this.runtime = runtime;
    }

    public InspectContainerHostConfig securityOpt(List<String> securityOpt) {
        this.securityOpt = securityOpt;
        return this;
    }

    public InspectContainerHostConfig addSecurityOptItem(String securityOptItem) {
        if (this.securityOpt == null) {
            this.securityOpt = new ArrayList<String>();
        }
        this.securityOpt.add(securityOptItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="SecurityOpt is a list of security-related options that are set in the container.")
    public List<String> getSecurityOpt() {
        return this.securityOpt;
    }

    public void setSecurityOpt(List<String> securityOpt) {
        this.securityOpt = securityOpt;
    }

    public InspectContainerHostConfig shmSize(Long shmSize) {
        this.shmSize = shmSize;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Long getShmSize() {
        return this.shmSize;
    }

    public void setShmSize(Long shmSize) {
        this.shmSize = shmSize;
    }

    public InspectContainerHostConfig tmpfs(Map<String, String> tmpfs) {
        this.tmpfs = tmpfs;
        return this;
    }

    public InspectContainerHostConfig putTmpfsItem(String key, String tmpfsItem) {
        if (this.tmpfs == null) {
            this.tmpfs = new HashMap<String, String>();
        }
        this.tmpfs.put(key, tmpfsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Tmpfs is a list of tmpfs filesystems that will be mounted into the container. It is a map of destination path to options for the mount.")
    public Map<String, String> getTmpfs() {
        return this.tmpfs;
    }

    public void setTmpfs(Map<String, String> tmpfs) {
        this.tmpfs = tmpfs;
    }

    public InspectContainerHostConfig utSMode(String utSMode) {
        this.utSMode = utSMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="UTSMode represents the configuration of the container's UID namespace. Populated as follows: \"\" (empty string) - Default, a UTS namespace will be created host - no UTS namespace created container:<id> - Using another container's UTS namespace ns:<path> - A path to a UTS namespace has been specified")
    public String getUtSMode() {
        return this.utSMode;
    }

    public void setUtSMode(String utSMode) {
        this.utSMode = utSMode;
    }

    public InspectContainerHostConfig ulimits(List<InspectUlimit> ulimits) {
        this.ulimits = ulimits;
        return this;
    }

    public InspectContainerHostConfig addUlimitsItem(InspectUlimit ulimitsItem) {
        if (this.ulimits == null) {
            this.ulimits = new ArrayList<InspectUlimit>();
        }
        this.ulimits.add(ulimitsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Ulimits is a set of ulimits that will be set within the container.")
    public List<InspectUlimit> getUlimits() {
        return this.ulimits;
    }

    public void setUlimits(List<InspectUlimit> ulimits) {
        this.ulimits = ulimits;
    }

    public InspectContainerHostConfig usernsMode(String usernsMode) {
        this.usernsMode = usernsMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="UsernsMode represents the configuration of the container's user namespace. When running rootless, a user namespace is created outside of libpod to allow some privileged operations. This will not be reflected here. Populated as follows: \"\" (empty string) - No user namespace will be created private - The container will be run in a user namespace container:<id> - Using another container's user namespace ns:<path> - A path to a user namespace has been specified TODO Rootless has an additional 'keep-id' option, presently not reflected here.")
    public String getUsernsMode() {
        return this.usernsMode;
    }

    public void setUsernsMode(String usernsMode) {
        this.usernsMode = usernsMode;
    }

    public InspectContainerHostConfig volumeDriver(String volumeDriver) {
        this.volumeDriver = volumeDriver;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="VolumeDriver is presently unused and is retained for Docker compatibility.")
    public String getVolumeDriver() {
        return this.volumeDriver;
    }

    public void setVolumeDriver(String volumeDriver) {
        this.volumeDriver = volumeDriver;
    }

    public InspectContainerHostConfig volumesFrom(List<String> volumesFrom) {
        this.volumesFrom = volumesFrom;
        return this;
    }

    public InspectContainerHostConfig addVolumesFromItem(String volumesFromItem) {
        if (this.volumesFrom == null) {
            this.volumesFrom = new ArrayList<String>();
        }
        this.volumesFrom.add(volumesFromItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="VolumesFrom is a list of containers which this container uses volumes from. This is not handled directly within libpod and is stored in an annotation. It is formatted as an array of container names and IDs.")
    public List<String> getVolumesFrom() {
        return this.volumesFrom;
    }

    public void setVolumesFrom(List<String> volumesFrom) {
        this.volumesFrom = volumesFrom;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InspectContainerHostConfig inspectContainerHostConfig = (InspectContainerHostConfig)o;
        return Objects.equals(this.annotations, inspectContainerHostConfig.annotations) && Objects.equals(this.autoRemove, inspectContainerHostConfig.autoRemove) && Objects.equals(this.autoRemoveImage, inspectContainerHostConfig.autoRemoveImage) && Objects.equals(this.binds, inspectContainerHostConfig.binds) && Objects.equals(this.blkioDeviceReadBps, inspectContainerHostConfig.blkioDeviceReadBps) && Objects.equals(this.blkioDeviceReadIOps, inspectContainerHostConfig.blkioDeviceReadIOps) && Objects.equals(this.blkioDeviceWriteBps, inspectContainerHostConfig.blkioDeviceWriteBps) && Objects.equals(this.blkioDeviceWriteIOps, inspectContainerHostConfig.blkioDeviceWriteIOps) && Objects.equals(this.blkioWeight, inspectContainerHostConfig.blkioWeight) && Objects.equals(this.blkioWeightDevice, inspectContainerHostConfig.blkioWeightDevice) && Objects.equals(this.capAdd, inspectContainerHostConfig.capAdd) && Objects.equals(this.capDrop, inspectContainerHostConfig.capDrop) && Objects.equals(this.cgroup, inspectContainerHostConfig.cgroup) && Objects.equals(this.cgroupConf, inspectContainerHostConfig.cgroupConf) && Objects.equals(this.cgroupManager, inspectContainerHostConfig.cgroupManager) && Objects.equals(this.cgroupMode, inspectContainerHostConfig.cgroupMode) && Objects.equals(this.cgroupParent, inspectContainerHostConfig.cgroupParent) && Objects.equals(this.cgroups, inspectContainerHostConfig.cgroups) && Objects.equals(this.consoleSize, inspectContainerHostConfig.consoleSize) && Objects.equals(this.containerIDFile, inspectContainerHostConfig.containerIDFile) && Objects.equals(this.cpuCount, inspectContainerHostConfig.cpuCount) && Objects.equals(this.cpuPercent, inspectContainerHostConfig.cpuPercent) && Objects.equals(this.cpuPeriod, inspectContainerHostConfig.cpuPeriod) && Objects.equals(this.cpuQuota, inspectContainerHostConfig.cpuQuota) && Objects.equals(this.cpuRealtimePeriod, inspectContainerHostConfig.cpuRealtimePeriod) && Objects.equals(this.cpuRealtimeRuntime, inspectContainerHostConfig.cpuRealtimeRuntime) && Objects.equals(this.cpuShares, inspectContainerHostConfig.cpuShares) && Objects.equals(this.cpusetCpus, inspectContainerHostConfig.cpusetCpus) && Objects.equals(this.cpusetMems, inspectContainerHostConfig.cpusetMems) && Objects.equals(this.devices, inspectContainerHostConfig.devices) && Objects.equals(this.diskQuota, inspectContainerHostConfig.diskQuota) && Objects.equals(this.dns, inspectContainerHostConfig.dns) && Objects.equals(this.dnsOptions, inspectContainerHostConfig.dnsOptions) && Objects.equals(this.dnsSearch, inspectContainerHostConfig.dnsSearch) && Objects.equals(this.extraHosts, inspectContainerHostConfig.extraHosts) && Objects.equals(this.groupAdd, inspectContainerHostConfig.groupAdd) && Objects.equals(this.idMappings, inspectContainerHostConfig.idMappings) && Objects.equals(this.ioMaximumBandwidth, inspectContainerHostConfig.ioMaximumBandwidth) && Objects.equals(this.ioMaximumIOps, inspectContainerHostConfig.ioMaximumIOps) && Objects.equals(this.init, inspectContainerHostConfig.init) && Objects.equals(this.intelRdtClosID, inspectContainerHostConfig.intelRdtClosID) && Objects.equals(this.ipcMode, inspectContainerHostConfig.ipcMode) && Objects.equals(this.isolation, inspectContainerHostConfig.isolation) && Objects.equals(this.kernelMemory, inspectContainerHostConfig.kernelMemory) && Objects.equals(this.links, inspectContainerHostConfig.links) && Objects.equals(this.logConfig, inspectContainerHostConfig.logConfig) && Objects.equals(this.memory, inspectContainerHostConfig.memory) && Objects.equals(this.memoryReservation, inspectContainerHostConfig.memoryReservation) && Objects.equals(this.memorySwap, inspectContainerHostConfig.memorySwap) && Objects.equals(this.memorySwappiness, inspectContainerHostConfig.memorySwappiness) && Objects.equals(this.nanoCpus, inspectContainerHostConfig.nanoCpus) && Objects.equals(this.networkMode, inspectContainerHostConfig.networkMode) && Objects.equals(this.oomKillDisable, inspectContainerHostConfig.oomKillDisable) && Objects.equals(this.oomScoreAdj, inspectContainerHostConfig.oomScoreAdj) && Objects.equals(this.pidMode, inspectContainerHostConfig.pidMode) && Objects.equals(this.pidsLimit, inspectContainerHostConfig.pidsLimit) && Objects.equals(this.portBindings, inspectContainerHostConfig.portBindings) && Objects.equals(this.privileged, inspectContainerHostConfig.privileged) && Objects.equals(this.publishAllPorts, inspectContainerHostConfig.publishAllPorts) && Objects.equals(this.readonlyRootfs, inspectContainerHostConfig.readonlyRootfs) && Objects.equals(this.restartPolicy, inspectContainerHostConfig.restartPolicy) && Objects.equals(this.runtime, inspectContainerHostConfig.runtime) && Objects.equals(this.securityOpt, inspectContainerHostConfig.securityOpt) && Objects.equals(this.shmSize, inspectContainerHostConfig.shmSize) && Objects.equals(this.tmpfs, inspectContainerHostConfig.tmpfs) && Objects.equals(this.utSMode, inspectContainerHostConfig.utSMode) && Objects.equals(this.ulimits, inspectContainerHostConfig.ulimits) && Objects.equals(this.usernsMode, inspectContainerHostConfig.usernsMode) && Objects.equals(this.volumeDriver, inspectContainerHostConfig.volumeDriver) && Objects.equals(this.volumesFrom, inspectContainerHostConfig.volumesFrom);
    }

    public int hashCode() {
        return Objects.hash(this.annotations, this.autoRemove, this.autoRemoveImage, this.binds, this.blkioDeviceReadBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteBps, this.blkioDeviceWriteIOps, this.blkioWeight, this.blkioWeightDevice, this.capAdd, this.capDrop, this.cgroup, this.cgroupConf, this.cgroupManager, this.cgroupMode, this.cgroupParent, this.cgroups, this.consoleSize, this.containerIDFile, this.cpuCount, this.cpuPercent, this.cpuPeriod, this.cpuQuota, this.cpuRealtimePeriod, this.cpuRealtimeRuntime, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.devices, this.diskQuota, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.idMappings, this.ioMaximumBandwidth, this.ioMaximumIOps, this.init, this.intelRdtClosID, this.ipcMode, this.isolation, this.kernelMemory, this.links, this.logConfig, this.memory, this.memoryReservation, this.memorySwap, this.memorySwappiness, this.nanoCpus, this.networkMode, this.oomKillDisable, this.oomScoreAdj, this.pidMode, this.pidsLimit, this.portBindings, this.privileged, this.publishAllPorts, this.readonlyRootfs, this.restartPolicy, this.runtime, this.securityOpt, this.shmSize, this.tmpfs, this.utSMode, this.ulimits, this.usernsMode, this.volumeDriver, this.volumesFrom);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InspectContainerHostConfig {\n");
        sb.append("    annotations: ").append(this.toIndentedString(this.annotations)).append("\n");
        sb.append("    autoRemove: ").append(this.toIndentedString(this.autoRemove)).append("\n");
        sb.append("    autoRemoveImage: ").append(this.toIndentedString(this.autoRemoveImage)).append("\n");
        sb.append("    binds: ").append(this.toIndentedString(this.binds)).append("\n");
        sb.append("    blkioDeviceReadBps: ").append(this.toIndentedString(this.blkioDeviceReadBps)).append("\n");
        sb.append("    blkioDeviceReadIOps: ").append(this.toIndentedString(this.blkioDeviceReadIOps)).append("\n");
        sb.append("    blkioDeviceWriteBps: ").append(this.toIndentedString(this.blkioDeviceWriteBps)).append("\n");
        sb.append("    blkioDeviceWriteIOps: ").append(this.toIndentedString(this.blkioDeviceWriteIOps)).append("\n");
        sb.append("    blkioWeight: ").append(this.toIndentedString(this.blkioWeight)).append("\n");
        sb.append("    blkioWeightDevice: ").append(this.toIndentedString(this.blkioWeightDevice)).append("\n");
        sb.append("    capAdd: ").append(this.toIndentedString(this.capAdd)).append("\n");
        sb.append("    capDrop: ").append(this.toIndentedString(this.capDrop)).append("\n");
        sb.append("    cgroup: ").append(this.toIndentedString(this.cgroup)).append("\n");
        sb.append("    cgroupConf: ").append(this.toIndentedString(this.cgroupConf)).append("\n");
        sb.append("    cgroupManager: ").append(this.toIndentedString(this.cgroupManager)).append("\n");
        sb.append("    cgroupMode: ").append(this.toIndentedString(this.cgroupMode)).append("\n");
        sb.append("    cgroupParent: ").append(this.toIndentedString(this.cgroupParent)).append("\n");
        sb.append("    cgroups: ").append(this.toIndentedString(this.cgroups)).append("\n");
        sb.append("    consoleSize: ").append(this.toIndentedString(this.consoleSize)).append("\n");
        sb.append("    containerIDFile: ").append(this.toIndentedString(this.containerIDFile)).append("\n");
        sb.append("    cpuCount: ").append(this.toIndentedString(this.cpuCount)).append("\n");
        sb.append("    cpuPercent: ").append(this.toIndentedString(this.cpuPercent)).append("\n");
        sb.append("    cpuPeriod: ").append(this.toIndentedString(this.cpuPeriod)).append("\n");
        sb.append("    cpuQuota: ").append(this.toIndentedString(this.cpuQuota)).append("\n");
        sb.append("    cpuRealtimePeriod: ").append(this.toIndentedString(this.cpuRealtimePeriod)).append("\n");
        sb.append("    cpuRealtimeRuntime: ").append(this.toIndentedString(this.cpuRealtimeRuntime)).append("\n");
        sb.append("    cpuShares: ").append(this.toIndentedString(this.cpuShares)).append("\n");
        sb.append("    cpusetCpus: ").append(this.toIndentedString(this.cpusetCpus)).append("\n");
        sb.append("    cpusetMems: ").append(this.toIndentedString(this.cpusetMems)).append("\n");
        sb.append("    devices: ").append(this.toIndentedString(this.devices)).append("\n");
        sb.append("    diskQuota: ").append(this.toIndentedString(this.diskQuota)).append("\n");
        sb.append("    dns: ").append(this.toIndentedString(this.dns)).append("\n");
        sb.append("    dnsOptions: ").append(this.toIndentedString(this.dnsOptions)).append("\n");
        sb.append("    dnsSearch: ").append(this.toIndentedString(this.dnsSearch)).append("\n");
        sb.append("    extraHosts: ").append(this.toIndentedString(this.extraHosts)).append("\n");
        sb.append("    groupAdd: ").append(this.toIndentedString(this.groupAdd)).append("\n");
        sb.append("    idMappings: ").append(this.toIndentedString(this.idMappings)).append("\n");
        sb.append("    ioMaximumBandwidth: ").append(this.toIndentedString(this.ioMaximumBandwidth)).append("\n");
        sb.append("    ioMaximumIOps: ").append(this.toIndentedString(this.ioMaximumIOps)).append("\n");
        sb.append("    init: ").append(this.toIndentedString(this.init)).append("\n");
        sb.append("    intelRdtClosID: ").append(this.toIndentedString(this.intelRdtClosID)).append("\n");
        sb.append("    ipcMode: ").append(this.toIndentedString(this.ipcMode)).append("\n");
        sb.append("    isolation: ").append(this.toIndentedString(this.isolation)).append("\n");
        sb.append("    kernelMemory: ").append(this.toIndentedString(this.kernelMemory)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    logConfig: ").append(this.toIndentedString(this.logConfig)).append("\n");
        sb.append("    memory: ").append(this.toIndentedString(this.memory)).append("\n");
        sb.append("    memoryReservation: ").append(this.toIndentedString(this.memoryReservation)).append("\n");
        sb.append("    memorySwap: ").append(this.toIndentedString(this.memorySwap)).append("\n");
        sb.append("    memorySwappiness: ").append(this.toIndentedString(this.memorySwappiness)).append("\n");
        sb.append("    nanoCpus: ").append(this.toIndentedString(this.nanoCpus)).append("\n");
        sb.append("    networkMode: ").append(this.toIndentedString(this.networkMode)).append("\n");
        sb.append("    oomKillDisable: ").append(this.toIndentedString(this.oomKillDisable)).append("\n");
        sb.append("    oomScoreAdj: ").append(this.toIndentedString(this.oomScoreAdj)).append("\n");
        sb.append("    pidMode: ").append(this.toIndentedString(this.pidMode)).append("\n");
        sb.append("    pidsLimit: ").append(this.toIndentedString(this.pidsLimit)).append("\n");
        sb.append("    portBindings: ").append(this.toIndentedString(this.portBindings)).append("\n");
        sb.append("    privileged: ").append(this.toIndentedString(this.privileged)).append("\n");
        sb.append("    publishAllPorts: ").append(this.toIndentedString(this.publishAllPorts)).append("\n");
        sb.append("    readonlyRootfs: ").append(this.toIndentedString(this.readonlyRootfs)).append("\n");
        sb.append("    restartPolicy: ").append(this.toIndentedString(this.restartPolicy)).append("\n");
        sb.append("    runtime: ").append(this.toIndentedString(this.runtime)).append("\n");
        sb.append("    securityOpt: ").append(this.toIndentedString(this.securityOpt)).append("\n");
        sb.append("    shmSize: ").append(this.toIndentedString(this.shmSize)).append("\n");
        sb.append("    tmpfs: ").append(this.toIndentedString(this.tmpfs)).append("\n");
        sb.append("    utSMode: ").append(this.toIndentedString(this.utSMode)).append("\n");
        sb.append("    ulimits: ").append(this.toIndentedString(this.ulimits)).append("\n");
        sb.append("    usernsMode: ").append(this.toIndentedString(this.usernsMode)).append("\n");
        sb.append("    volumeDriver: ").append(this.toIndentedString(this.volumeDriver)).append("\n");
        sb.append("    volumesFrom: ").append(this.toIndentedString(this.volumesFrom)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArrayulimits;
        JsonArray jsonArraydevices;
        JsonArray jsonArrayblkioWeightDevice;
        JsonArray jsonArrayblkioDeviceWriteIOps;
        JsonArray jsonArrayblkioDeviceWriteBps;
        JsonArray jsonArrayblkioDeviceReadIOps;
        JsonArray jsonArrayblkioDeviceReadBps;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in InspectContainerHostConfig is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `InspectContainerHostConfig` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BINDS) != null && !jsonObj.get(SERIALIZED_NAME_BINDS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_BINDS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `Binds` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BINDS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BLKIO_DEVICE_READ_BPS) != null && !jsonObj.get(SERIALIZED_NAME_BLKIO_DEVICE_READ_BPS).isJsonNull() && (jsonArrayblkioDeviceReadBps = jsonObj.getAsJsonArray(SERIALIZED_NAME_BLKIO_DEVICE_READ_BPS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_BLKIO_DEVICE_READ_BPS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `BlkioDeviceReadBps` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BLKIO_DEVICE_READ_BPS).toString()));
            }
            for (int i = 0; i < jsonArrayblkioDeviceReadBps.size(); ++i) {
                InspectBlkioThrottleDevice.validateJsonObject(jsonArrayblkioDeviceReadBps.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_BLKIO_DEVICE_READ_I_OPS) != null && !jsonObj.get(SERIALIZED_NAME_BLKIO_DEVICE_READ_I_OPS).isJsonNull() && (jsonArrayblkioDeviceReadIOps = jsonObj.getAsJsonArray(SERIALIZED_NAME_BLKIO_DEVICE_READ_I_OPS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_BLKIO_DEVICE_READ_I_OPS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `BlkioDeviceReadIOps` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BLKIO_DEVICE_READ_I_OPS).toString()));
            }
            for (int i = 0; i < jsonArrayblkioDeviceReadIOps.size(); ++i) {
                InspectBlkioThrottleDevice.validateJsonObject(jsonArrayblkioDeviceReadIOps.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_BLKIO_DEVICE_WRITE_BPS) != null && !jsonObj.get(SERIALIZED_NAME_BLKIO_DEVICE_WRITE_BPS).isJsonNull() && (jsonArrayblkioDeviceWriteBps = jsonObj.getAsJsonArray(SERIALIZED_NAME_BLKIO_DEVICE_WRITE_BPS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_BLKIO_DEVICE_WRITE_BPS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `BlkioDeviceWriteBps` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BLKIO_DEVICE_WRITE_BPS).toString()));
            }
            for (int i = 0; i < jsonArrayblkioDeviceWriteBps.size(); ++i) {
                InspectBlkioThrottleDevice.validateJsonObject(jsonArrayblkioDeviceWriteBps.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_BLKIO_DEVICE_WRITE_I_OPS) != null && !jsonObj.get(SERIALIZED_NAME_BLKIO_DEVICE_WRITE_I_OPS).isJsonNull() && (jsonArrayblkioDeviceWriteIOps = jsonObj.getAsJsonArray(SERIALIZED_NAME_BLKIO_DEVICE_WRITE_I_OPS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_BLKIO_DEVICE_WRITE_I_OPS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `BlkioDeviceWriteIOps` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BLKIO_DEVICE_WRITE_I_OPS).toString()));
            }
            for (int i = 0; i < jsonArrayblkioDeviceWriteIOps.size(); ++i) {
                InspectBlkioThrottleDevice.validateJsonObject(jsonArrayblkioDeviceWriteIOps.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_BLKIO_WEIGHT_DEVICE) != null && !jsonObj.get(SERIALIZED_NAME_BLKIO_WEIGHT_DEVICE).isJsonNull() && (jsonArrayblkioWeightDevice = jsonObj.getAsJsonArray(SERIALIZED_NAME_BLKIO_WEIGHT_DEVICE)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_BLKIO_WEIGHT_DEVICE).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `BlkioWeightDevice` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BLKIO_WEIGHT_DEVICE).toString()));
            }
            for (int i = 0; i < jsonArrayblkioWeightDevice.size(); ++i) {
                InspectBlkioWeightDevice.validateJsonObject(jsonArrayblkioWeightDevice.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_CAP_ADD) != null && !jsonObj.get(SERIALIZED_NAME_CAP_ADD).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CAP_ADD).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `CapAdd` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CAP_ADD).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CAP_DROP) != null && !jsonObj.get(SERIALIZED_NAME_CAP_DROP).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CAP_DROP).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `CapDrop` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CAP_DROP).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CGROUP) != null && !jsonObj.get(SERIALIZED_NAME_CGROUP).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CGROUP).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Cgroup` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CGROUP).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CGROUP_MANAGER) != null && !jsonObj.get(SERIALIZED_NAME_CGROUP_MANAGER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CGROUP_MANAGER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `CgroupManager` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CGROUP_MANAGER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CGROUP_MODE) != null && !jsonObj.get(SERIALIZED_NAME_CGROUP_MODE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CGROUP_MODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `CgroupMode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CGROUP_MODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CGROUP_PARENT) != null && !jsonObj.get(SERIALIZED_NAME_CGROUP_PARENT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CGROUP_PARENT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `CgroupParent` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CGROUP_PARENT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CGROUPS) != null && !jsonObj.get(SERIALIZED_NAME_CGROUPS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CGROUPS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Cgroups` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CGROUPS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONSOLE_SIZE) != null && !jsonObj.get(SERIALIZED_NAME_CONSOLE_SIZE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CONSOLE_SIZE).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `ConsoleSize` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONSOLE_SIZE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONTAINER_I_D_FILE) != null && !jsonObj.get(SERIALIZED_NAME_CONTAINER_I_D_FILE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CONTAINER_I_D_FILE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `ContainerIDFile` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONTAINER_I_D_FILE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CPUSET_CPUS) != null && !jsonObj.get(SERIALIZED_NAME_CPUSET_CPUS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CPUSET_CPUS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `CpusetCpus` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CPUSET_CPUS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CPUSET_MEMS) != null && !jsonObj.get(SERIALIZED_NAME_CPUSET_MEMS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CPUSET_MEMS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `CpusetMems` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CPUSET_MEMS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DEVICES) != null && !jsonObj.get(SERIALIZED_NAME_DEVICES).isJsonNull() && (jsonArraydevices = jsonObj.getAsJsonArray(SERIALIZED_NAME_DEVICES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_DEVICES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `Devices` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DEVICES).toString()));
            }
            for (int i = 0; i < jsonArraydevices.size(); ++i) {
                InspectDevice.validateJsonObject(jsonArraydevices.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_DNS) != null && !jsonObj.get(SERIALIZED_NAME_DNS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DNS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `Dns` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DNS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DNS_OPTIONS) != null && !jsonObj.get(SERIALIZED_NAME_DNS_OPTIONS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DNS_OPTIONS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `DnsOptions` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DNS_OPTIONS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DNS_SEARCH) != null && !jsonObj.get(SERIALIZED_NAME_DNS_SEARCH).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DNS_SEARCH).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `DnsSearch` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DNS_SEARCH).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EXTRA_HOSTS) != null && !jsonObj.get(SERIALIZED_NAME_EXTRA_HOSTS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_EXTRA_HOSTS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `ExtraHosts` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EXTRA_HOSTS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_GROUP_ADD) != null && !jsonObj.get(SERIALIZED_NAME_GROUP_ADD).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_GROUP_ADD).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `GroupAdd` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_GROUP_ADD).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID_MAPPINGS) != null && !jsonObj.get(SERIALIZED_NAME_ID_MAPPINGS).isJsonNull()) {
            InspectIDMappings.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ID_MAPPINGS));
        }
        if (jsonObj.get(SERIALIZED_NAME_INTEL_RDT_CLOS_I_D) != null && !jsonObj.get(SERIALIZED_NAME_INTEL_RDT_CLOS_I_D).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_INTEL_RDT_CLOS_I_D).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `IntelRdtClosID` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INTEL_RDT_CLOS_I_D).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_IPC_MODE) != null && !jsonObj.get(SERIALIZED_NAME_IPC_MODE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_IPC_MODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `IpcMode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IPC_MODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ISOLATION) != null && !jsonObj.get(SERIALIZED_NAME_ISOLATION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ISOLATION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Isolation` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ISOLATION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LINKS) != null && !jsonObj.get(SERIALIZED_NAME_LINKS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_LINKS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `Links` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LINKS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LOG_CONFIG) != null && !jsonObj.get(SERIALIZED_NAME_LOG_CONFIG).isJsonNull()) {
            InspectLogConfig.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_LOG_CONFIG));
        }
        if (jsonObj.get(SERIALIZED_NAME_NETWORK_MODE) != null && !jsonObj.get(SERIALIZED_NAME_NETWORK_MODE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NETWORK_MODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `NetworkMode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NETWORK_MODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PID_MODE) != null && !jsonObj.get(SERIALIZED_NAME_PID_MODE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PID_MODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `PidMode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PID_MODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RESTART_POLICY) != null && !jsonObj.get(SERIALIZED_NAME_RESTART_POLICY).isJsonNull()) {
            InspectRestartPolicy.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_RESTART_POLICY));
        }
        if (jsonObj.get(SERIALIZED_NAME_RUNTIME) != null && !jsonObj.get(SERIALIZED_NAME_RUNTIME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_RUNTIME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Runtime` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RUNTIME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SECURITY_OPT) != null && !jsonObj.get(SERIALIZED_NAME_SECURITY_OPT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SECURITY_OPT).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `SecurityOpt` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SECURITY_OPT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_UT_S_MODE) != null && !jsonObj.get(SERIALIZED_NAME_UT_S_MODE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_UT_S_MODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `UTSMode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UT_S_MODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ULIMITS) != null && !jsonObj.get(SERIALIZED_NAME_ULIMITS).isJsonNull() && (jsonArrayulimits = jsonObj.getAsJsonArray(SERIALIZED_NAME_ULIMITS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ULIMITS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `Ulimits` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ULIMITS).toString()));
            }
            for (int i = 0; i < jsonArrayulimits.size(); ++i) {
                InspectUlimit.validateJsonObject(jsonArrayulimits.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_USERNS_MODE) != null && !jsonObj.get(SERIALIZED_NAME_USERNS_MODE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_USERNS_MODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `UsernsMode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_USERNS_MODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_VOLUME_DRIVER) != null && !jsonObj.get(SERIALIZED_NAME_VOLUME_DRIVER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_VOLUME_DRIVER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `VolumeDriver` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VOLUME_DRIVER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_VOLUMES_FROM) != null && !jsonObj.get(SERIALIZED_NAME_VOLUMES_FROM).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_VOLUMES_FROM).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `VolumesFrom` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VOLUMES_FROM).toString()));
        }
    }

    public static InspectContainerHostConfig fromJson(String jsonString) throws IOException {
        return (InspectContainerHostConfig)JSON.getGson().fromJson(jsonString, InspectContainerHostConfig.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ANNOTATIONS);
        openapiFields.add(SERIALIZED_NAME_AUTO_REMOVE);
        openapiFields.add(SERIALIZED_NAME_AUTO_REMOVE_IMAGE);
        openapiFields.add(SERIALIZED_NAME_BINDS);
        openapiFields.add(SERIALIZED_NAME_BLKIO_DEVICE_READ_BPS);
        openapiFields.add(SERIALIZED_NAME_BLKIO_DEVICE_READ_I_OPS);
        openapiFields.add(SERIALIZED_NAME_BLKIO_DEVICE_WRITE_BPS);
        openapiFields.add(SERIALIZED_NAME_BLKIO_DEVICE_WRITE_I_OPS);
        openapiFields.add(SERIALIZED_NAME_BLKIO_WEIGHT);
        openapiFields.add(SERIALIZED_NAME_BLKIO_WEIGHT_DEVICE);
        openapiFields.add(SERIALIZED_NAME_CAP_ADD);
        openapiFields.add(SERIALIZED_NAME_CAP_DROP);
        openapiFields.add(SERIALIZED_NAME_CGROUP);
        openapiFields.add(SERIALIZED_NAME_CGROUP_CONF);
        openapiFields.add(SERIALIZED_NAME_CGROUP_MANAGER);
        openapiFields.add(SERIALIZED_NAME_CGROUP_MODE);
        openapiFields.add(SERIALIZED_NAME_CGROUP_PARENT);
        openapiFields.add(SERIALIZED_NAME_CGROUPS);
        openapiFields.add(SERIALIZED_NAME_CONSOLE_SIZE);
        openapiFields.add(SERIALIZED_NAME_CONTAINER_I_D_FILE);
        openapiFields.add(SERIALIZED_NAME_CPU_COUNT);
        openapiFields.add(SERIALIZED_NAME_CPU_PERCENT);
        openapiFields.add(SERIALIZED_NAME_CPU_PERIOD);
        openapiFields.add(SERIALIZED_NAME_CPU_QUOTA);
        openapiFields.add(SERIALIZED_NAME_CPU_REALTIME_PERIOD);
        openapiFields.add(SERIALIZED_NAME_CPU_REALTIME_RUNTIME);
        openapiFields.add(SERIALIZED_NAME_CPU_SHARES);
        openapiFields.add(SERIALIZED_NAME_CPUSET_CPUS);
        openapiFields.add(SERIALIZED_NAME_CPUSET_MEMS);
        openapiFields.add(SERIALIZED_NAME_DEVICES);
        openapiFields.add(SERIALIZED_NAME_DISK_QUOTA);
        openapiFields.add(SERIALIZED_NAME_DNS);
        openapiFields.add(SERIALIZED_NAME_DNS_OPTIONS);
        openapiFields.add(SERIALIZED_NAME_DNS_SEARCH);
        openapiFields.add(SERIALIZED_NAME_EXTRA_HOSTS);
        openapiFields.add(SERIALIZED_NAME_GROUP_ADD);
        openapiFields.add(SERIALIZED_NAME_ID_MAPPINGS);
        openapiFields.add(SERIALIZED_NAME_IO_MAXIMUM_BANDWIDTH);
        openapiFields.add(SERIALIZED_NAME_IO_MAXIMUM_I_OPS);
        openapiFields.add(SERIALIZED_NAME_INIT);
        openapiFields.add(SERIALIZED_NAME_INTEL_RDT_CLOS_I_D);
        openapiFields.add(SERIALIZED_NAME_IPC_MODE);
        openapiFields.add(SERIALIZED_NAME_ISOLATION);
        openapiFields.add(SERIALIZED_NAME_KERNEL_MEMORY);
        openapiFields.add(SERIALIZED_NAME_LINKS);
        openapiFields.add(SERIALIZED_NAME_LOG_CONFIG);
        openapiFields.add(SERIALIZED_NAME_MEMORY);
        openapiFields.add(SERIALIZED_NAME_MEMORY_RESERVATION);
        openapiFields.add(SERIALIZED_NAME_MEMORY_SWAP);
        openapiFields.add(SERIALIZED_NAME_MEMORY_SWAPPINESS);
        openapiFields.add(SERIALIZED_NAME_NANO_CPUS);
        openapiFields.add(SERIALIZED_NAME_NETWORK_MODE);
        openapiFields.add(SERIALIZED_NAME_OOM_KILL_DISABLE);
        openapiFields.add(SERIALIZED_NAME_OOM_SCORE_ADJ);
        openapiFields.add(SERIALIZED_NAME_PID_MODE);
        openapiFields.add(SERIALIZED_NAME_PIDS_LIMIT);
        openapiFields.add(SERIALIZED_NAME_PORT_BINDINGS);
        openapiFields.add(SERIALIZED_NAME_PRIVILEGED);
        openapiFields.add(SERIALIZED_NAME_PUBLISH_ALL_PORTS);
        openapiFields.add(SERIALIZED_NAME_READONLY_ROOTFS);
        openapiFields.add(SERIALIZED_NAME_RESTART_POLICY);
        openapiFields.add(SERIALIZED_NAME_RUNTIME);
        openapiFields.add(SERIALIZED_NAME_SECURITY_OPT);
        openapiFields.add(SERIALIZED_NAME_SHM_SIZE);
        openapiFields.add(SERIALIZED_NAME_TMPFS);
        openapiFields.add(SERIALIZED_NAME_UT_S_MODE);
        openapiFields.add(SERIALIZED_NAME_ULIMITS);
        openapiFields.add(SERIALIZED_NAME_USERNS_MODE);
        openapiFields.add(SERIALIZED_NAME_VOLUME_DRIVER);
        openapiFields.add(SERIALIZED_NAME_VOLUMES_FROM);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!InspectContainerHostConfig.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(InspectContainerHostConfig.class));
            return new TypeAdapter<InspectContainerHostConfig>(){

                public void write(JsonWriter out, InspectContainerHostConfig value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public InspectContainerHostConfig read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    InspectContainerHostConfig.validateJsonObject(jsonObj);
                    return (InspectContainerHostConfig)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

