/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

@ApiModel(description="InspectMount provides a record of a single mount in a container. It contains fields for both named and normal volumes. Only user-specified volumes will be included, and tmpfs volumes are not included even if the user specified them.")
public class InspectMount
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_DESTINATION = "Destination";
    @SerializedName(value="Destination")
    private String destination;
    public static final String SERIALIZED_NAME_DRIVER = "Driver";
    @SerializedName(value="Driver")
    private String driver;
    public static final String SERIALIZED_NAME_MODE = "Mode";
    @SerializedName(value="Mode")
    private String mode;
    public static final String SERIALIZED_NAME_NAME = "Name";
    @SerializedName(value="Name")
    private String name;
    public static final String SERIALIZED_NAME_OPTIONS = "Options";
    @SerializedName(value="Options")
    private List<String> options = null;
    public static final String SERIALIZED_NAME_PROPAGATION = "Propagation";
    @SerializedName(value="Propagation")
    private String propagation;
    public static final String SERIALIZED_NAME_R_W = "RW";
    @SerializedName(value="RW")
    private Boolean RW;
    public static final String SERIALIZED_NAME_SOURCE = "Source";
    @SerializedName(value="Source")
    private String source;
    public static final String SERIALIZED_NAME_SUB_PATH = "SubPath";
    @SerializedName(value="SubPath")
    private String subPath;
    public static final String SERIALIZED_NAME_TYPE = "Type";
    @SerializedName(value="Type")
    private String type;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public InspectMount destination(String destination) {
        this.destination = destination;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The destination directory for the volume. Specified as a path within the container, as it would be passed into the OCI runtime.")
    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public InspectMount driver(String driver) {
        this.driver = driver;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The driver used for the named volume. Empty for bind mounts.")
    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public InspectMount mode(String mode) {
        this.mode = mode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Contains SELinux :z/:Z mount options. Unclear what, if anything, else goes in here.")
    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public InspectMount name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the volume. Empty for bind mounts.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public InspectMount options(List<String> options) {
        this.options = options;
        return this;
    }

    public InspectMount addOptionsItem(String optionsItem) {
        if (this.options == null) {
            this.options = new ArrayList<String>();
        }
        this.options.add(optionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="All remaining mount options. Additional data, not present in the original output.")
    public List<String> getOptions() {
        return this.options;
    }

    public void setOptions(List<String> options) {
        this.options = options;
    }

    public InspectMount propagation(String propagation) {
        this.propagation = propagation;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Mount propagation for the mount. Can be empty if not specified, but is always printed - no omitempty.")
    public String getPropagation() {
        return this.propagation;
    }

    public void setPropagation(String propagation) {
        this.propagation = propagation;
    }

    public InspectMount RW(Boolean RW) {
        this.RW = RW;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether the volume is read-write")
    public Boolean getRW() {
        return this.RW;
    }

    public void setRW(Boolean RW) {
        this.RW = RW;
    }

    public InspectMount source(String source) {
        this.source = source;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The source directory for the volume.")
    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public InspectMount subPath(String subPath) {
        this.subPath = subPath;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="SubPath object from the volume. Specified as a path within the source volume to be mounted at the Destination.")
    public String getSubPath() {
        return this.subPath;
    }

    public void setSubPath(String subPath) {
        this.subPath = subPath;
    }

    public InspectMount type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether the mount is a volume or bind mount. Allowed values are \"volume\" and \"bind\".")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InspectMount inspectMount = (InspectMount)o;
        return Objects.equals(this.destination, inspectMount.destination) && Objects.equals(this.driver, inspectMount.driver) && Objects.equals(this.mode, inspectMount.mode) && Objects.equals(this.name, inspectMount.name) && Objects.equals(this.options, inspectMount.options) && Objects.equals(this.propagation, inspectMount.propagation) && Objects.equals(this.RW, inspectMount.RW) && Objects.equals(this.source, inspectMount.source) && Objects.equals(this.subPath, inspectMount.subPath) && Objects.equals(this.type, inspectMount.type);
    }

    public int hashCode() {
        return Objects.hash(this.destination, this.driver, this.mode, this.name, this.options, this.propagation, this.RW, this.source, this.subPath, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InspectMount {\n");
        sb.append("    destination: ").append(this.toIndentedString(this.destination)).append("\n");
        sb.append("    driver: ").append(this.toIndentedString(this.driver)).append("\n");
        sb.append("    mode: ").append(this.toIndentedString(this.mode)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("    propagation: ").append(this.toIndentedString(this.propagation)).append("\n");
        sb.append("    RW: ").append(this.toIndentedString(this.RW)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    subPath: ").append(this.toIndentedString(this.subPath)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in InspectMount is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `InspectMount` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESTINATION) != null && !jsonObj.get(SERIALIZED_NAME_DESTINATION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DESTINATION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Destination` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESTINATION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DRIVER) != null && !jsonObj.get(SERIALIZED_NAME_DRIVER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DRIVER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Driver` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DRIVER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MODE) != null && !jsonObj.get(SERIALIZED_NAME_MODE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_MODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Mode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_OPTIONS) != null && !jsonObj.get(SERIALIZED_NAME_OPTIONS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_OPTIONS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `Options` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OPTIONS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PROPAGATION) != null && !jsonObj.get(SERIALIZED_NAME_PROPAGATION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PROPAGATION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Propagation` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PROPAGATION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SOURCE) != null && !jsonObj.get(SERIALIZED_NAME_SOURCE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SOURCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Source` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SOURCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SUB_PATH) != null && !jsonObj.get(SERIALIZED_NAME_SUB_PATH).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SUB_PATH).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `SubPath` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SUB_PATH).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_TYPE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
        }
    }

    public static InspectMount fromJson(String jsonString) throws IOException {
        return (InspectMount)JSON.getGson().fromJson(jsonString, InspectMount.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_DESTINATION);
        openapiFields.add(SERIALIZED_NAME_DRIVER);
        openapiFields.add(SERIALIZED_NAME_MODE);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_OPTIONS);
        openapiFields.add(SERIALIZED_NAME_PROPAGATION);
        openapiFields.add(SERIALIZED_NAME_R_W);
        openapiFields.add(SERIALIZED_NAME_SOURCE);
        openapiFields.add(SERIALIZED_NAME_SUB_PATH);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!InspectMount.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(InspectMount.class));
            return new TypeAdapter<InspectMount>(){

                public void write(JsonWriter out, InspectMount value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public InspectMount read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    InspectMount.validateJsonObject(jsonObj);
                    return (InspectMount)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

