/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

@ApiModel(description="LinuxIntelRdt has container runtime resource constraints for Intel RDT CAT and MBA features and flags enabling Intel RDT CMT and MBM features. Intel RDT features are available in Linux 4.14 and newer kernel versions.")
public class LinuxIntelRdt
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_CLOS_I_D = "closID";
    @SerializedName(value="closID")
    private String closID;
    public static final String SERIALIZED_NAME_ENABLE_C_M_T = "enableCMT";
    @SerializedName(value="enableCMT")
    private Boolean enableCMT;
    public static final String SERIALIZED_NAME_ENABLE_M_B_M = "enableMBM";
    @SerializedName(value="enableMBM")
    private Boolean enableMBM;
    public static final String SERIALIZED_NAME_L3_CACHE_SCHEMA = "l3CacheSchema";
    @SerializedName(value="l3CacheSchema")
    private String l3CacheSchema;
    public static final String SERIALIZED_NAME_MEM_BW_SCHEMA = "memBwSchema";
    @SerializedName(value="memBwSchema")
    private String memBwSchema;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public LinuxIntelRdt closID(String closID) {
        this.closID = closID;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The identity for RDT Class of Service")
    public String getClosID() {
        return this.closID;
    }

    public void setClosID(String closID) {
        this.closID = closID;
    }

    public LinuxIntelRdt enableCMT(Boolean enableCMT) {
        this.enableCMT = enableCMT;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="EnableCMT is the flag to indicate if the Intel RDT CMT is enabled. CMT (Cache Monitoring Technology) supports monitoring of the last-level cache (LLC) occupancy for the container.")
    public Boolean getEnableCMT() {
        return this.enableCMT;
    }

    public void setEnableCMT(Boolean enableCMT) {
        this.enableCMT = enableCMT;
    }

    public LinuxIntelRdt enableMBM(Boolean enableMBM) {
        this.enableMBM = enableMBM;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="EnableMBM is the flag to indicate if the Intel RDT MBM is enabled. MBM (Memory Bandwidth Monitoring) supports monitoring of total and local memory bandwidth for the container.")
    public Boolean getEnableMBM() {
        return this.enableMBM;
    }

    public void setEnableMBM(Boolean enableMBM) {
        this.enableMBM = enableMBM;
    }

    public LinuxIntelRdt l3CacheSchema(String l3CacheSchema) {
        this.l3CacheSchema = l3CacheSchema;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The schema for L3 cache id and capacity bitmask (CBM) Format: \"L3:<cache_id0>=<cbm0>;<cache_id1>=<cbm1>;...\"")
    public String getL3CacheSchema() {
        return this.l3CacheSchema;
    }

    public void setL3CacheSchema(String l3CacheSchema) {
        this.l3CacheSchema = l3CacheSchema;
    }

    public LinuxIntelRdt memBwSchema(String memBwSchema) {
        this.memBwSchema = memBwSchema;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The schema of memory bandwidth per L3 cache id Format: \"MB:<cache_id0>=bandwidth0;<cache_id1>=bandwidth1;...\" The unit of memory bandwidth is specified in \"percentages\" by default, and in \"MBps\" if MBA Software Controller is enabled.")
    public String getMemBwSchema() {
        return this.memBwSchema;
    }

    public void setMemBwSchema(String memBwSchema) {
        this.memBwSchema = memBwSchema;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LinuxIntelRdt linuxIntelRdt = (LinuxIntelRdt)o;
        return Objects.equals(this.closID, linuxIntelRdt.closID) && Objects.equals(this.enableCMT, linuxIntelRdt.enableCMT) && Objects.equals(this.enableMBM, linuxIntelRdt.enableMBM) && Objects.equals(this.l3CacheSchema, linuxIntelRdt.l3CacheSchema) && Objects.equals(this.memBwSchema, linuxIntelRdt.memBwSchema);
    }

    public int hashCode() {
        return Objects.hash(this.closID, this.enableCMT, this.enableMBM, this.l3CacheSchema, this.memBwSchema);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LinuxIntelRdt {\n");
        sb.append("    closID: ").append(this.toIndentedString(this.closID)).append("\n");
        sb.append("    enableCMT: ").append(this.toIndentedString(this.enableCMT)).append("\n");
        sb.append("    enableMBM: ").append(this.toIndentedString(this.enableMBM)).append("\n");
        sb.append("    l3CacheSchema: ").append(this.toIndentedString(this.l3CacheSchema)).append("\n");
        sb.append("    memBwSchema: ").append(this.toIndentedString(this.memBwSchema)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in LinuxIntelRdt is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `LinuxIntelRdt` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CLOS_I_D) != null && !jsonObj.get(SERIALIZED_NAME_CLOS_I_D).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CLOS_I_D).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `closID` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CLOS_I_D).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_L3_CACHE_SCHEMA) != null && !jsonObj.get(SERIALIZED_NAME_L3_CACHE_SCHEMA).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_L3_CACHE_SCHEMA).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `l3CacheSchema` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_L3_CACHE_SCHEMA).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MEM_BW_SCHEMA) != null && !jsonObj.get(SERIALIZED_NAME_MEM_BW_SCHEMA).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_MEM_BW_SCHEMA).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `memBwSchema` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MEM_BW_SCHEMA).toString()));
        }
    }

    public static LinuxIntelRdt fromJson(String jsonString) throws IOException {
        return (LinuxIntelRdt)JSON.getGson().fromJson(jsonString, LinuxIntelRdt.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CLOS_I_D);
        openapiFields.add(SERIALIZED_NAME_ENABLE_C_M_T);
        openapiFields.add(SERIALIZED_NAME_ENABLE_M_B_M);
        openapiFields.add(SERIALIZED_NAME_L3_CACHE_SCHEMA);
        openapiFields.add(SERIALIZED_NAME_MEM_BW_SCHEMA);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!LinuxIntelRdt.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(LinuxIntelRdt.class));
            return new TypeAdapter<LinuxIntelRdt>(){

                public void write(JsonWriter out, LinuxIntelRdt value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public LinuxIntelRdt read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    LinuxIntelRdt.validateJsonObject(jsonObj);
                    return (LinuxIntelRdt)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

