/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

@ApiModel(description="Size is the size information of the content related to this manifest. Note: These sizes only take the locally available content into account.")
public class ManifestSummarySize
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_CONTENT = "Content";
    @SerializedName(value="Content")
    private Long content;
    public static final String SERIALIZED_NAME_TOTAL = "Total";
    @SerializedName(value="Total")
    private Long total;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ManifestSummarySize content(Long content) {
        this.content = content;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Content is the size (in bytes) of all the locally present content in the content store (e.g. image config, layers) referenced by this manifest and its children. This only includes blobs in the content store.")
    public Long getContent() {
        return this.content;
    }

    public void setContent(Long content) {
        this.content = content;
    }

    public ManifestSummarySize total(Long total) {
        this.total = total;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Total is the total size (in bytes) of all the locally present data (both distributable and non-distributable) that's related to this manifest and its children. This equal to the sum of [Content] size AND all the sizes in the [Size] struct present in the Kind-specific data struct. For example, for an image kind (Kind == ManifestKindImage), this would include the size of the image content and unpacked image snapshots ([Size.Content] + [ImageData.Size.Unpacked]).")
    public Long getTotal() {
        return this.total;
    }

    public void setTotal(Long total) {
        this.total = total;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ManifestSummarySize manifestSummarySize = (ManifestSummarySize)o;
        return Objects.equals(this.content, manifestSummarySize.content) && Objects.equals(this.total, manifestSummarySize.total);
    }

    public int hashCode() {
        return Objects.hash(this.content, this.total);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ManifestSummarySize {\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("    total: ").append(this.toIndentedString(this.total)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ManifestSummarySize is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `ManifestSummarySize` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
    }

    public static ManifestSummarySize fromJson(String jsonString) throws IOException {
        return (ManifestSummarySize)JSON.getGson().fromJson(jsonString, ManifestSummarySize.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CONTENT);
        openapiFields.add(SERIALIZED_NAME_TOTAL);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ManifestSummarySize.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ManifestSummarySize.class));
            return new TypeAdapter<ManifestSummarySize>(){

                public void write(JsonWriter out, ManifestSummarySize value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public ManifestSummarySize read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ManifestSummarySize.validateJsonObject(jsonObj);
                    return (ManifestSummarySize)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

