/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.github.pod4dev.libpodj.model.Route;
import io.github.pod4dev.libpodj.model.Subnet;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.validation.Valid;

public class Network
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_CREATED = "created";
    @SerializedName(value="created")
    private OffsetDateTime created;
    public static final String SERIALIZED_NAME_DNS_ENABLED = "dns_enabled";
    @SerializedName(value="dns_enabled")
    private Boolean dnsEnabled;
    public static final String SERIALIZED_NAME_DRIVER = "driver";
    @SerializedName(value="driver")
    private String driver;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_INTERNAL = "internal";
    @SerializedName(value="internal")
    private Boolean internal;
    public static final String SERIALIZED_NAME_IPAM_OPTIONS = "ipam_options";
    @SerializedName(value="ipam_options")
    private Map<String, String> ipamOptions = null;
    public static final String SERIALIZED_NAME_IPV6_ENABLED = "ipv6_enabled";
    @SerializedName(value="ipv6_enabled")
    private Boolean ipv6Enabled;
    public static final String SERIALIZED_NAME_LABELS = "labels";
    @SerializedName(value="labels")
    private Map<String, String> labels = null;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_NETWORK_DNS_SERVERS = "network_dns_servers";
    @SerializedName(value="network_dns_servers")
    private List<String> networkDnsServers = null;
    public static final String SERIALIZED_NAME_NETWORK_INTERFACE = "network_interface";
    @SerializedName(value="network_interface")
    private String networkInterface;
    public static final String SERIALIZED_NAME_OPTIONS = "options";
    @SerializedName(value="options")
    private Map<String, String> options = null;
    public static final String SERIALIZED_NAME_ROUTES = "routes";
    @SerializedName(value="routes")
    private List<Route> routes = null;
    public static final String SERIALIZED_NAME_SUBNETS = "subnets";
    @SerializedName(value="subnets")
    private List<Subnet> subnets = null;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Network created(OffsetDateTime created) {
        this.created = created;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Created contains the timestamp when this network was created.")
    public OffsetDateTime getCreated() {
        return this.created;
    }

    public void setCreated(OffsetDateTime created) {
        this.created = created;
    }

    public Network dnsEnabled(Boolean dnsEnabled) {
        this.dnsEnabled = dnsEnabled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="DNSEnabled is whether name resolution is active for container on this Network. Only supported with the bridge driver.")
    public Boolean getDnsEnabled() {
        return this.dnsEnabled;
    }

    public void setDnsEnabled(Boolean dnsEnabled) {
        this.dnsEnabled = dnsEnabled;
    }

    public Network driver(String driver) {
        this.driver = driver;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Driver for this Network, e.g. bridge, macvlan...")
    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public Network id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ID of the Network.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Network internal(Boolean internal) {
        this.internal = internal;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Internal is whether the Network should not have external routes to public or other Networks.")
    public Boolean getInternal() {
        return this.internal;
    }

    public void setInternal(Boolean internal) {
        this.internal = internal;
    }

    public Network ipamOptions(Map<String, String> ipamOptions) {
        this.ipamOptions = ipamOptions;
        return this;
    }

    public Network putIpamOptionsItem(String key, String ipamOptionsItem) {
        if (this.ipamOptions == null) {
            this.ipamOptions = new HashMap<String, String>();
        }
        this.ipamOptions.put(key, ipamOptionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="IPAMOptions contains options used for the ip assignment.")
    public Map<String, String> getIpamOptions() {
        return this.ipamOptions;
    }

    public void setIpamOptions(Map<String, String> ipamOptions) {
        this.ipamOptions = ipamOptions;
    }

    public Network ipv6Enabled(Boolean ipv6Enabled) {
        this.ipv6Enabled = ipv6Enabled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="IPv6Enabled if set to true an ipv6 subnet should be created for this net.")
    public Boolean getIpv6Enabled() {
        return this.ipv6Enabled;
    }

    public void setIpv6Enabled(Boolean ipv6Enabled) {
        this.ipv6Enabled = ipv6Enabled;
    }

    public Network labels(Map<String, String> labels) {
        this.labels = labels;
        return this;
    }

    public Network putLabelsItem(String key, String labelsItem) {
        if (this.labels == null) {
            this.labels = new HashMap<String, String>();
        }
        this.labels.put(key, labelsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Labels is a set of key-value labels that have been applied to the Network.")
    public Map<String, String> getLabels() {
        return this.labels;
    }

    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
    }

    public Network name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the Network.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Network networkDnsServers(List<String> networkDnsServers) {
        this.networkDnsServers = networkDnsServers;
        return this;
    }

    public Network addNetworkDnsServersItem(String networkDnsServersItem) {
        if (this.networkDnsServers == null) {
            this.networkDnsServers = new ArrayList<String>();
        }
        this.networkDnsServers.add(networkDnsServersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of custom DNS server for podman's DNS resolver at network level, all the containers attached to this network will consider resolvers configured at network level.")
    public List<String> getNetworkDnsServers() {
        return this.networkDnsServers;
    }

    public void setNetworkDnsServers(List<String> networkDnsServers) {
        this.networkDnsServers = networkDnsServers;
    }

    public Network networkInterface(String networkInterface) {
        this.networkInterface = networkInterface;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="NetworkInterface is the network interface name on the host.")
    public String getNetworkInterface() {
        return this.networkInterface;
    }

    public void setNetworkInterface(String networkInterface) {
        this.networkInterface = networkInterface;
    }

    public Network options(Map<String, String> options) {
        this.options = options;
        return this;
    }

    public Network putOptionsItem(String key, String optionsItem) {
        if (this.options == null) {
            this.options = new HashMap<String, String>();
        }
        this.options.put(key, optionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Options is a set of key-value options that have been applied to the Network.")
    public Map<String, String> getOptions() {
        return this.options;
    }

    public void setOptions(Map<String, String> options) {
        this.options = options;
    }

    public Network routes(List<Route> routes) {
        this.routes = routes;
        return this;
    }

    public Network addRoutesItem(Route routesItem) {
        if (this.routes == null) {
            this.routes = new ArrayList<Route>();
        }
        this.routes.add(routesItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Routes to use for this network.")
    public List<Route> getRoutes() {
        return this.routes;
    }

    public void setRoutes(List<Route> routes) {
        this.routes = routes;
    }

    public Network subnets(List<Subnet> subnets) {
        this.subnets = subnets;
        return this;
    }

    public Network addSubnetsItem(Subnet subnetsItem) {
        if (this.subnets == null) {
            this.subnets = new ArrayList<Subnet>();
        }
        this.subnets.add(subnetsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Subnets to use for this network.")
    public List<Subnet> getSubnets() {
        return this.subnets;
    }

    public void setSubnets(List<Subnet> subnets) {
        this.subnets = subnets;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Network network = (Network)o;
        return Objects.equals(this.created, network.created) && Objects.equals(this.dnsEnabled, network.dnsEnabled) && Objects.equals(this.driver, network.driver) && Objects.equals(this.id, network.id) && Objects.equals(this.internal, network.internal) && Objects.equals(this.ipamOptions, network.ipamOptions) && Objects.equals(this.ipv6Enabled, network.ipv6Enabled) && Objects.equals(this.labels, network.labels) && Objects.equals(this.name, network.name) && Objects.equals(this.networkDnsServers, network.networkDnsServers) && Objects.equals(this.networkInterface, network.networkInterface) && Objects.equals(this.options, network.options) && Objects.equals(this.routes, network.routes) && Objects.equals(this.subnets, network.subnets);
    }

    public int hashCode() {
        return Objects.hash(this.created, this.dnsEnabled, this.driver, this.id, this.internal, this.ipamOptions, this.ipv6Enabled, this.labels, this.name, this.networkDnsServers, this.networkInterface, this.options, this.routes, this.subnets);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Network {\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    dnsEnabled: ").append(this.toIndentedString(this.dnsEnabled)).append("\n");
        sb.append("    driver: ").append(this.toIndentedString(this.driver)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    internal: ").append(this.toIndentedString(this.internal)).append("\n");
        sb.append("    ipamOptions: ").append(this.toIndentedString(this.ipamOptions)).append("\n");
        sb.append("    ipv6Enabled: ").append(this.toIndentedString(this.ipv6Enabled)).append("\n");
        sb.append("    labels: ").append(this.toIndentedString(this.labels)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    networkDnsServers: ").append(this.toIndentedString(this.networkDnsServers)).append("\n");
        sb.append("    networkInterface: ").append(this.toIndentedString(this.networkInterface)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("    routes: ").append(this.toIndentedString(this.routes)).append("\n");
        sb.append("    subnets: ").append(this.toIndentedString(this.subnets)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArraysubnets;
        JsonArray jsonArrayroutes;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in Network is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Network` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DRIVER) != null && !jsonObj.get(SERIALIZED_NAME_DRIVER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DRIVER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `driver` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DRIVER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NETWORK_DNS_SERVERS) != null && !jsonObj.get(SERIALIZED_NAME_NETWORK_DNS_SERVERS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NETWORK_DNS_SERVERS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `network_dns_servers` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NETWORK_DNS_SERVERS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NETWORK_INTERFACE) != null && !jsonObj.get(SERIALIZED_NAME_NETWORK_INTERFACE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NETWORK_INTERFACE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `network_interface` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NETWORK_INTERFACE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ROUTES) != null && !jsonObj.get(SERIALIZED_NAME_ROUTES).isJsonNull() && (jsonArrayroutes = jsonObj.getAsJsonArray(SERIALIZED_NAME_ROUTES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ROUTES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `routes` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ROUTES).toString()));
            }
            for (int i = 0; i < jsonArrayroutes.size(); ++i) {
                Route.validateJsonObject(jsonArrayroutes.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_SUBNETS) != null && !jsonObj.get(SERIALIZED_NAME_SUBNETS).isJsonNull() && (jsonArraysubnets = jsonObj.getAsJsonArray(SERIALIZED_NAME_SUBNETS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_SUBNETS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `subnets` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SUBNETS).toString()));
            }
            for (int i = 0; i < jsonArraysubnets.size(); ++i) {
                Subnet.validateJsonObject(jsonArraysubnets.get(i).getAsJsonObject());
            }
        }
    }

    public static Network fromJson(String jsonString) throws IOException {
        return (Network)JSON.getGson().fromJson(jsonString, Network.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CREATED);
        openapiFields.add(SERIALIZED_NAME_DNS_ENABLED);
        openapiFields.add(SERIALIZED_NAME_DRIVER);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_INTERNAL);
        openapiFields.add(SERIALIZED_NAME_IPAM_OPTIONS);
        openapiFields.add(SERIALIZED_NAME_IPV6_ENABLED);
        openapiFields.add(SERIALIZED_NAME_LABELS);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_NETWORK_DNS_SERVERS);
        openapiFields.add(SERIALIZED_NAME_NETWORK_INTERFACE);
        openapiFields.add(SERIALIZED_NAME_OPTIONS);
        openapiFields.add(SERIALIZED_NAME_ROUTES);
        openapiFields.add(SERIALIZED_NAME_SUBNETS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Network.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Network.class));
            return new TypeAdapter<Network>(){

                public void write(JsonWriter out, Network value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Network read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Network.validateJsonObject(jsonObj);
                    return (Network)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

