/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class PodStatsReport
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_BLOCK_I_O = "BlockIO";
    @SerializedName(value="BlockIO")
    private String blockIO;
    public static final String SERIALIZED_NAME_C_I_D = "CID";
    @SerializedName(value="CID")
    private String CID;
    public static final String SERIALIZED_NAME_C_P_U = "CPU";
    @SerializedName(value="CPU")
    private String CPU;
    public static final String SERIALIZED_NAME_MEM = "Mem";
    @SerializedName(value="Mem")
    private String mem;
    public static final String SERIALIZED_NAME_MEM_USAGE = "MemUsage";
    @SerializedName(value="MemUsage")
    private String memUsage;
    public static final String SERIALIZED_NAME_MEM_USAGE_BYTES = "MemUsageBytes";
    @SerializedName(value="MemUsageBytes")
    private String memUsageBytes;
    public static final String SERIALIZED_NAME_NAME = "Name";
    @SerializedName(value="Name")
    private String name;
    public static final String SERIALIZED_NAME_NET_I_O = "NetIO";
    @SerializedName(value="NetIO")
    private String netIO;
    public static final String SERIALIZED_NAME_P_I_D_S = "PIDS";
    @SerializedName(value="PIDS")
    private String PIDS;
    public static final String SERIALIZED_NAME_POD = "Pod";
    @SerializedName(value="Pod")
    private String pod;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public PodStatsReport blockIO(String blockIO) {
        this.blockIO = blockIO;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Humanized disk usage read + write")
    public String getBlockIO() {
        return this.blockIO;
    }

    public void setBlockIO(String blockIO) {
        this.blockIO = blockIO;
    }

    public PodStatsReport CID(String CID) {
        this.CID = CID;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="e43534f89a7d", value="Container ID")
    public String getCID() {
        return this.CID;
    }

    public void setCID(String CID) {
        this.CID = CID;
    }

    public PodStatsReport CPU(String CPU) {
        this.CPU = CPU;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="75.5%", value="Percentage of CPU utilized by pod")
    public String getCPU() {
        return this.CPU;
    }

    public void setCPU(String CPU) {
        this.CPU = CPU;
    }

    public PodStatsReport mem(String mem) {
        this.mem = mem;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="50.5%", value="Percentage of Memory utilized by pod")
    public String getMem() {
        return this.mem;
    }

    public void setMem(String mem) {
        this.mem = mem;
    }

    public PodStatsReport memUsage(String memUsage) {
        this.memUsage = memUsage;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="12mb / 24mb", value="Humanized Memory usage and maximum")
    public String getMemUsage() {
        return this.memUsage;
    }

    public void setMemUsage(String memUsage) {
        this.memUsage = memUsage;
    }

    public PodStatsReport memUsageBytes(String memUsageBytes) {
        this.memUsageBytes = memUsageBytes;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1,000,000 / 4,000,000", value="Memory usage and maximum in bytes")
    public String getMemUsageBytes() {
        return this.memUsageBytes;
    }

    public void setMemUsageBytes(String memUsageBytes) {
        this.memUsageBytes = memUsageBytes;
    }

    public PodStatsReport name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="elastic_pascal", value="Pod Name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PodStatsReport netIO(String netIO) {
        this.netIO = netIO;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Network usage inbound + outbound")
    public String getNetIO() {
        return this.netIO;
    }

    public void setNetIO(String netIO) {
        this.netIO = netIO;
    }

    public PodStatsReport PIDS(String PIDS) {
        this.PIDS = PIDS;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Container PID")
    public String getPIDS() {
        return this.PIDS;
    }

    public void setPIDS(String PIDS) {
        this.PIDS = PIDS;
    }

    public PodStatsReport pod(String pod) {
        this.pod = pod;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="62310217a19e", value="Pod ID")
    public String getPod() {
        return this.pod;
    }

    public void setPod(String pod) {
        this.pod = pod;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PodStatsReport podStatsReport = (PodStatsReport)o;
        return Objects.equals(this.blockIO, podStatsReport.blockIO) && Objects.equals(this.CID, podStatsReport.CID) && Objects.equals(this.CPU, podStatsReport.CPU) && Objects.equals(this.mem, podStatsReport.mem) && Objects.equals(this.memUsage, podStatsReport.memUsage) && Objects.equals(this.memUsageBytes, podStatsReport.memUsageBytes) && Objects.equals(this.name, podStatsReport.name) && Objects.equals(this.netIO, podStatsReport.netIO) && Objects.equals(this.PIDS, podStatsReport.PIDS) && Objects.equals(this.pod, podStatsReport.pod);
    }

    public int hashCode() {
        return Objects.hash(this.blockIO, this.CID, this.CPU, this.mem, this.memUsage, this.memUsageBytes, this.name, this.netIO, this.PIDS, this.pod);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PodStatsReport {\n");
        sb.append("    blockIO: ").append(this.toIndentedString(this.blockIO)).append("\n");
        sb.append("    CID: ").append(this.toIndentedString(this.CID)).append("\n");
        sb.append("    CPU: ").append(this.toIndentedString(this.CPU)).append("\n");
        sb.append("    mem: ").append(this.toIndentedString(this.mem)).append("\n");
        sb.append("    memUsage: ").append(this.toIndentedString(this.memUsage)).append("\n");
        sb.append("    memUsageBytes: ").append(this.toIndentedString(this.memUsageBytes)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    netIO: ").append(this.toIndentedString(this.netIO)).append("\n");
        sb.append("    PIDS: ").append(this.toIndentedString(this.PIDS)).append("\n");
        sb.append("    pod: ").append(this.toIndentedString(this.pod)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in PodStatsReport is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `PodStatsReport` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BLOCK_I_O) != null && !jsonObj.get(SERIALIZED_NAME_BLOCK_I_O).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_BLOCK_I_O).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `BlockIO` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BLOCK_I_O).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_C_I_D) != null && !jsonObj.get(SERIALIZED_NAME_C_I_D).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_C_I_D).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `CID` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_C_I_D).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_C_P_U) != null && !jsonObj.get(SERIALIZED_NAME_C_P_U).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_C_P_U).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `CPU` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_C_P_U).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MEM) != null && !jsonObj.get(SERIALIZED_NAME_MEM).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_MEM).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Mem` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MEM).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MEM_USAGE) != null && !jsonObj.get(SERIALIZED_NAME_MEM_USAGE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_MEM_USAGE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `MemUsage` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MEM_USAGE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MEM_USAGE_BYTES) != null && !jsonObj.get(SERIALIZED_NAME_MEM_USAGE_BYTES).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_MEM_USAGE_BYTES).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `MemUsageBytes` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MEM_USAGE_BYTES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NET_I_O) != null && !jsonObj.get(SERIALIZED_NAME_NET_I_O).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NET_I_O).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `NetIO` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NET_I_O).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_P_I_D_S) != null && !jsonObj.get(SERIALIZED_NAME_P_I_D_S).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_P_I_D_S).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `PIDS` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_P_I_D_S).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_POD) != null && !jsonObj.get(SERIALIZED_NAME_POD).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_POD).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Pod` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_POD).toString()));
        }
    }

    public static PodStatsReport fromJson(String jsonString) throws IOException {
        return (PodStatsReport)JSON.getGson().fromJson(jsonString, PodStatsReport.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_BLOCK_I_O);
        openapiFields.add(SERIALIZED_NAME_C_I_D);
        openapiFields.add(SERIALIZED_NAME_C_P_U);
        openapiFields.add(SERIALIZED_NAME_MEM);
        openapiFields.add(SERIALIZED_NAME_MEM_USAGE);
        openapiFields.add(SERIALIZED_NAME_MEM_USAGE_BYTES);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_NET_I_O);
        openapiFields.add(SERIALIZED_NAME_P_I_D_S);
        openapiFields.add(SERIALIZED_NAME_POD);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!PodStatsReport.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(PodStatsReport.class));
            return new TypeAdapter<PodStatsReport>(){

                public void write(JsonWriter out, PodStatsReport value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public PodStatsReport read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    PodStatsReport.validateJsonObject(jsonObj);
                    return (PodStatsReport)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

