/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.github.pod4dev.libpodj.model.SecretDriverSpec;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.validation.Valid;

public class SecretCreate
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_DATA = "Data";
    @SerializedName(value="Data")
    private String data;
    public static final String SERIALIZED_NAME_DRIVER = "Driver";
    @SerializedName(value="Driver")
    private SecretDriverSpec driver;
    public static final String SERIALIZED_NAME_LABELS = "Labels";
    @SerializedName(value="Labels")
    private Map<String, String> labels = null;
    public static final String SERIALIZED_NAME_NAME = "Name";
    @SerializedName(value="Name")
    private String name;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public SecretCreate data(String data) {
        this.data = data;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Base64-url-safe-encoded (RFC 4648) data to store as secret.")
    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public SecretCreate driver(SecretDriverSpec driver) {
        this.driver = driver;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public SecretDriverSpec getDriver() {
        return this.driver;
    }

    public void setDriver(SecretDriverSpec driver) {
        this.driver = driver;
    }

    public SecretCreate labels(Map<String, String> labels) {
        this.labels = labels;
        return this;
    }

    public SecretCreate putLabelsItem(String key, String labelsItem) {
        if (this.labels == null) {
            this.labels = new HashMap<String, String>();
        }
        this.labels.put(key, labelsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Labels are labels on the secret")
    public Map<String, String> getLabels() {
        return this.labels;
    }

    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
    }

    public SecretCreate name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="User-defined name of the secret.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecretCreate secretCreate = (SecretCreate)o;
        return Objects.equals(this.data, secretCreate.data) && Objects.equals(this.driver, secretCreate.driver) && Objects.equals(this.labels, secretCreate.labels) && Objects.equals(this.name, secretCreate.name);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.driver, this.labels, this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SecretCreate {\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    driver: ").append(this.toIndentedString(this.driver)).append("\n");
        sb.append("    labels: ").append(this.toIndentedString(this.labels)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in SecretCreate is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `SecretCreate` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DATA) != null && !jsonObj.get(SERIALIZED_NAME_DATA).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DATA).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Data` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DATA).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DRIVER) != null && !jsonObj.get(SERIALIZED_NAME_DRIVER).isJsonNull()) {
            SecretDriverSpec.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_DRIVER));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
    }

    public static SecretCreate fromJson(String jsonString) throws IOException {
        return (SecretCreate)JSON.getGson().fromJson(jsonString, SecretCreate.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_DATA);
        openapiFields.add(SERIALIZED_NAME_DRIVER);
        openapiFields.add(SERIALIZED_NAME_LABELS);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!SecretCreate.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(SecretCreate.class));
            return new TypeAdapter<SecretCreate>(){

                public void write(JsonWriter out, SecretCreate value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public SecretCreate read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    SecretCreate.validateJsonObject(jsonObj);
                    return (SecretCreate)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

