/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.github.pod4dev.libpodj.model.IDMappingOptions;
import io.github.pod4dev.libpodj.model.ImageVolume;
import io.github.pod4dev.libpodj.model.LinuxDevice;
import io.github.pod4dev.libpodj.model.LinuxDeviceCgroup;
import io.github.pod4dev.libpodj.model.LinuxIntelRdt;
import io.github.pod4dev.libpodj.model.LinuxPersonality;
import io.github.pod4dev.libpodj.model.LinuxResources;
import io.github.pod4dev.libpodj.model.LinuxThrottleDevice;
import io.github.pod4dev.libpodj.model.LinuxWeightDevice;
import io.github.pod4dev.libpodj.model.LogConfigLibpod;
import io.github.pod4dev.libpodj.model.Mount;
import io.github.pod4dev.libpodj.model.NamedVolume;
import io.github.pod4dev.libpodj.model.Namespace;
import io.github.pod4dev.libpodj.model.OverlayVolume;
import io.github.pod4dev.libpodj.model.POSIXRlimit;
import io.github.pod4dev.libpodj.model.PerNetworkOptions;
import io.github.pod4dev.libpodj.model.PortMapping;
import io.github.pod4dev.libpodj.model.Schema2HealthConfig;
import io.github.pod4dev.libpodj.model.Secret;
import io.github.pod4dev.libpodj.model.StartupHealthCheck;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.validation.Valid;

@ApiModel(description="SpecGenerator creates an OCI spec and Libpod configuration options to create a container based on the given configuration.")
public class SpecGenerator
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_NETWORKS = "Networks";
    @SerializedName(value="Networks")
    private Map<String, PerNetworkOptions> networks = null;
    public static final String SERIALIZED_NAME_ANNOTATIONS = "annotations";
    @SerializedName(value="annotations")
    private Map<String, String> annotations = null;
    public static final String SERIALIZED_NAME_APPARMOR_PROFILE = "apparmor_profile";
    @SerializedName(value="apparmor_profile")
    private String apparmorProfile;
    public static final String SERIALIZED_NAME_BASE_HOSTS_FILE = "base_hosts_file";
    @SerializedName(value="base_hosts_file")
    private String baseHostsFile;
    public static final String SERIALIZED_NAME_CAP_ADD = "cap_add";
    @SerializedName(value="cap_add")
    private List<String> capAdd = null;
    public static final String SERIALIZED_NAME_CAP_DROP = "cap_drop";
    @SerializedName(value="cap_drop")
    private List<String> capDrop = null;
    public static final String SERIALIZED_NAME_CGROUP_PARENT = "cgroup_parent";
    @SerializedName(value="cgroup_parent")
    private String cgroupParent;
    public static final String SERIALIZED_NAME_CGROUPNS = "cgroupns";
    @SerializedName(value="cgroupns")
    private Namespace cgroupns;
    public static final String SERIALIZED_NAME_CGROUPS_MODE = "cgroups_mode";
    @SerializedName(value="cgroups_mode")
    private String cgroupsMode;
    public static final String SERIALIZED_NAME_CHROOT_DIRECTORIES = "chroot_directories";
    @SerializedName(value="chroot_directories")
    private List<String> chrootDirectories = null;
    public static final String SERIALIZED_NAME_CNI_NETWORKS = "cni_networks";
    @SerializedName(value="cni_networks")
    private List<String> cniNetworks = null;
    public static final String SERIALIZED_NAME_COMMAND = "command";
    @SerializedName(value="command")
    private List<String> command = null;
    public static final String SERIALIZED_NAME_CONMON_PID_FILE = "conmon_pid_file";
    @SerializedName(value="conmon_pid_file")
    private String conmonPidFile;
    public static final String SERIALIZED_NAME_CONTAINER_CREATE_COMMAND = "containerCreateCommand";
    @SerializedName(value="containerCreateCommand")
    private List<String> containerCreateCommand = null;
    public static final String SERIALIZED_NAME_CREATE_WORKING_DIR = "create_working_dir";
    @SerializedName(value="create_working_dir")
    private Boolean createWorkingDir;
    public static final String SERIALIZED_NAME_DEPENDENCY_CONTAINERS = "dependencyContainers";
    @SerializedName(value="dependencyContainers")
    private List<String> dependencyContainers = null;
    public static final String SERIALIZED_NAME_DEVICE_CGROUP_RULE = "device_cgroup_rule";
    @SerializedName(value="device_cgroup_rule")
    private List<LinuxDeviceCgroup> deviceCgroupRule = null;
    public static final String SERIALIZED_NAME_DEVICES = "devices";
    @SerializedName(value="devices")
    private List<LinuxDevice> devices = null;
    public static final String SERIALIZED_NAME_DEVICES_FROM = "devices_from";
    @SerializedName(value="devices_from")
    private List<String> devicesFrom = null;
    public static final String SERIALIZED_NAME_DNS_OPTION = "dns_option";
    @SerializedName(value="dns_option")
    private List<String> dnsOption = null;
    public static final String SERIALIZED_NAME_DNS_SEARCH = "dns_search";
    @SerializedName(value="dns_search")
    private List<String> dnsSearch = null;
    public static final String SERIALIZED_NAME_DNS_SERVER = "dns_server";
    @SerializedName(value="dns_server")
    private List<String> dnsServer = null;
    public static final String SERIALIZED_NAME_ENTRYPOINT = "entrypoint";
    @SerializedName(value="entrypoint")
    private List<String> entrypoint = null;
    public static final String SERIALIZED_NAME_ENV = "env";
    @SerializedName(value="env")
    private Map<String, String> env = null;
    public static final String SERIALIZED_NAME_ENV_HOST = "env_host";
    @SerializedName(value="env_host")
    private Boolean envHost;
    public static final String SERIALIZED_NAME_ENVMERGE = "envmerge";
    @SerializedName(value="envmerge")
    private List<String> envmerge = null;
    public static final String SERIALIZED_NAME_EXPOSE = "expose";
    @SerializedName(value="expose")
    private Object expose;
    public static final String SERIALIZED_NAME_GROUP_ENTRY = "group_entry";
    @SerializedName(value="group_entry")
    private String groupEntry;
    public static final String SERIALIZED_NAME_GROUPS = "groups";
    @SerializedName(value="groups")
    private List<String> groups = null;
    public static final String SERIALIZED_NAME_HEALTH_CHECK_ON_FAILURE_ACTION = "health_check_on_failure_action";
    @SerializedName(value="health_check_on_failure_action")
    private Long healthCheckOnFailureAction;
    public static final String SERIALIZED_NAME_HEALTH_LOG_DESTINATION = "healthLogDestination";
    @SerializedName(value="healthLogDestination")
    private String healthLogDestination;
    public static final String SERIALIZED_NAME_HEALTH_MAX_LOG_COUNT = "healthMaxLogCount";
    @SerializedName(value="healthMaxLogCount")
    private Integer healthMaxLogCount;
    public static final String SERIALIZED_NAME_HEALTH_MAX_LOG_SIZE = "healthMaxLogSize";
    @SerializedName(value="healthMaxLogSize")
    private Integer healthMaxLogSize;
    public static final String SERIALIZED_NAME_HEALTHCONFIG = "healthconfig";
    @SerializedName(value="healthconfig")
    private Schema2HealthConfig healthconfig;
    public static final String SERIALIZED_NAME_HOST_DEVICE_LIST = "host_device_list";
    @SerializedName(value="host_device_list")
    private List<LinuxDevice> hostDeviceList = null;
    public static final String SERIALIZED_NAME_HOSTADD = "hostadd";
    @SerializedName(value="hostadd")
    private List<String> hostadd = null;
    public static final String SERIALIZED_NAME_HOSTNAME = "hostname";
    @SerializedName(value="hostname")
    private String hostname;
    public static final String SERIALIZED_NAME_HOSTUSERS = "hostusers";
    @SerializedName(value="hostusers")
    private List<String> hostusers = null;
    public static final String SERIALIZED_NAME_HTTPPROXY = "httpproxy";
    @SerializedName(value="httpproxy")
    private Boolean httpproxy;
    public static final String SERIALIZED_NAME_IDMAPPINGS = "idmappings";
    @SerializedName(value="idmappings")
    private IDMappingOptions idmappings;
    public static final String SERIALIZED_NAME_IMAGE = "image";
    @SerializedName(value="image")
    private String image;
    public static final String SERIALIZED_NAME_IMAGE_ARCH = "image_arch";
    @SerializedName(value="image_arch")
    private String imageArch;
    public static final String SERIALIZED_NAME_IMAGE_OS = "image_os";
    @SerializedName(value="image_os")
    private String imageOs;
    public static final String SERIALIZED_NAME_IMAGE_VARIANT = "image_variant";
    @SerializedName(value="image_variant")
    private String imageVariant;
    public static final String SERIALIZED_NAME_IMAGE_VOLUME_MODE = "image_volume_mode";
    @SerializedName(value="image_volume_mode")
    private String imageVolumeMode;
    public static final String SERIALIZED_NAME_IMAGE_VOLUMES = "image_volumes";
    @SerializedName(value="image_volumes")
    private List<ImageVolume> imageVolumes = null;
    public static final String SERIALIZED_NAME_INIT = "init";
    @SerializedName(value="init")
    private Boolean init;
    public static final String SERIALIZED_NAME_INIT_CONTAINER_TYPE = "init_container_type";
    @SerializedName(value="init_container_type")
    private String initContainerType;
    public static final String SERIALIZED_NAME_INIT_PATH = "init_path";
    @SerializedName(value="init_path")
    private String initPath;
    public static final String SERIALIZED_NAME_INTEL_RDT = "intelRdt";
    @SerializedName(value="intelRdt")
    private LinuxIntelRdt intelRdt;
    public static final String SERIALIZED_NAME_IPCNS = "ipcns";
    @SerializedName(value="ipcns")
    private Namespace ipcns;
    public static final String SERIALIZED_NAME_LABEL_NESTED = "label_nested";
    @SerializedName(value="label_nested")
    private Boolean labelNested;
    public static final String SERIALIZED_NAME_LABELS = "labels";
    @SerializedName(value="labels")
    private Map<String, String> labels = null;
    public static final String SERIALIZED_NAME_LOG_CONFIGURATION = "log_configuration";
    @SerializedName(value="log_configuration")
    private LogConfigLibpod logConfiguration;
    public static final String SERIALIZED_NAME_MANAGE_PASSWORD = "manage_password";
    @SerializedName(value="manage_password")
    private Boolean managePassword;
    public static final String SERIALIZED_NAME_MASK = "mask";
    @SerializedName(value="mask")
    private List<String> mask = null;
    public static final String SERIALIZED_NAME_MOUNTS = "mounts";
    @SerializedName(value="mounts")
    private List<Mount> mounts = null;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_NETNS = "netns";
    @SerializedName(value="netns")
    private Namespace netns;
    public static final String SERIALIZED_NAME_NETWORK_OPTIONS = "network_options";
    @SerializedName(value="network_options")
    private Map<String, List<String>> networkOptions = null;
    public static final String SERIALIZED_NAME_NO_NEW_PRIVILEGES = "no_new_privileges";
    @SerializedName(value="no_new_privileges")
    private Boolean noNewPrivileges;
    public static final String SERIALIZED_NAME_OCI_RUNTIME = "oci_runtime";
    @SerializedName(value="oci_runtime")
    private String ociRuntime;
    public static final String SERIALIZED_NAME_OOM_SCORE_ADJ = "oom_score_adj";
    @SerializedName(value="oom_score_adj")
    private Long oomScoreAdj;
    public static final String SERIALIZED_NAME_OVERLAY_VOLUMES = "overlay_volumes";
    @SerializedName(value="overlay_volumes")
    private List<OverlayVolume> overlayVolumes = null;
    public static final String SERIALIZED_NAME_PASSWD_ENTRY = "passwd_entry";
    @SerializedName(value="passwd_entry")
    private String passwdEntry;
    public static final String SERIALIZED_NAME_PERSONALITY = "personality";
    @SerializedName(value="personality")
    private LinuxPersonality personality;
    public static final String SERIALIZED_NAME_PIDNS = "pidns";
    @SerializedName(value="pidns")
    private Namespace pidns;
    public static final String SERIALIZED_NAME_POD = "pod";
    @SerializedName(value="pod")
    private String pod;
    public static final String SERIALIZED_NAME_PORTMAPPINGS = "portmappings";
    @SerializedName(value="portmappings")
    private List<PortMapping> portmappings = null;
    public static final String SERIALIZED_NAME_PRIVILEGED = "privileged";
    @SerializedName(value="privileged")
    private Boolean privileged;
    public static final String SERIALIZED_NAME_PROCFS_OPTS = "procfs_opts";
    @SerializedName(value="procfs_opts")
    private List<String> procfsOpts = null;
    public static final String SERIALIZED_NAME_PUBLISH_IMAGE_PORTS = "publish_image_ports";
    @SerializedName(value="publish_image_ports")
    private Boolean publishImagePorts;
    public static final String SERIALIZED_NAME_R_LIMITS = "r_limits";
    @SerializedName(value="r_limits")
    private List<POSIXRlimit> rLimits = null;
    public static final String SERIALIZED_NAME_RAW_IMAGE_NAME = "raw_image_name";
    @SerializedName(value="raw_image_name")
    private String rawImageName;
    public static final String SERIALIZED_NAME_READ_ONLY_FILESYSTEM = "read_only_filesystem";
    @SerializedName(value="read_only_filesystem")
    private Boolean readOnlyFilesystem;
    public static final String SERIALIZED_NAME_READ_WRITE_TMPFS = "read_write_tmpfs";
    @SerializedName(value="read_write_tmpfs")
    private Boolean readWriteTmpfs;
    public static final String SERIALIZED_NAME_REMOVE = "remove";
    @SerializedName(value="remove")
    private Boolean remove;
    public static final String SERIALIZED_NAME_REMOVE_IMAGE = "removeImage";
    @SerializedName(value="removeImage")
    private Boolean removeImage;
    public static final String SERIALIZED_NAME_RESOURCE_LIMITS = "resource_limits";
    @SerializedName(value="resource_limits")
    private LinuxResources resourceLimits;
    public static final String SERIALIZED_NAME_RESTART_POLICY = "restart_policy";
    @SerializedName(value="restart_policy")
    private String restartPolicy;
    public static final String SERIALIZED_NAME_RESTART_TRIES = "restart_tries";
    @SerializedName(value="restart_tries")
    private Integer restartTries;
    public static final String SERIALIZED_NAME_ROOTFS = "rootfs";
    @SerializedName(value="rootfs")
    private String rootfs;
    public static final String SERIALIZED_NAME_ROOTFS_MAPPING = "rootfs_mapping";
    @SerializedName(value="rootfs_mapping")
    private String rootfsMapping;
    public static final String SERIALIZED_NAME_ROOTFS_OVERLAY = "rootfs_overlay";
    @SerializedName(value="rootfs_overlay")
    private Boolean rootfsOverlay;
    public static final String SERIALIZED_NAME_ROOTFS_PROPAGATION = "rootfs_propagation";
    @SerializedName(value="rootfs_propagation")
    private String rootfsPropagation;
    public static final String SERIALIZED_NAME_SDNOTIFY_MODE = "sdnotifyMode";
    @SerializedName(value="sdnotifyMode")
    private String sdnotifyMode;
    public static final String SERIALIZED_NAME_SECCOMP_POLICY = "seccomp_policy";
    @SerializedName(value="seccomp_policy")
    private String seccompPolicy;
    public static final String SERIALIZED_NAME_SECCOMP_PROFILE_PATH = "seccomp_profile_path";
    @SerializedName(value="seccomp_profile_path")
    private String seccompProfilePath;
    public static final String SERIALIZED_NAME_SECRET_ENV = "secret_env";
    @SerializedName(value="secret_env")
    private Map<String, String> secretEnv = null;
    public static final String SERIALIZED_NAME_SECRETS = "secrets";
    @SerializedName(value="secrets")
    private List<Secret> secrets = null;
    public static final String SERIALIZED_NAME_SELINUX_OPTS = "selinux_opts";
    @SerializedName(value="selinux_opts")
    private List<String> selinuxOpts = null;
    public static final String SERIALIZED_NAME_SHM_SIZE = "shm_size";
    @SerializedName(value="shm_size")
    private Long shmSize;
    public static final String SERIALIZED_NAME_SHM_SIZE_SYSTEMD = "shm_size_systemd";
    @SerializedName(value="shm_size_systemd")
    private Long shmSizeSystemd;
    public static final String SERIALIZED_NAME_STARTUP_HEALTH_CONFIG = "startupHealthConfig";
    @SerializedName(value="startupHealthConfig")
    private StartupHealthCheck startupHealthConfig;
    public static final String SERIALIZED_NAME_STDIN = "stdin";
    @SerializedName(value="stdin")
    private Boolean stdin;
    public static final String SERIALIZED_NAME_STOP_SIGNAL = "stop_signal";
    @SerializedName(value="stop_signal")
    private Long stopSignal;
    public static final String SERIALIZED_NAME_STOP_TIMEOUT = "stop_timeout";
    @SerializedName(value="stop_timeout")
    private Integer stopTimeout;
    public static final String SERIALIZED_NAME_STORAGE_OPTS = "storage_opts";
    @SerializedName(value="storage_opts")
    private Map<String, String> storageOpts = null;
    public static final String SERIALIZED_NAME_SYSCTL = "sysctl";
    @SerializedName(value="sysctl")
    private Map<String, String> sysctl = null;
    public static final String SERIALIZED_NAME_SYSTEMD = "systemd";
    @SerializedName(value="systemd")
    private String systemd;
    public static final String SERIALIZED_NAME_TERMINAL = "terminal";
    @SerializedName(value="terminal")
    private Boolean terminal;
    public static final String SERIALIZED_NAME_THROTTLE_READ_BPS_DEVICE = "throttleReadBpsDevice";
    @SerializedName(value="throttleReadBpsDevice")
    private Map<String, LinuxThrottleDevice> throttleReadBpsDevice = null;
    public static final String SERIALIZED_NAME_THROTTLE_READ_I_O_P_S_DEVICE = "throttleReadIOPSDevice";
    @SerializedName(value="throttleReadIOPSDevice")
    private Map<String, LinuxThrottleDevice> throttleReadIOPSDevice = null;
    public static final String SERIALIZED_NAME_THROTTLE_WRITE_BPS_DEVICE = "throttleWriteBpsDevice";
    @SerializedName(value="throttleWriteBpsDevice")
    private Map<String, LinuxThrottleDevice> throttleWriteBpsDevice = null;
    public static final String SERIALIZED_NAME_THROTTLE_WRITE_I_O_P_S_DEVICE = "throttleWriteIOPSDevice";
    @SerializedName(value="throttleWriteIOPSDevice")
    private Map<String, LinuxThrottleDevice> throttleWriteIOPSDevice = null;
    public static final String SERIALIZED_NAME_TIMEOUT = "timeout";
    @SerializedName(value="timeout")
    private Integer timeout;
    public static final String SERIALIZED_NAME_TIMEZONE = "timezone";
    @SerializedName(value="timezone")
    private String timezone;
    public static final String SERIALIZED_NAME_UMASK = "umask";
    @SerializedName(value="umask")
    private String umask;
    public static final String SERIALIZED_NAME_UNIFIED = "unified";
    @SerializedName(value="unified")
    private Map<String, String> unified = null;
    public static final String SERIALIZED_NAME_UNMASK = "unmask";
    @SerializedName(value="unmask")
    private List<String> unmask = null;
    public static final String SERIALIZED_NAME_UNSETENV = "unsetenv";
    @SerializedName(value="unsetenv")
    private List<String> unsetenv = null;
    public static final String SERIALIZED_NAME_UNSETENVALL = "unsetenvall";
    @SerializedName(value="unsetenvall")
    private Boolean unsetenvall;
    public static final String SERIALIZED_NAME_USE_IMAGE_HOSTS = "use_image_hosts";
    @SerializedName(value="use_image_hosts")
    private Boolean useImageHosts;
    public static final String SERIALIZED_NAME_USE_IMAGE_RESOLVE_CONF = "use_image_resolve_conf";
    @SerializedName(value="use_image_resolve_conf")
    private Boolean useImageResolveConf;
    public static final String SERIALIZED_NAME_USER = "user";
    @SerializedName(value="user")
    private String user;
    public static final String SERIALIZED_NAME_USERNS = "userns";
    @SerializedName(value="userns")
    private Namespace userns;
    public static final String SERIALIZED_NAME_UTSNS = "utsns";
    @SerializedName(value="utsns")
    private Namespace utsns;
    public static final String SERIALIZED_NAME_VOLATILE = "volatile";
    @SerializedName(value="volatile")
    private Boolean _volatile;
    public static final String SERIALIZED_NAME_VOLUMES = "volumes";
    @SerializedName(value="volumes")
    private List<NamedVolume> volumes = null;
    public static final String SERIALIZED_NAME_VOLUMES_FROM = "volumes_from";
    @SerializedName(value="volumes_from")
    private List<String> volumesFrom = null;
    public static final String SERIALIZED_NAME_WEIGHT_DEVICE = "weightDevice";
    @SerializedName(value="weightDevice")
    private Map<String, LinuxWeightDevice> weightDevice = null;
    public static final String SERIALIZED_NAME_WORK_DIR = "work_dir";
    @SerializedName(value="work_dir")
    private String workDir;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public SpecGenerator networks(Map<String, PerNetworkOptions> networks) {
        this.networks = networks;
        return this;
    }

    public SpecGenerator putNetworksItem(String key, PerNetworkOptions networksItem) {
        if (this.networks == null) {
            this.networks = new HashMap<String, PerNetworkOptions>();
        }
        this.networks.put(key, networksItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Map of networks names or ids that the container should join. You can request additional settings for each network, you can set network aliases, static ips, static mac address  and the network interface name for this container on the specific network. If the map is empty and the bridge network mode is set the container will be joined to the default network. Optional.")
    public Map<String, PerNetworkOptions> getNetworks() {
        return this.networks;
    }

    public void setNetworks(Map<String, PerNetworkOptions> networks) {
        this.networks = networks;
    }

    public SpecGenerator annotations(Map<String, String> annotations) {
        this.annotations = annotations;
        return this;
    }

    public SpecGenerator putAnnotationsItem(String key, String annotationsItem) {
        if (this.annotations == null) {
            this.annotations = new HashMap<String, String>();
        }
        this.annotations.put(key, annotationsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Annotations are key-value options passed into the container runtime that can be used to trigger special behavior. Optional.")
    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Map<String, String> annotations) {
        this.annotations = annotations;
    }

    public SpecGenerator apparmorProfile(String apparmorProfile) {
        this.apparmorProfile = apparmorProfile;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ApparmorProfile is the name of the Apparmor profile the container will use. Optional.")
    public String getApparmorProfile() {
        return this.apparmorProfile;
    }

    public void setApparmorProfile(String apparmorProfile) {
        this.apparmorProfile = apparmorProfile;
    }

    public SpecGenerator baseHostsFile(String baseHostsFile) {
        this.baseHostsFile = baseHostsFile;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="BaseHostsFile is the path to a hosts file, the entries from this file are added to the containers hosts file. As special value \"image\" is allowed which uses the /etc/hosts file from within the image and \"none\" which uses no base file at all. If it is empty we should default to the base_hosts_file configuration in containers.conf. Optional.")
    public String getBaseHostsFile() {
        return this.baseHostsFile;
    }

    public void setBaseHostsFile(String baseHostsFile) {
        this.baseHostsFile = baseHostsFile;
    }

    public SpecGenerator capAdd(List<String> capAdd) {
        this.capAdd = capAdd;
        return this;
    }

    public SpecGenerator addCapAddItem(String capAddItem) {
        if (this.capAdd == null) {
            this.capAdd = new ArrayList<String>();
        }
        this.capAdd.add(capAddItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="CapAdd are capabilities which will be added to the container. Conflicts with Privileged. Optional.")
    public List<String> getCapAdd() {
        return this.capAdd;
    }

    public void setCapAdd(List<String> capAdd) {
        this.capAdd = capAdd;
    }

    public SpecGenerator capDrop(List<String> capDrop) {
        this.capDrop = capDrop;
        return this;
    }

    public SpecGenerator addCapDropItem(String capDropItem) {
        if (this.capDrop == null) {
            this.capDrop = new ArrayList<String>();
        }
        this.capDrop.add(capDropItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="CapDrop are capabilities which will be removed from the container. Conflicts with Privileged. Optional.")
    public List<String> getCapDrop() {
        return this.capDrop;
    }

    public void setCapDrop(List<String> capDrop) {
        this.capDrop = capDrop;
    }

    public SpecGenerator cgroupParent(String cgroupParent) {
        this.cgroupParent = cgroupParent;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="CgroupParent is the container's Cgroup parent. If not set, the default for the current cgroup driver will be used. Optional.")
    public String getCgroupParent() {
        return this.cgroupParent;
    }

    public void setCgroupParent(String cgroupParent) {
        this.cgroupParent = cgroupParent;
    }

    public SpecGenerator cgroupns(Namespace cgroupns) {
        this.cgroupns = cgroupns;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public Namespace getCgroupns() {
        return this.cgroupns;
    }

    public void setCgroupns(Namespace cgroupns) {
        this.cgroupns = cgroupns;
    }

    public SpecGenerator cgroupsMode(String cgroupsMode) {
        this.cgroupsMode = cgroupsMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="CgroupsMode sets a policy for how cgroups will be created for the container, including the ability to disable creation entirely. Optional.")
    public String getCgroupsMode() {
        return this.cgroupsMode;
    }

    public void setCgroupsMode(String cgroupsMode) {
        this.cgroupsMode = cgroupsMode;
    }

    public SpecGenerator chrootDirectories(List<String> chrootDirectories) {
        this.chrootDirectories = chrootDirectories;
        return this;
    }

    public SpecGenerator addChrootDirectoriesItem(String chrootDirectoriesItem) {
        if (this.chrootDirectories == null) {
            this.chrootDirectories = new ArrayList<String>();
        }
        this.chrootDirectories.add(chrootDirectoriesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ChrootDirs is an additional set of directories that need to be treated as root directories. Standard bind mounts will be mounted into paths relative to these directories. Optional.")
    public List<String> getChrootDirectories() {
        return this.chrootDirectories;
    }

    public void setChrootDirectories(List<String> chrootDirectories) {
        this.chrootDirectories = chrootDirectories;
    }

    public SpecGenerator cniNetworks(List<String> cniNetworks) {
        this.cniNetworks = cniNetworks;
        return this;
    }

    public SpecGenerator addCniNetworksItem(String cniNetworksItem) {
        if (this.cniNetworks == null) {
            this.cniNetworks = new ArrayList<String>();
        }
        this.cniNetworks.add(cniNetworksItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="CNINetworks is a list of CNI networks to join the container to. If this list is empty, the default CNI network will be joined instead. If at least one entry is present, we will not join the default network (unless it is part of this list). Only available if NetNS is set to bridge. Optional. Deprecated: as of podman 4.0 use \"Networks\" instead.")
    public List<String> getCniNetworks() {
        return this.cniNetworks;
    }

    public void setCniNetworks(List<String> cniNetworks) {
        this.cniNetworks = cniNetworks;
    }

    public SpecGenerator command(List<String> command) {
        this.command = command;
        return this;
    }

    public SpecGenerator addCommandItem(String commandItem) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        this.command.add(commandItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Command is the container's command. If not given and Image is specified, this will be populated by the image's configuration. Optional.")
    public List<String> getCommand() {
        return this.command;
    }

    public void setCommand(List<String> command) {
        this.command = command;
    }

    public SpecGenerator conmonPidFile(String conmonPidFile) {
        this.conmonPidFile = conmonPidFile;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ConmonPidFile is a path at which a PID file for Conmon will be placed. If not given, a default location will be used. Optional.")
    public String getConmonPidFile() {
        return this.conmonPidFile;
    }

    public void setConmonPidFile(String conmonPidFile) {
        this.conmonPidFile = conmonPidFile;
    }

    public SpecGenerator containerCreateCommand(List<String> containerCreateCommand) {
        this.containerCreateCommand = containerCreateCommand;
        return this;
    }

    public SpecGenerator addContainerCreateCommandItem(String containerCreateCommandItem) {
        if (this.containerCreateCommand == null) {
            this.containerCreateCommand = new ArrayList<String>();
        }
        this.containerCreateCommand.add(containerCreateCommandItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ContainerCreateCommand is the command that was used to create this container. This will be shown in the output of Inspect() on the container, and may also be used by some tools that wish to recreate the container (e.g. `podman generate systemd --new`). Optional.")
    public List<String> getContainerCreateCommand() {
        return this.containerCreateCommand;
    }

    public void setContainerCreateCommand(List<String> containerCreateCommand) {
        this.containerCreateCommand = containerCreateCommand;
    }

    public SpecGenerator createWorkingDir(Boolean createWorkingDir) {
        this.createWorkingDir = createWorkingDir;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Create the working directory if it doesn't exist. If unset, it doesn't create it. Optional.")
    public Boolean getCreateWorkingDir() {
        return this.createWorkingDir;
    }

    public void setCreateWorkingDir(Boolean createWorkingDir) {
        this.createWorkingDir = createWorkingDir;
    }

    public SpecGenerator dependencyContainers(List<String> dependencyContainers) {
        this.dependencyContainers = dependencyContainers;
        return this;
    }

    public SpecGenerator addDependencyContainersItem(String dependencyContainersItem) {
        if (this.dependencyContainers == null) {
            this.dependencyContainers = new ArrayList<String>();
        }
        this.dependencyContainers.add(dependencyContainersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="DependencyContainers is an array of containers this container depends on. Dependency containers must be started before this container. Dependencies can be specified by name or full/partial ID. Optional.")
    public List<String> getDependencyContainers() {
        return this.dependencyContainers;
    }

    public void setDependencyContainers(List<String> dependencyContainers) {
        this.dependencyContainers = dependencyContainers;
    }

    public SpecGenerator deviceCgroupRule(List<LinuxDeviceCgroup> deviceCgroupRule) {
        this.deviceCgroupRule = deviceCgroupRule;
        return this;
    }

    public SpecGenerator addDeviceCgroupRuleItem(LinuxDeviceCgroup deviceCgroupRuleItem) {
        if (this.deviceCgroupRule == null) {
            this.deviceCgroupRule = new ArrayList<LinuxDeviceCgroup>();
        }
        this.deviceCgroupRule.add(deviceCgroupRuleItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="DeviceCgroupRule are device cgroup rules that allow containers to use additional types of devices.")
    public List<LinuxDeviceCgroup> getDeviceCgroupRule() {
        return this.deviceCgroupRule;
    }

    public void setDeviceCgroupRule(List<LinuxDeviceCgroup> deviceCgroupRule) {
        this.deviceCgroupRule = deviceCgroupRule;
    }

    public SpecGenerator devices(List<LinuxDevice> devices) {
        this.devices = devices;
        return this;
    }

    public SpecGenerator addDevicesItem(LinuxDevice devicesItem) {
        if (this.devices == null) {
            this.devices = new ArrayList<LinuxDevice>();
        }
        this.devices.add(devicesItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Devices are devices that will be added to the container. Optional.")
    public List<LinuxDevice> getDevices() {
        return this.devices;
    }

    public void setDevices(List<LinuxDevice> devices) {
        this.devices = devices;
    }

    public SpecGenerator devicesFrom(List<String> devicesFrom) {
        this.devicesFrom = devicesFrom;
        return this;
    }

    public SpecGenerator addDevicesFromItem(String devicesFromItem) {
        if (this.devicesFrom == null) {
            this.devicesFrom = new ArrayList<String>();
        }
        this.devicesFrom.add(devicesFromItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="DevicesFrom specifies that this container will mount the device(s) from other container(s). Optional.")
    public List<String> getDevicesFrom() {
        return this.devicesFrom;
    }

    public void setDevicesFrom(List<String> devicesFrom) {
        this.devicesFrom = devicesFrom;
    }

    public SpecGenerator dnsOption(List<String> dnsOption) {
        this.dnsOption = dnsOption;
        return this;
    }

    public SpecGenerator addDnsOptionItem(String dnsOptionItem) {
        if (this.dnsOption == null) {
            this.dnsOption = new ArrayList<String>();
        }
        this.dnsOption.add(dnsOptionItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="DNSOptions is a set of DNS options that will be used in the container's resolv.conf, replacing the host's DNS options which are used by default. Conflicts with UseImageResolvConf. Optional.")
    public List<String> getDnsOption() {
        return this.dnsOption;
    }

    public void setDnsOption(List<String> dnsOption) {
        this.dnsOption = dnsOption;
    }

    public SpecGenerator dnsSearch(List<String> dnsSearch) {
        this.dnsSearch = dnsSearch;
        return this;
    }

    public SpecGenerator addDnsSearchItem(String dnsSearchItem) {
        if (this.dnsSearch == null) {
            this.dnsSearch = new ArrayList<String>();
        }
        this.dnsSearch.add(dnsSearchItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="DNSSearch is a set of DNS search domains that will be used in the container's resolv.conf, replacing the host's DNS search domains which are used by default. Conflicts with UseImageResolvConf. Optional.")
    public List<String> getDnsSearch() {
        return this.dnsSearch;
    }

    public void setDnsSearch(List<String> dnsSearch) {
        this.dnsSearch = dnsSearch;
    }

    public SpecGenerator dnsServer(List<String> dnsServer) {
        this.dnsServer = dnsServer;
        return this;
    }

    public SpecGenerator addDnsServerItem(String dnsServerItem) {
        if (this.dnsServer == null) {
            this.dnsServer = new ArrayList<String>();
        }
        this.dnsServer.add(dnsServerItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="DNSServers is a set of DNS servers that will be used in the container's resolv.conf, replacing the host's DNS Servers which are used by default. Conflicts with UseImageResolvConf. Optional.")
    public List<String> getDnsServer() {
        return this.dnsServer;
    }

    public void setDnsServer(List<String> dnsServer) {
        this.dnsServer = dnsServer;
    }

    public SpecGenerator entrypoint(List<String> entrypoint) {
        this.entrypoint = entrypoint;
        return this;
    }

    public SpecGenerator addEntrypointItem(String entrypointItem) {
        if (this.entrypoint == null) {
            this.entrypoint = new ArrayList<String>();
        }
        this.entrypoint.add(entrypointItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Entrypoint is the container's entrypoint. If not given and Image is specified, this will be populated by the image's configuration. Optional.")
    public List<String> getEntrypoint() {
        return this.entrypoint;
    }

    public void setEntrypoint(List<String> entrypoint) {
        this.entrypoint = entrypoint;
    }

    public SpecGenerator env(Map<String, String> env) {
        this.env = env;
        return this;
    }

    public SpecGenerator putEnvItem(String key, String envItem) {
        if (this.env == null) {
            this.env = new HashMap<String, String>();
        }
        this.env.put(key, envItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Env is a set of environment variables that will be set in the container. Optional.")
    public Map<String, String> getEnv() {
        return this.env;
    }

    public void setEnv(Map<String, String> env) {
        this.env = env;
    }

    public SpecGenerator envHost(Boolean envHost) {
        this.envHost = envHost;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="EnvHost indicates that the host environment should be added to container Optional.")
    public Boolean getEnvHost() {
        return this.envHost;
    }

    public void setEnvHost(Boolean envHost) {
        this.envHost = envHost;
    }

    public SpecGenerator envmerge(List<String> envmerge) {
        this.envmerge = envmerge;
        return this;
    }

    public SpecGenerator addEnvmergeItem(String envmergeItem) {
        if (this.envmerge == null) {
            this.envmerge = new ArrayList<String>();
        }
        this.envmerge.add(envmergeItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="EnvMerge takes the specified environment variables from image and preprocess them before injecting them into the container. Optional.")
    public List<String> getEnvmerge() {
        return this.envmerge;
    }

    public void setEnvmerge(List<String> envmerge) {
        this.envmerge = envmerge;
    }

    public SpecGenerator expose(Object expose) {
        this.expose = expose;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Expose is a number of ports that will be forwarded to the container if PublishExposedPorts is set. Expose is a map of uint16 (port number) to a string representing protocol i.e map[uint16]string. Allowed protocols are \"tcp\", \"udp\", and \"sctp\", or some combination of the three separated by commas. If protocol is set to \"\" we will assume TCP. Only available if NetNS is set to Bridge or Slirp, and PublishExposedPorts is set. Optional.")
    public Object getExpose() {
        return this.expose;
    }

    public void setExpose(Object expose) {
        this.expose = expose;
    }

    public SpecGenerator groupEntry(String groupEntry) {
        this.groupEntry = groupEntry;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="GroupEntry specifies an arbitrary string to append to the container's /etc/group file. Optional.")
    public String getGroupEntry() {
        return this.groupEntry;
    }

    public void setGroupEntry(String groupEntry) {
        this.groupEntry = groupEntry;
    }

    public SpecGenerator groups(List<String> groups) {
        this.groups = groups;
        return this;
    }

    public SpecGenerator addGroupsItem(String groupsItem) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        this.groups.add(groupsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Groups are a list of supplemental groups the container's user will be granted access to. Optional.")
    public List<String> getGroups() {
        return this.groups;
    }

    public void setGroups(List<String> groups) {
        this.groups = groups;
    }

    public SpecGenerator healthCheckOnFailureAction(Long healthCheckOnFailureAction) {
        this.healthCheckOnFailureAction = healthCheckOnFailureAction;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="HealthCheckOnFailureAction defines how Podman reacts when a container's health status turns unhealthy.")
    public Long getHealthCheckOnFailureAction() {
        return this.healthCheckOnFailureAction;
    }

    public void setHealthCheckOnFailureAction(Long healthCheckOnFailureAction) {
        this.healthCheckOnFailureAction = healthCheckOnFailureAction;
    }

    public SpecGenerator healthLogDestination(String healthLogDestination) {
        this.healthLogDestination = healthLogDestination;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="HealthLogDestination defines the destination where the log is stored")
    public String getHealthLogDestination() {
        return this.healthLogDestination;
    }

    public void setHealthLogDestination(String healthLogDestination) {
        this.healthLogDestination = healthLogDestination;
    }

    public SpecGenerator healthMaxLogCount(Integer healthMaxLogCount) {
        this.healthMaxLogCount = healthMaxLogCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="HealthMaxLogCount is maximum number of attempts in the HealthCheck log file. ('0' value means an infinite number of attempts in the log file)")
    public Integer getHealthMaxLogCount() {
        return this.healthMaxLogCount;
    }

    public void setHealthMaxLogCount(Integer healthMaxLogCount) {
        this.healthMaxLogCount = healthMaxLogCount;
    }

    public SpecGenerator healthMaxLogSize(Integer healthMaxLogSize) {
        this.healthMaxLogSize = healthMaxLogSize;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="HealthMaxLogSize is the maximum length in characters of stored HealthCheck log (\"0\" value means an infinite log length)")
    public Integer getHealthMaxLogSize() {
        return this.healthMaxLogSize;
    }

    public void setHealthMaxLogSize(Integer healthMaxLogSize) {
        this.healthMaxLogSize = healthMaxLogSize;
    }

    public SpecGenerator healthconfig(Schema2HealthConfig healthconfig) {
        this.healthconfig = healthconfig;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public Schema2HealthConfig getHealthconfig() {
        return this.healthconfig;
    }

    public void setHealthconfig(Schema2HealthConfig healthconfig) {
        this.healthconfig = healthconfig;
    }

    public SpecGenerator hostDeviceList(List<LinuxDevice> hostDeviceList) {
        this.hostDeviceList = hostDeviceList;
        return this;
    }

    public SpecGenerator addHostDeviceListItem(LinuxDevice hostDeviceListItem) {
        if (this.hostDeviceList == null) {
            this.hostDeviceList = new ArrayList<LinuxDevice>();
        }
        this.hostDeviceList.add(hostDeviceListItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="HostDeviceList is used to recreate the mounted device on inherited containers")
    public List<LinuxDevice> getHostDeviceList() {
        return this.hostDeviceList;
    }

    public void setHostDeviceList(List<LinuxDevice> hostDeviceList) {
        this.hostDeviceList = hostDeviceList;
    }

    public SpecGenerator hostadd(List<String> hostadd) {
        this.hostadd = hostadd;
        return this;
    }

    public SpecGenerator addHostaddItem(String hostaddItem) {
        if (this.hostadd == null) {
            this.hostadd = new ArrayList<String>();
        }
        this.hostadd.add(hostaddItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="HostAdd is a set of hosts which will be added to the container's etc/hosts file. Conflicts with UseImageHosts. Optional.")
    public List<String> getHostadd() {
        return this.hostadd;
    }

    public void setHostadd(List<String> hostadd) {
        this.hostadd = hostadd;
    }

    public SpecGenerator hostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Hostname is the container's hostname. If not set, the hostname will not be modified (if UtsNS is not private) or will be set to the container ID (if UtsNS is private). Conflicts with UtsNS if UtsNS is not set to private. Optional.")
    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public SpecGenerator hostusers(List<String> hostusers) {
        this.hostusers = hostusers;
        return this;
    }

    public SpecGenerator addHostusersItem(String hostusersItem) {
        if (this.hostusers == null) {
            this.hostusers = new ArrayList<String>();
        }
        this.hostusers.add(hostusersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="HostUsers is a list of host usernames or UIDs to add to the container etc/passwd file")
    public List<String> getHostusers() {
        return this.hostusers;
    }

    public void setHostusers(List<String> hostusers) {
        this.hostusers = hostusers;
    }

    public SpecGenerator httpproxy(Boolean httpproxy) {
        this.httpproxy = httpproxy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="EnvHTTPProxy indicates that the http host proxy environment variables should be added to container Optional.")
    public Boolean getHttpproxy() {
        return this.httpproxy;
    }

    public void setHttpproxy(Boolean httpproxy) {
        this.httpproxy = httpproxy;
    }

    public SpecGenerator idmappings(IDMappingOptions idmappings) {
        this.idmappings = idmappings;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public IDMappingOptions getIdmappings() {
        return this.idmappings;
    }

    public void setIdmappings(IDMappingOptions idmappings) {
        this.idmappings = idmappings;
    }

    public SpecGenerator image(String image) {
        this.image = image;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Image is the image the container will be based on. The image will be used as the container's root filesystem, and its environment vars, volumes, and other configuration will be applied to the container. Conflicts with Rootfs. At least one of Image or Rootfs must be specified.")
    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public SpecGenerator imageArch(String imageArch) {
        this.imageArch = imageArch;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ImageArch is the user-specified image architecture. Used to select a different variant from a manifest list. Optional.")
    public String getImageArch() {
        return this.imageArch;
    }

    public void setImageArch(String imageArch) {
        this.imageArch = imageArch;
    }

    public SpecGenerator imageOs(String imageOs) {
        this.imageOs = imageOs;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ImageOS is the user-specified OS of the image. Used to select a different variant from a manifest list. Optional.")
    public String getImageOs() {
        return this.imageOs;
    }

    public void setImageOs(String imageOs) {
        this.imageOs = imageOs;
    }

    public SpecGenerator imageVariant(String imageVariant) {
        this.imageVariant = imageVariant;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ImageVariant is the user-specified image variant. Used to select a different variant from a manifest list. Optional.")
    public String getImageVariant() {
        return this.imageVariant;
    }

    public void setImageVariant(String imageVariant) {
        this.imageVariant = imageVariant;
    }

    public SpecGenerator imageVolumeMode(String imageVolumeMode) {
        this.imageVolumeMode = imageVolumeMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ImageVolumeMode indicates how image volumes will be created. Supported modes are \"ignore\" (do not create), \"tmpfs\" (create as tmpfs), and \"anonymous\" (create as anonymous volumes). The default if unset is anonymous. Optional.")
    public String getImageVolumeMode() {
        return this.imageVolumeMode;
    }

    public void setImageVolumeMode(String imageVolumeMode) {
        this.imageVolumeMode = imageVolumeMode;
    }

    public SpecGenerator imageVolumes(List<ImageVolume> imageVolumes) {
        this.imageVolumes = imageVolumes;
        return this;
    }

    public SpecGenerator addImageVolumesItem(ImageVolume imageVolumesItem) {
        if (this.imageVolumes == null) {
            this.imageVolumes = new ArrayList<ImageVolume>();
        }
        this.imageVolumes.add(imageVolumesItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Image volumes bind-mount a container-image mount into the container. Optional.")
    public List<ImageVolume> getImageVolumes() {
        return this.imageVolumes;
    }

    public void setImageVolumes(List<ImageVolume> imageVolumes) {
        this.imageVolumes = imageVolumes;
    }

    public SpecGenerator init(Boolean init) {
        this.init = init;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Init specifies that an init binary will be mounted into the container, and will be used as PID1. Optional.")
    public Boolean getInit() {
        return this.init;
    }

    public void setInit(Boolean init) {
        this.init = init;
    }

    public SpecGenerator initContainerType(String initContainerType) {
        this.initContainerType = initContainerType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="InitContainerType describes if this container is an init container and if so, what type: always or once. Optional.")
    public String getInitContainerType() {
        return this.initContainerType;
    }

    public void setInitContainerType(String initContainerType) {
        this.initContainerType = initContainerType;
    }

    public SpecGenerator initPath(String initPath) {
        this.initPath = initPath;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="InitPath specifies the path to the init binary that will be added if Init is specified above. If not specified, the default set in the Libpod config will be used. Ignored if Init above is not set. Optional.")
    public String getInitPath() {
        return this.initPath;
    }

    public void setInitPath(String initPath) {
        this.initPath = initPath;
    }

    public SpecGenerator intelRdt(LinuxIntelRdt intelRdt) {
        this.intelRdt = intelRdt;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public LinuxIntelRdt getIntelRdt() {
        return this.intelRdt;
    }

    public void setIntelRdt(LinuxIntelRdt intelRdt) {
        this.intelRdt = intelRdt;
    }

    public SpecGenerator ipcns(Namespace ipcns) {
        this.ipcns = ipcns;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public Namespace getIpcns() {
        return this.ipcns;
    }

    public void setIpcns(Namespace ipcns) {
        this.ipcns = ipcns;
    }

    public SpecGenerator labelNested(Boolean labelNested) {
        this.labelNested = labelNested;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="LabelNested indicates whether or not the container is allowed to run fully nested containers including SELinux labelling. Optional.")
    public Boolean getLabelNested() {
        return this.labelNested;
    }

    public void setLabelNested(Boolean labelNested) {
        this.labelNested = labelNested;
    }

    public SpecGenerator labels(Map<String, String> labels) {
        this.labels = labels;
        return this;
    }

    public SpecGenerator putLabelsItem(String key, String labelsItem) {
        if (this.labels == null) {
            this.labels = new HashMap<String, String>();
        }
        this.labels.put(key, labelsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Labels are key-value pairs that are used to add metadata to containers. Optional.")
    public Map<String, String> getLabels() {
        return this.labels;
    }

    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
    }

    public SpecGenerator logConfiguration(LogConfigLibpod logConfiguration) {
        this.logConfiguration = logConfiguration;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public LogConfigLibpod getLogConfiguration() {
        return this.logConfiguration;
    }

    public void setLogConfiguration(LogConfigLibpod logConfiguration) {
        this.logConfiguration = logConfiguration;
    }

    public SpecGenerator managePassword(Boolean managePassword) {
        this.managePassword = managePassword;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Passwd is a container run option that determines if we are validating users/groups before running the container")
    public Boolean getManagePassword() {
        return this.managePassword;
    }

    public void setManagePassword(Boolean managePassword) {
        this.managePassword = managePassword;
    }

    public SpecGenerator mask(List<String> mask) {
        this.mask = mask;
        return this;
    }

    public SpecGenerator addMaskItem(String maskItem) {
        if (this.mask == null) {
            this.mask = new ArrayList<String>();
        }
        this.mask.add(maskItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Mask is the path we want to mask in the container. This masks the paths given in addition to the default list. Optional")
    public List<String> getMask() {
        return this.mask;
    }

    public void setMask(List<String> mask) {
        this.mask = mask;
    }

    public SpecGenerator mounts(List<Mount> mounts) {
        this.mounts = mounts;
        return this;
    }

    public SpecGenerator addMountsItem(Mount mountsItem) {
        if (this.mounts == null) {
            this.mounts = new ArrayList<Mount>();
        }
        this.mounts.add(mountsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Mounts are mounts that will be added to the container. These will supersede Image Volumes and VolumesFrom volumes where there are conflicts. Optional.")
    public List<Mount> getMounts() {
        return this.mounts;
    }

    public void setMounts(List<Mount> mounts) {
        this.mounts = mounts;
    }

    public SpecGenerator name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name is the name the container will be given. If no name is provided, one will be randomly generated. Optional.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SpecGenerator netns(Namespace netns) {
        this.netns = netns;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public Namespace getNetns() {
        return this.netns;
    }

    public void setNetns(Namespace netns) {
        this.netns = netns;
    }

    public SpecGenerator networkOptions(Map<String, List<String>> networkOptions) {
        this.networkOptions = networkOptions;
        return this;
    }

    public SpecGenerator putNetworkOptionsItem(String key, List<String> networkOptionsItem) {
        if (this.networkOptions == null) {
            this.networkOptions = new HashMap<String, List<String>>();
        }
        this.networkOptions.put(key, networkOptionsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="NetworkOptions are additional options for each network Optional.")
    public Map<String, List<String>> getNetworkOptions() {
        return this.networkOptions;
    }

    public void setNetworkOptions(Map<String, List<String>> networkOptions) {
        this.networkOptions = networkOptions;
    }

    public SpecGenerator noNewPrivileges(Boolean noNewPrivileges) {
        this.noNewPrivileges = noNewPrivileges;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="NoNewPrivileges is whether the container will set the no new privileges flag on create, which disables gaining additional privileges (e.g. via setuid) in the container. Optional.")
    public Boolean getNoNewPrivileges() {
        return this.noNewPrivileges;
    }

    public void setNoNewPrivileges(Boolean noNewPrivileges) {
        this.noNewPrivileges = noNewPrivileges;
    }

    public SpecGenerator ociRuntime(String ociRuntime) {
        this.ociRuntime = ociRuntime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="OCIRuntime is the name of the OCI runtime that will be used to create the container. If not specified, the default will be used. Optional.")
    public String getOciRuntime() {
        return this.ociRuntime;
    }

    public void setOciRuntime(String ociRuntime) {
        this.ociRuntime = ociRuntime;
    }

    public SpecGenerator oomScoreAdj(Long oomScoreAdj) {
        this.oomScoreAdj = oomScoreAdj;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="OOMScoreAdj adjusts the score used by the OOM killer to determine processes to kill for the container's process. Optional.")
    public Long getOomScoreAdj() {
        return this.oomScoreAdj;
    }

    public void setOomScoreAdj(Long oomScoreAdj) {
        this.oomScoreAdj = oomScoreAdj;
    }

    public SpecGenerator overlayVolumes(List<OverlayVolume> overlayVolumes) {
        this.overlayVolumes = overlayVolumes;
        return this;
    }

    public SpecGenerator addOverlayVolumesItem(OverlayVolume overlayVolumesItem) {
        if (this.overlayVolumes == null) {
            this.overlayVolumes = new ArrayList<OverlayVolume>();
        }
        this.overlayVolumes.add(overlayVolumesItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Overlay volumes are named volumes that will be added to the container. Optional.")
    public List<OverlayVolume> getOverlayVolumes() {
        return this.overlayVolumes;
    }

    public void setOverlayVolumes(List<OverlayVolume> overlayVolumes) {
        this.overlayVolumes = overlayVolumes;
    }

    public SpecGenerator passwdEntry(String passwdEntry) {
        this.passwdEntry = passwdEntry;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="PasswdEntry specifies an arbitrary string to append to the container's /etc/passwd file. Optional.")
    public String getPasswdEntry() {
        return this.passwdEntry;
    }

    public void setPasswdEntry(String passwdEntry) {
        this.passwdEntry = passwdEntry;
    }

    public SpecGenerator personality(LinuxPersonality personality) {
        this.personality = personality;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public LinuxPersonality getPersonality() {
        return this.personality;
    }

    public void setPersonality(LinuxPersonality personality) {
        this.personality = personality;
    }

    public SpecGenerator pidns(Namespace pidns) {
        this.pidns = pidns;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public Namespace getPidns() {
        return this.pidns;
    }

    public void setPidns(Namespace pidns) {
        this.pidns = pidns;
    }

    public SpecGenerator pod(String pod) {
        this.pod = pod;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Pod is the ID of the pod the container will join. Optional.")
    public String getPod() {
        return this.pod;
    }

    public void setPod(String pod) {
        this.pod = pod;
    }

    public SpecGenerator portmappings(List<PortMapping> portmappings) {
        this.portmappings = portmappings;
        return this;
    }

    public SpecGenerator addPortmappingsItem(PortMapping portmappingsItem) {
        if (this.portmappings == null) {
            this.portmappings = new ArrayList<PortMapping>();
        }
        this.portmappings.add(portmappingsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="PortBindings is a set of ports to map into the container. Only available if NetNS is set to bridge, slirp, or pasta. Optional.")
    public List<PortMapping> getPortmappings() {
        return this.portmappings;
    }

    public void setPortmappings(List<PortMapping> portmappings) {
        this.portmappings = portmappings;
    }

    public SpecGenerator privileged(Boolean privileged) {
        this.privileged = privileged;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Privileged is whether the container is privileged. Privileged does the following: Adds all devices on the system to the container. Adds all capabilities to the container. Disables Seccomp, SELinux, and Apparmor confinement. (Though SELinux can be manually re-enabled). TODO: this conflicts with things. TODO: this does more. Optional.")
    public Boolean getPrivileged() {
        return this.privileged;
    }

    public void setPrivileged(Boolean privileged) {
        this.privileged = privileged;
    }

    public SpecGenerator procfsOpts(List<String> procfsOpts) {
        this.procfsOpts = procfsOpts;
        return this;
    }

    public SpecGenerator addProcfsOptsItem(String procfsOptsItem) {
        if (this.procfsOpts == null) {
            this.procfsOpts = new ArrayList<String>();
        }
        this.procfsOpts.add(procfsOptsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ProcOpts are the options used for the proc mount.")
    public List<String> getProcfsOpts() {
        return this.procfsOpts;
    }

    public void setProcfsOpts(List<String> procfsOpts) {
        this.procfsOpts = procfsOpts;
    }

    public SpecGenerator publishImagePorts(Boolean publishImagePorts) {
        this.publishImagePorts = publishImagePorts;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="PublishExposedPorts will publish ports specified in the image to random unused ports (guaranteed to be above 1024) on the host. This is based on ports set in Expose below, and any ports specified by the Image (if one is given). Only available if NetNS is set to Bridge or Slirp. Optional.")
    public Boolean getPublishImagePorts() {
        return this.publishImagePorts;
    }

    public void setPublishImagePorts(Boolean publishImagePorts) {
        this.publishImagePorts = publishImagePorts;
    }

    public SpecGenerator rLimits(List<POSIXRlimit> rLimits) {
        this.rLimits = rLimits;
        return this;
    }

    public SpecGenerator addRLimitsItem(POSIXRlimit rLimitsItem) {
        if (this.rLimits == null) {
            this.rLimits = new ArrayList<POSIXRlimit>();
        }
        this.rLimits.add(rLimitsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Rlimits are POSIX rlimits to apply to the container. Optional.")
    public List<POSIXRlimit> getrLimits() {
        return this.rLimits;
    }

    public void setrLimits(List<POSIXRlimit> rLimits) {
        this.rLimits = rLimits;
    }

    public SpecGenerator rawImageName(String rawImageName) {
        this.rawImageName = rawImageName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="RawImageName is the user-specified and unprocessed input referring to a local or a remote image. Optional, but strongly encouraged to be set if Image is set.")
    public String getRawImageName() {
        return this.rawImageName;
    }

    public void setRawImageName(String rawImageName) {
        this.rawImageName = rawImageName;
    }

    public SpecGenerator readOnlyFilesystem(Boolean readOnlyFilesystem) {
        this.readOnlyFilesystem = readOnlyFilesystem;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ReadOnlyFilesystem indicates that everything will be mounted as read-only. Optional.")
    public Boolean getReadOnlyFilesystem() {
        return this.readOnlyFilesystem;
    }

    public void setReadOnlyFilesystem(Boolean readOnlyFilesystem) {
        this.readOnlyFilesystem = readOnlyFilesystem;
    }

    public SpecGenerator readWriteTmpfs(Boolean readWriteTmpfs) {
        this.readWriteTmpfs = readWriteTmpfs;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ReadWriteTmpfs indicates that when running with a ReadOnlyFilesystem mount temporary file systems. Optional.")
    public Boolean getReadWriteTmpfs() {
        return this.readWriteTmpfs;
    }

    public void setReadWriteTmpfs(Boolean readWriteTmpfs) {
        this.readWriteTmpfs = readWriteTmpfs;
    }

    public SpecGenerator remove(Boolean remove) {
        this.remove = remove;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Remove indicates if the container should be removed once it has been started and exits. Optional.")
    public Boolean getRemove() {
        return this.remove;
    }

    public void setRemove(Boolean remove) {
        this.remove = remove;
    }

    public SpecGenerator removeImage(Boolean removeImage) {
        this.removeImage = removeImage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="RemoveImage indicates that the container should remove the image it was created from after it exits. Only allowed if Remove is set to true and Image, not Rootfs, is in use. Optional.")
    public Boolean getRemoveImage() {
        return this.removeImage;
    }

    public void setRemoveImage(Boolean removeImage) {
        this.removeImage = removeImage;
    }

    public SpecGenerator resourceLimits(LinuxResources resourceLimits) {
        this.resourceLimits = resourceLimits;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public LinuxResources getResourceLimits() {
        return this.resourceLimits;
    }

    public void setResourceLimits(LinuxResources resourceLimits) {
        this.resourceLimits = resourceLimits;
    }

    public SpecGenerator restartPolicy(String restartPolicy) {
        this.restartPolicy = restartPolicy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="RestartPolicy is the container's restart policy - an action which will be taken when the container exits. If not given, the default policy, which does nothing, will be used. Optional.")
    public String getRestartPolicy() {
        return this.restartPolicy;
    }

    public void setRestartPolicy(String restartPolicy) {
        this.restartPolicy = restartPolicy;
    }

    public SpecGenerator restartTries(Integer restartTries) {
        this.restartTries = restartTries;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="RestartRetries is the number of attempts that will be made to restart the container. Only available when RestartPolicy is set to \"on-failure\". Optional.")
    public Integer getRestartTries() {
        return this.restartTries;
    }

    public void setRestartTries(Integer restartTries) {
        this.restartTries = restartTries;
    }

    public SpecGenerator rootfs(String rootfs) {
        this.rootfs = rootfs;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Rootfs is the path to a directory that will be used as the container's root filesystem. No modification will be made to the directory, it will be directly mounted into the container as root. Conflicts with Image. At least one of Image or Rootfs must be specified.")
    public String getRootfs() {
        return this.rootfs;
    }

    public void setRootfs(String rootfs) {
        this.rootfs = rootfs;
    }

    public SpecGenerator rootfsMapping(String rootfsMapping) {
        this.rootfsMapping = rootfsMapping;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="RootfsMapping specifies if there are UID/GID mappings to apply to the rootfs. Optional.")
    public String getRootfsMapping() {
        return this.rootfsMapping;
    }

    public void setRootfsMapping(String rootfsMapping) {
        this.rootfsMapping = rootfsMapping;
    }

    public SpecGenerator rootfsOverlay(Boolean rootfsOverlay) {
        this.rootfsOverlay = rootfsOverlay;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="RootfsOverlay tells if rootfs is actually an overlay on top of base path. Optional.")
    public Boolean getRootfsOverlay() {
        return this.rootfsOverlay;
    }

    public void setRootfsOverlay(Boolean rootfsOverlay) {
        this.rootfsOverlay = rootfsOverlay;
    }

    public SpecGenerator rootfsPropagation(String rootfsPropagation) {
        this.rootfsPropagation = rootfsPropagation;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="RootfsPropagation is the rootfs propagation mode for the container. If not set, the default of rslave will be used. Optional.")
    public String getRootfsPropagation() {
        return this.rootfsPropagation;
    }

    public void setRootfsPropagation(String rootfsPropagation) {
        this.rootfsPropagation = rootfsPropagation;
    }

    public SpecGenerator sdnotifyMode(String sdnotifyMode) {
        this.sdnotifyMode = sdnotifyMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Determine how to handle the NOTIFY_SOCKET - do we participate or pass it through \"container\" - let the OCI runtime deal with it, advertise conmon's MAINPID \"conmon-only\" - advertise conmon's MAINPID, send READY when started, don't pass to OCI \"ignore\" - unset NOTIFY_SOCKET Optional.")
    public String getSdnotifyMode() {
        return this.sdnotifyMode;
    }

    public void setSdnotifyMode(String sdnotifyMode) {
        this.sdnotifyMode = sdnotifyMode;
    }

    public SpecGenerator seccompPolicy(String seccompPolicy) {
        this.seccompPolicy = seccompPolicy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="SeccompPolicy determines which seccomp profile gets applied the container. valid values: empty,default,image")
    public String getSeccompPolicy() {
        return this.seccompPolicy;
    }

    public void setSeccompPolicy(String seccompPolicy) {
        this.seccompPolicy = seccompPolicy;
    }

    public SpecGenerator seccompProfilePath(String seccompProfilePath) {
        this.seccompProfilePath = seccompProfilePath;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="SeccompProfilePath is the path to a JSON file containing the container's Seccomp profile. If not specified, no Seccomp profile will be used. Optional.")
    public String getSeccompProfilePath() {
        return this.seccompProfilePath;
    }

    public void setSeccompProfilePath(String seccompProfilePath) {
        this.seccompProfilePath = seccompProfilePath;
    }

    public SpecGenerator secretEnv(Map<String, String> secretEnv) {
        this.secretEnv = secretEnv;
        return this;
    }

    public SpecGenerator putSecretEnvItem(String key, String secretEnvItem) {
        if (this.secretEnv == null) {
            this.secretEnv = new HashMap<String, String>();
        }
        this.secretEnv.put(key, secretEnvItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="EnvSecrets are secrets that will be set as environment variables Optional.")
    public Map<String, String> getSecretEnv() {
        return this.secretEnv;
    }

    public void setSecretEnv(Map<String, String> secretEnv) {
        this.secretEnv = secretEnv;
    }

    public SpecGenerator secrets(List<Secret> secrets) {
        this.secrets = secrets;
        return this;
    }

    public SpecGenerator addSecretsItem(Secret secretsItem) {
        if (this.secrets == null) {
            this.secrets = new ArrayList<Secret>();
        }
        this.secrets.add(secretsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Secrets are the secrets that will be added to the container Optional.")
    public List<Secret> getSecrets() {
        return this.secrets;
    }

    public void setSecrets(List<Secret> secrets) {
        this.secrets = secrets;
    }

    public SpecGenerator selinuxOpts(List<String> selinuxOpts) {
        this.selinuxOpts = selinuxOpts;
        return this;
    }

    public SpecGenerator addSelinuxOptsItem(String selinuxOptsItem) {
        if (this.selinuxOpts == null) {
            this.selinuxOpts = new ArrayList<String>();
        }
        this.selinuxOpts.add(selinuxOptsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="SelinuxProcessLabel is the process label the container will use. If SELinux is enabled and this is not specified, a label will be automatically generated if not specified. Optional.")
    public List<String> getSelinuxOpts() {
        return this.selinuxOpts;
    }

    public void setSelinuxOpts(List<String> selinuxOpts) {
        this.selinuxOpts = selinuxOpts;
    }

    public SpecGenerator shmSize(Long shmSize) {
        this.shmSize = shmSize;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ShmSize is the size of the tmpfs to mount in at /dev/shm, in bytes. Conflicts with ShmSize if IpcNS is not private. Optional.")
    public Long getShmSize() {
        return this.shmSize;
    }

    public void setShmSize(Long shmSize) {
        this.shmSize = shmSize;
    }

    public SpecGenerator shmSizeSystemd(Long shmSizeSystemd) {
        this.shmSizeSystemd = shmSizeSystemd;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ShmSizeSystemd is the size of systemd-specific tmpfs mounts specifically /run, /run/lock, /var/log/journal and /tmp. Optional")
    public Long getShmSizeSystemd() {
        return this.shmSizeSystemd;
    }

    public void setShmSizeSystemd(Long shmSizeSystemd) {
        this.shmSizeSystemd = shmSizeSystemd;
    }

    public SpecGenerator startupHealthConfig(StartupHealthCheck startupHealthConfig) {
        this.startupHealthConfig = startupHealthConfig;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public StartupHealthCheck getStartupHealthConfig() {
        return this.startupHealthConfig;
    }

    public void setStartupHealthConfig(StartupHealthCheck startupHealthConfig) {
        this.startupHealthConfig = startupHealthConfig;
    }

    public SpecGenerator stdin(Boolean stdin) {
        this.stdin = stdin;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Stdin is whether the container will keep its STDIN open. Optional.")
    public Boolean getStdin() {
        return this.stdin;
    }

    public void setStdin(Boolean stdin) {
        this.stdin = stdin;
    }

    public SpecGenerator stopSignal(Long stopSignal) {
        this.stopSignal = stopSignal;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="It implements the [os.Signal] interface.")
    public Long getStopSignal() {
        return this.stopSignal;
    }

    public void setStopSignal(Long stopSignal) {
        this.stopSignal = stopSignal;
    }

    public SpecGenerator stopTimeout(Integer stopTimeout) {
        this.stopTimeout = stopTimeout;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="StopTimeout is a timeout between the container's stop signal being sent and SIGKILL being sent. If not provided, the default will be used. If 0 is used, stop signal will not be sent, and SIGKILL will be sent instead. Optional.")
    public Integer getStopTimeout() {
        return this.stopTimeout;
    }

    public void setStopTimeout(Integer stopTimeout) {
        this.stopTimeout = stopTimeout;
    }

    public SpecGenerator storageOpts(Map<String, String> storageOpts) {
        this.storageOpts = storageOpts;
        return this;
    }

    public SpecGenerator putStorageOptsItem(String key, String storageOptsItem) {
        if (this.storageOpts == null) {
            this.storageOpts = new HashMap<String, String>();
        }
        this.storageOpts.put(key, storageOptsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="StorageOpts is the container's storage options Optional.")
    public Map<String, String> getStorageOpts() {
        return this.storageOpts;
    }

    public void setStorageOpts(Map<String, String> storageOpts) {
        this.storageOpts = storageOpts;
    }

    public SpecGenerator sysctl(Map<String, String> sysctl) {
        this.sysctl = sysctl;
        return this;
    }

    public SpecGenerator putSysctlItem(String key, String sysctlItem) {
        if (this.sysctl == null) {
            this.sysctl = new HashMap<String, String>();
        }
        this.sysctl.put(key, sysctlItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Sysctl sets kernel parameters for the container")
    public Map<String, String> getSysctl() {
        return this.sysctl;
    }

    public void setSysctl(Map<String, String> sysctl) {
        this.sysctl = sysctl;
    }

    public SpecGenerator systemd(String systemd) {
        this.systemd = systemd;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Systemd is whether the container will be started in systemd mode. Valid options are \"true\", \"false\", and \"always\". \"true\" enables this mode only if the binary run in the container is sbin/init or systemd. \"always\" unconditionally enables systemd mode. \"false\" unconditionally disables systemd mode. If enabled, mounts and stop signal will be modified. If set to \"always\" or set to \"true\" and conditionally triggered, conflicts with StopSignal. If not specified, \"false\" will be assumed. Optional.")
    public String getSystemd() {
        return this.systemd;
    }

    public void setSystemd(String systemd) {
        this.systemd = systemd;
    }

    public SpecGenerator terminal(Boolean terminal) {
        this.terminal = terminal;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Terminal is whether the container will create a PTY. Optional.")
    public Boolean getTerminal() {
        return this.terminal;
    }

    public void setTerminal(Boolean terminal) {
        this.terminal = terminal;
    }

    public SpecGenerator throttleReadBpsDevice(Map<String, LinuxThrottleDevice> throttleReadBpsDevice) {
        this.throttleReadBpsDevice = throttleReadBpsDevice;
        return this;
    }

    public SpecGenerator putThrottleReadBpsDeviceItem(String key, LinuxThrottleDevice throttleReadBpsDeviceItem) {
        if (this.throttleReadBpsDevice == null) {
            this.throttleReadBpsDevice = new HashMap<String, LinuxThrottleDevice>();
        }
        this.throttleReadBpsDevice.put(key, throttleReadBpsDeviceItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="IO read rate limit per cgroup per device, bytes per second")
    public Map<String, LinuxThrottleDevice> getThrottleReadBpsDevice() {
        return this.throttleReadBpsDevice;
    }

    public void setThrottleReadBpsDevice(Map<String, LinuxThrottleDevice> throttleReadBpsDevice) {
        this.throttleReadBpsDevice = throttleReadBpsDevice;
    }

    public SpecGenerator throttleReadIOPSDevice(Map<String, LinuxThrottleDevice> throttleReadIOPSDevice) {
        this.throttleReadIOPSDevice = throttleReadIOPSDevice;
        return this;
    }

    public SpecGenerator putThrottleReadIOPSDeviceItem(String key, LinuxThrottleDevice throttleReadIOPSDeviceItem) {
        if (this.throttleReadIOPSDevice == null) {
            this.throttleReadIOPSDevice = new HashMap<String, LinuxThrottleDevice>();
        }
        this.throttleReadIOPSDevice.put(key, throttleReadIOPSDeviceItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="IO read rate limit per cgroup per device, IO per second")
    public Map<String, LinuxThrottleDevice> getThrottleReadIOPSDevice() {
        return this.throttleReadIOPSDevice;
    }

    public void setThrottleReadIOPSDevice(Map<String, LinuxThrottleDevice> throttleReadIOPSDevice) {
        this.throttleReadIOPSDevice = throttleReadIOPSDevice;
    }

    public SpecGenerator throttleWriteBpsDevice(Map<String, LinuxThrottleDevice> throttleWriteBpsDevice) {
        this.throttleWriteBpsDevice = throttleWriteBpsDevice;
        return this;
    }

    public SpecGenerator putThrottleWriteBpsDeviceItem(String key, LinuxThrottleDevice throttleWriteBpsDeviceItem) {
        if (this.throttleWriteBpsDevice == null) {
            this.throttleWriteBpsDevice = new HashMap<String, LinuxThrottleDevice>();
        }
        this.throttleWriteBpsDevice.put(key, throttleWriteBpsDeviceItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="IO write rate limit per cgroup per device, bytes per second")
    public Map<String, LinuxThrottleDevice> getThrottleWriteBpsDevice() {
        return this.throttleWriteBpsDevice;
    }

    public void setThrottleWriteBpsDevice(Map<String, LinuxThrottleDevice> throttleWriteBpsDevice) {
        this.throttleWriteBpsDevice = throttleWriteBpsDevice;
    }

    public SpecGenerator throttleWriteIOPSDevice(Map<String, LinuxThrottleDevice> throttleWriteIOPSDevice) {
        this.throttleWriteIOPSDevice = throttleWriteIOPSDevice;
        return this;
    }

    public SpecGenerator putThrottleWriteIOPSDeviceItem(String key, LinuxThrottleDevice throttleWriteIOPSDeviceItem) {
        if (this.throttleWriteIOPSDevice == null) {
            this.throttleWriteIOPSDevice = new HashMap<String, LinuxThrottleDevice>();
        }
        this.throttleWriteIOPSDevice.put(key, throttleWriteIOPSDeviceItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="IO write rate limit per cgroup per device, IO per second")
    public Map<String, LinuxThrottleDevice> getThrottleWriteIOPSDevice() {
        return this.throttleWriteIOPSDevice;
    }

    public void setThrottleWriteIOPSDevice(Map<String, LinuxThrottleDevice> throttleWriteIOPSDevice) {
        this.throttleWriteIOPSDevice = throttleWriteIOPSDevice;
    }

    public SpecGenerator timeout(Integer timeout) {
        this.timeout = timeout;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Timeout is a maximum time in seconds the container will run before main process is sent SIGKILL. If 0 is used, signal will not be sent. Container can run indefinitely if they do not stop after the default termination signal. Optional.")
    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public SpecGenerator timezone(String timezone) {
        this.timezone = timezone;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Timezone is the timezone inside the container. Local means it has the same timezone as the host machine Optional.")
    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public SpecGenerator umask(String umask) {
        this.umask = umask;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Umask is the umask the init process of the container will be run with.")
    public String getUmask() {
        return this.umask;
    }

    public void setUmask(String umask) {
        this.umask = umask;
    }

    public SpecGenerator unified(Map<String, String> unified) {
        this.unified = unified;
        return this;
    }

    public SpecGenerator putUnifiedItem(String key, String unifiedItem) {
        if (this.unified == null) {
            this.unified = new HashMap<String, String>();
        }
        this.unified.put(key, unifiedItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="CgroupConf are key-value options passed into the container runtime that are used to configure cgroup v2. Optional.")
    public Map<String, String> getUnified() {
        return this.unified;
    }

    public void setUnified(Map<String, String> unified) {
        this.unified = unified;
    }

    public SpecGenerator unmask(List<String> unmask) {
        this.unmask = unmask;
        return this;
    }

    public SpecGenerator addUnmaskItem(String unmaskItem) {
        if (this.unmask == null) {
            this.unmask = new ArrayList<String>();
        }
        this.unmask.add(unmaskItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Unmask a path in the container. Some paths are masked by default, preventing them from being accessed within the container; this undoes that masking. If ALL is passed, all paths will be unmasked. Optional.")
    public List<String> getUnmask() {
        return this.unmask;
    }

    public void setUnmask(List<String> unmask) {
        this.unmask = unmask;
    }

    public SpecGenerator unsetenv(List<String> unsetenv) {
        this.unsetenv = unsetenv;
        return this;
    }

    public SpecGenerator addUnsetenvItem(String unsetenvItem) {
        if (this.unsetenv == null) {
            this.unsetenv = new ArrayList<String>();
        }
        this.unsetenv.add(unsetenvItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="UnsetEnv unsets the specified default environment variables from the image or from built-in or containers.conf Optional.")
    public List<String> getUnsetenv() {
        return this.unsetenv;
    }

    public void setUnsetenv(List<String> unsetenv) {
        this.unsetenv = unsetenv;
    }

    public SpecGenerator unsetenvall(Boolean unsetenvall) {
        this.unsetenvall = unsetenvall;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="UnsetEnvAll unsetall default environment variables from the image or from built-in or containers.conf UnsetEnvAll unsets all default environment variables from the image or from built-in Optional.")
    public Boolean getUnsetenvall() {
        return this.unsetenvall;
    }

    public void setUnsetenvall(Boolean unsetenvall) {
        this.unsetenvall = unsetenvall;
    }

    public SpecGenerator useImageHosts(Boolean useImageHosts) {
        this.useImageHosts = useImageHosts;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="UseImageHosts indicates that /etc/hosts should not be managed by Podman, and instead sourced from the image. Conflicts with HostAdd. Optional.")
    public Boolean getUseImageHosts() {
        return this.useImageHosts;
    }

    public void setUseImageHosts(Boolean useImageHosts) {
        this.useImageHosts = useImageHosts;
    }

    public SpecGenerator useImageResolveConf(Boolean useImageResolveConf) {
        this.useImageResolveConf = useImageResolveConf;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="UseImageResolvConf indicates that resolv.conf should not be managed by Podman, but instead sourced from the image. Conflicts with DNSServer, DNSSearch, DNSOption. Optional.")
    public Boolean getUseImageResolveConf() {
        return this.useImageResolveConf;
    }

    public void setUseImageResolveConf(Boolean useImageResolveConf) {
        this.useImageResolveConf = useImageResolveConf;
    }

    public SpecGenerator user(String user) {
        this.user = user;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="User is the user the container will be run as. Can be given as a UID or a username; if a username, it will be resolved within the container, using the container's /etc/passwd. If unset, the container will be run as root. Optional.")
    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public SpecGenerator userns(Namespace userns) {
        this.userns = userns;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public Namespace getUserns() {
        return this.userns;
    }

    public void setUserns(Namespace userns) {
        this.userns = userns;
    }

    public SpecGenerator utsns(Namespace utsns) {
        this.utsns = utsns;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public Namespace getUtsns() {
        return this.utsns;
    }

    public void setUtsns(Namespace utsns) {
        this.utsns = utsns;
    }

    public SpecGenerator _volatile(Boolean _volatile) {
        this._volatile = _volatile;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Volatile specifies whether the container storage can be optimized at the cost of not syncing all the dirty files in memory. Optional.")
    public Boolean getVolatile() {
        return this._volatile;
    }

    public void setVolatile(Boolean _volatile) {
        this._volatile = _volatile;
    }

    public SpecGenerator volumes(List<NamedVolume> volumes) {
        this.volumes = volumes;
        return this;
    }

    public SpecGenerator addVolumesItem(NamedVolume volumesItem) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<NamedVolume>();
        }
        this.volumes.add(volumesItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Volumes are named volumes that will be added to the container. These will supersede Image Volumes and VolumesFrom volumes where there are conflicts. Optional.")
    public List<NamedVolume> getVolumes() {
        return this.volumes;
    }

    public void setVolumes(List<NamedVolume> volumes) {
        this.volumes = volumes;
    }

    public SpecGenerator volumesFrom(List<String> volumesFrom) {
        this.volumesFrom = volumesFrom;
        return this;
    }

    public SpecGenerator addVolumesFromItem(String volumesFromItem) {
        if (this.volumesFrom == null) {
            this.volumesFrom = new ArrayList<String>();
        }
        this.volumesFrom.add(volumesFromItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="VolumesFrom is a set of containers whose volumes will be added to this container. The name or ID of the container must be provided, and may optionally be followed by a : and then one or more comma-separated options. Valid options are 'ro', 'rw', and 'z'. Options will be used for all volumes sourced from the container. Optional.")
    public List<String> getVolumesFrom() {
        return this.volumesFrom;
    }

    public void setVolumesFrom(List<String> volumesFrom) {
        this.volumesFrom = volumesFrom;
    }

    public SpecGenerator weightDevice(Map<String, LinuxWeightDevice> weightDevice) {
        this.weightDevice = weightDevice;
        return this;
    }

    public SpecGenerator putWeightDeviceItem(String key, LinuxWeightDevice weightDeviceItem) {
        if (this.weightDevice == null) {
            this.weightDevice = new HashMap<String, LinuxWeightDevice>();
        }
        this.weightDevice.put(key, weightDeviceItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Weight per cgroup per device, can override BlkioWeight")
    public Map<String, LinuxWeightDevice> getWeightDevice() {
        return this.weightDevice;
    }

    public void setWeightDevice(Map<String, LinuxWeightDevice> weightDevice) {
        this.weightDevice = weightDevice;
    }

    public SpecGenerator workDir(String workDir) {
        this.workDir = workDir;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="WorkDir is the container's working directory. If unset, the default, /, will be used. Optional.")
    public String getWorkDir() {
        return this.workDir;
    }

    public void setWorkDir(String workDir) {
        this.workDir = workDir;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpecGenerator specGenerator = (SpecGenerator)o;
        return Objects.equals(this.networks, specGenerator.networks) && Objects.equals(this.annotations, specGenerator.annotations) && Objects.equals(this.apparmorProfile, specGenerator.apparmorProfile) && Objects.equals(this.baseHostsFile, specGenerator.baseHostsFile) && Objects.equals(this.capAdd, specGenerator.capAdd) && Objects.equals(this.capDrop, specGenerator.capDrop) && Objects.equals(this.cgroupParent, specGenerator.cgroupParent) && Objects.equals(this.cgroupns, specGenerator.cgroupns) && Objects.equals(this.cgroupsMode, specGenerator.cgroupsMode) && Objects.equals(this.chrootDirectories, specGenerator.chrootDirectories) && Objects.equals(this.cniNetworks, specGenerator.cniNetworks) && Objects.equals(this.command, specGenerator.command) && Objects.equals(this.conmonPidFile, specGenerator.conmonPidFile) && Objects.equals(this.containerCreateCommand, specGenerator.containerCreateCommand) && Objects.equals(this.createWorkingDir, specGenerator.createWorkingDir) && Objects.equals(this.dependencyContainers, specGenerator.dependencyContainers) && Objects.equals(this.deviceCgroupRule, specGenerator.deviceCgroupRule) && Objects.equals(this.devices, specGenerator.devices) && Objects.equals(this.devicesFrom, specGenerator.devicesFrom) && Objects.equals(this.dnsOption, specGenerator.dnsOption) && Objects.equals(this.dnsSearch, specGenerator.dnsSearch) && Objects.equals(this.dnsServer, specGenerator.dnsServer) && Objects.equals(this.entrypoint, specGenerator.entrypoint) && Objects.equals(this.env, specGenerator.env) && Objects.equals(this.envHost, specGenerator.envHost) && Objects.equals(this.envmerge, specGenerator.envmerge) && Objects.equals(this.expose, specGenerator.expose) && Objects.equals(this.groupEntry, specGenerator.groupEntry) && Objects.equals(this.groups, specGenerator.groups) && Objects.equals(this.healthCheckOnFailureAction, specGenerator.healthCheckOnFailureAction) && Objects.equals(this.healthLogDestination, specGenerator.healthLogDestination) && Objects.equals(this.healthMaxLogCount, specGenerator.healthMaxLogCount) && Objects.equals(this.healthMaxLogSize, specGenerator.healthMaxLogSize) && Objects.equals(this.healthconfig, specGenerator.healthconfig) && Objects.equals(this.hostDeviceList, specGenerator.hostDeviceList) && Objects.equals(this.hostadd, specGenerator.hostadd) && Objects.equals(this.hostname, specGenerator.hostname) && Objects.equals(this.hostusers, specGenerator.hostusers) && Objects.equals(this.httpproxy, specGenerator.httpproxy) && Objects.equals(this.idmappings, specGenerator.idmappings) && Objects.equals(this.image, specGenerator.image) && Objects.equals(this.imageArch, specGenerator.imageArch) && Objects.equals(this.imageOs, specGenerator.imageOs) && Objects.equals(this.imageVariant, specGenerator.imageVariant) && Objects.equals(this.imageVolumeMode, specGenerator.imageVolumeMode) && Objects.equals(this.imageVolumes, specGenerator.imageVolumes) && Objects.equals(this.init, specGenerator.init) && Objects.equals(this.initContainerType, specGenerator.initContainerType) && Objects.equals(this.initPath, specGenerator.initPath) && Objects.equals(this.intelRdt, specGenerator.intelRdt) && Objects.equals(this.ipcns, specGenerator.ipcns) && Objects.equals(this.labelNested, specGenerator.labelNested) && Objects.equals(this.labels, specGenerator.labels) && Objects.equals(this.logConfiguration, specGenerator.logConfiguration) && Objects.equals(this.managePassword, specGenerator.managePassword) && Objects.equals(this.mask, specGenerator.mask) && Objects.equals(this.mounts, specGenerator.mounts) && Objects.equals(this.name, specGenerator.name) && Objects.equals(this.netns, specGenerator.netns) && Objects.equals(this.networkOptions, specGenerator.networkOptions) && Objects.equals(this.noNewPrivileges, specGenerator.noNewPrivileges) && Objects.equals(this.ociRuntime, specGenerator.ociRuntime) && Objects.equals(this.oomScoreAdj, specGenerator.oomScoreAdj) && Objects.equals(this.overlayVolumes, specGenerator.overlayVolumes) && Objects.equals(this.passwdEntry, specGenerator.passwdEntry) && Objects.equals(this.personality, specGenerator.personality) && Objects.equals(this.pidns, specGenerator.pidns) && Objects.equals(this.pod, specGenerator.pod) && Objects.equals(this.portmappings, specGenerator.portmappings) && Objects.equals(this.privileged, specGenerator.privileged) && Objects.equals(this.procfsOpts, specGenerator.procfsOpts) && Objects.equals(this.publishImagePorts, specGenerator.publishImagePorts) && Objects.equals(this.rLimits, specGenerator.rLimits) && Objects.equals(this.rawImageName, specGenerator.rawImageName) && Objects.equals(this.readOnlyFilesystem, specGenerator.readOnlyFilesystem) && Objects.equals(this.readWriteTmpfs, specGenerator.readWriteTmpfs) && Objects.equals(this.remove, specGenerator.remove) && Objects.equals(this.removeImage, specGenerator.removeImage) && Objects.equals(this.resourceLimits, specGenerator.resourceLimits) && Objects.equals(this.restartPolicy, specGenerator.restartPolicy) && Objects.equals(this.restartTries, specGenerator.restartTries) && Objects.equals(this.rootfs, specGenerator.rootfs) && Objects.equals(this.rootfsMapping, specGenerator.rootfsMapping) && Objects.equals(this.rootfsOverlay, specGenerator.rootfsOverlay) && Objects.equals(this.rootfsPropagation, specGenerator.rootfsPropagation) && Objects.equals(this.sdnotifyMode, specGenerator.sdnotifyMode) && Objects.equals(this.seccompPolicy, specGenerator.seccompPolicy) && Objects.equals(this.seccompProfilePath, specGenerator.seccompProfilePath) && Objects.equals(this.secretEnv, specGenerator.secretEnv) && Objects.equals(this.secrets, specGenerator.secrets) && Objects.equals(this.selinuxOpts, specGenerator.selinuxOpts) && Objects.equals(this.shmSize, specGenerator.shmSize) && Objects.equals(this.shmSizeSystemd, specGenerator.shmSizeSystemd) && Objects.equals(this.startupHealthConfig, specGenerator.startupHealthConfig) && Objects.equals(this.stdin, specGenerator.stdin) && Objects.equals(this.stopSignal, specGenerator.stopSignal) && Objects.equals(this.stopTimeout, specGenerator.stopTimeout) && Objects.equals(this.storageOpts, specGenerator.storageOpts) && Objects.equals(this.sysctl, specGenerator.sysctl) && Objects.equals(this.systemd, specGenerator.systemd) && Objects.equals(this.terminal, specGenerator.terminal) && Objects.equals(this.throttleReadBpsDevice, specGenerator.throttleReadBpsDevice) && Objects.equals(this.throttleReadIOPSDevice, specGenerator.throttleReadIOPSDevice) && Objects.equals(this.throttleWriteBpsDevice, specGenerator.throttleWriteBpsDevice) && Objects.equals(this.throttleWriteIOPSDevice, specGenerator.throttleWriteIOPSDevice) && Objects.equals(this.timeout, specGenerator.timeout) && Objects.equals(this.timezone, specGenerator.timezone) && Objects.equals(this.umask, specGenerator.umask) && Objects.equals(this.unified, specGenerator.unified) && Objects.equals(this.unmask, specGenerator.unmask) && Objects.equals(this.unsetenv, specGenerator.unsetenv) && Objects.equals(this.unsetenvall, specGenerator.unsetenvall) && Objects.equals(this.useImageHosts, specGenerator.useImageHosts) && Objects.equals(this.useImageResolveConf, specGenerator.useImageResolveConf) && Objects.equals(this.user, specGenerator.user) && Objects.equals(this.userns, specGenerator.userns) && Objects.equals(this.utsns, specGenerator.utsns) && Objects.equals(this._volatile, specGenerator._volatile) && Objects.equals(this.volumes, specGenerator.volumes) && Objects.equals(this.volumesFrom, specGenerator.volumesFrom) && Objects.equals(this.weightDevice, specGenerator.weightDevice) && Objects.equals(this.workDir, specGenerator.workDir);
    }

    public int hashCode() {
        return Objects.hash(this.networks, this.annotations, this.apparmorProfile, this.baseHostsFile, this.capAdd, this.capDrop, this.cgroupParent, this.cgroupns, this.cgroupsMode, this.chrootDirectories, this.cniNetworks, this.command, this.conmonPidFile, this.containerCreateCommand, this.createWorkingDir, this.dependencyContainers, this.deviceCgroupRule, this.devices, this.devicesFrom, this.dnsOption, this.dnsSearch, this.dnsServer, this.entrypoint, this.env, this.envHost, this.envmerge, this.expose, this.groupEntry, this.groups, this.healthCheckOnFailureAction, this.healthLogDestination, this.healthMaxLogCount, this.healthMaxLogSize, this.healthconfig, this.hostDeviceList, this.hostadd, this.hostname, this.hostusers, this.httpproxy, this.idmappings, this.image, this.imageArch, this.imageOs, this.imageVariant, this.imageVolumeMode, this.imageVolumes, this.init, this.initContainerType, this.initPath, this.intelRdt, this.ipcns, this.labelNested, this.labels, this.logConfiguration, this.managePassword, this.mask, this.mounts, this.name, this.netns, this.networkOptions, this.noNewPrivileges, this.ociRuntime, this.oomScoreAdj, this.overlayVolumes, this.passwdEntry, this.personality, this.pidns, this.pod, this.portmappings, this.privileged, this.procfsOpts, this.publishImagePorts, this.rLimits, this.rawImageName, this.readOnlyFilesystem, this.readWriteTmpfs, this.remove, this.removeImage, this.resourceLimits, this.restartPolicy, this.restartTries, this.rootfs, this.rootfsMapping, this.rootfsOverlay, this.rootfsPropagation, this.sdnotifyMode, this.seccompPolicy, this.seccompProfilePath, this.secretEnv, this.secrets, this.selinuxOpts, this.shmSize, this.shmSizeSystemd, this.startupHealthConfig, this.stdin, this.stopSignal, this.stopTimeout, this.storageOpts, this.sysctl, this.systemd, this.terminal, this.throttleReadBpsDevice, this.throttleReadIOPSDevice, this.throttleWriteBpsDevice, this.throttleWriteIOPSDevice, this.timeout, this.timezone, this.umask, this.unified, this.unmask, this.unsetenv, this.unsetenvall, this.useImageHosts, this.useImageResolveConf, this.user, this.userns, this.utsns, this._volatile, this.volumes, this.volumesFrom, this.weightDevice, this.workDir);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SpecGenerator {\n");
        sb.append("    networks: ").append(this.toIndentedString(this.networks)).append("\n");
        sb.append("    annotations: ").append(this.toIndentedString(this.annotations)).append("\n");
        sb.append("    apparmorProfile: ").append(this.toIndentedString(this.apparmorProfile)).append("\n");
        sb.append("    baseHostsFile: ").append(this.toIndentedString(this.baseHostsFile)).append("\n");
        sb.append("    capAdd: ").append(this.toIndentedString(this.capAdd)).append("\n");
        sb.append("    capDrop: ").append(this.toIndentedString(this.capDrop)).append("\n");
        sb.append("    cgroupParent: ").append(this.toIndentedString(this.cgroupParent)).append("\n");
        sb.append("    cgroupns: ").append(this.toIndentedString(this.cgroupns)).append("\n");
        sb.append("    cgroupsMode: ").append(this.toIndentedString(this.cgroupsMode)).append("\n");
        sb.append("    chrootDirectories: ").append(this.toIndentedString(this.chrootDirectories)).append("\n");
        sb.append("    cniNetworks: ").append(this.toIndentedString(this.cniNetworks)).append("\n");
        sb.append("    command: ").append(this.toIndentedString(this.command)).append("\n");
        sb.append("    conmonPidFile: ").append(this.toIndentedString(this.conmonPidFile)).append("\n");
        sb.append("    containerCreateCommand: ").append(this.toIndentedString(this.containerCreateCommand)).append("\n");
        sb.append("    createWorkingDir: ").append(this.toIndentedString(this.createWorkingDir)).append("\n");
        sb.append("    dependencyContainers: ").append(this.toIndentedString(this.dependencyContainers)).append("\n");
        sb.append("    deviceCgroupRule: ").append(this.toIndentedString(this.deviceCgroupRule)).append("\n");
        sb.append("    devices: ").append(this.toIndentedString(this.devices)).append("\n");
        sb.append("    devicesFrom: ").append(this.toIndentedString(this.devicesFrom)).append("\n");
        sb.append("    dnsOption: ").append(this.toIndentedString(this.dnsOption)).append("\n");
        sb.append("    dnsSearch: ").append(this.toIndentedString(this.dnsSearch)).append("\n");
        sb.append("    dnsServer: ").append(this.toIndentedString(this.dnsServer)).append("\n");
        sb.append("    entrypoint: ").append(this.toIndentedString(this.entrypoint)).append("\n");
        sb.append("    env: ").append(this.toIndentedString(this.env)).append("\n");
        sb.append("    envHost: ").append(this.toIndentedString(this.envHost)).append("\n");
        sb.append("    envmerge: ").append(this.toIndentedString(this.envmerge)).append("\n");
        sb.append("    expose: ").append(this.toIndentedString(this.expose)).append("\n");
        sb.append("    groupEntry: ").append(this.toIndentedString(this.groupEntry)).append("\n");
        sb.append("    groups: ").append(this.toIndentedString(this.groups)).append("\n");
        sb.append("    healthCheckOnFailureAction: ").append(this.toIndentedString(this.healthCheckOnFailureAction)).append("\n");
        sb.append("    healthLogDestination: ").append(this.toIndentedString(this.healthLogDestination)).append("\n");
        sb.append("    healthMaxLogCount: ").append(this.toIndentedString(this.healthMaxLogCount)).append("\n");
        sb.append("    healthMaxLogSize: ").append(this.toIndentedString(this.healthMaxLogSize)).append("\n");
        sb.append("    healthconfig: ").append(this.toIndentedString(this.healthconfig)).append("\n");
        sb.append("    hostDeviceList: ").append(this.toIndentedString(this.hostDeviceList)).append("\n");
        sb.append("    hostadd: ").append(this.toIndentedString(this.hostadd)).append("\n");
        sb.append("    hostname: ").append(this.toIndentedString(this.hostname)).append("\n");
        sb.append("    hostusers: ").append(this.toIndentedString(this.hostusers)).append("\n");
        sb.append("    httpproxy: ").append(this.toIndentedString(this.httpproxy)).append("\n");
        sb.append("    idmappings: ").append(this.toIndentedString(this.idmappings)).append("\n");
        sb.append("    image: ").append(this.toIndentedString(this.image)).append("\n");
        sb.append("    imageArch: ").append(this.toIndentedString(this.imageArch)).append("\n");
        sb.append("    imageOs: ").append(this.toIndentedString(this.imageOs)).append("\n");
        sb.append("    imageVariant: ").append(this.toIndentedString(this.imageVariant)).append("\n");
        sb.append("    imageVolumeMode: ").append(this.toIndentedString(this.imageVolumeMode)).append("\n");
        sb.append("    imageVolumes: ").append(this.toIndentedString(this.imageVolumes)).append("\n");
        sb.append("    init: ").append(this.toIndentedString(this.init)).append("\n");
        sb.append("    initContainerType: ").append(this.toIndentedString(this.initContainerType)).append("\n");
        sb.append("    initPath: ").append(this.toIndentedString(this.initPath)).append("\n");
        sb.append("    intelRdt: ").append(this.toIndentedString(this.intelRdt)).append("\n");
        sb.append("    ipcns: ").append(this.toIndentedString(this.ipcns)).append("\n");
        sb.append("    labelNested: ").append(this.toIndentedString(this.labelNested)).append("\n");
        sb.append("    labels: ").append(this.toIndentedString(this.labels)).append("\n");
        sb.append("    logConfiguration: ").append(this.toIndentedString(this.logConfiguration)).append("\n");
        sb.append("    managePassword: ").append(this.toIndentedString(this.managePassword)).append("\n");
        sb.append("    mask: ").append(this.toIndentedString(this.mask)).append("\n");
        sb.append("    mounts: ").append(this.toIndentedString(this.mounts)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    netns: ").append(this.toIndentedString(this.netns)).append("\n");
        sb.append("    networkOptions: ").append(this.toIndentedString(this.networkOptions)).append("\n");
        sb.append("    noNewPrivileges: ").append(this.toIndentedString(this.noNewPrivileges)).append("\n");
        sb.append("    ociRuntime: ").append(this.toIndentedString(this.ociRuntime)).append("\n");
        sb.append("    oomScoreAdj: ").append(this.toIndentedString(this.oomScoreAdj)).append("\n");
        sb.append("    overlayVolumes: ").append(this.toIndentedString(this.overlayVolumes)).append("\n");
        sb.append("    passwdEntry: ").append(this.toIndentedString(this.passwdEntry)).append("\n");
        sb.append("    personality: ").append(this.toIndentedString(this.personality)).append("\n");
        sb.append("    pidns: ").append(this.toIndentedString(this.pidns)).append("\n");
        sb.append("    pod: ").append(this.toIndentedString(this.pod)).append("\n");
        sb.append("    portmappings: ").append(this.toIndentedString(this.portmappings)).append("\n");
        sb.append("    privileged: ").append(this.toIndentedString(this.privileged)).append("\n");
        sb.append("    procfsOpts: ").append(this.toIndentedString(this.procfsOpts)).append("\n");
        sb.append("    publishImagePorts: ").append(this.toIndentedString(this.publishImagePorts)).append("\n");
        sb.append("    rLimits: ").append(this.toIndentedString(this.rLimits)).append("\n");
        sb.append("    rawImageName: ").append(this.toIndentedString(this.rawImageName)).append("\n");
        sb.append("    readOnlyFilesystem: ").append(this.toIndentedString(this.readOnlyFilesystem)).append("\n");
        sb.append("    readWriteTmpfs: ").append(this.toIndentedString(this.readWriteTmpfs)).append("\n");
        sb.append("    remove: ").append(this.toIndentedString(this.remove)).append("\n");
        sb.append("    removeImage: ").append(this.toIndentedString(this.removeImage)).append("\n");
        sb.append("    resourceLimits: ").append(this.toIndentedString(this.resourceLimits)).append("\n");
        sb.append("    restartPolicy: ").append(this.toIndentedString(this.restartPolicy)).append("\n");
        sb.append("    restartTries: ").append(this.toIndentedString(this.restartTries)).append("\n");
        sb.append("    rootfs: ").append(this.toIndentedString(this.rootfs)).append("\n");
        sb.append("    rootfsMapping: ").append(this.toIndentedString(this.rootfsMapping)).append("\n");
        sb.append("    rootfsOverlay: ").append(this.toIndentedString(this.rootfsOverlay)).append("\n");
        sb.append("    rootfsPropagation: ").append(this.toIndentedString(this.rootfsPropagation)).append("\n");
        sb.append("    sdnotifyMode: ").append(this.toIndentedString(this.sdnotifyMode)).append("\n");
        sb.append("    seccompPolicy: ").append(this.toIndentedString(this.seccompPolicy)).append("\n");
        sb.append("    seccompProfilePath: ").append(this.toIndentedString(this.seccompProfilePath)).append("\n");
        sb.append("    secretEnv: ").append(this.toIndentedString(this.secretEnv)).append("\n");
        sb.append("    secrets: ").append(this.toIndentedString(this.secrets)).append("\n");
        sb.append("    selinuxOpts: ").append(this.toIndentedString(this.selinuxOpts)).append("\n");
        sb.append("    shmSize: ").append(this.toIndentedString(this.shmSize)).append("\n");
        sb.append("    shmSizeSystemd: ").append(this.toIndentedString(this.shmSizeSystemd)).append("\n");
        sb.append("    startupHealthConfig: ").append(this.toIndentedString(this.startupHealthConfig)).append("\n");
        sb.append("    stdin: ").append(this.toIndentedString(this.stdin)).append("\n");
        sb.append("    stopSignal: ").append(this.toIndentedString(this.stopSignal)).append("\n");
        sb.append("    stopTimeout: ").append(this.toIndentedString(this.stopTimeout)).append("\n");
        sb.append("    storageOpts: ").append(this.toIndentedString(this.storageOpts)).append("\n");
        sb.append("    sysctl: ").append(this.toIndentedString(this.sysctl)).append("\n");
        sb.append("    systemd: ").append(this.toIndentedString(this.systemd)).append("\n");
        sb.append("    terminal: ").append(this.toIndentedString(this.terminal)).append("\n");
        sb.append("    throttleReadBpsDevice: ").append(this.toIndentedString(this.throttleReadBpsDevice)).append("\n");
        sb.append("    throttleReadIOPSDevice: ").append(this.toIndentedString(this.throttleReadIOPSDevice)).append("\n");
        sb.append("    throttleWriteBpsDevice: ").append(this.toIndentedString(this.throttleWriteBpsDevice)).append("\n");
        sb.append("    throttleWriteIOPSDevice: ").append(this.toIndentedString(this.throttleWriteIOPSDevice)).append("\n");
        sb.append("    timeout: ").append(this.toIndentedString(this.timeout)).append("\n");
        sb.append("    timezone: ").append(this.toIndentedString(this.timezone)).append("\n");
        sb.append("    umask: ").append(this.toIndentedString(this.umask)).append("\n");
        sb.append("    unified: ").append(this.toIndentedString(this.unified)).append("\n");
        sb.append("    unmask: ").append(this.toIndentedString(this.unmask)).append("\n");
        sb.append("    unsetenv: ").append(this.toIndentedString(this.unsetenv)).append("\n");
        sb.append("    unsetenvall: ").append(this.toIndentedString(this.unsetenvall)).append("\n");
        sb.append("    useImageHosts: ").append(this.toIndentedString(this.useImageHosts)).append("\n");
        sb.append("    useImageResolveConf: ").append(this.toIndentedString(this.useImageResolveConf)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    userns: ").append(this.toIndentedString(this.userns)).append("\n");
        sb.append("    utsns: ").append(this.toIndentedString(this.utsns)).append("\n");
        sb.append("    _volatile: ").append(this.toIndentedString(this._volatile)).append("\n");
        sb.append("    volumes: ").append(this.toIndentedString(this.volumes)).append("\n");
        sb.append("    volumesFrom: ").append(this.toIndentedString(this.volumesFrom)).append("\n");
        sb.append("    weightDevice: ").append(this.toIndentedString(this.weightDevice)).append("\n");
        sb.append("    workDir: ").append(this.toIndentedString(this.workDir)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArrayvolumes;
        JsonArray jsonArraysecrets;
        JsonArray jsonArrayrLimits;
        JsonArray jsonArrayportmappings;
        JsonArray jsonArrayoverlayVolumes;
        JsonArray jsonArraymounts;
        JsonArray jsonArrayimageVolumes;
        JsonArray jsonArrayhostDeviceList;
        JsonArray jsonArraydevices;
        JsonArray jsonArraydeviceCgroupRule;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in SpecGenerator is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `SpecGenerator` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_APPARMOR_PROFILE) != null && !jsonObj.get(SERIALIZED_NAME_APPARMOR_PROFILE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_APPARMOR_PROFILE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `apparmor_profile` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_APPARMOR_PROFILE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BASE_HOSTS_FILE) != null && !jsonObj.get(SERIALIZED_NAME_BASE_HOSTS_FILE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_BASE_HOSTS_FILE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `base_hosts_file` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BASE_HOSTS_FILE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CAP_ADD) != null && !jsonObj.get(SERIALIZED_NAME_CAP_ADD).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CAP_ADD).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `cap_add` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CAP_ADD).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CAP_DROP) != null && !jsonObj.get(SERIALIZED_NAME_CAP_DROP).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CAP_DROP).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `cap_drop` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CAP_DROP).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CGROUP_PARENT) != null && !jsonObj.get(SERIALIZED_NAME_CGROUP_PARENT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CGROUP_PARENT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `cgroup_parent` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CGROUP_PARENT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CGROUPNS) != null && !jsonObj.get(SERIALIZED_NAME_CGROUPNS).isJsonNull()) {
            Namespace.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_CGROUPNS));
        }
        if (jsonObj.get(SERIALIZED_NAME_CGROUPS_MODE) != null && !jsonObj.get(SERIALIZED_NAME_CGROUPS_MODE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CGROUPS_MODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `cgroups_mode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CGROUPS_MODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CHROOT_DIRECTORIES) != null && !jsonObj.get(SERIALIZED_NAME_CHROOT_DIRECTORIES).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CHROOT_DIRECTORIES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `chroot_directories` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CHROOT_DIRECTORIES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CNI_NETWORKS) != null && !jsonObj.get(SERIALIZED_NAME_CNI_NETWORKS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CNI_NETWORKS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `cni_networks` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CNI_NETWORKS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_COMMAND) != null && !jsonObj.get(SERIALIZED_NAME_COMMAND).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_COMMAND).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `command` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COMMAND).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONMON_PID_FILE) != null && !jsonObj.get(SERIALIZED_NAME_CONMON_PID_FILE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CONMON_PID_FILE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `conmon_pid_file` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONMON_PID_FILE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONTAINER_CREATE_COMMAND) != null && !jsonObj.get(SERIALIZED_NAME_CONTAINER_CREATE_COMMAND).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CONTAINER_CREATE_COMMAND).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `containerCreateCommand` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONTAINER_CREATE_COMMAND).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DEPENDENCY_CONTAINERS) != null && !jsonObj.get(SERIALIZED_NAME_DEPENDENCY_CONTAINERS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DEPENDENCY_CONTAINERS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `dependencyContainers` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DEPENDENCY_CONTAINERS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DEVICE_CGROUP_RULE) != null && !jsonObj.get(SERIALIZED_NAME_DEVICE_CGROUP_RULE).isJsonNull() && (jsonArraydeviceCgroupRule = jsonObj.getAsJsonArray(SERIALIZED_NAME_DEVICE_CGROUP_RULE)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_DEVICE_CGROUP_RULE).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `device_cgroup_rule` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DEVICE_CGROUP_RULE).toString()));
            }
            for (int i = 0; i < jsonArraydeviceCgroupRule.size(); ++i) {
                LinuxDeviceCgroup.validateJsonObject(jsonArraydeviceCgroupRule.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_DEVICES) != null && !jsonObj.get(SERIALIZED_NAME_DEVICES).isJsonNull() && (jsonArraydevices = jsonObj.getAsJsonArray(SERIALIZED_NAME_DEVICES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_DEVICES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `devices` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DEVICES).toString()));
            }
            for (int i = 0; i < jsonArraydevices.size(); ++i) {
                LinuxDevice.validateJsonObject(jsonArraydevices.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_DEVICES_FROM) != null && !jsonObj.get(SERIALIZED_NAME_DEVICES_FROM).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DEVICES_FROM).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `devices_from` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DEVICES_FROM).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DNS_OPTION) != null && !jsonObj.get(SERIALIZED_NAME_DNS_OPTION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DNS_OPTION).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `dns_option` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DNS_OPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DNS_SEARCH) != null && !jsonObj.get(SERIALIZED_NAME_DNS_SEARCH).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DNS_SEARCH).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `dns_search` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DNS_SEARCH).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DNS_SERVER) != null && !jsonObj.get(SERIALIZED_NAME_DNS_SERVER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DNS_SERVER).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `dns_server` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DNS_SERVER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ENTRYPOINT) != null && !jsonObj.get(SERIALIZED_NAME_ENTRYPOINT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ENTRYPOINT).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `entrypoint` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENTRYPOINT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ENVMERGE) != null && !jsonObj.get(SERIALIZED_NAME_ENVMERGE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ENVMERGE).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `envmerge` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENVMERGE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_GROUP_ENTRY) != null && !jsonObj.get(SERIALIZED_NAME_GROUP_ENTRY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_GROUP_ENTRY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `group_entry` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_GROUP_ENTRY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_GROUPS) != null && !jsonObj.get(SERIALIZED_NAME_GROUPS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_GROUPS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `groups` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_GROUPS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_HEALTH_LOG_DESTINATION) != null && !jsonObj.get(SERIALIZED_NAME_HEALTH_LOG_DESTINATION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_HEALTH_LOG_DESTINATION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `healthLogDestination` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HEALTH_LOG_DESTINATION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_HEALTHCONFIG) != null && !jsonObj.get(SERIALIZED_NAME_HEALTHCONFIG).isJsonNull()) {
            Schema2HealthConfig.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_HEALTHCONFIG));
        }
        if (jsonObj.get(SERIALIZED_NAME_HOST_DEVICE_LIST) != null && !jsonObj.get(SERIALIZED_NAME_HOST_DEVICE_LIST).isJsonNull() && (jsonArrayhostDeviceList = jsonObj.getAsJsonArray(SERIALIZED_NAME_HOST_DEVICE_LIST)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_HOST_DEVICE_LIST).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `host_device_list` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HOST_DEVICE_LIST).toString()));
            }
            for (int i = 0; i < jsonArrayhostDeviceList.size(); ++i) {
                LinuxDevice.validateJsonObject(jsonArrayhostDeviceList.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_HOSTADD) != null && !jsonObj.get(SERIALIZED_NAME_HOSTADD).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_HOSTADD).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `hostadd` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HOSTADD).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_HOSTNAME) != null && !jsonObj.get(SERIALIZED_NAME_HOSTNAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_HOSTNAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `hostname` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HOSTNAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_HOSTUSERS) != null && !jsonObj.get(SERIALIZED_NAME_HOSTUSERS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_HOSTUSERS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `hostusers` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HOSTUSERS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_IDMAPPINGS) != null && !jsonObj.get(SERIALIZED_NAME_IDMAPPINGS).isJsonNull()) {
            IDMappingOptions.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_IDMAPPINGS));
        }
        if (jsonObj.get(SERIALIZED_NAME_IMAGE) != null && !jsonObj.get(SERIALIZED_NAME_IMAGE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_IMAGE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `image` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IMAGE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_IMAGE_ARCH) != null && !jsonObj.get(SERIALIZED_NAME_IMAGE_ARCH).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_IMAGE_ARCH).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `image_arch` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IMAGE_ARCH).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_IMAGE_OS) != null && !jsonObj.get(SERIALIZED_NAME_IMAGE_OS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_IMAGE_OS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `image_os` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IMAGE_OS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_IMAGE_VARIANT) != null && !jsonObj.get(SERIALIZED_NAME_IMAGE_VARIANT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_IMAGE_VARIANT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `image_variant` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IMAGE_VARIANT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_IMAGE_VOLUME_MODE) != null && !jsonObj.get(SERIALIZED_NAME_IMAGE_VOLUME_MODE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_IMAGE_VOLUME_MODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `image_volume_mode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IMAGE_VOLUME_MODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_IMAGE_VOLUMES) != null && !jsonObj.get(SERIALIZED_NAME_IMAGE_VOLUMES).isJsonNull() && (jsonArrayimageVolumes = jsonObj.getAsJsonArray(SERIALIZED_NAME_IMAGE_VOLUMES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_IMAGE_VOLUMES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `image_volumes` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IMAGE_VOLUMES).toString()));
            }
            for (int i = 0; i < jsonArrayimageVolumes.size(); ++i) {
                ImageVolume.validateJsonObject(jsonArrayimageVolumes.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_INIT_CONTAINER_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_INIT_CONTAINER_TYPE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_INIT_CONTAINER_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `init_container_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INIT_CONTAINER_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_INIT_PATH) != null && !jsonObj.get(SERIALIZED_NAME_INIT_PATH).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_INIT_PATH).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `init_path` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INIT_PATH).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_INTEL_RDT) != null && !jsonObj.get(SERIALIZED_NAME_INTEL_RDT).isJsonNull()) {
            LinuxIntelRdt.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_INTEL_RDT));
        }
        if (jsonObj.get(SERIALIZED_NAME_IPCNS) != null && !jsonObj.get(SERIALIZED_NAME_IPCNS).isJsonNull()) {
            Namespace.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_IPCNS));
        }
        if (jsonObj.get(SERIALIZED_NAME_LOG_CONFIGURATION) != null && !jsonObj.get(SERIALIZED_NAME_LOG_CONFIGURATION).isJsonNull()) {
            LogConfigLibpod.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_LOG_CONFIGURATION));
        }
        if (jsonObj.get(SERIALIZED_NAME_MASK) != null && !jsonObj.get(SERIALIZED_NAME_MASK).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_MASK).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `mask` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MASK).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MOUNTS) != null && !jsonObj.get(SERIALIZED_NAME_MOUNTS).isJsonNull() && (jsonArraymounts = jsonObj.getAsJsonArray(SERIALIZED_NAME_MOUNTS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_MOUNTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `mounts` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MOUNTS).toString()));
            }
            for (int i = 0; i < jsonArraymounts.size(); ++i) {
                Mount.validateJsonObject(jsonArraymounts.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NETNS) != null && !jsonObj.get(SERIALIZED_NAME_NETNS).isJsonNull()) {
            Namespace.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_NETNS));
        }
        if (jsonObj.get(SERIALIZED_NAME_OCI_RUNTIME) != null && !jsonObj.get(SERIALIZED_NAME_OCI_RUNTIME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_OCI_RUNTIME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `oci_runtime` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OCI_RUNTIME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_OVERLAY_VOLUMES) != null && !jsonObj.get(SERIALIZED_NAME_OVERLAY_VOLUMES).isJsonNull() && (jsonArrayoverlayVolumes = jsonObj.getAsJsonArray(SERIALIZED_NAME_OVERLAY_VOLUMES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_OVERLAY_VOLUMES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `overlay_volumes` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OVERLAY_VOLUMES).toString()));
            }
            for (int i = 0; i < jsonArrayoverlayVolumes.size(); ++i) {
                OverlayVolume.validateJsonObject(jsonArrayoverlayVolumes.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_PASSWD_ENTRY) != null && !jsonObj.get(SERIALIZED_NAME_PASSWD_ENTRY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PASSWD_ENTRY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `passwd_entry` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PASSWD_ENTRY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PERSONALITY) != null && !jsonObj.get(SERIALIZED_NAME_PERSONALITY).isJsonNull()) {
            LinuxPersonality.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_PERSONALITY));
        }
        if (jsonObj.get(SERIALIZED_NAME_PIDNS) != null && !jsonObj.get(SERIALIZED_NAME_PIDNS).isJsonNull()) {
            Namespace.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_PIDNS));
        }
        if (jsonObj.get(SERIALIZED_NAME_POD) != null && !jsonObj.get(SERIALIZED_NAME_POD).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_POD).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `pod` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_POD).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PORTMAPPINGS) != null && !jsonObj.get(SERIALIZED_NAME_PORTMAPPINGS).isJsonNull() && (jsonArrayportmappings = jsonObj.getAsJsonArray(SERIALIZED_NAME_PORTMAPPINGS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_PORTMAPPINGS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `portmappings` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PORTMAPPINGS).toString()));
            }
            for (int i = 0; i < jsonArrayportmappings.size(); ++i) {
                PortMapping.validateJsonObject(jsonArrayportmappings.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_PROCFS_OPTS) != null && !jsonObj.get(SERIALIZED_NAME_PROCFS_OPTS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PROCFS_OPTS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `procfs_opts` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PROCFS_OPTS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_R_LIMITS) != null && !jsonObj.get(SERIALIZED_NAME_R_LIMITS).isJsonNull() && (jsonArrayrLimits = jsonObj.getAsJsonArray(SERIALIZED_NAME_R_LIMITS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_R_LIMITS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `r_limits` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_R_LIMITS).toString()));
            }
            for (int i = 0; i < jsonArrayrLimits.size(); ++i) {
                POSIXRlimit.validateJsonObject(jsonArrayrLimits.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_RAW_IMAGE_NAME) != null && !jsonObj.get(SERIALIZED_NAME_RAW_IMAGE_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_RAW_IMAGE_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `raw_image_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RAW_IMAGE_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RESOURCE_LIMITS) != null && !jsonObj.get(SERIALIZED_NAME_RESOURCE_LIMITS).isJsonNull()) {
            LinuxResources.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_RESOURCE_LIMITS));
        }
        if (jsonObj.get(SERIALIZED_NAME_RESTART_POLICY) != null && !jsonObj.get(SERIALIZED_NAME_RESTART_POLICY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_RESTART_POLICY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `restart_policy` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESTART_POLICY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ROOTFS) != null && !jsonObj.get(SERIALIZED_NAME_ROOTFS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ROOTFS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `rootfs` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ROOTFS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ROOTFS_MAPPING) != null && !jsonObj.get(SERIALIZED_NAME_ROOTFS_MAPPING).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ROOTFS_MAPPING).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `rootfs_mapping` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ROOTFS_MAPPING).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ROOTFS_PROPAGATION) != null && !jsonObj.get(SERIALIZED_NAME_ROOTFS_PROPAGATION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ROOTFS_PROPAGATION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `rootfs_propagation` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ROOTFS_PROPAGATION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SDNOTIFY_MODE) != null && !jsonObj.get(SERIALIZED_NAME_SDNOTIFY_MODE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SDNOTIFY_MODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `sdnotifyMode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SDNOTIFY_MODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SECCOMP_POLICY) != null && !jsonObj.get(SERIALIZED_NAME_SECCOMP_POLICY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SECCOMP_POLICY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `seccomp_policy` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SECCOMP_POLICY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SECCOMP_PROFILE_PATH) != null && !jsonObj.get(SERIALIZED_NAME_SECCOMP_PROFILE_PATH).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SECCOMP_PROFILE_PATH).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `seccomp_profile_path` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SECCOMP_PROFILE_PATH).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SECRETS) != null && !jsonObj.get(SERIALIZED_NAME_SECRETS).isJsonNull() && (jsonArraysecrets = jsonObj.getAsJsonArray(SERIALIZED_NAME_SECRETS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_SECRETS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `secrets` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SECRETS).toString()));
            }
            for (int i = 0; i < jsonArraysecrets.size(); ++i) {
                Secret.validateJsonObject(jsonArraysecrets.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_SELINUX_OPTS) != null && !jsonObj.get(SERIALIZED_NAME_SELINUX_OPTS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SELINUX_OPTS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `selinux_opts` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SELINUX_OPTS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STARTUP_HEALTH_CONFIG) != null && !jsonObj.get(SERIALIZED_NAME_STARTUP_HEALTH_CONFIG).isJsonNull()) {
            StartupHealthCheck.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_STARTUP_HEALTH_CONFIG));
        }
        if (jsonObj.get(SERIALIZED_NAME_SYSTEMD) != null && !jsonObj.get(SERIALIZED_NAME_SYSTEMD).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SYSTEMD).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `systemd` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SYSTEMD).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TIMEZONE) != null && !jsonObj.get(SERIALIZED_NAME_TIMEZONE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_TIMEZONE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `timezone` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TIMEZONE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_UMASK) != null && !jsonObj.get(SERIALIZED_NAME_UMASK).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_UMASK).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `umask` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UMASK).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_UNMASK) != null && !jsonObj.get(SERIALIZED_NAME_UNMASK).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_UNMASK).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `unmask` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UNMASK).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_UNSETENV) != null && !jsonObj.get(SERIALIZED_NAME_UNSETENV).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_UNSETENV).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `unsetenv` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UNSETENV).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_USER) != null && !jsonObj.get(SERIALIZED_NAME_USER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_USER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `user` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_USER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_USERNS) != null && !jsonObj.get(SERIALIZED_NAME_USERNS).isJsonNull()) {
            Namespace.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_USERNS));
        }
        if (jsonObj.get(SERIALIZED_NAME_UTSNS) != null && !jsonObj.get(SERIALIZED_NAME_UTSNS).isJsonNull()) {
            Namespace.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_UTSNS));
        }
        if (jsonObj.get(SERIALIZED_NAME_VOLUMES) != null && !jsonObj.get(SERIALIZED_NAME_VOLUMES).isJsonNull() && (jsonArrayvolumes = jsonObj.getAsJsonArray(SERIALIZED_NAME_VOLUMES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_VOLUMES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `volumes` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VOLUMES).toString()));
            }
            for (int i = 0; i < jsonArrayvolumes.size(); ++i) {
                NamedVolume.validateJsonObject(jsonArrayvolumes.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_VOLUMES_FROM) != null && !jsonObj.get(SERIALIZED_NAME_VOLUMES_FROM).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_VOLUMES_FROM).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `volumes_from` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VOLUMES_FROM).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_WORK_DIR) != null && !jsonObj.get(SERIALIZED_NAME_WORK_DIR).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_WORK_DIR).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `work_dir` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_WORK_DIR).toString()));
        }
    }

    public static SpecGenerator fromJson(String jsonString) throws IOException {
        return (SpecGenerator)JSON.getGson().fromJson(jsonString, SpecGenerator.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_NETWORKS);
        openapiFields.add(SERIALIZED_NAME_ANNOTATIONS);
        openapiFields.add(SERIALIZED_NAME_APPARMOR_PROFILE);
        openapiFields.add(SERIALIZED_NAME_BASE_HOSTS_FILE);
        openapiFields.add(SERIALIZED_NAME_CAP_ADD);
        openapiFields.add(SERIALIZED_NAME_CAP_DROP);
        openapiFields.add(SERIALIZED_NAME_CGROUP_PARENT);
        openapiFields.add(SERIALIZED_NAME_CGROUPNS);
        openapiFields.add(SERIALIZED_NAME_CGROUPS_MODE);
        openapiFields.add(SERIALIZED_NAME_CHROOT_DIRECTORIES);
        openapiFields.add(SERIALIZED_NAME_CNI_NETWORKS);
        openapiFields.add(SERIALIZED_NAME_COMMAND);
        openapiFields.add(SERIALIZED_NAME_CONMON_PID_FILE);
        openapiFields.add(SERIALIZED_NAME_CONTAINER_CREATE_COMMAND);
        openapiFields.add(SERIALIZED_NAME_CREATE_WORKING_DIR);
        openapiFields.add(SERIALIZED_NAME_DEPENDENCY_CONTAINERS);
        openapiFields.add(SERIALIZED_NAME_DEVICE_CGROUP_RULE);
        openapiFields.add(SERIALIZED_NAME_DEVICES);
        openapiFields.add(SERIALIZED_NAME_DEVICES_FROM);
        openapiFields.add(SERIALIZED_NAME_DNS_OPTION);
        openapiFields.add(SERIALIZED_NAME_DNS_SEARCH);
        openapiFields.add(SERIALIZED_NAME_DNS_SERVER);
        openapiFields.add(SERIALIZED_NAME_ENTRYPOINT);
        openapiFields.add(SERIALIZED_NAME_ENV);
        openapiFields.add(SERIALIZED_NAME_ENV_HOST);
        openapiFields.add(SERIALIZED_NAME_ENVMERGE);
        openapiFields.add(SERIALIZED_NAME_EXPOSE);
        openapiFields.add(SERIALIZED_NAME_GROUP_ENTRY);
        openapiFields.add(SERIALIZED_NAME_GROUPS);
        openapiFields.add(SERIALIZED_NAME_HEALTH_CHECK_ON_FAILURE_ACTION);
        openapiFields.add(SERIALIZED_NAME_HEALTH_LOG_DESTINATION);
        openapiFields.add(SERIALIZED_NAME_HEALTH_MAX_LOG_COUNT);
        openapiFields.add(SERIALIZED_NAME_HEALTH_MAX_LOG_SIZE);
        openapiFields.add(SERIALIZED_NAME_HEALTHCONFIG);
        openapiFields.add(SERIALIZED_NAME_HOST_DEVICE_LIST);
        openapiFields.add(SERIALIZED_NAME_HOSTADD);
        openapiFields.add(SERIALIZED_NAME_HOSTNAME);
        openapiFields.add(SERIALIZED_NAME_HOSTUSERS);
        openapiFields.add(SERIALIZED_NAME_HTTPPROXY);
        openapiFields.add(SERIALIZED_NAME_IDMAPPINGS);
        openapiFields.add(SERIALIZED_NAME_IMAGE);
        openapiFields.add(SERIALIZED_NAME_IMAGE_ARCH);
        openapiFields.add(SERIALIZED_NAME_IMAGE_OS);
        openapiFields.add(SERIALIZED_NAME_IMAGE_VARIANT);
        openapiFields.add(SERIALIZED_NAME_IMAGE_VOLUME_MODE);
        openapiFields.add(SERIALIZED_NAME_IMAGE_VOLUMES);
        openapiFields.add(SERIALIZED_NAME_INIT);
        openapiFields.add(SERIALIZED_NAME_INIT_CONTAINER_TYPE);
        openapiFields.add(SERIALIZED_NAME_INIT_PATH);
        openapiFields.add(SERIALIZED_NAME_INTEL_RDT);
        openapiFields.add(SERIALIZED_NAME_IPCNS);
        openapiFields.add(SERIALIZED_NAME_LABEL_NESTED);
        openapiFields.add(SERIALIZED_NAME_LABELS);
        openapiFields.add(SERIALIZED_NAME_LOG_CONFIGURATION);
        openapiFields.add(SERIALIZED_NAME_MANAGE_PASSWORD);
        openapiFields.add(SERIALIZED_NAME_MASK);
        openapiFields.add(SERIALIZED_NAME_MOUNTS);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_NETNS);
        openapiFields.add(SERIALIZED_NAME_NETWORK_OPTIONS);
        openapiFields.add(SERIALIZED_NAME_NO_NEW_PRIVILEGES);
        openapiFields.add(SERIALIZED_NAME_OCI_RUNTIME);
        openapiFields.add(SERIALIZED_NAME_OOM_SCORE_ADJ);
        openapiFields.add(SERIALIZED_NAME_OVERLAY_VOLUMES);
        openapiFields.add(SERIALIZED_NAME_PASSWD_ENTRY);
        openapiFields.add(SERIALIZED_NAME_PERSONALITY);
        openapiFields.add(SERIALIZED_NAME_PIDNS);
        openapiFields.add(SERIALIZED_NAME_POD);
        openapiFields.add(SERIALIZED_NAME_PORTMAPPINGS);
        openapiFields.add(SERIALIZED_NAME_PRIVILEGED);
        openapiFields.add(SERIALIZED_NAME_PROCFS_OPTS);
        openapiFields.add(SERIALIZED_NAME_PUBLISH_IMAGE_PORTS);
        openapiFields.add(SERIALIZED_NAME_R_LIMITS);
        openapiFields.add(SERIALIZED_NAME_RAW_IMAGE_NAME);
        openapiFields.add(SERIALIZED_NAME_READ_ONLY_FILESYSTEM);
        openapiFields.add(SERIALIZED_NAME_READ_WRITE_TMPFS);
        openapiFields.add(SERIALIZED_NAME_REMOVE);
        openapiFields.add(SERIALIZED_NAME_REMOVE_IMAGE);
        openapiFields.add(SERIALIZED_NAME_RESOURCE_LIMITS);
        openapiFields.add(SERIALIZED_NAME_RESTART_POLICY);
        openapiFields.add(SERIALIZED_NAME_RESTART_TRIES);
        openapiFields.add(SERIALIZED_NAME_ROOTFS);
        openapiFields.add(SERIALIZED_NAME_ROOTFS_MAPPING);
        openapiFields.add(SERIALIZED_NAME_ROOTFS_OVERLAY);
        openapiFields.add(SERIALIZED_NAME_ROOTFS_PROPAGATION);
        openapiFields.add(SERIALIZED_NAME_SDNOTIFY_MODE);
        openapiFields.add(SERIALIZED_NAME_SECCOMP_POLICY);
        openapiFields.add(SERIALIZED_NAME_SECCOMP_PROFILE_PATH);
        openapiFields.add(SERIALIZED_NAME_SECRET_ENV);
        openapiFields.add(SERIALIZED_NAME_SECRETS);
        openapiFields.add(SERIALIZED_NAME_SELINUX_OPTS);
        openapiFields.add(SERIALIZED_NAME_SHM_SIZE);
        openapiFields.add(SERIALIZED_NAME_SHM_SIZE_SYSTEMD);
        openapiFields.add(SERIALIZED_NAME_STARTUP_HEALTH_CONFIG);
        openapiFields.add(SERIALIZED_NAME_STDIN);
        openapiFields.add(SERIALIZED_NAME_STOP_SIGNAL);
        openapiFields.add(SERIALIZED_NAME_STOP_TIMEOUT);
        openapiFields.add(SERIALIZED_NAME_STORAGE_OPTS);
        openapiFields.add(SERIALIZED_NAME_SYSCTL);
        openapiFields.add(SERIALIZED_NAME_SYSTEMD);
        openapiFields.add(SERIALIZED_NAME_TERMINAL);
        openapiFields.add(SERIALIZED_NAME_THROTTLE_READ_BPS_DEVICE);
        openapiFields.add(SERIALIZED_NAME_THROTTLE_READ_I_O_P_S_DEVICE);
        openapiFields.add(SERIALIZED_NAME_THROTTLE_WRITE_BPS_DEVICE);
        openapiFields.add(SERIALIZED_NAME_THROTTLE_WRITE_I_O_P_S_DEVICE);
        openapiFields.add(SERIALIZED_NAME_TIMEOUT);
        openapiFields.add(SERIALIZED_NAME_TIMEZONE);
        openapiFields.add(SERIALIZED_NAME_UMASK);
        openapiFields.add(SERIALIZED_NAME_UNIFIED);
        openapiFields.add(SERIALIZED_NAME_UNMASK);
        openapiFields.add(SERIALIZED_NAME_UNSETENV);
        openapiFields.add(SERIALIZED_NAME_UNSETENVALL);
        openapiFields.add(SERIALIZED_NAME_USE_IMAGE_HOSTS);
        openapiFields.add(SERIALIZED_NAME_USE_IMAGE_RESOLVE_CONF);
        openapiFields.add(SERIALIZED_NAME_USER);
        openapiFields.add(SERIALIZED_NAME_USERNS);
        openapiFields.add(SERIALIZED_NAME_UTSNS);
        openapiFields.add(SERIALIZED_NAME_VOLATILE);
        openapiFields.add(SERIALIZED_NAME_VOLUMES);
        openapiFields.add(SERIALIZED_NAME_VOLUMES_FROM);
        openapiFields.add(SERIALIZED_NAME_WEIGHT_DEVICE);
        openapiFields.add(SERIALIZED_NAME_WORK_DIR);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!SpecGenerator.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(SpecGenerator.class));
            return new TypeAdapter<SpecGenerator>(){

                public void write(JsonWriter out, SpecGenerator value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public SpecGenerator read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    SpecGenerator.validateJsonObject(jsonObj);
                    return (SpecGenerator)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

