/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.github.pod4dev.libpodj.model.ContainerStore;
import io.github.pod4dev.libpodj.model.ImageStore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.validation.Valid;

@ApiModel(description="StoreInfo describes the container storage and its attributes")
public class StoreInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_CONFIG_FILE = "configFile";
    @SerializedName(value="configFile")
    private String configFile;
    public static final String SERIALIZED_NAME_CONTAINER_STORE = "containerStore";
    @SerializedName(value="containerStore")
    private ContainerStore containerStore;
    public static final String SERIALIZED_NAME_GRAPH_DRIVER_NAME = "graphDriverName";
    @SerializedName(value="graphDriverName")
    private String graphDriverName;
    public static final String SERIALIZED_NAME_GRAPH_OPTIONS = "graphOptions";
    @SerializedName(value="graphOptions")
    private Map<String, Object> graphOptions = null;
    public static final String SERIALIZED_NAME_GRAPH_ROOT = "graphRoot";
    @SerializedName(value="graphRoot")
    private String graphRoot;
    public static final String SERIALIZED_NAME_GRAPH_ROOT_ALLOCATED = "graphRootAllocated";
    @SerializedName(value="graphRootAllocated")
    private Integer graphRootAllocated;
    public static final String SERIALIZED_NAME_GRAPH_ROOT_USED = "graphRootUsed";
    @SerializedName(value="graphRootUsed")
    private Integer graphRootUsed;
    public static final String SERIALIZED_NAME_GRAPH_STATUS = "graphStatus";
    @SerializedName(value="graphStatus")
    private Map<String, String> graphStatus = null;
    public static final String SERIALIZED_NAME_IMAGE_COPY_TMP_DIR = "imageCopyTmpDir";
    @SerializedName(value="imageCopyTmpDir")
    private String imageCopyTmpDir;
    public static final String SERIALIZED_NAME_IMAGE_STORE = "imageStore";
    @SerializedName(value="imageStore")
    private ImageStore imageStore;
    public static final String SERIALIZED_NAME_RUN_ROOT = "runRoot";
    @SerializedName(value="runRoot")
    private String runRoot;
    public static final String SERIALIZED_NAME_TRANSIENT_STORE = "transientStore";
    @SerializedName(value="transientStore")
    private Boolean transientStore;
    public static final String SERIALIZED_NAME_VOLUME_PATH = "volumePath";
    @SerializedName(value="volumePath")
    private String volumePath;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public StoreInfo configFile(String configFile) {
        this.configFile = configFile;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public StoreInfo containerStore(ContainerStore containerStore) {
        this.containerStore = containerStore;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public ContainerStore getContainerStore() {
        return this.containerStore;
    }

    public void setContainerStore(ContainerStore containerStore) {
        this.containerStore = containerStore;
    }

    public StoreInfo graphDriverName(String graphDriverName) {
        this.graphDriverName = graphDriverName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getGraphDriverName() {
        return this.graphDriverName;
    }

    public void setGraphDriverName(String graphDriverName) {
        this.graphDriverName = graphDriverName;
    }

    public StoreInfo graphOptions(Map<String, Object> graphOptions) {
        this.graphOptions = graphOptions;
        return this;
    }

    public StoreInfo putGraphOptionsItem(String key, Object graphOptionsItem) {
        if (this.graphOptions == null) {
            this.graphOptions = new HashMap<String, Object>();
        }
        this.graphOptions.put(key, graphOptionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Map<String, Object> getGraphOptions() {
        return this.graphOptions;
    }

    public void setGraphOptions(Map<String, Object> graphOptions) {
        this.graphOptions = graphOptions;
    }

    public StoreInfo graphRoot(String graphRoot) {
        this.graphRoot = graphRoot;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getGraphRoot() {
        return this.graphRoot;
    }

    public void setGraphRoot(String graphRoot) {
        this.graphRoot = graphRoot;
    }

    public StoreInfo graphRootAllocated(Integer graphRootAllocated) {
        this.graphRootAllocated = graphRootAllocated;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="GraphRootAllocated is how much space the graphroot has in bytes")
    public Integer getGraphRootAllocated() {
        return this.graphRootAllocated;
    }

    public void setGraphRootAllocated(Integer graphRootAllocated) {
        this.graphRootAllocated = graphRootAllocated;
    }

    public StoreInfo graphRootUsed(Integer graphRootUsed) {
        this.graphRootUsed = graphRootUsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="GraphRootUsed is how much of graphroot is used in bytes")
    public Integer getGraphRootUsed() {
        return this.graphRootUsed;
    }

    public void setGraphRootUsed(Integer graphRootUsed) {
        this.graphRootUsed = graphRootUsed;
    }

    public StoreInfo graphStatus(Map<String, String> graphStatus) {
        this.graphStatus = graphStatus;
        return this;
    }

    public StoreInfo putGraphStatusItem(String key, String graphStatusItem) {
        if (this.graphStatus == null) {
            this.graphStatus = new HashMap<String, String>();
        }
        this.graphStatus.put(key, graphStatusItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Map<String, String> getGraphStatus() {
        return this.graphStatus;
    }

    public void setGraphStatus(Map<String, String> graphStatus) {
        this.graphStatus = graphStatus;
    }

    public StoreInfo imageCopyTmpDir(String imageCopyTmpDir) {
        this.imageCopyTmpDir = imageCopyTmpDir;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getImageCopyTmpDir() {
        return this.imageCopyTmpDir;
    }

    public void setImageCopyTmpDir(String imageCopyTmpDir) {
        this.imageCopyTmpDir = imageCopyTmpDir;
    }

    public StoreInfo imageStore(ImageStore imageStore) {
        this.imageStore = imageStore;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public ImageStore getImageStore() {
        return this.imageStore;
    }

    public void setImageStore(ImageStore imageStore) {
        this.imageStore = imageStore;
    }

    public StoreInfo runRoot(String runRoot) {
        this.runRoot = runRoot;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getRunRoot() {
        return this.runRoot;
    }

    public void setRunRoot(String runRoot) {
        this.runRoot = runRoot;
    }

    public StoreInfo transientStore(Boolean transientStore) {
        this.transientStore = transientStore;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Boolean getTransientStore() {
        return this.transientStore;
    }

    public void setTransientStore(Boolean transientStore) {
        this.transientStore = transientStore;
    }

    public StoreInfo volumePath(String volumePath) {
        this.volumePath = volumePath;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getVolumePath() {
        return this.volumePath;
    }

    public void setVolumePath(String volumePath) {
        this.volumePath = volumePath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoreInfo storeInfo = (StoreInfo)o;
        return Objects.equals(this.configFile, storeInfo.configFile) && Objects.equals(this.containerStore, storeInfo.containerStore) && Objects.equals(this.graphDriverName, storeInfo.graphDriverName) && Objects.equals(this.graphOptions, storeInfo.graphOptions) && Objects.equals(this.graphRoot, storeInfo.graphRoot) && Objects.equals(this.graphRootAllocated, storeInfo.graphRootAllocated) && Objects.equals(this.graphRootUsed, storeInfo.graphRootUsed) && Objects.equals(this.graphStatus, storeInfo.graphStatus) && Objects.equals(this.imageCopyTmpDir, storeInfo.imageCopyTmpDir) && Objects.equals(this.imageStore, storeInfo.imageStore) && Objects.equals(this.runRoot, storeInfo.runRoot) && Objects.equals(this.transientStore, storeInfo.transientStore) && Objects.equals(this.volumePath, storeInfo.volumePath);
    }

    public int hashCode() {
        return Objects.hash(this.configFile, this.containerStore, this.graphDriverName, this.graphOptions, this.graphRoot, this.graphRootAllocated, this.graphRootUsed, this.graphStatus, this.imageCopyTmpDir, this.imageStore, this.runRoot, this.transientStore, this.volumePath);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StoreInfo {\n");
        sb.append("    configFile: ").append(this.toIndentedString(this.configFile)).append("\n");
        sb.append("    containerStore: ").append(this.toIndentedString(this.containerStore)).append("\n");
        sb.append("    graphDriverName: ").append(this.toIndentedString(this.graphDriverName)).append("\n");
        sb.append("    graphOptions: ").append(this.toIndentedString(this.graphOptions)).append("\n");
        sb.append("    graphRoot: ").append(this.toIndentedString(this.graphRoot)).append("\n");
        sb.append("    graphRootAllocated: ").append(this.toIndentedString(this.graphRootAllocated)).append("\n");
        sb.append("    graphRootUsed: ").append(this.toIndentedString(this.graphRootUsed)).append("\n");
        sb.append("    graphStatus: ").append(this.toIndentedString(this.graphStatus)).append("\n");
        sb.append("    imageCopyTmpDir: ").append(this.toIndentedString(this.imageCopyTmpDir)).append("\n");
        sb.append("    imageStore: ").append(this.toIndentedString(this.imageStore)).append("\n");
        sb.append("    runRoot: ").append(this.toIndentedString(this.runRoot)).append("\n");
        sb.append("    transientStore: ").append(this.toIndentedString(this.transientStore)).append("\n");
        sb.append("    volumePath: ").append(this.toIndentedString(this.volumePath)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in StoreInfo is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `StoreInfo` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONFIG_FILE) != null && !jsonObj.get(SERIALIZED_NAME_CONFIG_FILE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CONFIG_FILE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `configFile` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONFIG_FILE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONTAINER_STORE) != null && !jsonObj.get(SERIALIZED_NAME_CONTAINER_STORE).isJsonNull()) {
            ContainerStore.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_CONTAINER_STORE));
        }
        if (jsonObj.get(SERIALIZED_NAME_GRAPH_DRIVER_NAME) != null && !jsonObj.get(SERIALIZED_NAME_GRAPH_DRIVER_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_GRAPH_DRIVER_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `graphDriverName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_GRAPH_DRIVER_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_GRAPH_ROOT) != null && !jsonObj.get(SERIALIZED_NAME_GRAPH_ROOT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_GRAPH_ROOT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `graphRoot` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_GRAPH_ROOT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_IMAGE_COPY_TMP_DIR) != null && !jsonObj.get(SERIALIZED_NAME_IMAGE_COPY_TMP_DIR).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_IMAGE_COPY_TMP_DIR).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `imageCopyTmpDir` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IMAGE_COPY_TMP_DIR).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_IMAGE_STORE) != null && !jsonObj.get(SERIALIZED_NAME_IMAGE_STORE).isJsonNull()) {
            ImageStore.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_IMAGE_STORE));
        }
        if (jsonObj.get(SERIALIZED_NAME_RUN_ROOT) != null && !jsonObj.get(SERIALIZED_NAME_RUN_ROOT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_RUN_ROOT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `runRoot` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RUN_ROOT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_VOLUME_PATH) != null && !jsonObj.get(SERIALIZED_NAME_VOLUME_PATH).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_VOLUME_PATH).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `volumePath` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VOLUME_PATH).toString()));
        }
    }

    public static StoreInfo fromJson(String jsonString) throws IOException {
        return (StoreInfo)JSON.getGson().fromJson(jsonString, StoreInfo.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CONFIG_FILE);
        openapiFields.add(SERIALIZED_NAME_CONTAINER_STORE);
        openapiFields.add(SERIALIZED_NAME_GRAPH_DRIVER_NAME);
        openapiFields.add(SERIALIZED_NAME_GRAPH_OPTIONS);
        openapiFields.add(SERIALIZED_NAME_GRAPH_ROOT);
        openapiFields.add(SERIALIZED_NAME_GRAPH_ROOT_ALLOCATED);
        openapiFields.add(SERIALIZED_NAME_GRAPH_ROOT_USED);
        openapiFields.add(SERIALIZED_NAME_GRAPH_STATUS);
        openapiFields.add(SERIALIZED_NAME_IMAGE_COPY_TMP_DIR);
        openapiFields.add(SERIALIZED_NAME_IMAGE_STORE);
        openapiFields.add(SERIALIZED_NAME_RUN_ROOT);
        openapiFields.add(SERIALIZED_NAME_TRANSIENT_STORE);
        openapiFields.add(SERIALIZED_NAME_VOLUME_PATH);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!StoreInfo.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(StoreInfo.class));
            return new TypeAdapter<StoreInfo>(){

                public void write(JsonWriter out, StoreInfo value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public StoreInfo read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    StoreInfo.validateJsonObject(jsonObj);
                    return (StoreInfo)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

