/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.validation.Valid;

public class TmpfsOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_MODE = "Mode";
    @SerializedName(value="Mode")
    private Integer mode;
    public static final String SERIALIZED_NAME_OPTIONS = "Options";
    @SerializedName(value="Options")
    private List<List<String>> options = null;
    public static final String SERIALIZED_NAME_SIZE_BYTES = "SizeBytes";
    @SerializedName(value="SizeBytes")
    private Long sizeBytes;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public TmpfsOptions mode(Integer mode) {
        this.mode = mode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The bits have the same definition on all systems, so that information about files can be moved from one system to another portably. Not all bits apply to all systems. The only required bit is [ModeDir] for directories.")
    public Integer getMode() {
        return this.mode;
    }

    public void setMode(Integer mode) {
        this.mode = mode;
    }

    public TmpfsOptions options(List<List<String>> options) {
        this.options = options;
        return this;
    }

    public TmpfsOptions addOptionsItem(List<String> optionsItem) {
        if (this.options == null) {
            this.options = new ArrayList<List<String>>();
        }
        this.options.add(optionsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Options to be passed to the tmpfs mount. An array of arrays. Flag options should be provided as 1-length arrays. Other types should be provided as 2-length arrays, where the first item is the key and the second the value.")
    public List<List<String>> getOptions() {
        return this.options;
    }

    public void setOptions(List<List<String>> options) {
        this.options = options;
    }

    public TmpfsOptions sizeBytes(Long sizeBytes) {
        this.sizeBytes = sizeBytes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Size sets the size of the tmpfs, in bytes.  This will be converted to an operating system specific value depending on the host. For example, on linux, it will be converted to use a 'k', 'm' or 'g' syntax. BSD, though not widely supported with docker, uses a straight byte value.  Percentages are not supported.")
    public Long getSizeBytes() {
        return this.sizeBytes;
    }

    public void setSizeBytes(Long sizeBytes) {
        this.sizeBytes = sizeBytes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TmpfsOptions tmpfsOptions = (TmpfsOptions)o;
        return Objects.equals(this.mode, tmpfsOptions.mode) && Objects.equals(this.options, tmpfsOptions.options) && Objects.equals(this.sizeBytes, tmpfsOptions.sizeBytes);
    }

    public int hashCode() {
        return Objects.hash(this.mode, this.options, this.sizeBytes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TmpfsOptions {\n");
        sb.append("    mode: ").append(this.toIndentedString(this.mode)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("    sizeBytes: ").append(this.toIndentedString(this.sizeBytes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in TmpfsOptions is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `TmpfsOptions` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_OPTIONS) != null && !jsonObj.get(SERIALIZED_NAME_OPTIONS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_OPTIONS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `Options` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OPTIONS).toString()));
        }
    }

    public static TmpfsOptions fromJson(String jsonString) throws IOException {
        return (TmpfsOptions)JSON.getGson().fromJson(jsonString, TmpfsOptions.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_MODE);
        openapiFields.add(SERIALIZED_NAME_OPTIONS);
        openapiFields.add(SERIALIZED_NAME_SIZE_BYTES);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!TmpfsOptions.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(TmpfsOptions.class));
            return new TypeAdapter<TmpfsOptions>(){

                public void write(JsonWriter out, TmpfsOptions value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public TmpfsOptions read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    TmpfsOptions.validateJsonObject(jsonObj);
                    return (TmpfsOptions)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

