/*
 * supports a RESTful API for the Libpod library
 * This documentation describes the Podman v2.x+ RESTful API. It consists of a Docker-compatible API and a Libpod API providing support for Podman’s unique features such as pods.  To start the service and keep it running for 5,000 seconds (-t 0 runs forever):  podman system service -t 5000 &  You can then use cURL on the socket using requests documented below.  NOTE: if you install the package podman-docker, it will create a symbolic link for /run/docker.sock to /run/podman/podman.sock  NOTE: Some fields in the API response JSON are encoded as omitempty, which means that if said field has a zero value, they will not be encoded in the API response. This is a feature to help reduce the size of the JSON responses returned via the API.  NOTE: Due to the limitations of [go-swagger](https://github.com/go-swagger/go-swagger), some field values that have a complex type show up as null in the docs as well as in the API responses. This is because the zero value for the field type is null. The field description in the docs will state what type the field is expected to be for such cases.  See podman-system-service(1) for more information.  Quick Examples:  'podman info'  curl --unix-socket /run/podman/podman.sock http://d/v5.0.0/libpod/info  'podman pull quay.io/containers/podman'  curl -XPOST --unix-socket /run/podman/podman.sock -v 'http://d/v5.0.0/images/create?fromImage=quay.io%2Fcontainers%2Fpodman'  'podman list images'  curl --unix-socket /run/podman/podman.sock -v 'http://d/v5.0.0/libpod/images/json' | jq
 *
 * The version of the OpenAPI document: 5.0.0
 * Contact: podman@lists.podman.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.github.pod4dev.libpodj.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.model.TypeMount;
import java.io.IOException;
import java.util.Arrays;
import java.io.Serializable;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import io.github.pod4dev.libpodj.JSON;

/**
 * AccessMode
 */
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.9.0")
public class AccessMode implements Serializable {
  private static final long serialVersionUID = 1L;

  public static final String SERIALIZED_NAME_BLOCK_VOLUME = "BlockVolume";
  @SerializedName(SERIALIZED_NAME_BLOCK_VOLUME)
  private Object blockVolume;

  public static final String SERIALIZED_NAME_MOUNT_VOLUME = "MountVolume";
  @SerializedName(SERIALIZED_NAME_MOUNT_VOLUME)
  private TypeMount mountVolume;

  public static final String SERIALIZED_NAME_SCOPE = "Scope";
  @SerializedName(SERIALIZED_NAME_SCOPE)
  private String scope;

  public static final String SERIALIZED_NAME_SHARING = "Sharing";
  @SerializedName(SERIALIZED_NAME_SHARING)
  private String sharing;

  public AccessMode() {
  }

  public AccessMode blockVolume(Object blockVolume) {
    this.blockVolume = blockVolume;
    return this;
  }

  /**
   * Intentionally empty.
   * @return blockVolume
   */
  @jakarta.annotation.Nullable

  public Object getBlockVolume() {
    return blockVolume;
  }

  public void setBlockVolume(Object blockVolume) {
    this.blockVolume = blockVolume;
  }


  public AccessMode mountVolume(TypeMount mountVolume) {
    this.mountVolume = mountVolume;
    return this;
  }

  /**
   * Get mountVolume
   * @return mountVolume
   */
  @jakarta.annotation.Nullable
  @Valid

  public TypeMount getMountVolume() {
    return mountVolume;
  }

  public void setMountVolume(TypeMount mountVolume) {
    this.mountVolume = mountVolume;
  }


  public AccessMode scope(String scope) {
    this.scope = scope;
    return this;
  }

  /**
   * Scope defines the Scope of a Cluster Volume. This is how many nodes a Volume can be accessed simultaneously on.
   * @return scope
   */
  @jakarta.annotation.Nullable

  public String getScope() {
    return scope;
  }

  public void setScope(String scope) {
    this.scope = scope;
  }


  public AccessMode sharing(String sharing) {
    this.sharing = sharing;
    return this;
  }

  /**
   * SharingMode defines the Sharing of a Cluster Volume. This is how Tasks using a Volume at the same time can use it.
   * @return sharing
   */
  @jakarta.annotation.Nullable

  public String getSharing() {
    return sharing;
  }

  public void setSharing(String sharing) {
    this.sharing = sharing;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AccessMode accessMode = (AccessMode) o;
    return Objects.equals(this.blockVolume, accessMode.blockVolume) &&
        Objects.equals(this.mountVolume, accessMode.mountVolume) &&
        Objects.equals(this.scope, accessMode.scope) &&
        Objects.equals(this.sharing, accessMode.sharing);
  }

  @Override
  public int hashCode() {
    return Objects.hash(blockVolume, mountVolume, scope, sharing);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AccessMode {\n");
    sb.append("    blockVolume: ").append(toIndentedString(blockVolume)).append("\n");
    sb.append("    mountVolume: ").append(toIndentedString(mountVolume)).append("\n");
    sb.append("    scope: ").append(toIndentedString(scope)).append("\n");
    sb.append("    sharing: ").append(toIndentedString(sharing)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("BlockVolume");
    openapiFields.add("MountVolume");
    openapiFields.add("Scope");
    openapiFields.add("Sharing");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

  /**
   * Validates the JSON Element and throws an exception if issues found
   *
   * @param jsonElement JSON Element
   * @throws IOException if the JSON Element is invalid with respect to AccessMode
   */
  public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (jsonElement == null) {
        if (!AccessMode.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in AccessMode is not found in the empty JSON string", AccessMode.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!AccessMode.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `AccessMode` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      // validate the optional field `MountVolume`
      if (jsonObj.get("MountVolume") != null && !jsonObj.get("MountVolume").isJsonNull()) {
        TypeMount.validateJsonElement(jsonObj.get("MountVolume"));
      }
      if ((jsonObj.get("Scope") != null && !jsonObj.get("Scope").isJsonNull()) && !jsonObj.get("Scope").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `Scope` to be a primitive type in the JSON string but got `%s`", jsonObj.get("Scope").toString()));
      }
      if ((jsonObj.get("Sharing") != null && !jsonObj.get("Sharing").isJsonNull()) && !jsonObj.get("Sharing").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `Sharing` to be a primitive type in the JSON string but got `%s`", jsonObj.get("Sharing").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!AccessMode.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'AccessMode' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<AccessMode> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(AccessMode.class));

       return (TypeAdapter<T>) new TypeAdapter<AccessMode>() {
           @Override
           public void write(JsonWriter out, AccessMode value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public AccessMode read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

  /**
   * Create an instance of AccessMode given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of AccessMode
   * @throws IOException if the JSON string is invalid with respect to AccessMode
   */
  public static AccessMode fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, AccessMode.class);
  }

  /**
   * Convert an instance of AccessMode to an JSON string
   *
   * @return JSON string
   */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

