/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.api;

import com.google.gson.reflect.TypeToken;
import io.github.pod4dev.libpodj.ApiCallback;
import io.github.pod4dev.libpodj.ApiClient;
import io.github.pod4dev.libpodj.ApiException;
import io.github.pod4dev.libpodj.ApiResponse;
import io.github.pod4dev.libpodj.Configuration;
import io.github.pod4dev.libpodj.Pair;
import io.github.pod4dev.libpodj.model.HistoryResponse;
import io.github.pod4dev.libpodj.model.ImageBuild200Response;
import io.github.pod4dev.libpodj.model.ImageDelete200ResponseInner;
import io.github.pod4dev.libpodj.model.ImageInspect;
import io.github.pod4dev.libpodj.model.ImageSearch200Response;
import io.github.pod4dev.libpodj.model.Summary;
import jakarta.validation.constraints.NotNull;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class ImagesCompatApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ImagesCompatApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ImagesCompatApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call imageBuildCall(String contentType, String xRegistryConfig, String dockerfile, String t, String extrahosts, Boolean nohosts, String remote, Integer retry, String retryDelay, Boolean q, Boolean compatvolumes, Boolean nocache, String cachefrom, Boolean pull, Boolean rm, Boolean forcerm, Integer memory, Integer memswap, Integer cpushares, String cpusetcpus, Integer cpuperiod, Integer cpuquota, String buildargs, Integer shmsize, Boolean squash, String labels, String networkmode, String platform, String target, String outputs, File inputStream, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        File localVarPostBody = inputStream;
        String localVarPath = "/build";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (dockerfile != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dockerfile", dockerfile));
        }
        if (t != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("t", t));
        }
        if (extrahosts != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("extrahosts", extrahosts));
        }
        if (nohosts != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("nohosts", nohosts));
        }
        if (remote != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("remote", remote));
        }
        if (retry != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("retry", retry));
        }
        if (retryDelay != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("retry-delay", retryDelay));
        }
        if (q != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("q", q));
        }
        if (compatvolumes != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("compatvolumes", compatvolumes));
        }
        if (nocache != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("nocache", nocache));
        }
        if (cachefrom != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("cachefrom", cachefrom));
        }
        if (pull != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pull", pull));
        }
        if (rm != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("rm", rm));
        }
        if (forcerm != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("forcerm", forcerm));
        }
        if (memory != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("memory", memory));
        }
        if (memswap != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("memswap", memswap));
        }
        if (cpushares != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("cpushares", cpushares));
        }
        if (cpusetcpus != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("cpusetcpus", cpusetcpus));
        }
        if (cpuperiod != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("cpuperiod", cpuperiod));
        }
        if (cpuquota != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("cpuquota", cpuquota));
        }
        if (buildargs != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("buildargs", buildargs));
        }
        if (shmsize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("shmsize", shmsize));
        }
        if (squash != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("squash", squash));
        }
        if (labels != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labels", labels));
        }
        if (networkmode != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("networkmode", networkmode));
        }
        if (platform != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("platform", platform));
        }
        if (target != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("target", target));
        }
        if (outputs != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("outputs", outputs));
        }
        if (contentType != null) {
            localVarHeaderParams.put("Content-Type", this.localVarApiClient.parameterToString(contentType));
        }
        if (xRegistryConfig != null) {
            localVarHeaderParams.put("X-Registry-Config", this.localVarApiClient.parameterToString(xRegistryConfig));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/x-tar"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call imageBuildValidateBeforeCall(String contentType, String xRegistryConfig, String dockerfile, String t, String extrahosts, Boolean nohosts, String remote, Integer retry, String retryDelay, Boolean q, Boolean compatvolumes, Boolean nocache, String cachefrom, Boolean pull, Boolean rm, Boolean forcerm, Integer memory, Integer memswap, Integer cpushares, String cpusetcpus, Integer cpuperiod, Integer cpuquota, String buildargs, Integer shmsize, Boolean squash, String labels, String networkmode, String platform, String target, String outputs, File inputStream, ApiCallback _callback) throws ApiException {
        return this.imageBuildCall(contentType, xRegistryConfig, dockerfile, t, extrahosts, nohosts, remote, retry, retryDelay, q, compatvolumes, nocache, cachefrom, pull, rm, forcerm, memory, memswap, cpushares, cpusetcpus, cpuperiod, cpuquota, buildargs, shmsize, squash, labels, networkmode, platform, target, outputs, inputStream, _callback);
    }

    private ApiResponse<ImageBuild200Response> imageBuildWithHttpInfo(String contentType, String xRegistryConfig, String dockerfile, String t, String extrahosts, Boolean nohosts, String remote, Integer retry, String retryDelay, Boolean q, Boolean compatvolumes, Boolean nocache, String cachefrom, Boolean pull, Boolean rm, Boolean forcerm, Integer memory, Integer memswap, Integer cpushares, String cpusetcpus, Integer cpuperiod, Integer cpuquota, String buildargs, Integer shmsize, Boolean squash, String labels, String networkmode, String platform, String target, String outputs, File inputStream) throws ApiException {
        Call localVarCall = this.imageBuildValidateBeforeCall(contentType, xRegistryConfig, dockerfile, t, extrahosts, nohosts, remote, retry, retryDelay, q, compatvolumes, nocache, cachefrom, pull, rm, forcerm, memory, memswap, cpushares, cpusetcpus, cpuperiod, cpuquota, buildargs, shmsize, squash, labels, networkmode, platform, target, outputs, inputStream, null);
        Type localVarReturnType = new TypeToken<ImageBuild200Response>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call imageBuildAsync(String contentType, String xRegistryConfig, String dockerfile, String t, String extrahosts, Boolean nohosts, String remote, Integer retry, String retryDelay, Boolean q, Boolean compatvolumes, Boolean nocache, String cachefrom, Boolean pull, Boolean rm, Boolean forcerm, Integer memory, Integer memswap, Integer cpushares, String cpusetcpus, Integer cpuperiod, Integer cpuquota, String buildargs, Integer shmsize, Boolean squash, String labels, String networkmode, String platform, String target, String outputs, File inputStream, ApiCallback<ImageBuild200Response> _callback) throws ApiException {
        Call localVarCall = this.imageBuildValidateBeforeCall(contentType, xRegistryConfig, dockerfile, t, extrahosts, nohosts, remote, retry, retryDelay, q, compatvolumes, nocache, cachefrom, pull, rm, forcerm, memory, memswap, cpushares, cpusetcpus, cpuperiod, cpuquota, buildargs, shmsize, squash, labels, networkmode, platform, target, outputs, inputStream, _callback);
        Type localVarReturnType = new TypeToken<ImageBuild200Response>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIimageBuildRequest imageBuild() {
        return new APIimageBuildRequest();
    }

    private Call imageCreateCall(String xRegistryAuth, String fromImage, String fromSrc, String repo, String tag, String message, String platform, File inputImage, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        File localVarPostBody = inputImage;
        String localVarPath = "/images/create";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fromImage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fromImage", fromImage));
        }
        if (fromSrc != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fromSrc", fromSrc));
        }
        if (repo != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("repo", repo));
        }
        if (tag != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("tag", tag));
        }
        if (message != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("message", message));
        }
        if (platform != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("platform", platform));
        }
        if (xRegistryAuth != null) {
            localVarHeaderParams.put("X-Registry-Auth", this.localVarApiClient.parameterToString(xRegistryAuth));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"text/plain", "application/octet-stream"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call imageCreateValidateBeforeCall(String xRegistryAuth, String fromImage, String fromSrc, String repo, String tag, String message, String platform, File inputImage, ApiCallback _callback) throws ApiException {
        return this.imageCreateCall(xRegistryAuth, fromImage, fromSrc, repo, tag, message, platform, inputImage, _callback);
    }

    private ApiResponse<File> imageCreateWithHttpInfo(String xRegistryAuth, String fromImage, String fromSrc, String repo, String tag, String message, String platform, File inputImage) throws ApiException {
        Call localVarCall = this.imageCreateValidateBeforeCall(xRegistryAuth, fromImage, fromSrc, repo, tag, message, platform, inputImage, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call imageCreateAsync(String xRegistryAuth, String fromImage, String fromSrc, String repo, String tag, String message, String platform, File inputImage, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.imageCreateValidateBeforeCall(xRegistryAuth, fromImage, fromSrc, repo, tag, message, platform, inputImage, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIimageCreateRequest imageCreate() {
        return new APIimageCreateRequest();
    }

    private Call imageDeleteCall(String name, Boolean force, Boolean noprune, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/images/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        if (noprune != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("noprune", noprune));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call imageDeleteValidateBeforeCall(String name, Boolean force, Boolean noprune, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling imageDelete(Async)");
        }
        return this.imageDeleteCall(name, force, noprune, _callback);
    }

    private ApiResponse<List<ImageDelete200ResponseInner>> imageDeleteWithHttpInfo(@NotNull String name, Boolean force, Boolean noprune) throws ApiException {
        Call localVarCall = this.imageDeleteValidateBeforeCall(name, force, noprune, null);
        Type localVarReturnType = new TypeToken<List<ImageDelete200ResponseInner>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call imageDeleteAsync(String name, Boolean force, Boolean noprune, ApiCallback<List<ImageDelete200ResponseInner>> _callback) throws ApiException {
        Call localVarCall = this.imageDeleteValidateBeforeCall(name, force, noprune, _callback);
        Type localVarReturnType = new TypeToken<List<ImageDelete200ResponseInner>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIimageDeleteRequest imageDelete(String name) {
        return new APIimageDeleteRequest(name);
    }

    private Call imageGetCall(String name, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/images/{name}/get".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/x-tar"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call imageGetValidateBeforeCall(String name, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling imageGet(Async)");
        }
        return this.imageGetCall(name, _callback);
    }

    private ApiResponse<File> imageGetWithHttpInfo(@NotNull String name) throws ApiException {
        Call localVarCall = this.imageGetValidateBeforeCall(name, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call imageGetAsync(String name, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.imageGetValidateBeforeCall(name, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIimageGetRequest imageGet(String name) {
        return new APIimageGetRequest(name);
    }

    private Call imageGetAllCall(String names, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/images/get";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (names != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("names", names));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call imageGetAllValidateBeforeCall(String names, ApiCallback _callback) throws ApiException {
        if (names == null) {
            throw new ApiException("Missing the required parameter 'names' when calling imageGetAll(Async)");
        }
        return this.imageGetAllCall(names, _callback);
    }

    private ApiResponse<File> imageGetAllWithHttpInfo(@NotNull String names) throws ApiException {
        Call localVarCall = this.imageGetAllValidateBeforeCall(names, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call imageGetAllAsync(String names, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.imageGetAllValidateBeforeCall(names, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIimageGetAllRequest imageGetAll(String names) {
        return new APIimageGetAllRequest(names);
    }

    private Call imageHistoryCall(String name, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/images/{name}/history".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call imageHistoryValidateBeforeCall(String name, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling imageHistory(Async)");
        }
        return this.imageHistoryCall(name, _callback);
    }

    private ApiResponse<HistoryResponse> imageHistoryWithHttpInfo(@NotNull String name) throws ApiException {
        Call localVarCall = this.imageHistoryValidateBeforeCall(name, null);
        Type localVarReturnType = new TypeToken<HistoryResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call imageHistoryAsync(String name, ApiCallback<HistoryResponse> _callback) throws ApiException {
        Call localVarCall = this.imageHistoryValidateBeforeCall(name, _callback);
        Type localVarReturnType = new TypeToken<HistoryResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIimageHistoryRequest imageHistory(String name) {
        return new APIimageHistoryRequest(name);
    }

    private Call imageInspectCall(String name, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/images/{name}/json".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call imageInspectValidateBeforeCall(String name, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling imageInspect(Async)");
        }
        return this.imageInspectCall(name, _callback);
    }

    private ApiResponse<ImageInspect> imageInspectWithHttpInfo(@NotNull String name) throws ApiException {
        Call localVarCall = this.imageInspectValidateBeforeCall(name, null);
        Type localVarReturnType = new TypeToken<ImageInspect>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call imageInspectAsync(String name, ApiCallback<ImageInspect> _callback) throws ApiException {
        Call localVarCall = this.imageInspectValidateBeforeCall(name, _callback);
        Type localVarReturnType = new TypeToken<ImageInspect>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIimageInspectRequest imageInspect(String name) {
        return new APIimageInspectRequest(name);
    }

    private Call imageListCall(Boolean all, String filters, Boolean digests, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/images/json";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (all != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("all", all));
        }
        if (filters != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filters", filters));
        }
        if (digests != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("digests", digests));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call imageListValidateBeforeCall(Boolean all, String filters, Boolean digests, ApiCallback _callback) throws ApiException {
        return this.imageListCall(all, filters, digests, _callback);
    }

    private ApiResponse<List<Summary>> imageListWithHttpInfo(Boolean all, String filters, Boolean digests) throws ApiException {
        Call localVarCall = this.imageListValidateBeforeCall(all, filters, digests, null);
        Type localVarReturnType = new TypeToken<List<Summary>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call imageListAsync(Boolean all, String filters, Boolean digests, ApiCallback<List<Summary>> _callback) throws ApiException {
        Call localVarCall = this.imageListValidateBeforeCall(all, filters, digests, _callback);
        Type localVarReturnType = new TypeToken<List<Summary>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIimageListRequest imageList() {
        return new APIimageListRequest();
    }

    private Call imageLoadCall(Boolean quiet, String request, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        String localVarPostBody = request;
        String localVarPath = "/images/load";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (quiet != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("quiet", quiet));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/x-tar"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call imageLoadValidateBeforeCall(Boolean quiet, String request, ApiCallback _callback) throws ApiException {
        return this.imageLoadCall(quiet, request, _callback);
    }

    private ApiResponse<Void> imageLoadWithHttpInfo(Boolean quiet, String request) throws ApiException {
        Call localVarCall = this.imageLoadValidateBeforeCall(quiet, request, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call imageLoadAsync(Boolean quiet, String request, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.imageLoadValidateBeforeCall(quiet, request, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIimageLoadRequest imageLoad() {
        return new APIimageLoadRequest();
    }

    private Call imagePruneCall(String filters, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/images/prune";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (filters != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filters", filters));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call imagePruneValidateBeforeCall(String filters, ApiCallback _callback) throws ApiException {
        return this.imagePruneCall(filters, _callback);
    }

    private ApiResponse<List<ImageDelete200ResponseInner>> imagePruneWithHttpInfo(String filters) throws ApiException {
        Call localVarCall = this.imagePruneValidateBeforeCall(filters, null);
        Type localVarReturnType = new TypeToken<List<ImageDelete200ResponseInner>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call imagePruneAsync(String filters, ApiCallback<List<ImageDelete200ResponseInner>> _callback) throws ApiException {
        Call localVarCall = this.imagePruneValidateBeforeCall(filters, _callback);
        Type localVarReturnType = new TypeToken<List<ImageDelete200ResponseInner>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIimagePruneRequest imagePrune() {
        return new APIimagePruneRequest();
    }

    private Call imagePushCall(String name, String tag, Boolean all, Boolean compress, String destination, String format, Boolean tlsVerify, String xRegistryAuth, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/images/{name}/push".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (tag != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("tag", tag));
        }
        if (all != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("all", all));
        }
        if (compress != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("compress", compress));
        }
        if (destination != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("destination", destination));
        }
        if (format != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("format", format));
        }
        if (tlsVerify != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("tlsVerify", tlsVerify));
        }
        if (xRegistryAuth != null) {
            localVarHeaderParams.put("X-Registry-Auth", this.localVarApiClient.parameterToString(xRegistryAuth));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call imagePushValidateBeforeCall(String name, String tag, Boolean all, Boolean compress, String destination, String format, Boolean tlsVerify, String xRegistryAuth, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling imagePush(Async)");
        }
        return this.imagePushCall(name, tag, all, compress, destination, format, tlsVerify, xRegistryAuth, _callback);
    }

    private ApiResponse<File> imagePushWithHttpInfo(@NotNull String name, String tag, Boolean all, Boolean compress, String destination, String format, Boolean tlsVerify, String xRegistryAuth) throws ApiException {
        Call localVarCall = this.imagePushValidateBeforeCall(name, tag, all, compress, destination, format, tlsVerify, xRegistryAuth, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call imagePushAsync(String name, String tag, Boolean all, Boolean compress, String destination, String format, Boolean tlsVerify, String xRegistryAuth, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.imagePushValidateBeforeCall(name, tag, all, compress, destination, format, tlsVerify, xRegistryAuth, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIimagePushRequest imagePush(String name) {
        return new APIimagePushRequest(name);
    }

    private Call imageSearchCall(String term, Integer limit, String filters, Boolean tlsVerify, Boolean listTags, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/images/search";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (term != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("term", term));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (filters != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filters", filters));
        }
        if (tlsVerify != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("tlsVerify", tlsVerify));
        }
        if (listTags != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("listTags", listTags));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call imageSearchValidateBeforeCall(String term, Integer limit, String filters, Boolean tlsVerify, Boolean listTags, ApiCallback _callback) throws ApiException {
        return this.imageSearchCall(term, limit, filters, tlsVerify, listTags, _callback);
    }

    private ApiResponse<ImageSearch200Response> imageSearchWithHttpInfo(String term, Integer limit, String filters, Boolean tlsVerify, Boolean listTags) throws ApiException {
        Call localVarCall = this.imageSearchValidateBeforeCall(term, limit, filters, tlsVerify, listTags, null);
        Type localVarReturnType = new TypeToken<ImageSearch200Response>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call imageSearchAsync(String term, Integer limit, String filters, Boolean tlsVerify, Boolean listTags, ApiCallback<ImageSearch200Response> _callback) throws ApiException {
        Call localVarCall = this.imageSearchValidateBeforeCall(term, limit, filters, tlsVerify, listTags, _callback);
        Type localVarReturnType = new TypeToken<ImageSearch200Response>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIimageSearchRequest imageSearch() {
        return new APIimageSearchRequest();
    }

    private Call imageTagCall(String name, String repo, String tag, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/images/{name}/tag".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (repo != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("repo", repo));
        }
        if (tag != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("tag", tag));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call imageTagValidateBeforeCall(String name, String repo, String tag, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling imageTag(Async)");
        }
        return this.imageTagCall(name, repo, tag, _callback);
    }

    private ApiResponse<Void> imageTagWithHttpInfo(@NotNull String name, String repo, String tag) throws ApiException {
        Call localVarCall = this.imageTagValidateBeforeCall(name, repo, tag, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call imageTagAsync(String name, String repo, String tag, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.imageTagValidateBeforeCall(name, repo, tag, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIimageTagRequest imageTag(String name) {
        return new APIimageTagRequest(name);
    }

    public class APIimageBuildRequest {
        private String contentType;
        private String xRegistryConfig;
        private String dockerfile;
        private String t;
        private String extrahosts;
        private Boolean nohosts;
        private String remote;
        private Integer retry;
        private String retryDelay;
        private Boolean q;
        private Boolean compatvolumes;
        private Boolean nocache;
        private String cachefrom;
        private Boolean pull;
        private Boolean rm;
        private Boolean forcerm;
        private Integer memory;
        private Integer memswap;
        private Integer cpushares;
        private String cpusetcpus;
        private Integer cpuperiod;
        private Integer cpuquota;
        private String buildargs;
        private Integer shmsize;
        private Boolean squash;
        private String labels;
        private String networkmode;
        private String platform;
        private String target;
        private String outputs;
        private File inputStream;

        private APIimageBuildRequest() {
        }

        public APIimageBuildRequest contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public APIimageBuildRequest xRegistryConfig(String xRegistryConfig) {
            this.xRegistryConfig = xRegistryConfig;
            return this;
        }

        public APIimageBuildRequest dockerfile(String dockerfile) {
            this.dockerfile = dockerfile;
            return this;
        }

        public APIimageBuildRequest t(String t) {
            this.t = t;
            return this;
        }

        public APIimageBuildRequest extrahosts(String extrahosts) {
            this.extrahosts = extrahosts;
            return this;
        }

        public APIimageBuildRequest nohosts(Boolean nohosts) {
            this.nohosts = nohosts;
            return this;
        }

        public APIimageBuildRequest remote(String remote) {
            this.remote = remote;
            return this;
        }

        public APIimageBuildRequest retry(Integer retry) {
            this.retry = retry;
            return this;
        }

        public APIimageBuildRequest retryDelay(String retryDelay) {
            this.retryDelay = retryDelay;
            return this;
        }

        public APIimageBuildRequest q(Boolean q) {
            this.q = q;
            return this;
        }

        public APIimageBuildRequest compatvolumes(Boolean compatvolumes) {
            this.compatvolumes = compatvolumes;
            return this;
        }

        public APIimageBuildRequest nocache(Boolean nocache) {
            this.nocache = nocache;
            return this;
        }

        public APIimageBuildRequest cachefrom(String cachefrom) {
            this.cachefrom = cachefrom;
            return this;
        }

        public APIimageBuildRequest pull(Boolean pull) {
            this.pull = pull;
            return this;
        }

        public APIimageBuildRequest rm(Boolean rm) {
            this.rm = rm;
            return this;
        }

        public APIimageBuildRequest forcerm(Boolean forcerm) {
            this.forcerm = forcerm;
            return this;
        }

        public APIimageBuildRequest memory(Integer memory) {
            this.memory = memory;
            return this;
        }

        public APIimageBuildRequest memswap(Integer memswap) {
            this.memswap = memswap;
            return this;
        }

        public APIimageBuildRequest cpushares(Integer cpushares) {
            this.cpushares = cpushares;
            return this;
        }

        public APIimageBuildRequest cpusetcpus(String cpusetcpus) {
            this.cpusetcpus = cpusetcpus;
            return this;
        }

        public APIimageBuildRequest cpuperiod(Integer cpuperiod) {
            this.cpuperiod = cpuperiod;
            return this;
        }

        public APIimageBuildRequest cpuquota(Integer cpuquota) {
            this.cpuquota = cpuquota;
            return this;
        }

        public APIimageBuildRequest buildargs(String buildargs) {
            this.buildargs = buildargs;
            return this;
        }

        public APIimageBuildRequest shmsize(Integer shmsize) {
            this.shmsize = shmsize;
            return this;
        }

        public APIimageBuildRequest squash(Boolean squash) {
            this.squash = squash;
            return this;
        }

        public APIimageBuildRequest labels(String labels) {
            this.labels = labels;
            return this;
        }

        public APIimageBuildRequest networkmode(String networkmode) {
            this.networkmode = networkmode;
            return this;
        }

        public APIimageBuildRequest platform(String platform) {
            this.platform = platform;
            return this;
        }

        public APIimageBuildRequest target(String target) {
            this.target = target;
            return this;
        }

        public APIimageBuildRequest outputs(String outputs) {
            this.outputs = outputs;
            return this;
        }

        public APIimageBuildRequest inputStream(File inputStream) {
            this.inputStream = inputStream;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ImagesCompatApi.this.imageBuildCall(this.contentType, this.xRegistryConfig, this.dockerfile, this.t, this.extrahosts, this.nohosts, this.remote, this.retry, this.retryDelay, this.q, this.compatvolumes, this.nocache, this.cachefrom, this.pull, this.rm, this.forcerm, this.memory, this.memswap, this.cpushares, this.cpusetcpus, this.cpuperiod, this.cpuquota, this.buildargs, this.shmsize, this.squash, this.labels, this.networkmode, this.platform, this.target, this.outputs, this.inputStream, _callback);
        }

        public ImageBuild200Response execute() throws ApiException {
            ApiResponse<ImageBuild200Response> localVarResp = ImagesCompatApi.this.imageBuildWithHttpInfo(this.contentType, this.xRegistryConfig, this.dockerfile, this.t, this.extrahosts, this.nohosts, this.remote, this.retry, this.retryDelay, this.q, this.compatvolumes, this.nocache, this.cachefrom, this.pull, this.rm, this.forcerm, this.memory, this.memswap, this.cpushares, this.cpusetcpus, this.cpuperiod, this.cpuquota, this.buildargs, this.shmsize, this.squash, this.labels, this.networkmode, this.platform, this.target, this.outputs, this.inputStream);
            return localVarResp.getData();
        }

        public ApiResponse<ImageBuild200Response> executeWithHttpInfo() throws ApiException {
            return ImagesCompatApi.this.imageBuildWithHttpInfo(this.contentType, this.xRegistryConfig, this.dockerfile, this.t, this.extrahosts, this.nohosts, this.remote, this.retry, this.retryDelay, this.q, this.compatvolumes, this.nocache, this.cachefrom, this.pull, this.rm, this.forcerm, this.memory, this.memswap, this.cpushares, this.cpusetcpus, this.cpuperiod, this.cpuquota, this.buildargs, this.shmsize, this.squash, this.labels, this.networkmode, this.platform, this.target, this.outputs, this.inputStream);
        }

        public Call executeAsync(ApiCallback<ImageBuild200Response> _callback) throws ApiException {
            return ImagesCompatApi.this.imageBuildAsync(this.contentType, this.xRegistryConfig, this.dockerfile, this.t, this.extrahosts, this.nohosts, this.remote, this.retry, this.retryDelay, this.q, this.compatvolumes, this.nocache, this.cachefrom, this.pull, this.rm, this.forcerm, this.memory, this.memswap, this.cpushares, this.cpusetcpus, this.cpuperiod, this.cpuquota, this.buildargs, this.shmsize, this.squash, this.labels, this.networkmode, this.platform, this.target, this.outputs, this.inputStream, _callback);
        }
    }

    public class APIimageCreateRequest {
        private String xRegistryAuth;
        private String fromImage;
        private String fromSrc;
        private String repo;
        private String tag;
        private String message;
        private String platform;
        private File inputImage;

        private APIimageCreateRequest() {
        }

        public APIimageCreateRequest xRegistryAuth(String xRegistryAuth) {
            this.xRegistryAuth = xRegistryAuth;
            return this;
        }

        public APIimageCreateRequest fromImage(String fromImage) {
            this.fromImage = fromImage;
            return this;
        }

        public APIimageCreateRequest fromSrc(String fromSrc) {
            this.fromSrc = fromSrc;
            return this;
        }

        public APIimageCreateRequest repo(String repo) {
            this.repo = repo;
            return this;
        }

        public APIimageCreateRequest tag(String tag) {
            this.tag = tag;
            return this;
        }

        public APIimageCreateRequest message(String message) {
            this.message = message;
            return this;
        }

        public APIimageCreateRequest platform(String platform) {
            this.platform = platform;
            return this;
        }

        public APIimageCreateRequest inputImage(File inputImage) {
            this.inputImage = inputImage;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ImagesCompatApi.this.imageCreateCall(this.xRegistryAuth, this.fromImage, this.fromSrc, this.repo, this.tag, this.message, this.platform, this.inputImage, _callback);
        }

        public File execute() throws ApiException {
            ApiResponse<File> localVarResp = ImagesCompatApi.this.imageCreateWithHttpInfo(this.xRegistryAuth, this.fromImage, this.fromSrc, this.repo, this.tag, this.message, this.platform, this.inputImage);
            return localVarResp.getData();
        }

        public ApiResponse<File> executeWithHttpInfo() throws ApiException {
            return ImagesCompatApi.this.imageCreateWithHttpInfo(this.xRegistryAuth, this.fromImage, this.fromSrc, this.repo, this.tag, this.message, this.platform, this.inputImage);
        }

        public Call executeAsync(ApiCallback<File> _callback) throws ApiException {
            return ImagesCompatApi.this.imageCreateAsync(this.xRegistryAuth, this.fromImage, this.fromSrc, this.repo, this.tag, this.message, this.platform, this.inputImage, _callback);
        }
    }

    public class APIimageDeleteRequest {
        private final String name;
        private Boolean force;
        private Boolean noprune;

        private APIimageDeleteRequest(String name) {
            this.name = name;
        }

        public APIimageDeleteRequest force(Boolean force) {
            this.force = force;
            return this;
        }

        public APIimageDeleteRequest noprune(Boolean noprune) {
            this.noprune = noprune;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ImagesCompatApi.this.imageDeleteCall(this.name, this.force, this.noprune, _callback);
        }

        public List<ImageDelete200ResponseInner> execute() throws ApiException {
            ApiResponse<List<ImageDelete200ResponseInner>> localVarResp = ImagesCompatApi.this.imageDeleteWithHttpInfo(this.name, this.force, this.noprune);
            return localVarResp.getData();
        }

        public ApiResponse<List<ImageDelete200ResponseInner>> executeWithHttpInfo() throws ApiException {
            return ImagesCompatApi.this.imageDeleteWithHttpInfo(this.name, this.force, this.noprune);
        }

        public Call executeAsync(ApiCallback<List<ImageDelete200ResponseInner>> _callback) throws ApiException {
            return ImagesCompatApi.this.imageDeleteAsync(this.name, this.force, this.noprune, _callback);
        }
    }

    public class APIimageGetRequest {
        private final String name;

        private APIimageGetRequest(String name) {
            this.name = name;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ImagesCompatApi.this.imageGetCall(this.name, _callback);
        }

        public File execute() throws ApiException {
            ApiResponse<File> localVarResp = ImagesCompatApi.this.imageGetWithHttpInfo(this.name);
            return localVarResp.getData();
        }

        public ApiResponse<File> executeWithHttpInfo() throws ApiException {
            return ImagesCompatApi.this.imageGetWithHttpInfo(this.name);
        }

        public Call executeAsync(ApiCallback<File> _callback) throws ApiException {
            return ImagesCompatApi.this.imageGetAsync(this.name, _callback);
        }
    }

    public class APIimageGetAllRequest {
        private final String names;

        private APIimageGetAllRequest(String names) {
            this.names = names;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ImagesCompatApi.this.imageGetAllCall(this.names, _callback);
        }

        public File execute() throws ApiException {
            ApiResponse<File> localVarResp = ImagesCompatApi.this.imageGetAllWithHttpInfo(this.names);
            return localVarResp.getData();
        }

        public ApiResponse<File> executeWithHttpInfo() throws ApiException {
            return ImagesCompatApi.this.imageGetAllWithHttpInfo(this.names);
        }

        public Call executeAsync(ApiCallback<File> _callback) throws ApiException {
            return ImagesCompatApi.this.imageGetAllAsync(this.names, _callback);
        }
    }

    public class APIimageHistoryRequest {
        private final String name;

        private APIimageHistoryRequest(String name) {
            this.name = name;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ImagesCompatApi.this.imageHistoryCall(this.name, _callback);
        }

        public HistoryResponse execute() throws ApiException {
            ApiResponse<HistoryResponse> localVarResp = ImagesCompatApi.this.imageHistoryWithHttpInfo(this.name);
            return localVarResp.getData();
        }

        public ApiResponse<HistoryResponse> executeWithHttpInfo() throws ApiException {
            return ImagesCompatApi.this.imageHistoryWithHttpInfo(this.name);
        }

        public Call executeAsync(ApiCallback<HistoryResponse> _callback) throws ApiException {
            return ImagesCompatApi.this.imageHistoryAsync(this.name, _callback);
        }
    }

    public class APIimageInspectRequest {
        private final String name;

        private APIimageInspectRequest(String name) {
            this.name = name;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ImagesCompatApi.this.imageInspectCall(this.name, _callback);
        }

        public ImageInspect execute() throws ApiException {
            ApiResponse<ImageInspect> localVarResp = ImagesCompatApi.this.imageInspectWithHttpInfo(this.name);
            return localVarResp.getData();
        }

        public ApiResponse<ImageInspect> executeWithHttpInfo() throws ApiException {
            return ImagesCompatApi.this.imageInspectWithHttpInfo(this.name);
        }

        public Call executeAsync(ApiCallback<ImageInspect> _callback) throws ApiException {
            return ImagesCompatApi.this.imageInspectAsync(this.name, _callback);
        }
    }

    public class APIimageListRequest {
        private Boolean all;
        private String filters;
        private Boolean digests;

        private APIimageListRequest() {
        }

        public APIimageListRequest all(Boolean all) {
            this.all = all;
            return this;
        }

        public APIimageListRequest filters(String filters) {
            this.filters = filters;
            return this;
        }

        public APIimageListRequest digests(Boolean digests) {
            this.digests = digests;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ImagesCompatApi.this.imageListCall(this.all, this.filters, this.digests, _callback);
        }

        public List<Summary> execute() throws ApiException {
            ApiResponse<List<Summary>> localVarResp = ImagesCompatApi.this.imageListWithHttpInfo(this.all, this.filters, this.digests);
            return localVarResp.getData();
        }

        public ApiResponse<List<Summary>> executeWithHttpInfo() throws ApiException {
            return ImagesCompatApi.this.imageListWithHttpInfo(this.all, this.filters, this.digests);
        }

        public Call executeAsync(ApiCallback<List<Summary>> _callback) throws ApiException {
            return ImagesCompatApi.this.imageListAsync(this.all, this.filters, this.digests, _callback);
        }
    }

    public class APIimageLoadRequest {
        private Boolean quiet;
        private String request;

        private APIimageLoadRequest() {
        }

        public APIimageLoadRequest quiet(Boolean quiet) {
            this.quiet = quiet;
            return this;
        }

        public APIimageLoadRequest request(String request) {
            this.request = request;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ImagesCompatApi.this.imageLoadCall(this.quiet, this.request, _callback);
        }

        public void execute() throws ApiException {
            ImagesCompatApi.this.imageLoadWithHttpInfo(this.quiet, this.request);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return ImagesCompatApi.this.imageLoadWithHttpInfo(this.quiet, this.request);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return ImagesCompatApi.this.imageLoadAsync(this.quiet, this.request, _callback);
        }
    }

    public class APIimagePruneRequest {
        private String filters;

        private APIimagePruneRequest() {
        }

        public APIimagePruneRequest filters(String filters) {
            this.filters = filters;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ImagesCompatApi.this.imagePruneCall(this.filters, _callback);
        }

        public List<ImageDelete200ResponseInner> execute() throws ApiException {
            ApiResponse<List<ImageDelete200ResponseInner>> localVarResp = ImagesCompatApi.this.imagePruneWithHttpInfo(this.filters);
            return localVarResp.getData();
        }

        public ApiResponse<List<ImageDelete200ResponseInner>> executeWithHttpInfo() throws ApiException {
            return ImagesCompatApi.this.imagePruneWithHttpInfo(this.filters);
        }

        public Call executeAsync(ApiCallback<List<ImageDelete200ResponseInner>> _callback) throws ApiException {
            return ImagesCompatApi.this.imagePruneAsync(this.filters, _callback);
        }
    }

    public class APIimagePushRequest {
        private final String name;
        private String tag;
        private Boolean all;
        private Boolean compress;
        private String destination;
        private String format;
        private Boolean tlsVerify;
        private String xRegistryAuth;

        private APIimagePushRequest(String name) {
            this.name = name;
        }

        public APIimagePushRequest tag(String tag) {
            this.tag = tag;
            return this;
        }

        public APIimagePushRequest all(Boolean all) {
            this.all = all;
            return this;
        }

        public APIimagePushRequest compress(Boolean compress) {
            this.compress = compress;
            return this;
        }

        public APIimagePushRequest destination(String destination) {
            this.destination = destination;
            return this;
        }

        public APIimagePushRequest format(String format) {
            this.format = format;
            return this;
        }

        public APIimagePushRequest tlsVerify(Boolean tlsVerify) {
            this.tlsVerify = tlsVerify;
            return this;
        }

        public APIimagePushRequest xRegistryAuth(String xRegistryAuth) {
            this.xRegistryAuth = xRegistryAuth;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ImagesCompatApi.this.imagePushCall(this.name, this.tag, this.all, this.compress, this.destination, this.format, this.tlsVerify, this.xRegistryAuth, _callback);
        }

        public File execute() throws ApiException {
            ApiResponse<File> localVarResp = ImagesCompatApi.this.imagePushWithHttpInfo(this.name, this.tag, this.all, this.compress, this.destination, this.format, this.tlsVerify, this.xRegistryAuth);
            return localVarResp.getData();
        }

        public ApiResponse<File> executeWithHttpInfo() throws ApiException {
            return ImagesCompatApi.this.imagePushWithHttpInfo(this.name, this.tag, this.all, this.compress, this.destination, this.format, this.tlsVerify, this.xRegistryAuth);
        }

        public Call executeAsync(ApiCallback<File> _callback) throws ApiException {
            return ImagesCompatApi.this.imagePushAsync(this.name, this.tag, this.all, this.compress, this.destination, this.format, this.tlsVerify, this.xRegistryAuth, _callback);
        }
    }

    public class APIimageSearchRequest {
        private String term;
        private Integer limit;
        private String filters;
        private Boolean tlsVerify;
        private Boolean listTags;

        private APIimageSearchRequest() {
        }

        public APIimageSearchRequest term(String term) {
            this.term = term;
            return this;
        }

        public APIimageSearchRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIimageSearchRequest filters(String filters) {
            this.filters = filters;
            return this;
        }

        public APIimageSearchRequest tlsVerify(Boolean tlsVerify) {
            this.tlsVerify = tlsVerify;
            return this;
        }

        public APIimageSearchRequest listTags(Boolean listTags) {
            this.listTags = listTags;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ImagesCompatApi.this.imageSearchCall(this.term, this.limit, this.filters, this.tlsVerify, this.listTags, _callback);
        }

        public ImageSearch200Response execute() throws ApiException {
            ApiResponse<ImageSearch200Response> localVarResp = ImagesCompatApi.this.imageSearchWithHttpInfo(this.term, this.limit, this.filters, this.tlsVerify, this.listTags);
            return localVarResp.getData();
        }

        public ApiResponse<ImageSearch200Response> executeWithHttpInfo() throws ApiException {
            return ImagesCompatApi.this.imageSearchWithHttpInfo(this.term, this.limit, this.filters, this.tlsVerify, this.listTags);
        }

        public Call executeAsync(ApiCallback<ImageSearch200Response> _callback) throws ApiException {
            return ImagesCompatApi.this.imageSearchAsync(this.term, this.limit, this.filters, this.tlsVerify, this.listTags, _callback);
        }
    }

    public class APIimageTagRequest {
        private final String name;
        private String repo;
        private String tag;

        private APIimageTagRequest(String name) {
            this.name = name;
        }

        public APIimageTagRequest repo(String repo) {
            this.repo = repo;
            return this;
        }

        public APIimageTagRequest tag(String tag) {
            this.tag = tag;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ImagesCompatApi.this.imageTagCall(this.name, this.repo, this.tag, _callback);
        }

        public void execute() throws ApiException {
            ImagesCompatApi.this.imageTagWithHttpInfo(this.name, this.repo, this.tag);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return ImagesCompatApi.this.imageTagWithHttpInfo(this.name, this.repo, this.tag);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return ImagesCompatApi.this.imageTagAsync(this.name, this.repo, this.tag, _callback);
        }
    }
}

