/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.github.pod4dev.libpodj.model.PluginConfig;
import io.github.pod4dev.libpodj.model.PluginSettings;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class Plugin
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_CONFIG = "Config";
    @SerializedName(value="Config")
    private PluginConfig config;
    public static final String SERIALIZED_NAME_ENABLED = "Enabled";
    @SerializedName(value="Enabled")
    private Boolean enabled;
    public static final String SERIALIZED_NAME_NAME = "Name";
    @SerializedName(value="Name")
    private String name;
    public static final String SERIALIZED_NAME_SETTINGS = "Settings";
    @SerializedName(value="Settings")
    private PluginSettings settings;
    public static final String SERIALIZED_NAME_ID = "Id";
    @SerializedName(value="Id")
    private String id;
    public static final String SERIALIZED_NAME_PLUGIN_REFERENCE = "PluginReference";
    @SerializedName(value="PluginReference")
    private String pluginReference;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Plugin config(PluginConfig config) {
        this.config = config;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    public PluginConfig getConfig() {
        return this.config;
    }

    public void setConfig(PluginConfig config) {
        this.config = config;
    }

    public Plugin enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Nonnull
    @NotNull
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Plugin name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Plugin settings(PluginSettings settings) {
        this.settings = settings;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    public PluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(PluginSettings settings) {
        this.settings = settings;
    }

    public Plugin id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Plugin pluginReference(String pluginReference) {
        this.pluginReference = pluginReference;
        return this;
    }

    @Nullable
    public String getPluginReference() {
        return this.pluginReference;
    }

    public void setPluginReference(String pluginReference) {
        this.pluginReference = pluginReference;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Plugin plugin = (Plugin)o;
        return Objects.equals(this.config, plugin.config) && Objects.equals(this.enabled, plugin.enabled) && Objects.equals(this.name, plugin.name) && Objects.equals(this.settings, plugin.settings) && Objects.equals(this.id, plugin.id) && Objects.equals(this.pluginReference, plugin.pluginReference);
    }

    public int hashCode() {
        return Objects.hash(this.config, this.enabled, this.name, this.settings, this.id, this.pluginReference);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Plugin {\n");
        sb.append("    config: ").append(this.toIndentedString(this.config)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    settings: ").append(this.toIndentedString(this.settings)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    pluginReference: ").append(this.toIndentedString(this.pluginReference)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in Plugin is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Plugin` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        PluginConfig.validateJsonElement(jsonObj.get(SERIALIZED_NAME_CONFIG));
        if (!jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        PluginSettings.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SETTINGS));
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PLUGIN_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_PLUGIN_REFERENCE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PLUGIN_REFERENCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `PluginReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PLUGIN_REFERENCE).toString()));
        }
    }

    public static Plugin fromJson(String jsonString) throws IOException {
        return (Plugin)JSON.getGson().fromJson(jsonString, Plugin.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CONFIG);
        openapiFields.add(SERIALIZED_NAME_ENABLED);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_SETTINGS);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_PLUGIN_REFERENCE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_CONFIG);
        openapiRequiredFields.add(SERIALIZED_NAME_ENABLED);
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_SETTINGS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Plugin.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Plugin.class));
            return new TypeAdapter<Plugin>(){

                public void write(JsonWriter out, Plugin value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Plugin read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    Plugin.validateJsonElement(jsonElement);
                    return (Plugin)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

