/*
 * supports a RESTful API for the Libpod library
 * This documentation describes the Podman v2.x+ RESTful API. It consists of a Docker-compatible API and a Libpod API providing support for Podman’s unique features such as pods.  To start the service and keep it running for 5,000 seconds (-t 0 runs forever):  podman system service -t 5000 &  You can then use cURL on the socket using requests documented below.  NOTE: if you install the package podman-docker, it will create a symbolic link for /run/docker.sock to /run/podman/podman.sock  NOTE: Some fields in the API response JSON are encoded as omitempty, which means that if said field has a zero value, they will not be encoded in the API response. This is a feature to help reduce the size of the JSON responses returned via the API.  NOTE: Due to the limitations of [go-swagger](https://github.com/go-swagger/go-swagger), some field values that have a complex type show up as null in the docs as well as in the API responses. This is because the zero value for the field type is null. The field description in the docs will state what type the field is expected to be for such cases.  See podman-system-service(1) for more information.  Quick Examples:  'podman info'  curl --unix-socket /run/podman/podman.sock http://d/v5.0.0/libpod/info  'podman pull quay.io/containers/podman'  curl -XPOST --unix-socket /run/podman/podman.sock -v 'http://d/v5.0.0/images/create?fromImage=quay.io%2Fcontainers%2Fpodman'  'podman list images'  curl --unix-socket /run/podman/podman.sock -v 'http://d/v5.0.0/libpod/images/json' | jq
 *
 * The version of the OpenAPI document: 5.0.0
 * Contact: podman@lists.podman.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.github.pod4dev.libpodj.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.model.IDMappingOptions;
import io.github.pod4dev.libpodj.model.ImageVolume;
import io.github.pod4dev.libpodj.model.LinuxDevice;
import io.github.pod4dev.libpodj.model.LinuxDeviceCgroup;
import io.github.pod4dev.libpodj.model.LinuxIntelRdt;
import io.github.pod4dev.libpodj.model.LinuxPersonality;
import io.github.pod4dev.libpodj.model.LinuxResources;
import io.github.pod4dev.libpodj.model.LinuxThrottleDevice;
import io.github.pod4dev.libpodj.model.LinuxWeightDevice;
import io.github.pod4dev.libpodj.model.LogConfigLibpod;
import io.github.pod4dev.libpodj.model.Mount;
import io.github.pod4dev.libpodj.model.NamedVolume;
import io.github.pod4dev.libpodj.model.Namespace;
import io.github.pod4dev.libpodj.model.OverlayVolume;
import io.github.pod4dev.libpodj.model.POSIXRlimit;
import io.github.pod4dev.libpodj.model.PerNetworkOptions;
import io.github.pod4dev.libpodj.model.PortMapping;
import io.github.pod4dev.libpodj.model.Schema2HealthConfig;
import io.github.pod4dev.libpodj.model.Secret;
import io.github.pod4dev.libpodj.model.StartupHealthCheck;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.io.Serializable;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import io.github.pod4dev.libpodj.JSON;

/**
 * SpecGenerator creates an OCI spec and Libpod configuration options to create a container based on the given configuration.
 */
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.9.0")
public class SpecGenerator implements Serializable {
  private static final long serialVersionUID = 1L;

  public static final String SERIALIZED_NAME_NETWORKS = "Networks";
  @SerializedName(SERIALIZED_NAME_NETWORKS)
  private Map<String, PerNetworkOptions> networks = new HashMap<>();

  public static final String SERIALIZED_NAME_ANNOTATIONS = "annotations";
  @SerializedName(SERIALIZED_NAME_ANNOTATIONS)
  private Map<String, String> annotations = new HashMap<>();

  public static final String SERIALIZED_NAME_APPARMOR_PROFILE = "apparmor_profile";
  @SerializedName(SERIALIZED_NAME_APPARMOR_PROFILE)
  private String apparmorProfile;

  public static final String SERIALIZED_NAME_BASE_HOSTS_FILE = "base_hosts_file";
  @SerializedName(SERIALIZED_NAME_BASE_HOSTS_FILE)
  private String baseHostsFile;

  public static final String SERIALIZED_NAME_CAP_ADD = "cap_add";
  @SerializedName(SERIALIZED_NAME_CAP_ADD)
  private List<String> capAdd = new ArrayList<>();

  public static final String SERIALIZED_NAME_CAP_DROP = "cap_drop";
  @SerializedName(SERIALIZED_NAME_CAP_DROP)
  private List<String> capDrop = new ArrayList<>();

  public static final String SERIALIZED_NAME_CGROUP_PARENT = "cgroup_parent";
  @SerializedName(SERIALIZED_NAME_CGROUP_PARENT)
  private String cgroupParent;

  public static final String SERIALIZED_NAME_CGROUPNS = "cgroupns";
  @SerializedName(SERIALIZED_NAME_CGROUPNS)
  private Namespace cgroupns;

  public static final String SERIALIZED_NAME_CGROUPS_MODE = "cgroups_mode";
  @SerializedName(SERIALIZED_NAME_CGROUPS_MODE)
  private String cgroupsMode;

  public static final String SERIALIZED_NAME_CHROOT_DIRECTORIES = "chroot_directories";
  @SerializedName(SERIALIZED_NAME_CHROOT_DIRECTORIES)
  private List<String> chrootDirectories = new ArrayList<>();

  public static final String SERIALIZED_NAME_CNI_NETWORKS = "cni_networks";
  @SerializedName(SERIALIZED_NAME_CNI_NETWORKS)
  private List<String> cniNetworks = new ArrayList<>();

  public static final String SERIALIZED_NAME_COMMAND = "command";
  @SerializedName(SERIALIZED_NAME_COMMAND)
  private List<String> command = new ArrayList<>();

  public static final String SERIALIZED_NAME_CONMON_PID_FILE = "conmon_pid_file";
  @SerializedName(SERIALIZED_NAME_CONMON_PID_FILE)
  private String conmonPidFile;

  public static final String SERIALIZED_NAME_CONTAINER_CREATE_COMMAND = "containerCreateCommand";
  @SerializedName(SERIALIZED_NAME_CONTAINER_CREATE_COMMAND)
  private List<String> containerCreateCommand = new ArrayList<>();

  public static final String SERIALIZED_NAME_CREATE_WORKING_DIR = "create_working_dir";
  @SerializedName(SERIALIZED_NAME_CREATE_WORKING_DIR)
  private Boolean createWorkingDir;

  public static final String SERIALIZED_NAME_DEPENDENCY_CONTAINERS = "dependencyContainers";
  @SerializedName(SERIALIZED_NAME_DEPENDENCY_CONTAINERS)
  private List<String> dependencyContainers = new ArrayList<>();

  public static final String SERIALIZED_NAME_DEVICE_CGROUP_RULE = "device_cgroup_rule";
  @SerializedName(SERIALIZED_NAME_DEVICE_CGROUP_RULE)
  private List<@Valid LinuxDeviceCgroup> deviceCgroupRule = new ArrayList<>();

  public static final String SERIALIZED_NAME_DEVICES = "devices";
  @SerializedName(SERIALIZED_NAME_DEVICES)
  private List<@Valid LinuxDevice> devices = new ArrayList<>();

  public static final String SERIALIZED_NAME_DEVICES_FROM = "devices_from";
  @SerializedName(SERIALIZED_NAME_DEVICES_FROM)
  private List<String> devicesFrom = new ArrayList<>();

  public static final String SERIALIZED_NAME_DNS_OPTION = "dns_option";
  @SerializedName(SERIALIZED_NAME_DNS_OPTION)
  private List<String> dnsOption = new ArrayList<>();

  public static final String SERIALIZED_NAME_DNS_SEARCH = "dns_search";
  @SerializedName(SERIALIZED_NAME_DNS_SEARCH)
  private List<String> dnsSearch = new ArrayList<>();

  public static final String SERIALIZED_NAME_DNS_SERVER = "dns_server";
  @SerializedName(SERIALIZED_NAME_DNS_SERVER)
  private List<String> dnsServer = new ArrayList<>();

  public static final String SERIALIZED_NAME_ENTRYPOINT = "entrypoint";
  @SerializedName(SERIALIZED_NAME_ENTRYPOINT)
  private List<String> entrypoint = new ArrayList<>();

  public static final String SERIALIZED_NAME_ENV = "env";
  @SerializedName(SERIALIZED_NAME_ENV)
  private Map<String, String> env = new HashMap<>();

  public static final String SERIALIZED_NAME_ENV_HOST = "env_host";
  @SerializedName(SERIALIZED_NAME_ENV_HOST)
  private Boolean envHost;

  public static final String SERIALIZED_NAME_ENVMERGE = "envmerge";
  @SerializedName(SERIALIZED_NAME_ENVMERGE)
  private List<String> envmerge = new ArrayList<>();

  public static final String SERIALIZED_NAME_EXPOSE = "expose";
  @SerializedName(SERIALIZED_NAME_EXPOSE)
  private Object expose;

  public static final String SERIALIZED_NAME_GROUP_ENTRY = "group_entry";
  @SerializedName(SERIALIZED_NAME_GROUP_ENTRY)
  private String groupEntry;

  public static final String SERIALIZED_NAME_GROUPS = "groups";
  @SerializedName(SERIALIZED_NAME_GROUPS)
  private List<String> groups = new ArrayList<>();

  public static final String SERIALIZED_NAME_HEALTH_CHECK_ON_FAILURE_ACTION = "health_check_on_failure_action";
  @SerializedName(SERIALIZED_NAME_HEALTH_CHECK_ON_FAILURE_ACTION)
  private Long healthCheckOnFailureAction;

  public static final String SERIALIZED_NAME_HEALTH_LOG_DESTINATION = "healthLogDestination";
  @SerializedName(SERIALIZED_NAME_HEALTH_LOG_DESTINATION)
  private String healthLogDestination;

  public static final String SERIALIZED_NAME_HEALTH_MAX_LOG_COUNT = "healthMaxLogCount";
  @SerializedName(SERIALIZED_NAME_HEALTH_MAX_LOG_COUNT)
  private Integer healthMaxLogCount;

  public static final String SERIALIZED_NAME_HEALTH_MAX_LOG_SIZE = "healthMaxLogSize";
  @SerializedName(SERIALIZED_NAME_HEALTH_MAX_LOG_SIZE)
  private Integer healthMaxLogSize;

  public static final String SERIALIZED_NAME_HEALTHCONFIG = "healthconfig";
  @SerializedName(SERIALIZED_NAME_HEALTHCONFIG)
  private Schema2HealthConfig healthconfig;

  public static final String SERIALIZED_NAME_HOST_DEVICE_LIST = "host_device_list";
  @SerializedName(SERIALIZED_NAME_HOST_DEVICE_LIST)
  private List<@Valid LinuxDevice> hostDeviceList = new ArrayList<>();

  public static final String SERIALIZED_NAME_HOSTADD = "hostadd";
  @SerializedName(SERIALIZED_NAME_HOSTADD)
  private List<String> hostadd = new ArrayList<>();

  public static final String SERIALIZED_NAME_HOSTNAME = "hostname";
  @SerializedName(SERIALIZED_NAME_HOSTNAME)
  private String hostname;

  public static final String SERIALIZED_NAME_HOSTUSERS = "hostusers";
  @SerializedName(SERIALIZED_NAME_HOSTUSERS)
  private List<String> hostusers = new ArrayList<>();

  public static final String SERIALIZED_NAME_HTTPPROXY = "httpproxy";
  @SerializedName(SERIALIZED_NAME_HTTPPROXY)
  private Boolean httpproxy;

  public static final String SERIALIZED_NAME_IDMAPPINGS = "idmappings";
  @SerializedName(SERIALIZED_NAME_IDMAPPINGS)
  private IDMappingOptions idmappings;

  public static final String SERIALIZED_NAME_IMAGE = "image";
  @SerializedName(SERIALIZED_NAME_IMAGE)
  private String image;

  public static final String SERIALIZED_NAME_IMAGE_ARCH = "image_arch";
  @SerializedName(SERIALIZED_NAME_IMAGE_ARCH)
  private String imageArch;

  public static final String SERIALIZED_NAME_IMAGE_OS = "image_os";
  @SerializedName(SERIALIZED_NAME_IMAGE_OS)
  private String imageOs;

  public static final String SERIALIZED_NAME_IMAGE_VARIANT = "image_variant";
  @SerializedName(SERIALIZED_NAME_IMAGE_VARIANT)
  private String imageVariant;

  public static final String SERIALIZED_NAME_IMAGE_VOLUME_MODE = "image_volume_mode";
  @SerializedName(SERIALIZED_NAME_IMAGE_VOLUME_MODE)
  private String imageVolumeMode;

  public static final String SERIALIZED_NAME_IMAGE_VOLUMES = "image_volumes";
  @SerializedName(SERIALIZED_NAME_IMAGE_VOLUMES)
  private List<@Valid ImageVolume> imageVolumes = new ArrayList<>();

  public static final String SERIALIZED_NAME_INIT = "init";
  @SerializedName(SERIALIZED_NAME_INIT)
  private Boolean init;

  public static final String SERIALIZED_NAME_INIT_CONTAINER_TYPE = "init_container_type";
  @SerializedName(SERIALIZED_NAME_INIT_CONTAINER_TYPE)
  private String initContainerType;

  public static final String SERIALIZED_NAME_INIT_PATH = "init_path";
  @SerializedName(SERIALIZED_NAME_INIT_PATH)
  private String initPath;

  public static final String SERIALIZED_NAME_INTEL_RDT = "intelRdt";
  @SerializedName(SERIALIZED_NAME_INTEL_RDT)
  private LinuxIntelRdt intelRdt;

  public static final String SERIALIZED_NAME_IPCNS = "ipcns";
  @SerializedName(SERIALIZED_NAME_IPCNS)
  private Namespace ipcns;

  public static final String SERIALIZED_NAME_LABEL_NESTED = "label_nested";
  @SerializedName(SERIALIZED_NAME_LABEL_NESTED)
  private Boolean labelNested;

  public static final String SERIALIZED_NAME_LABELS = "labels";
  @SerializedName(SERIALIZED_NAME_LABELS)
  private Map<String, String> labels = new HashMap<>();

  public static final String SERIALIZED_NAME_LOG_CONFIGURATION = "log_configuration";
  @SerializedName(SERIALIZED_NAME_LOG_CONFIGURATION)
  private LogConfigLibpod logConfiguration;

  public static final String SERIALIZED_NAME_MANAGE_PASSWORD = "manage_password";
  @SerializedName(SERIALIZED_NAME_MANAGE_PASSWORD)
  private Boolean managePassword;

  public static final String SERIALIZED_NAME_MASK = "mask";
  @SerializedName(SERIALIZED_NAME_MASK)
  private List<String> mask = new ArrayList<>();

  public static final String SERIALIZED_NAME_MOUNTS = "mounts";
  @SerializedName(SERIALIZED_NAME_MOUNTS)
  private List<@Valid Mount> mounts = new ArrayList<>();

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_NETNS = "netns";
  @SerializedName(SERIALIZED_NAME_NETNS)
  private Namespace netns;

  public static final String SERIALIZED_NAME_NETWORK_OPTIONS = "network_options";
  @SerializedName(SERIALIZED_NAME_NETWORK_OPTIONS)
  private Map<String, List<String>> networkOptions = new HashMap<>();

  public static final String SERIALIZED_NAME_NO_NEW_PRIVILEGES = "no_new_privileges";
  @SerializedName(SERIALIZED_NAME_NO_NEW_PRIVILEGES)
  private Boolean noNewPrivileges;

  public static final String SERIALIZED_NAME_OCI_RUNTIME = "oci_runtime";
  @SerializedName(SERIALIZED_NAME_OCI_RUNTIME)
  private String ociRuntime;

  public static final String SERIALIZED_NAME_OOM_SCORE_ADJ = "oom_score_adj";
  @SerializedName(SERIALIZED_NAME_OOM_SCORE_ADJ)
  private Long oomScoreAdj;

  public static final String SERIALIZED_NAME_OVERLAY_VOLUMES = "overlay_volumes";
  @SerializedName(SERIALIZED_NAME_OVERLAY_VOLUMES)
  private List<@Valid OverlayVolume> overlayVolumes = new ArrayList<>();

  public static final String SERIALIZED_NAME_PASSWD_ENTRY = "passwd_entry";
  @SerializedName(SERIALIZED_NAME_PASSWD_ENTRY)
  private String passwdEntry;

  public static final String SERIALIZED_NAME_PERSONALITY = "personality";
  @SerializedName(SERIALIZED_NAME_PERSONALITY)
  private LinuxPersonality personality;

  public static final String SERIALIZED_NAME_PIDNS = "pidns";
  @SerializedName(SERIALIZED_NAME_PIDNS)
  private Namespace pidns;

  public static final String SERIALIZED_NAME_POD = "pod";
  @SerializedName(SERIALIZED_NAME_POD)
  private String pod;

  public static final String SERIALIZED_NAME_PORTMAPPINGS = "portmappings";
  @SerializedName(SERIALIZED_NAME_PORTMAPPINGS)
  private List<@Valid PortMapping> portmappings = new ArrayList<>();

  public static final String SERIALIZED_NAME_PRIVILEGED = "privileged";
  @SerializedName(SERIALIZED_NAME_PRIVILEGED)
  private Boolean privileged;

  public static final String SERIALIZED_NAME_PROCFS_OPTS = "procfs_opts";
  @SerializedName(SERIALIZED_NAME_PROCFS_OPTS)
  private List<String> procfsOpts = new ArrayList<>();

  public static final String SERIALIZED_NAME_PUBLISH_IMAGE_PORTS = "publish_image_ports";
  @SerializedName(SERIALIZED_NAME_PUBLISH_IMAGE_PORTS)
  private Boolean publishImagePorts;

  public static final String SERIALIZED_NAME_R_LIMITS = "r_limits";
  @SerializedName(SERIALIZED_NAME_R_LIMITS)
  private List<@Valid POSIXRlimit> rLimits = new ArrayList<>();

  public static final String SERIALIZED_NAME_RAW_IMAGE_NAME = "raw_image_name";
  @SerializedName(SERIALIZED_NAME_RAW_IMAGE_NAME)
  private String rawImageName;

  public static final String SERIALIZED_NAME_READ_ONLY_FILESYSTEM = "read_only_filesystem";
  @SerializedName(SERIALIZED_NAME_READ_ONLY_FILESYSTEM)
  private Boolean readOnlyFilesystem;

  public static final String SERIALIZED_NAME_READ_WRITE_TMPFS = "read_write_tmpfs";
  @SerializedName(SERIALIZED_NAME_READ_WRITE_TMPFS)
  private Boolean readWriteTmpfs;

  public static final String SERIALIZED_NAME_REMOVE = "remove";
  @SerializedName(SERIALIZED_NAME_REMOVE)
  private Boolean remove;

  public static final String SERIALIZED_NAME_REMOVE_IMAGE = "removeImage";
  @SerializedName(SERIALIZED_NAME_REMOVE_IMAGE)
  private Boolean removeImage;

  public static final String SERIALIZED_NAME_RESOURCE_LIMITS = "resource_limits";
  @SerializedName(SERIALIZED_NAME_RESOURCE_LIMITS)
  private LinuxResources resourceLimits;

  public static final String SERIALIZED_NAME_RESTART_POLICY = "restart_policy";
  @SerializedName(SERIALIZED_NAME_RESTART_POLICY)
  private String restartPolicy;

  public static final String SERIALIZED_NAME_RESTART_TRIES = "restart_tries";
  @SerializedName(SERIALIZED_NAME_RESTART_TRIES)
  private Integer restartTries;

  public static final String SERIALIZED_NAME_ROOTFS = "rootfs";
  @SerializedName(SERIALIZED_NAME_ROOTFS)
  private String rootfs;

  public static final String SERIALIZED_NAME_ROOTFS_MAPPING = "rootfs_mapping";
  @SerializedName(SERIALIZED_NAME_ROOTFS_MAPPING)
  private String rootfsMapping;

  public static final String SERIALIZED_NAME_ROOTFS_OVERLAY = "rootfs_overlay";
  @SerializedName(SERIALIZED_NAME_ROOTFS_OVERLAY)
  private Boolean rootfsOverlay;

  public static final String SERIALIZED_NAME_ROOTFS_PROPAGATION = "rootfs_propagation";
  @SerializedName(SERIALIZED_NAME_ROOTFS_PROPAGATION)
  private String rootfsPropagation;

  public static final String SERIALIZED_NAME_SDNOTIFY_MODE = "sdnotifyMode";
  @SerializedName(SERIALIZED_NAME_SDNOTIFY_MODE)
  private String sdnotifyMode;

  public static final String SERIALIZED_NAME_SECCOMP_POLICY = "seccomp_policy";
  @SerializedName(SERIALIZED_NAME_SECCOMP_POLICY)
  private String seccompPolicy;

  public static final String SERIALIZED_NAME_SECCOMP_PROFILE_PATH = "seccomp_profile_path";
  @SerializedName(SERIALIZED_NAME_SECCOMP_PROFILE_PATH)
  private String seccompProfilePath;

  public static final String SERIALIZED_NAME_SECRET_ENV = "secret_env";
  @SerializedName(SERIALIZED_NAME_SECRET_ENV)
  private Map<String, String> secretEnv = new HashMap<>();

  public static final String SERIALIZED_NAME_SECRETS = "secrets";
  @SerializedName(SERIALIZED_NAME_SECRETS)
  private List<@Valid Secret> secrets = new ArrayList<>();

  public static final String SERIALIZED_NAME_SELINUX_OPTS = "selinux_opts";
  @SerializedName(SERIALIZED_NAME_SELINUX_OPTS)
  private List<String> selinuxOpts = new ArrayList<>();

  public static final String SERIALIZED_NAME_SHM_SIZE = "shm_size";
  @SerializedName(SERIALIZED_NAME_SHM_SIZE)
  private Long shmSize;

  public static final String SERIALIZED_NAME_SHM_SIZE_SYSTEMD = "shm_size_systemd";
  @SerializedName(SERIALIZED_NAME_SHM_SIZE_SYSTEMD)
  private Long shmSizeSystemd;

  public static final String SERIALIZED_NAME_STARTUP_HEALTH_CONFIG = "startupHealthConfig";
  @SerializedName(SERIALIZED_NAME_STARTUP_HEALTH_CONFIG)
  private StartupHealthCheck startupHealthConfig;

  public static final String SERIALIZED_NAME_STDIN = "stdin";
  @SerializedName(SERIALIZED_NAME_STDIN)
  private Boolean stdin;

  public static final String SERIALIZED_NAME_STOP_SIGNAL = "stop_signal";
  @SerializedName(SERIALIZED_NAME_STOP_SIGNAL)
  private Long stopSignal;

  public static final String SERIALIZED_NAME_STOP_TIMEOUT = "stop_timeout";
  @SerializedName(SERIALIZED_NAME_STOP_TIMEOUT)
  private Integer stopTimeout;

  public static final String SERIALIZED_NAME_STORAGE_OPTS = "storage_opts";
  @SerializedName(SERIALIZED_NAME_STORAGE_OPTS)
  private Map<String, String> storageOpts = new HashMap<>();

  public static final String SERIALIZED_NAME_SYSCTL = "sysctl";
  @SerializedName(SERIALIZED_NAME_SYSCTL)
  private Map<String, String> sysctl = new HashMap<>();

  public static final String SERIALIZED_NAME_SYSTEMD = "systemd";
  @SerializedName(SERIALIZED_NAME_SYSTEMD)
  private String systemd;

  public static final String SERIALIZED_NAME_TERMINAL = "terminal";
  @SerializedName(SERIALIZED_NAME_TERMINAL)
  private Boolean terminal;

  public static final String SERIALIZED_NAME_THROTTLE_READ_BPS_DEVICE = "throttleReadBpsDevice";
  @SerializedName(SERIALIZED_NAME_THROTTLE_READ_BPS_DEVICE)
  private Map<String, LinuxThrottleDevice> throttleReadBpsDevice = new HashMap<>();

  public static final String SERIALIZED_NAME_THROTTLE_READ_I_O_P_S_DEVICE = "throttleReadIOPSDevice";
  @SerializedName(SERIALIZED_NAME_THROTTLE_READ_I_O_P_S_DEVICE)
  private Map<String, LinuxThrottleDevice> throttleReadIOPSDevice = new HashMap<>();

  public static final String SERIALIZED_NAME_THROTTLE_WRITE_BPS_DEVICE = "throttleWriteBpsDevice";
  @SerializedName(SERIALIZED_NAME_THROTTLE_WRITE_BPS_DEVICE)
  private Map<String, LinuxThrottleDevice> throttleWriteBpsDevice = new HashMap<>();

  public static final String SERIALIZED_NAME_THROTTLE_WRITE_I_O_P_S_DEVICE = "throttleWriteIOPSDevice";
  @SerializedName(SERIALIZED_NAME_THROTTLE_WRITE_I_O_P_S_DEVICE)
  private Map<String, LinuxThrottleDevice> throttleWriteIOPSDevice = new HashMap<>();

  public static final String SERIALIZED_NAME_TIMEOUT = "timeout";
  @SerializedName(SERIALIZED_NAME_TIMEOUT)
  private Integer timeout;

  public static final String SERIALIZED_NAME_TIMEZONE = "timezone";
  @SerializedName(SERIALIZED_NAME_TIMEZONE)
  private String timezone;

  public static final String SERIALIZED_NAME_UMASK = "umask";
  @SerializedName(SERIALIZED_NAME_UMASK)
  private String umask;

  public static final String SERIALIZED_NAME_UNIFIED = "unified";
  @SerializedName(SERIALIZED_NAME_UNIFIED)
  private Map<String, String> unified = new HashMap<>();

  public static final String SERIALIZED_NAME_UNMASK = "unmask";
  @SerializedName(SERIALIZED_NAME_UNMASK)
  private List<String> unmask = new ArrayList<>();

  public static final String SERIALIZED_NAME_UNSETENV = "unsetenv";
  @SerializedName(SERIALIZED_NAME_UNSETENV)
  private List<String> unsetenv = new ArrayList<>();

  public static final String SERIALIZED_NAME_UNSETENVALL = "unsetenvall";
  @SerializedName(SERIALIZED_NAME_UNSETENVALL)
  private Boolean unsetenvall;

  public static final String SERIALIZED_NAME_USE_IMAGE_HOSTNAME = "use_image_hostname";
  @SerializedName(SERIALIZED_NAME_USE_IMAGE_HOSTNAME)
  private Boolean useImageHostname;

  public static final String SERIALIZED_NAME_USE_IMAGE_HOSTS = "use_image_hosts";
  @SerializedName(SERIALIZED_NAME_USE_IMAGE_HOSTS)
  private Boolean useImageHosts;

  public static final String SERIALIZED_NAME_USE_IMAGE_RESOLVE_CONF = "use_image_resolve_conf";
  @SerializedName(SERIALIZED_NAME_USE_IMAGE_RESOLVE_CONF)
  private Boolean useImageResolveConf;

  public static final String SERIALIZED_NAME_USER = "user";
  @SerializedName(SERIALIZED_NAME_USER)
  private String user;

  public static final String SERIALIZED_NAME_USERNS = "userns";
  @SerializedName(SERIALIZED_NAME_USERNS)
  private Namespace userns;

  public static final String SERIALIZED_NAME_UTSNS = "utsns";
  @SerializedName(SERIALIZED_NAME_UTSNS)
  private Namespace utsns;

  public static final String SERIALIZED_NAME_VOLATILE = "volatile";
  @SerializedName(SERIALIZED_NAME_VOLATILE)
  private Boolean _volatile;

  public static final String SERIALIZED_NAME_VOLUMES = "volumes";
  @SerializedName(SERIALIZED_NAME_VOLUMES)
  private List<@Valid NamedVolume> volumes = new ArrayList<>();

  public static final String SERIALIZED_NAME_VOLUMES_FROM = "volumes_from";
  @SerializedName(SERIALIZED_NAME_VOLUMES_FROM)
  private List<String> volumesFrom = new ArrayList<>();

  public static final String SERIALIZED_NAME_WEIGHT_DEVICE = "weightDevice";
  @SerializedName(SERIALIZED_NAME_WEIGHT_DEVICE)
  private Map<String, LinuxWeightDevice> weightDevice = new HashMap<>();

  public static final String SERIALIZED_NAME_WORK_DIR = "work_dir";
  @SerializedName(SERIALIZED_NAME_WORK_DIR)
  private String workDir;

  public SpecGenerator() {
  }

  public SpecGenerator networks(Map<String, PerNetworkOptions> networks) {
    this.networks = networks;
    return this;
  }

  public SpecGenerator putNetworksItem(String key, PerNetworkOptions networksItem) {
    if (this.networks == null) {
      this.networks = new HashMap<>();
    }
    this.networks.put(key, networksItem);
    return this;
  }

  /**
   * Map of networks names or ids that the container should join. You can request additional settings for each network, you can set network aliases, static ips, static mac address  and the network interface name for this container on the specific network. If the map is empty and the bridge network mode is set the container will be joined to the default network. Optional.
   * @return networks
   */
  @jakarta.annotation.Nullable
  @Valid

  public Map<String, PerNetworkOptions> getNetworks() {
    return networks;
  }

  public void setNetworks(Map<String, PerNetworkOptions> networks) {
    this.networks = networks;
  }


  public SpecGenerator annotations(Map<String, String> annotations) {
    this.annotations = annotations;
    return this;
  }

  public SpecGenerator putAnnotationsItem(String key, String annotationsItem) {
    if (this.annotations == null) {
      this.annotations = new HashMap<>();
    }
    this.annotations.put(key, annotationsItem);
    return this;
  }

  /**
   * Annotations are key-value options passed into the container runtime that can be used to trigger special behavior. Optional.
   * @return annotations
   */
  @jakarta.annotation.Nullable

  public Map<String, String> getAnnotations() {
    return annotations;
  }

  public void setAnnotations(Map<String, String> annotations) {
    this.annotations = annotations;
  }


  public SpecGenerator apparmorProfile(String apparmorProfile) {
    this.apparmorProfile = apparmorProfile;
    return this;
  }

  /**
   * ApparmorProfile is the name of the Apparmor profile the container will use. Optional.
   * @return apparmorProfile
   */
  @jakarta.annotation.Nullable

  public String getApparmorProfile() {
    return apparmorProfile;
  }

  public void setApparmorProfile(String apparmorProfile) {
    this.apparmorProfile = apparmorProfile;
  }


  public SpecGenerator baseHostsFile(String baseHostsFile) {
    this.baseHostsFile = baseHostsFile;
    return this;
  }

  /**
   * BaseHostsFile is the base file to create the &#x60;/etc/hosts&#x60; file inside the container. This must either be an absolute path to a file on the host system, or one of the special flags &#x60;image&#x60; or &#x60;none&#x60;. If it is empty it defaults to the base_hosts_file configuration in containers.conf. Optional.
   * @return baseHostsFile
   */
  @jakarta.annotation.Nullable

  public String getBaseHostsFile() {
    return baseHostsFile;
  }

  public void setBaseHostsFile(String baseHostsFile) {
    this.baseHostsFile = baseHostsFile;
  }


  public SpecGenerator capAdd(List<String> capAdd) {
    this.capAdd = capAdd;
    return this;
  }

  public SpecGenerator addCapAddItem(String capAddItem) {
    if (this.capAdd == null) {
      this.capAdd = new ArrayList<>();
    }
    this.capAdd.add(capAddItem);
    return this;
  }

  /**
   * CapAdd are capabilities which will be added to the container. Conflicts with Privileged. Optional.
   * @return capAdd
   */
  @jakarta.annotation.Nullable

  public List<String> getCapAdd() {
    return capAdd;
  }

  public void setCapAdd(List<String> capAdd) {
    this.capAdd = capAdd;
  }


  public SpecGenerator capDrop(List<String> capDrop) {
    this.capDrop = capDrop;
    return this;
  }

  public SpecGenerator addCapDropItem(String capDropItem) {
    if (this.capDrop == null) {
      this.capDrop = new ArrayList<>();
    }
    this.capDrop.add(capDropItem);
    return this;
  }

  /**
   * CapDrop are capabilities which will be removed from the container. Conflicts with Privileged. Optional.
   * @return capDrop
   */
  @jakarta.annotation.Nullable

  public List<String> getCapDrop() {
    return capDrop;
  }

  public void setCapDrop(List<String> capDrop) {
    this.capDrop = capDrop;
  }


  public SpecGenerator cgroupParent(String cgroupParent) {
    this.cgroupParent = cgroupParent;
    return this;
  }

  /**
   * CgroupParent is the container&#39;s Cgroup parent. If not set, the default for the current cgroup driver will be used. Optional.
   * @return cgroupParent
   */
  @jakarta.annotation.Nullable

  public String getCgroupParent() {
    return cgroupParent;
  }

  public void setCgroupParent(String cgroupParent) {
    this.cgroupParent = cgroupParent;
  }


  public SpecGenerator cgroupns(Namespace cgroupns) {
    this.cgroupns = cgroupns;
    return this;
  }

  /**
   * Get cgroupns
   * @return cgroupns
   */
  @jakarta.annotation.Nullable
  @Valid

  public Namespace getCgroupns() {
    return cgroupns;
  }

  public void setCgroupns(Namespace cgroupns) {
    this.cgroupns = cgroupns;
  }


  public SpecGenerator cgroupsMode(String cgroupsMode) {
    this.cgroupsMode = cgroupsMode;
    return this;
  }

  /**
   * CgroupsMode sets a policy for how cgroups will be created for the container, including the ability to disable creation entirely. Optional.
   * @return cgroupsMode
   */
  @jakarta.annotation.Nullable

  public String getCgroupsMode() {
    return cgroupsMode;
  }

  public void setCgroupsMode(String cgroupsMode) {
    this.cgroupsMode = cgroupsMode;
  }


  public SpecGenerator chrootDirectories(List<String> chrootDirectories) {
    this.chrootDirectories = chrootDirectories;
    return this;
  }

  public SpecGenerator addChrootDirectoriesItem(String chrootDirectoriesItem) {
    if (this.chrootDirectories == null) {
      this.chrootDirectories = new ArrayList<>();
    }
    this.chrootDirectories.add(chrootDirectoriesItem);
    return this;
  }

  /**
   * ChrootDirs is an additional set of directories that need to be treated as root directories. Standard bind mounts will be mounted into paths relative to these directories. Optional.
   * @return chrootDirectories
   */
  @jakarta.annotation.Nullable

  public List<String> getChrootDirectories() {
    return chrootDirectories;
  }

  public void setChrootDirectories(List<String> chrootDirectories) {
    this.chrootDirectories = chrootDirectories;
  }


  public SpecGenerator cniNetworks(List<String> cniNetworks) {
    this.cniNetworks = cniNetworks;
    return this;
  }

  public SpecGenerator addCniNetworksItem(String cniNetworksItem) {
    if (this.cniNetworks == null) {
      this.cniNetworks = new ArrayList<>();
    }
    this.cniNetworks.add(cniNetworksItem);
    return this;
  }

  /**
   * CNINetworks is a list of CNI networks to join the container to. If this list is empty, the default CNI network will be joined instead. If at least one entry is present, we will not join the default network (unless it is part of this list). Only available if NetNS is set to bridge. Optional. Deprecated: as of podman 4.0 use \&quot;Networks\&quot; instead.
   * @return cniNetworks
   */
  @jakarta.annotation.Nullable

  public List<String> getCniNetworks() {
    return cniNetworks;
  }

  public void setCniNetworks(List<String> cniNetworks) {
    this.cniNetworks = cniNetworks;
  }


  public SpecGenerator command(List<String> command) {
    this.command = command;
    return this;
  }

  public SpecGenerator addCommandItem(String commandItem) {
    if (this.command == null) {
      this.command = new ArrayList<>();
    }
    this.command.add(commandItem);
    return this;
  }

  /**
   * Command is the container&#39;s command. If not given and Image is specified, this will be populated by the image&#39;s configuration. Optional.
   * @return command
   */
  @jakarta.annotation.Nullable

  public List<String> getCommand() {
    return command;
  }

  public void setCommand(List<String> command) {
    this.command = command;
  }


  public SpecGenerator conmonPidFile(String conmonPidFile) {
    this.conmonPidFile = conmonPidFile;
    return this;
  }

  /**
   * ConmonPidFile is a path at which a PID file for Conmon will be placed. If not given, a default location will be used. Optional.
   * @return conmonPidFile
   */
  @jakarta.annotation.Nullable

  public String getConmonPidFile() {
    return conmonPidFile;
  }

  public void setConmonPidFile(String conmonPidFile) {
    this.conmonPidFile = conmonPidFile;
  }


  public SpecGenerator containerCreateCommand(List<String> containerCreateCommand) {
    this.containerCreateCommand = containerCreateCommand;
    return this;
  }

  public SpecGenerator addContainerCreateCommandItem(String containerCreateCommandItem) {
    if (this.containerCreateCommand == null) {
      this.containerCreateCommand = new ArrayList<>();
    }
    this.containerCreateCommand.add(containerCreateCommandItem);
    return this;
  }

  /**
   * ContainerCreateCommand is the command that was used to create this container. This will be shown in the output of Inspect() on the container, and may also be used by some tools that wish to recreate the container (e.g. &#x60;podman generate systemd --new&#x60;). Optional.
   * @return containerCreateCommand
   */
  @jakarta.annotation.Nullable

  public List<String> getContainerCreateCommand() {
    return containerCreateCommand;
  }

  public void setContainerCreateCommand(List<String> containerCreateCommand) {
    this.containerCreateCommand = containerCreateCommand;
  }


  public SpecGenerator createWorkingDir(Boolean createWorkingDir) {
    this.createWorkingDir = createWorkingDir;
    return this;
  }

  /**
   * Create the working directory if it doesn&#39;t exist. If unset, it doesn&#39;t create it. Optional.
   * @return createWorkingDir
   */
  @jakarta.annotation.Nullable

  public Boolean getCreateWorkingDir() {
    return createWorkingDir;
  }

  public void setCreateWorkingDir(Boolean createWorkingDir) {
    this.createWorkingDir = createWorkingDir;
  }


  public SpecGenerator dependencyContainers(List<String> dependencyContainers) {
    this.dependencyContainers = dependencyContainers;
    return this;
  }

  public SpecGenerator addDependencyContainersItem(String dependencyContainersItem) {
    if (this.dependencyContainers == null) {
      this.dependencyContainers = new ArrayList<>();
    }
    this.dependencyContainers.add(dependencyContainersItem);
    return this;
  }

  /**
   * DependencyContainers is an array of containers this container depends on. Dependency containers must be started before this container. Dependencies can be specified by name or full/partial ID. Optional.
   * @return dependencyContainers
   */
  @jakarta.annotation.Nullable

  public List<String> getDependencyContainers() {
    return dependencyContainers;
  }

  public void setDependencyContainers(List<String> dependencyContainers) {
    this.dependencyContainers = dependencyContainers;
  }


  public SpecGenerator deviceCgroupRule(List<@Valid LinuxDeviceCgroup> deviceCgroupRule) {
    this.deviceCgroupRule = deviceCgroupRule;
    return this;
  }

  public SpecGenerator addDeviceCgroupRuleItem(LinuxDeviceCgroup deviceCgroupRuleItem) {
    if (this.deviceCgroupRule == null) {
      this.deviceCgroupRule = new ArrayList<>();
    }
    this.deviceCgroupRule.add(deviceCgroupRuleItem);
    return this;
  }

  /**
   * DeviceCgroupRule are device cgroup rules that allow containers to use additional types of devices.
   * @return deviceCgroupRule
   */
  @jakarta.annotation.Nullable
  @Valid

  public List<@Valid LinuxDeviceCgroup> getDeviceCgroupRule() {
    return deviceCgroupRule;
  }

  public void setDeviceCgroupRule(List<@Valid LinuxDeviceCgroup> deviceCgroupRule) {
    this.deviceCgroupRule = deviceCgroupRule;
  }


  public SpecGenerator devices(List<@Valid LinuxDevice> devices) {
    this.devices = devices;
    return this;
  }

  public SpecGenerator addDevicesItem(LinuxDevice devicesItem) {
    if (this.devices == null) {
      this.devices = new ArrayList<>();
    }
    this.devices.add(devicesItem);
    return this;
  }

  /**
   * Devices are devices that will be added to the container. Optional.
   * @return devices
   */
  @jakarta.annotation.Nullable
  @Valid

  public List<@Valid LinuxDevice> getDevices() {
    return devices;
  }

  public void setDevices(List<@Valid LinuxDevice> devices) {
    this.devices = devices;
  }


  public SpecGenerator devicesFrom(List<String> devicesFrom) {
    this.devicesFrom = devicesFrom;
    return this;
  }

  public SpecGenerator addDevicesFromItem(String devicesFromItem) {
    if (this.devicesFrom == null) {
      this.devicesFrom = new ArrayList<>();
    }
    this.devicesFrom.add(devicesFromItem);
    return this;
  }

  /**
   * DevicesFrom specifies that this container will mount the device(s) from other container(s). Optional.
   * @return devicesFrom
   */
  @jakarta.annotation.Nullable

  public List<String> getDevicesFrom() {
    return devicesFrom;
  }

  public void setDevicesFrom(List<String> devicesFrom) {
    this.devicesFrom = devicesFrom;
  }


  public SpecGenerator dnsOption(List<String> dnsOption) {
    this.dnsOption = dnsOption;
    return this;
  }

  public SpecGenerator addDnsOptionItem(String dnsOptionItem) {
    if (this.dnsOption == null) {
      this.dnsOption = new ArrayList<>();
    }
    this.dnsOption.add(dnsOptionItem);
    return this;
  }

  /**
   * DNSOptions is a set of DNS options that will be used in the container&#39;s resolv.conf, replacing the host&#39;s DNS options which are used by default. Conflicts with UseImageResolvConf. Optional.
   * @return dnsOption
   */
  @jakarta.annotation.Nullable

  public List<String> getDnsOption() {
    return dnsOption;
  }

  public void setDnsOption(List<String> dnsOption) {
    this.dnsOption = dnsOption;
  }


  public SpecGenerator dnsSearch(List<String> dnsSearch) {
    this.dnsSearch = dnsSearch;
    return this;
  }

  public SpecGenerator addDnsSearchItem(String dnsSearchItem) {
    if (this.dnsSearch == null) {
      this.dnsSearch = new ArrayList<>();
    }
    this.dnsSearch.add(dnsSearchItem);
    return this;
  }

  /**
   * DNSSearch is a set of DNS search domains that will be used in the container&#39;s resolv.conf, replacing the host&#39;s DNS search domains which are used by default. Conflicts with UseImageResolvConf. Optional.
   * @return dnsSearch
   */
  @jakarta.annotation.Nullable

  public List<String> getDnsSearch() {
    return dnsSearch;
  }

  public void setDnsSearch(List<String> dnsSearch) {
    this.dnsSearch = dnsSearch;
  }


  public SpecGenerator dnsServer(List<String> dnsServer) {
    this.dnsServer = dnsServer;
    return this;
  }

  public SpecGenerator addDnsServerItem(String dnsServerItem) {
    if (this.dnsServer == null) {
      this.dnsServer = new ArrayList<>();
    }
    this.dnsServer.add(dnsServerItem);
    return this;
  }

  /**
   * DNSServers is a set of DNS servers that will be used in the container&#39;s resolv.conf, replacing the host&#39;s DNS Servers which are used by default. Conflicts with UseImageResolvConf. Optional.
   * @return dnsServer
   */
  @jakarta.annotation.Nullable

  public List<String> getDnsServer() {
    return dnsServer;
  }

  public void setDnsServer(List<String> dnsServer) {
    this.dnsServer = dnsServer;
  }


  public SpecGenerator entrypoint(List<String> entrypoint) {
    this.entrypoint = entrypoint;
    return this;
  }

  public SpecGenerator addEntrypointItem(String entrypointItem) {
    if (this.entrypoint == null) {
      this.entrypoint = new ArrayList<>();
    }
    this.entrypoint.add(entrypointItem);
    return this;
  }

  /**
   * Entrypoint is the container&#39;s entrypoint. If not given and Image is specified, this will be populated by the image&#39;s configuration. Optional.
   * @return entrypoint
   */
  @jakarta.annotation.Nullable

  public List<String> getEntrypoint() {
    return entrypoint;
  }

  public void setEntrypoint(List<String> entrypoint) {
    this.entrypoint = entrypoint;
  }


  public SpecGenerator env(Map<String, String> env) {
    this.env = env;
    return this;
  }

  public SpecGenerator putEnvItem(String key, String envItem) {
    if (this.env == null) {
      this.env = new HashMap<>();
    }
    this.env.put(key, envItem);
    return this;
  }

  /**
   * Env is a set of environment variables that will be set in the container. Optional.
   * @return env
   */
  @jakarta.annotation.Nullable

  public Map<String, String> getEnv() {
    return env;
  }

  public void setEnv(Map<String, String> env) {
    this.env = env;
  }


  public SpecGenerator envHost(Boolean envHost) {
    this.envHost = envHost;
    return this;
  }

  /**
   * EnvHost indicates that the host environment should be added to container Optional.
   * @return envHost
   */
  @jakarta.annotation.Nullable

  public Boolean getEnvHost() {
    return envHost;
  }

  public void setEnvHost(Boolean envHost) {
    this.envHost = envHost;
  }


  public SpecGenerator envmerge(List<String> envmerge) {
    this.envmerge = envmerge;
    return this;
  }

  public SpecGenerator addEnvmergeItem(String envmergeItem) {
    if (this.envmerge == null) {
      this.envmerge = new ArrayList<>();
    }
    this.envmerge.add(envmergeItem);
    return this;
  }

  /**
   * EnvMerge takes the specified environment variables from image and preprocess them before injecting them into the container. Optional.
   * @return envmerge
   */
  @jakarta.annotation.Nullable

  public List<String> getEnvmerge() {
    return envmerge;
  }

  public void setEnvmerge(List<String> envmerge) {
    this.envmerge = envmerge;
  }


  public SpecGenerator expose(Object expose) {
    this.expose = expose;
    return this;
  }

  /**
   * Expose is a number of ports that will be forwarded to the container if PublishExposedPorts is set. Expose is a map of uint16 (port number) to a string representing protocol i.e map[uint16]string. Allowed protocols are \&quot;tcp\&quot;, \&quot;udp\&quot;, and \&quot;sctp\&quot;, or some combination of the three separated by commas. If protocol is set to \&quot;\&quot; we will assume TCP. Only available if NetNS is set to Bridge or Slirp, and PublishExposedPorts is set. Optional.
   * @return expose
   */
  @jakarta.annotation.Nullable

  public Object getExpose() {
    return expose;
  }

  public void setExpose(Object expose) {
    this.expose = expose;
  }


  public SpecGenerator groupEntry(String groupEntry) {
    this.groupEntry = groupEntry;
    return this;
  }

  /**
   * GroupEntry specifies an arbitrary string to append to the container&#39;s /etc/group file. Optional.
   * @return groupEntry
   */
  @jakarta.annotation.Nullable

  public String getGroupEntry() {
    return groupEntry;
  }

  public void setGroupEntry(String groupEntry) {
    this.groupEntry = groupEntry;
  }


  public SpecGenerator groups(List<String> groups) {
    this.groups = groups;
    return this;
  }

  public SpecGenerator addGroupsItem(String groupsItem) {
    if (this.groups == null) {
      this.groups = new ArrayList<>();
    }
    this.groups.add(groupsItem);
    return this;
  }

  /**
   * Groups are a list of supplemental groups the container&#39;s user will be granted access to. Optional.
   * @return groups
   */
  @jakarta.annotation.Nullable

  public List<String> getGroups() {
    return groups;
  }

  public void setGroups(List<String> groups) {
    this.groups = groups;
  }


  public SpecGenerator healthCheckOnFailureAction(Long healthCheckOnFailureAction) {
    this.healthCheckOnFailureAction = healthCheckOnFailureAction;
    return this;
  }

  /**
   * HealthCheckOnFailureAction defines how Podman reacts when a container&#39;s health status turns unhealthy.
   * @return healthCheckOnFailureAction
   */
  @jakarta.annotation.Nullable

  public Long getHealthCheckOnFailureAction() {
    return healthCheckOnFailureAction;
  }

  public void setHealthCheckOnFailureAction(Long healthCheckOnFailureAction) {
    this.healthCheckOnFailureAction = healthCheckOnFailureAction;
  }


  public SpecGenerator healthLogDestination(String healthLogDestination) {
    this.healthLogDestination = healthLogDestination;
    return this;
  }

  /**
   * HealthLogDestination defines the destination where the log is stored. TODO (6.0): In next major release convert it to pointer and use omitempty
   * @return healthLogDestination
   */
  @jakarta.annotation.Nullable

  public String getHealthLogDestination() {
    return healthLogDestination;
  }

  public void setHealthLogDestination(String healthLogDestination) {
    this.healthLogDestination = healthLogDestination;
  }


  public SpecGenerator healthMaxLogCount(Integer healthMaxLogCount) {
    this.healthMaxLogCount = healthMaxLogCount;
    return this;
  }

  /**
   * HealthMaxLogCount is maximum number of attempts in the HealthCheck log file. (&#39;0&#39; value means an infinite number of attempts in the log file). TODO (6.0): In next major release convert it to pointer and use omitempty
   * @return healthMaxLogCount
   */
  @jakarta.annotation.Nullable

  public Integer getHealthMaxLogCount() {
    return healthMaxLogCount;
  }

  public void setHealthMaxLogCount(Integer healthMaxLogCount) {
    this.healthMaxLogCount = healthMaxLogCount;
  }


  public SpecGenerator healthMaxLogSize(Integer healthMaxLogSize) {
    this.healthMaxLogSize = healthMaxLogSize;
    return this;
  }

  /**
   * HealthMaxLogSize is the maximum length in characters of stored HealthCheck log (\&quot;0\&quot; value means an infinite log length). TODO (6.0): In next major release convert it to pointer and use omitempty
   * @return healthMaxLogSize
   */
  @jakarta.annotation.Nullable

  public Integer getHealthMaxLogSize() {
    return healthMaxLogSize;
  }

  public void setHealthMaxLogSize(Integer healthMaxLogSize) {
    this.healthMaxLogSize = healthMaxLogSize;
  }


  public SpecGenerator healthconfig(Schema2HealthConfig healthconfig) {
    this.healthconfig = healthconfig;
    return this;
  }

  /**
   * Get healthconfig
   * @return healthconfig
   */
  @jakarta.annotation.Nullable
  @Valid

  public Schema2HealthConfig getHealthconfig() {
    return healthconfig;
  }

  public void setHealthconfig(Schema2HealthConfig healthconfig) {
    this.healthconfig = healthconfig;
  }


  public SpecGenerator hostDeviceList(List<@Valid LinuxDevice> hostDeviceList) {
    this.hostDeviceList = hostDeviceList;
    return this;
  }

  public SpecGenerator addHostDeviceListItem(LinuxDevice hostDeviceListItem) {
    if (this.hostDeviceList == null) {
      this.hostDeviceList = new ArrayList<>();
    }
    this.hostDeviceList.add(hostDeviceListItem);
    return this;
  }

  /**
   * HostDeviceList is used to recreate the mounted device on inherited containers
   * @return hostDeviceList
   */
  @jakarta.annotation.Nullable
  @Valid

  public List<@Valid LinuxDevice> getHostDeviceList() {
    return hostDeviceList;
  }

  public void setHostDeviceList(List<@Valid LinuxDevice> hostDeviceList) {
    this.hostDeviceList = hostDeviceList;
  }


  public SpecGenerator hostadd(List<String> hostadd) {
    this.hostadd = hostadd;
    return this;
  }

  public SpecGenerator addHostaddItem(String hostaddItem) {
    if (this.hostadd == null) {
      this.hostadd = new ArrayList<>();
    }
    this.hostadd.add(hostaddItem);
    return this;
  }

  /**
   * HostAdd is a set of hosts which will be added to the container&#39;s etc/hosts file. Conflicts with UseImageHosts. Optional.
   * @return hostadd
   */
  @jakarta.annotation.Nullable

  public List<String> getHostadd() {
    return hostadd;
  }

  public void setHostadd(List<String> hostadd) {
    this.hostadd = hostadd;
  }


  public SpecGenerator hostname(String hostname) {
    this.hostname = hostname;
    return this;
  }

  /**
   * Hostname is the container&#39;s hostname. If not set, the hostname will not be modified (if UtsNS is not private) or will be set to the container ID (if UtsNS is private). Conflicts with UtsNS if UtsNS is not set to private. Optional.
   * @return hostname
   */
  @jakarta.annotation.Nullable

  public String getHostname() {
    return hostname;
  }

  public void setHostname(String hostname) {
    this.hostname = hostname;
  }


  public SpecGenerator hostusers(List<String> hostusers) {
    this.hostusers = hostusers;
    return this;
  }

  public SpecGenerator addHostusersItem(String hostusersItem) {
    if (this.hostusers == null) {
      this.hostusers = new ArrayList<>();
    }
    this.hostusers.add(hostusersItem);
    return this;
  }

  /**
   * HostUsers is a list of host usernames or UIDs to add to the container etc/passwd file
   * @return hostusers
   */
  @jakarta.annotation.Nullable

  public List<String> getHostusers() {
    return hostusers;
  }

  public void setHostusers(List<String> hostusers) {
    this.hostusers = hostusers;
  }


  public SpecGenerator httpproxy(Boolean httpproxy) {
    this.httpproxy = httpproxy;
    return this;
  }

  /**
   * EnvHTTPProxy indicates that the http host proxy environment variables should be added to container Optional.
   * @return httpproxy
   */
  @jakarta.annotation.Nullable

  public Boolean getHttpproxy() {
    return httpproxy;
  }

  public void setHttpproxy(Boolean httpproxy) {
    this.httpproxy = httpproxy;
  }


  public SpecGenerator idmappings(IDMappingOptions idmappings) {
    this.idmappings = idmappings;
    return this;
  }

  /**
   * Get idmappings
   * @return idmappings
   */
  @jakarta.annotation.Nullable
  @Valid

  public IDMappingOptions getIdmappings() {
    return idmappings;
  }

  public void setIdmappings(IDMappingOptions idmappings) {
    this.idmappings = idmappings;
  }


  public SpecGenerator image(String image) {
    this.image = image;
    return this;
  }

  /**
   * Image is the image the container will be based on. The image will be used as the container&#39;s root filesystem, and its environment vars, volumes, and other configuration will be applied to the container. Conflicts with Rootfs. At least one of Image or Rootfs must be specified.
   * @return image
   */
  @jakarta.annotation.Nullable

  public String getImage() {
    return image;
  }

  public void setImage(String image) {
    this.image = image;
  }


  public SpecGenerator imageArch(String imageArch) {
    this.imageArch = imageArch;
    return this;
  }

  /**
   * ImageArch is the user-specified image architecture. Used to select a different variant from a manifest list. Optional.
   * @return imageArch
   */
  @jakarta.annotation.Nullable

  public String getImageArch() {
    return imageArch;
  }

  public void setImageArch(String imageArch) {
    this.imageArch = imageArch;
  }


  public SpecGenerator imageOs(String imageOs) {
    this.imageOs = imageOs;
    return this;
  }

  /**
   * ImageOS is the user-specified OS of the image. Used to select a different variant from a manifest list. Optional.
   * @return imageOs
   */
  @jakarta.annotation.Nullable

  public String getImageOs() {
    return imageOs;
  }

  public void setImageOs(String imageOs) {
    this.imageOs = imageOs;
  }


  public SpecGenerator imageVariant(String imageVariant) {
    this.imageVariant = imageVariant;
    return this;
  }

  /**
   * ImageVariant is the user-specified image variant. Used to select a different variant from a manifest list. Optional.
   * @return imageVariant
   */
  @jakarta.annotation.Nullable

  public String getImageVariant() {
    return imageVariant;
  }

  public void setImageVariant(String imageVariant) {
    this.imageVariant = imageVariant;
  }


  public SpecGenerator imageVolumeMode(String imageVolumeMode) {
    this.imageVolumeMode = imageVolumeMode;
    return this;
  }

  /**
   * ImageVolumeMode indicates how image volumes will be created. Supported modes are \&quot;ignore\&quot; (do not create), \&quot;tmpfs\&quot; (create as tmpfs), and \&quot;anonymous\&quot; (create as anonymous volumes). The default if unset is anonymous. Optional.
   * @return imageVolumeMode
   */
  @jakarta.annotation.Nullable

  public String getImageVolumeMode() {
    return imageVolumeMode;
  }

  public void setImageVolumeMode(String imageVolumeMode) {
    this.imageVolumeMode = imageVolumeMode;
  }


  public SpecGenerator imageVolumes(List<@Valid ImageVolume> imageVolumes) {
    this.imageVolumes = imageVolumes;
    return this;
  }

  public SpecGenerator addImageVolumesItem(ImageVolume imageVolumesItem) {
    if (this.imageVolumes == null) {
      this.imageVolumes = new ArrayList<>();
    }
    this.imageVolumes.add(imageVolumesItem);
    return this;
  }

  /**
   * Image volumes bind-mount a container-image mount into the container. Optional.
   * @return imageVolumes
   */
  @jakarta.annotation.Nullable
  @Valid

  public List<@Valid ImageVolume> getImageVolumes() {
    return imageVolumes;
  }

  public void setImageVolumes(List<@Valid ImageVolume> imageVolumes) {
    this.imageVolumes = imageVolumes;
  }


  public SpecGenerator init(Boolean init) {
    this.init = init;
    return this;
  }

  /**
   * Init specifies that an init binary will be mounted into the container, and will be used as PID1. Optional.
   * @return init
   */
  @jakarta.annotation.Nullable

  public Boolean getInit() {
    return init;
  }

  public void setInit(Boolean init) {
    this.init = init;
  }


  public SpecGenerator initContainerType(String initContainerType) {
    this.initContainerType = initContainerType;
    return this;
  }

  /**
   * InitContainerType describes if this container is an init container and if so, what type: always or once. Optional.
   * @return initContainerType
   */
  @jakarta.annotation.Nullable

  public String getInitContainerType() {
    return initContainerType;
  }

  public void setInitContainerType(String initContainerType) {
    this.initContainerType = initContainerType;
  }


  public SpecGenerator initPath(String initPath) {
    this.initPath = initPath;
    return this;
  }

  /**
   * InitPath specifies the path to the init binary that will be added if Init is specified above. If not specified, the default set in the Libpod config will be used. Ignored if Init above is not set. Optional.
   * @return initPath
   */
  @jakarta.annotation.Nullable

  public String getInitPath() {
    return initPath;
  }

  public void setInitPath(String initPath) {
    this.initPath = initPath;
  }


  public SpecGenerator intelRdt(LinuxIntelRdt intelRdt) {
    this.intelRdt = intelRdt;
    return this;
  }

  /**
   * Get intelRdt
   * @return intelRdt
   */
  @jakarta.annotation.Nullable
  @Valid

  public LinuxIntelRdt getIntelRdt() {
    return intelRdt;
  }

  public void setIntelRdt(LinuxIntelRdt intelRdt) {
    this.intelRdt = intelRdt;
  }


  public SpecGenerator ipcns(Namespace ipcns) {
    this.ipcns = ipcns;
    return this;
  }

  /**
   * Get ipcns
   * @return ipcns
   */
  @jakarta.annotation.Nullable
  @Valid

  public Namespace getIpcns() {
    return ipcns;
  }

  public void setIpcns(Namespace ipcns) {
    this.ipcns = ipcns;
  }


  public SpecGenerator labelNested(Boolean labelNested) {
    this.labelNested = labelNested;
    return this;
  }

  /**
   * LabelNested indicates whether or not the container is allowed to run fully nested containers including SELinux labelling. Optional.
   * @return labelNested
   */
  @jakarta.annotation.Nullable

  public Boolean getLabelNested() {
    return labelNested;
  }

  public void setLabelNested(Boolean labelNested) {
    this.labelNested = labelNested;
  }


  public SpecGenerator labels(Map<String, String> labels) {
    this.labels = labels;
    return this;
  }

  public SpecGenerator putLabelsItem(String key, String labelsItem) {
    if (this.labels == null) {
      this.labels = new HashMap<>();
    }
    this.labels.put(key, labelsItem);
    return this;
  }

  /**
   * Labels are key-value pairs that are used to add metadata to containers. Optional.
   * @return labels
   */
  @jakarta.annotation.Nullable

  public Map<String, String> getLabels() {
    return labels;
  }

  public void setLabels(Map<String, String> labels) {
    this.labels = labels;
  }


  public SpecGenerator logConfiguration(LogConfigLibpod logConfiguration) {
    this.logConfiguration = logConfiguration;
    return this;
  }

  /**
   * Get logConfiguration
   * @return logConfiguration
   */
  @jakarta.annotation.Nullable
  @Valid

  public LogConfigLibpod getLogConfiguration() {
    return logConfiguration;
  }

  public void setLogConfiguration(LogConfigLibpod logConfiguration) {
    this.logConfiguration = logConfiguration;
  }


  public SpecGenerator managePassword(Boolean managePassword) {
    this.managePassword = managePassword;
    return this;
  }

  /**
   * Passwd is a container run option that determines if we are validating users/groups before running the container
   * @return managePassword
   */
  @jakarta.annotation.Nullable

  public Boolean getManagePassword() {
    return managePassword;
  }

  public void setManagePassword(Boolean managePassword) {
    this.managePassword = managePassword;
  }


  public SpecGenerator mask(List<String> mask) {
    this.mask = mask;
    return this;
  }

  public SpecGenerator addMaskItem(String maskItem) {
    if (this.mask == null) {
      this.mask = new ArrayList<>();
    }
    this.mask.add(maskItem);
    return this;
  }

  /**
   * Mask is the path we want to mask in the container. This masks the paths given in addition to the default list. Optional
   * @return mask
   */
  @jakarta.annotation.Nullable

  public List<String> getMask() {
    return mask;
  }

  public void setMask(List<String> mask) {
    this.mask = mask;
  }


  public SpecGenerator mounts(List<@Valid Mount> mounts) {
    this.mounts = mounts;
    return this;
  }

  public SpecGenerator addMountsItem(Mount mountsItem) {
    if (this.mounts == null) {
      this.mounts = new ArrayList<>();
    }
    this.mounts.add(mountsItem);
    return this;
  }

  /**
   * Mounts are mounts that will be added to the container. These will supersede Image Volumes and VolumesFrom volumes where there are conflicts. Optional.
   * @return mounts
   */
  @jakarta.annotation.Nullable
  @Valid

  public List<@Valid Mount> getMounts() {
    return mounts;
  }

  public void setMounts(List<@Valid Mount> mounts) {
    this.mounts = mounts;
  }


  public SpecGenerator name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Name is the name the container will be given. If no name is provided, one will be randomly generated. Optional.
   * @return name
   */
  @jakarta.annotation.Nullable

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }


  public SpecGenerator netns(Namespace netns) {
    this.netns = netns;
    return this;
  }

  /**
   * Get netns
   * @return netns
   */
  @jakarta.annotation.Nullable
  @Valid

  public Namespace getNetns() {
    return netns;
  }

  public void setNetns(Namespace netns) {
    this.netns = netns;
  }


  public SpecGenerator networkOptions(Map<String, List<String>> networkOptions) {
    this.networkOptions = networkOptions;
    return this;
  }

  public SpecGenerator putNetworkOptionsItem(String key, List<String> networkOptionsItem) {
    if (this.networkOptions == null) {
      this.networkOptions = new HashMap<>();
    }
    this.networkOptions.put(key, networkOptionsItem);
    return this;
  }

  /**
   * NetworkOptions are additional options for each network Optional.
   * @return networkOptions
   */
  @jakarta.annotation.Nullable
  @Valid

  public Map<String, List<String>> getNetworkOptions() {
    return networkOptions;
  }

  public void setNetworkOptions(Map<String, List<String>> networkOptions) {
    this.networkOptions = networkOptions;
  }


  public SpecGenerator noNewPrivileges(Boolean noNewPrivileges) {
    this.noNewPrivileges = noNewPrivileges;
    return this;
  }

  /**
   * NoNewPrivileges is whether the container will set the no new privileges flag on create, which disables gaining additional privileges (e.g. via setuid) in the container. Optional.
   * @return noNewPrivileges
   */
  @jakarta.annotation.Nullable

  public Boolean getNoNewPrivileges() {
    return noNewPrivileges;
  }

  public void setNoNewPrivileges(Boolean noNewPrivileges) {
    this.noNewPrivileges = noNewPrivileges;
  }


  public SpecGenerator ociRuntime(String ociRuntime) {
    this.ociRuntime = ociRuntime;
    return this;
  }

  /**
   * OCIRuntime is the name of the OCI runtime that will be used to create the container. If not specified, the default will be used. Optional.
   * @return ociRuntime
   */
  @jakarta.annotation.Nullable

  public String getOciRuntime() {
    return ociRuntime;
  }

  public void setOciRuntime(String ociRuntime) {
    this.ociRuntime = ociRuntime;
  }


  public SpecGenerator oomScoreAdj(Long oomScoreAdj) {
    this.oomScoreAdj = oomScoreAdj;
    return this;
  }

  /**
   * OOMScoreAdj adjusts the score used by the OOM killer to determine processes to kill for the container&#39;s process. Optional.
   * @return oomScoreAdj
   */
  @jakarta.annotation.Nullable

  public Long getOomScoreAdj() {
    return oomScoreAdj;
  }

  public void setOomScoreAdj(Long oomScoreAdj) {
    this.oomScoreAdj = oomScoreAdj;
  }


  public SpecGenerator overlayVolumes(List<@Valid OverlayVolume> overlayVolumes) {
    this.overlayVolumes = overlayVolumes;
    return this;
  }

  public SpecGenerator addOverlayVolumesItem(OverlayVolume overlayVolumesItem) {
    if (this.overlayVolumes == null) {
      this.overlayVolumes = new ArrayList<>();
    }
    this.overlayVolumes.add(overlayVolumesItem);
    return this;
  }

  /**
   * Overlay volumes are named volumes that will be added to the container. Optional.
   * @return overlayVolumes
   */
  @jakarta.annotation.Nullable
  @Valid

  public List<@Valid OverlayVolume> getOverlayVolumes() {
    return overlayVolumes;
  }

  public void setOverlayVolumes(List<@Valid OverlayVolume> overlayVolumes) {
    this.overlayVolumes = overlayVolumes;
  }


  public SpecGenerator passwdEntry(String passwdEntry) {
    this.passwdEntry = passwdEntry;
    return this;
  }

  /**
   * PasswdEntry specifies an arbitrary string to append to the container&#39;s /etc/passwd file. Optional.
   * @return passwdEntry
   */
  @jakarta.annotation.Nullable

  public String getPasswdEntry() {
    return passwdEntry;
  }

  public void setPasswdEntry(String passwdEntry) {
    this.passwdEntry = passwdEntry;
  }


  public SpecGenerator personality(LinuxPersonality personality) {
    this.personality = personality;
    return this;
  }

  /**
   * Get personality
   * @return personality
   */
  @jakarta.annotation.Nullable
  @Valid

  public LinuxPersonality getPersonality() {
    return personality;
  }

  public void setPersonality(LinuxPersonality personality) {
    this.personality = personality;
  }


  public SpecGenerator pidns(Namespace pidns) {
    this.pidns = pidns;
    return this;
  }

  /**
   * Get pidns
   * @return pidns
   */
  @jakarta.annotation.Nullable
  @Valid

  public Namespace getPidns() {
    return pidns;
  }

  public void setPidns(Namespace pidns) {
    this.pidns = pidns;
  }


  public SpecGenerator pod(String pod) {
    this.pod = pod;
    return this;
  }

  /**
   * Pod is the ID of the pod the container will join. Optional.
   * @return pod
   */
  @jakarta.annotation.Nullable

  public String getPod() {
    return pod;
  }

  public void setPod(String pod) {
    this.pod = pod;
  }


  public SpecGenerator portmappings(List<@Valid PortMapping> portmappings) {
    this.portmappings = portmappings;
    return this;
  }

  public SpecGenerator addPortmappingsItem(PortMapping portmappingsItem) {
    if (this.portmappings == null) {
      this.portmappings = new ArrayList<>();
    }
    this.portmappings.add(portmappingsItem);
    return this;
  }

  /**
   * PortBindings is a set of ports to map into the container. Only available if NetNS is set to bridge, slirp, or pasta. Optional.
   * @return portmappings
   */
  @jakarta.annotation.Nullable
  @Valid

  public List<@Valid PortMapping> getPortmappings() {
    return portmappings;
  }

  public void setPortmappings(List<@Valid PortMapping> portmappings) {
    this.portmappings = portmappings;
  }


  public SpecGenerator privileged(Boolean privileged) {
    this.privileged = privileged;
    return this;
  }

  /**
   * Privileged is whether the container is privileged. Privileged does the following: Adds all devices on the system to the container. Adds all capabilities to the container. Disables Seccomp, SELinux, and Apparmor confinement. (Though SELinux can be manually re-enabled). TODO: this conflicts with things. TODO: this does more. Optional.
   * @return privileged
   */
  @jakarta.annotation.Nullable

  public Boolean getPrivileged() {
    return privileged;
  }

  public void setPrivileged(Boolean privileged) {
    this.privileged = privileged;
  }


  public SpecGenerator procfsOpts(List<String> procfsOpts) {
    this.procfsOpts = procfsOpts;
    return this;
  }

  public SpecGenerator addProcfsOptsItem(String procfsOptsItem) {
    if (this.procfsOpts == null) {
      this.procfsOpts = new ArrayList<>();
    }
    this.procfsOpts.add(procfsOptsItem);
    return this;
  }

  /**
   * ProcOpts are the options used for the proc mount.
   * @return procfsOpts
   */
  @jakarta.annotation.Nullable

  public List<String> getProcfsOpts() {
    return procfsOpts;
  }

  public void setProcfsOpts(List<String> procfsOpts) {
    this.procfsOpts = procfsOpts;
  }


  public SpecGenerator publishImagePorts(Boolean publishImagePorts) {
    this.publishImagePorts = publishImagePorts;
    return this;
  }

  /**
   * PublishExposedPorts will publish ports specified in the image to random unused ports (guaranteed to be above 1024) on the host. This is based on ports set in Expose below, and any ports specified by the Image (if one is given). Only available if NetNS is set to Bridge or Slirp. Optional.
   * @return publishImagePorts
   */
  @jakarta.annotation.Nullable

  public Boolean getPublishImagePorts() {
    return publishImagePorts;
  }

  public void setPublishImagePorts(Boolean publishImagePorts) {
    this.publishImagePorts = publishImagePorts;
  }


  public SpecGenerator rLimits(List<@Valid POSIXRlimit> rLimits) {
    this.rLimits = rLimits;
    return this;
  }

  public SpecGenerator addRLimitsItem(POSIXRlimit rLimitsItem) {
    if (this.rLimits == null) {
      this.rLimits = new ArrayList<>();
    }
    this.rLimits.add(rLimitsItem);
    return this;
  }

  /**
   * Rlimits are POSIX rlimits to apply to the container. Optional.
   * @return rLimits
   */
  @jakarta.annotation.Nullable
  @Valid

  public List<@Valid POSIXRlimit> getrLimits() {
    return rLimits;
  }

  public void setrLimits(List<@Valid POSIXRlimit> rLimits) {
    this.rLimits = rLimits;
  }


  public SpecGenerator rawImageName(String rawImageName) {
    this.rawImageName = rawImageName;
    return this;
  }

  /**
   * RawImageName is the user-specified and unprocessed input referring to a local or a remote image. Optional, but strongly encouraged to be set if Image is set.
   * @return rawImageName
   */
  @jakarta.annotation.Nullable

  public String getRawImageName() {
    return rawImageName;
  }

  public void setRawImageName(String rawImageName) {
    this.rawImageName = rawImageName;
  }


  public SpecGenerator readOnlyFilesystem(Boolean readOnlyFilesystem) {
    this.readOnlyFilesystem = readOnlyFilesystem;
    return this;
  }

  /**
   * ReadOnlyFilesystem indicates that everything will be mounted as read-only. Optional.
   * @return readOnlyFilesystem
   */
  @jakarta.annotation.Nullable

  public Boolean getReadOnlyFilesystem() {
    return readOnlyFilesystem;
  }

  public void setReadOnlyFilesystem(Boolean readOnlyFilesystem) {
    this.readOnlyFilesystem = readOnlyFilesystem;
  }


  public SpecGenerator readWriteTmpfs(Boolean readWriteTmpfs) {
    this.readWriteTmpfs = readWriteTmpfs;
    return this;
  }

  /**
   * ReadWriteTmpfs indicates that when running with a ReadOnlyFilesystem mount temporary file systems. Optional.
   * @return readWriteTmpfs
   */
  @jakarta.annotation.Nullable

  public Boolean getReadWriteTmpfs() {
    return readWriteTmpfs;
  }

  public void setReadWriteTmpfs(Boolean readWriteTmpfs) {
    this.readWriteTmpfs = readWriteTmpfs;
  }


  public SpecGenerator remove(Boolean remove) {
    this.remove = remove;
    return this;
  }

  /**
   * Remove indicates if the container should be removed once it has been started and exits. Optional.
   * @return remove
   */
  @jakarta.annotation.Nullable

  public Boolean getRemove() {
    return remove;
  }

  public void setRemove(Boolean remove) {
    this.remove = remove;
  }


  public SpecGenerator removeImage(Boolean removeImage) {
    this.removeImage = removeImage;
    return this;
  }

  /**
   * RemoveImage indicates that the container should remove the image it was created from after it exits. Only allowed if Remove is set to true and Image, not Rootfs, is in use. Optional.
   * @return removeImage
   */
  @jakarta.annotation.Nullable

  public Boolean getRemoveImage() {
    return removeImage;
  }

  public void setRemoveImage(Boolean removeImage) {
    this.removeImage = removeImage;
  }


  public SpecGenerator resourceLimits(LinuxResources resourceLimits) {
    this.resourceLimits = resourceLimits;
    return this;
  }

  /**
   * Get resourceLimits
   * @return resourceLimits
   */
  @jakarta.annotation.Nullable
  @Valid

  public LinuxResources getResourceLimits() {
    return resourceLimits;
  }

  public void setResourceLimits(LinuxResources resourceLimits) {
    this.resourceLimits = resourceLimits;
  }


  public SpecGenerator restartPolicy(String restartPolicy) {
    this.restartPolicy = restartPolicy;
    return this;
  }

  /**
   * RestartPolicy is the container&#39;s restart policy - an action which will be taken when the container exits. If not given, the default policy, which does nothing, will be used. Optional.
   * @return restartPolicy
   */
  @jakarta.annotation.Nullable

  public String getRestartPolicy() {
    return restartPolicy;
  }

  public void setRestartPolicy(String restartPolicy) {
    this.restartPolicy = restartPolicy;
  }


  public SpecGenerator restartTries(Integer restartTries) {
    this.restartTries = restartTries;
    return this;
  }

  /**
   * RestartRetries is the number of attempts that will be made to restart the container. Only available when RestartPolicy is set to \&quot;on-failure\&quot;. Optional.
   * @return restartTries
   */
  @jakarta.annotation.Nullable

  public Integer getRestartTries() {
    return restartTries;
  }

  public void setRestartTries(Integer restartTries) {
    this.restartTries = restartTries;
  }


  public SpecGenerator rootfs(String rootfs) {
    this.rootfs = rootfs;
    return this;
  }

  /**
   * Rootfs is the path to a directory that will be used as the container&#39;s root filesystem. No modification will be made to the directory, it will be directly mounted into the container as root. Conflicts with Image. At least one of Image or Rootfs must be specified.
   * @return rootfs
   */
  @jakarta.annotation.Nullable

  public String getRootfs() {
    return rootfs;
  }

  public void setRootfs(String rootfs) {
    this.rootfs = rootfs;
  }


  public SpecGenerator rootfsMapping(String rootfsMapping) {
    this.rootfsMapping = rootfsMapping;
    return this;
  }

  /**
   * RootfsMapping specifies if there are UID/GID mappings to apply to the rootfs. Optional.
   * @return rootfsMapping
   */
  @jakarta.annotation.Nullable

  public String getRootfsMapping() {
    return rootfsMapping;
  }

  public void setRootfsMapping(String rootfsMapping) {
    this.rootfsMapping = rootfsMapping;
  }


  public SpecGenerator rootfsOverlay(Boolean rootfsOverlay) {
    this.rootfsOverlay = rootfsOverlay;
    return this;
  }

  /**
   * RootfsOverlay tells if rootfs is actually an overlay on top of base path. Optional.
   * @return rootfsOverlay
   */
  @jakarta.annotation.Nullable

  public Boolean getRootfsOverlay() {
    return rootfsOverlay;
  }

  public void setRootfsOverlay(Boolean rootfsOverlay) {
    this.rootfsOverlay = rootfsOverlay;
  }


  public SpecGenerator rootfsPropagation(String rootfsPropagation) {
    this.rootfsPropagation = rootfsPropagation;
    return this;
  }

  /**
   * RootfsPropagation is the rootfs propagation mode for the container. If not set, the default of rslave will be used. Optional.
   * @return rootfsPropagation
   */
  @jakarta.annotation.Nullable

  public String getRootfsPropagation() {
    return rootfsPropagation;
  }

  public void setRootfsPropagation(String rootfsPropagation) {
    this.rootfsPropagation = rootfsPropagation;
  }


  public SpecGenerator sdnotifyMode(String sdnotifyMode) {
    this.sdnotifyMode = sdnotifyMode;
    return this;
  }

  /**
   * Determine how to handle the NOTIFY_SOCKET - do we participate or pass it through \&quot;container\&quot; - let the OCI runtime deal with it, advertise conmon&#39;s MAINPID \&quot;conmon-only\&quot; - advertise conmon&#39;s MAINPID, send READY when started, don&#39;t pass to OCI \&quot;ignore\&quot; - unset NOTIFY_SOCKET Optional.
   * @return sdnotifyMode
   */
  @jakarta.annotation.Nullable

  public String getSdnotifyMode() {
    return sdnotifyMode;
  }

  public void setSdnotifyMode(String sdnotifyMode) {
    this.sdnotifyMode = sdnotifyMode;
  }


  public SpecGenerator seccompPolicy(String seccompPolicy) {
    this.seccompPolicy = seccompPolicy;
    return this;
  }

  /**
   * SeccompPolicy determines which seccomp profile gets applied the container. valid values: empty,default,image
   * @return seccompPolicy
   */
  @jakarta.annotation.Nullable

  public String getSeccompPolicy() {
    return seccompPolicy;
  }

  public void setSeccompPolicy(String seccompPolicy) {
    this.seccompPolicy = seccompPolicy;
  }


  public SpecGenerator seccompProfilePath(String seccompProfilePath) {
    this.seccompProfilePath = seccompProfilePath;
    return this;
  }

  /**
   * SeccompProfilePath is the path to a JSON file containing the container&#39;s Seccomp profile. If not specified, no Seccomp profile will be used. Optional.
   * @return seccompProfilePath
   */
  @jakarta.annotation.Nullable

  public String getSeccompProfilePath() {
    return seccompProfilePath;
  }

  public void setSeccompProfilePath(String seccompProfilePath) {
    this.seccompProfilePath = seccompProfilePath;
  }


  public SpecGenerator secretEnv(Map<String, String> secretEnv) {
    this.secretEnv = secretEnv;
    return this;
  }

  public SpecGenerator putSecretEnvItem(String key, String secretEnvItem) {
    if (this.secretEnv == null) {
      this.secretEnv = new HashMap<>();
    }
    this.secretEnv.put(key, secretEnvItem);
    return this;
  }

  /**
   * EnvSecrets are secrets that will be set as environment variables Optional.
   * @return secretEnv
   */
  @jakarta.annotation.Nullable

  public Map<String, String> getSecretEnv() {
    return secretEnv;
  }

  public void setSecretEnv(Map<String, String> secretEnv) {
    this.secretEnv = secretEnv;
  }


  public SpecGenerator secrets(List<@Valid Secret> secrets) {
    this.secrets = secrets;
    return this;
  }

  public SpecGenerator addSecretsItem(Secret secretsItem) {
    if (this.secrets == null) {
      this.secrets = new ArrayList<>();
    }
    this.secrets.add(secretsItem);
    return this;
  }

  /**
   * Secrets are the secrets that will be added to the container Optional.
   * @return secrets
   */
  @jakarta.annotation.Nullable
  @Valid

  public List<@Valid Secret> getSecrets() {
    return secrets;
  }

  public void setSecrets(List<@Valid Secret> secrets) {
    this.secrets = secrets;
  }


  public SpecGenerator selinuxOpts(List<String> selinuxOpts) {
    this.selinuxOpts = selinuxOpts;
    return this;
  }

  public SpecGenerator addSelinuxOptsItem(String selinuxOptsItem) {
    if (this.selinuxOpts == null) {
      this.selinuxOpts = new ArrayList<>();
    }
    this.selinuxOpts.add(selinuxOptsItem);
    return this;
  }

  /**
   * SelinuxProcessLabel is the process label the container will use. If SELinux is enabled and this is not specified, a label will be automatically generated if not specified. Optional.
   * @return selinuxOpts
   */
  @jakarta.annotation.Nullable

  public List<String> getSelinuxOpts() {
    return selinuxOpts;
  }

  public void setSelinuxOpts(List<String> selinuxOpts) {
    this.selinuxOpts = selinuxOpts;
  }


  public SpecGenerator shmSize(Long shmSize) {
    this.shmSize = shmSize;
    return this;
  }

  /**
   * ShmSize is the size of the tmpfs to mount in at /dev/shm, in bytes. Conflicts with ShmSize if IpcNS is not private. Optional.
   * @return shmSize
   */
  @jakarta.annotation.Nullable

  public Long getShmSize() {
    return shmSize;
  }

  public void setShmSize(Long shmSize) {
    this.shmSize = shmSize;
  }


  public SpecGenerator shmSizeSystemd(Long shmSizeSystemd) {
    this.shmSizeSystemd = shmSizeSystemd;
    return this;
  }

  /**
   * ShmSizeSystemd is the size of systemd-specific tmpfs mounts specifically /run, /run/lock, /var/log/journal and /tmp. Optional
   * @return shmSizeSystemd
   */
  @jakarta.annotation.Nullable

  public Long getShmSizeSystemd() {
    return shmSizeSystemd;
  }

  public void setShmSizeSystemd(Long shmSizeSystemd) {
    this.shmSizeSystemd = shmSizeSystemd;
  }


  public SpecGenerator startupHealthConfig(StartupHealthCheck startupHealthConfig) {
    this.startupHealthConfig = startupHealthConfig;
    return this;
  }

  /**
   * Get startupHealthConfig
   * @return startupHealthConfig
   */
  @jakarta.annotation.Nullable
  @Valid

  public StartupHealthCheck getStartupHealthConfig() {
    return startupHealthConfig;
  }

  public void setStartupHealthConfig(StartupHealthCheck startupHealthConfig) {
    this.startupHealthConfig = startupHealthConfig;
  }


  public SpecGenerator stdin(Boolean stdin) {
    this.stdin = stdin;
    return this;
  }

  /**
   * Stdin is whether the container will keep its STDIN open. Optional.
   * @return stdin
   */
  @jakarta.annotation.Nullable

  public Boolean getStdin() {
    return stdin;
  }

  public void setStdin(Boolean stdin) {
    this.stdin = stdin;
  }


  public SpecGenerator stopSignal(Long stopSignal) {
    this.stopSignal = stopSignal;
    return this;
  }

  /**
   * It implements the [os.Signal] interface.
   * @return stopSignal
   */
  @jakarta.annotation.Nullable

  public Long getStopSignal() {
    return stopSignal;
  }

  public void setStopSignal(Long stopSignal) {
    this.stopSignal = stopSignal;
  }


  public SpecGenerator stopTimeout(Integer stopTimeout) {
    this.stopTimeout = stopTimeout;
    return this;
  }

  /**
   * StopTimeout is a timeout between the container&#39;s stop signal being sent and SIGKILL being sent. If not provided, the default will be used. If 0 is used, stop signal will not be sent, and SIGKILL will be sent instead. Optional.
   * @return stopTimeout
   */
  @jakarta.annotation.Nullable

  public Integer getStopTimeout() {
    return stopTimeout;
  }

  public void setStopTimeout(Integer stopTimeout) {
    this.stopTimeout = stopTimeout;
  }


  public SpecGenerator storageOpts(Map<String, String> storageOpts) {
    this.storageOpts = storageOpts;
    return this;
  }

  public SpecGenerator putStorageOptsItem(String key, String storageOptsItem) {
    if (this.storageOpts == null) {
      this.storageOpts = new HashMap<>();
    }
    this.storageOpts.put(key, storageOptsItem);
    return this;
  }

  /**
   * StorageOpts is the container&#39;s storage options Optional.
   * @return storageOpts
   */
  @jakarta.annotation.Nullable

  public Map<String, String> getStorageOpts() {
    return storageOpts;
  }

  public void setStorageOpts(Map<String, String> storageOpts) {
    this.storageOpts = storageOpts;
  }


  public SpecGenerator sysctl(Map<String, String> sysctl) {
    this.sysctl = sysctl;
    return this;
  }

  public SpecGenerator putSysctlItem(String key, String sysctlItem) {
    if (this.sysctl == null) {
      this.sysctl = new HashMap<>();
    }
    this.sysctl.put(key, sysctlItem);
    return this;
  }

  /**
   * Sysctl sets kernel parameters for the container
   * @return sysctl
   */
  @jakarta.annotation.Nullable

  public Map<String, String> getSysctl() {
    return sysctl;
  }

  public void setSysctl(Map<String, String> sysctl) {
    this.sysctl = sysctl;
  }


  public SpecGenerator systemd(String systemd) {
    this.systemd = systemd;
    return this;
  }

  /**
   * Systemd is whether the container will be started in systemd mode. Valid options are \&quot;true\&quot;, \&quot;false\&quot;, and \&quot;always\&quot;. \&quot;true\&quot; enables this mode only if the binary run in the container is sbin/init or systemd. \&quot;always\&quot; unconditionally enables systemd mode. \&quot;false\&quot; unconditionally disables systemd mode. If enabled, mounts and stop signal will be modified. If set to \&quot;always\&quot; or set to \&quot;true\&quot; and conditionally triggered, conflicts with StopSignal. If not specified, \&quot;false\&quot; will be assumed. Optional.
   * @return systemd
   */
  @jakarta.annotation.Nullable

  public String getSystemd() {
    return systemd;
  }

  public void setSystemd(String systemd) {
    this.systemd = systemd;
  }


  public SpecGenerator terminal(Boolean terminal) {
    this.terminal = terminal;
    return this;
  }

  /**
   * Terminal is whether the container will create a PTY. Optional.
   * @return terminal
   */
  @jakarta.annotation.Nullable

  public Boolean getTerminal() {
    return terminal;
  }

  public void setTerminal(Boolean terminal) {
    this.terminal = terminal;
  }


  public SpecGenerator throttleReadBpsDevice(Map<String, LinuxThrottleDevice> throttleReadBpsDevice) {
    this.throttleReadBpsDevice = throttleReadBpsDevice;
    return this;
  }

  public SpecGenerator putThrottleReadBpsDeviceItem(String key, LinuxThrottleDevice throttleReadBpsDeviceItem) {
    if (this.throttleReadBpsDevice == null) {
      this.throttleReadBpsDevice = new HashMap<>();
    }
    this.throttleReadBpsDevice.put(key, throttleReadBpsDeviceItem);
    return this;
  }

  /**
   * IO read rate limit per cgroup per device, bytes per second
   * @return throttleReadBpsDevice
   */
  @jakarta.annotation.Nullable
  @Valid

  public Map<String, LinuxThrottleDevice> getThrottleReadBpsDevice() {
    return throttleReadBpsDevice;
  }

  public void setThrottleReadBpsDevice(Map<String, LinuxThrottleDevice> throttleReadBpsDevice) {
    this.throttleReadBpsDevice = throttleReadBpsDevice;
  }


  public SpecGenerator throttleReadIOPSDevice(Map<String, LinuxThrottleDevice> throttleReadIOPSDevice) {
    this.throttleReadIOPSDevice = throttleReadIOPSDevice;
    return this;
  }

  public SpecGenerator putThrottleReadIOPSDeviceItem(String key, LinuxThrottleDevice throttleReadIOPSDeviceItem) {
    if (this.throttleReadIOPSDevice == null) {
      this.throttleReadIOPSDevice = new HashMap<>();
    }
    this.throttleReadIOPSDevice.put(key, throttleReadIOPSDeviceItem);
    return this;
  }

  /**
   * IO read rate limit per cgroup per device, IO per second
   * @return throttleReadIOPSDevice
   */
  @jakarta.annotation.Nullable
  @Valid

  public Map<String, LinuxThrottleDevice> getThrottleReadIOPSDevice() {
    return throttleReadIOPSDevice;
  }

  public void setThrottleReadIOPSDevice(Map<String, LinuxThrottleDevice> throttleReadIOPSDevice) {
    this.throttleReadIOPSDevice = throttleReadIOPSDevice;
  }


  public SpecGenerator throttleWriteBpsDevice(Map<String, LinuxThrottleDevice> throttleWriteBpsDevice) {
    this.throttleWriteBpsDevice = throttleWriteBpsDevice;
    return this;
  }

  public SpecGenerator putThrottleWriteBpsDeviceItem(String key, LinuxThrottleDevice throttleWriteBpsDeviceItem) {
    if (this.throttleWriteBpsDevice == null) {
      this.throttleWriteBpsDevice = new HashMap<>();
    }
    this.throttleWriteBpsDevice.put(key, throttleWriteBpsDeviceItem);
    return this;
  }

  /**
   * IO write rate limit per cgroup per device, bytes per second
   * @return throttleWriteBpsDevice
   */
  @jakarta.annotation.Nullable
  @Valid

  public Map<String, LinuxThrottleDevice> getThrottleWriteBpsDevice() {
    return throttleWriteBpsDevice;
  }

  public void setThrottleWriteBpsDevice(Map<String, LinuxThrottleDevice> throttleWriteBpsDevice) {
    this.throttleWriteBpsDevice = throttleWriteBpsDevice;
  }


  public SpecGenerator throttleWriteIOPSDevice(Map<String, LinuxThrottleDevice> throttleWriteIOPSDevice) {
    this.throttleWriteIOPSDevice = throttleWriteIOPSDevice;
    return this;
  }

  public SpecGenerator putThrottleWriteIOPSDeviceItem(String key, LinuxThrottleDevice throttleWriteIOPSDeviceItem) {
    if (this.throttleWriteIOPSDevice == null) {
      this.throttleWriteIOPSDevice = new HashMap<>();
    }
    this.throttleWriteIOPSDevice.put(key, throttleWriteIOPSDeviceItem);
    return this;
  }

  /**
   * IO write rate limit per cgroup per device, IO per second
   * @return throttleWriteIOPSDevice
   */
  @jakarta.annotation.Nullable
  @Valid

  public Map<String, LinuxThrottleDevice> getThrottleWriteIOPSDevice() {
    return throttleWriteIOPSDevice;
  }

  public void setThrottleWriteIOPSDevice(Map<String, LinuxThrottleDevice> throttleWriteIOPSDevice) {
    this.throttleWriteIOPSDevice = throttleWriteIOPSDevice;
  }


  public SpecGenerator timeout(Integer timeout) {
    this.timeout = timeout;
    return this;
  }

  /**
   * Timeout is a maximum time in seconds the container will run before main process is sent SIGKILL. If 0 is used, signal will not be sent. Container can run indefinitely if they do not stop after the default termination signal. Optional.
   * @return timeout
   */
  @jakarta.annotation.Nullable

  public Integer getTimeout() {
    return timeout;
  }

  public void setTimeout(Integer timeout) {
    this.timeout = timeout;
  }


  public SpecGenerator timezone(String timezone) {
    this.timezone = timezone;
    return this;
  }

  /**
   * Timezone is the timezone inside the container. Local means it has the same timezone as the host machine Optional.
   * @return timezone
   */
  @jakarta.annotation.Nullable

  public String getTimezone() {
    return timezone;
  }

  public void setTimezone(String timezone) {
    this.timezone = timezone;
  }


  public SpecGenerator umask(String umask) {
    this.umask = umask;
    return this;
  }

  /**
   * Umask is the umask the init process of the container will be run with.
   * @return umask
   */
  @jakarta.annotation.Nullable

  public String getUmask() {
    return umask;
  }

  public void setUmask(String umask) {
    this.umask = umask;
  }


  public SpecGenerator unified(Map<String, String> unified) {
    this.unified = unified;
    return this;
  }

  public SpecGenerator putUnifiedItem(String key, String unifiedItem) {
    if (this.unified == null) {
      this.unified = new HashMap<>();
    }
    this.unified.put(key, unifiedItem);
    return this;
  }

  /**
   * CgroupConf are key-value options passed into the container runtime that are used to configure cgroup v2. Optional.
   * @return unified
   */
  @jakarta.annotation.Nullable

  public Map<String, String> getUnified() {
    return unified;
  }

  public void setUnified(Map<String, String> unified) {
    this.unified = unified;
  }


  public SpecGenerator unmask(List<String> unmask) {
    this.unmask = unmask;
    return this;
  }

  public SpecGenerator addUnmaskItem(String unmaskItem) {
    if (this.unmask == null) {
      this.unmask = new ArrayList<>();
    }
    this.unmask.add(unmaskItem);
    return this;
  }

  /**
   * Unmask a path in the container. Some paths are masked by default, preventing them from being accessed within the container; this undoes that masking. If ALL is passed, all paths will be unmasked. Optional.
   * @return unmask
   */
  @jakarta.annotation.Nullable

  public List<String> getUnmask() {
    return unmask;
  }

  public void setUnmask(List<String> unmask) {
    this.unmask = unmask;
  }


  public SpecGenerator unsetenv(List<String> unsetenv) {
    this.unsetenv = unsetenv;
    return this;
  }

  public SpecGenerator addUnsetenvItem(String unsetenvItem) {
    if (this.unsetenv == null) {
      this.unsetenv = new ArrayList<>();
    }
    this.unsetenv.add(unsetenvItem);
    return this;
  }

  /**
   * UnsetEnv unsets the specified default environment variables from the image or from built-in or containers.conf Optional.
   * @return unsetenv
   */
  @jakarta.annotation.Nullable

  public List<String> getUnsetenv() {
    return unsetenv;
  }

  public void setUnsetenv(List<String> unsetenv) {
    this.unsetenv = unsetenv;
  }


  public SpecGenerator unsetenvall(Boolean unsetenvall) {
    this.unsetenvall = unsetenvall;
    return this;
  }

  /**
   * UnsetEnvAll unsetall default environment variables from the image or from built-in or containers.conf UnsetEnvAll unsets all default environment variables from the image or from built-in Optional.
   * @return unsetenvall
   */
  @jakarta.annotation.Nullable

  public Boolean getUnsetenvall() {
    return unsetenvall;
  }

  public void setUnsetenvall(Boolean unsetenvall) {
    this.unsetenvall = unsetenvall;
  }


  public SpecGenerator useImageHostname(Boolean useImageHostname) {
    this.useImageHostname = useImageHostname;
    return this;
  }

  /**
   * UseImageHostname indicates that /etc/hostname should not be managed by Podman, and instead sourced from the image. Optional.
   * @return useImageHostname
   */
  @jakarta.annotation.Nullable

  public Boolean getUseImageHostname() {
    return useImageHostname;
  }

  public void setUseImageHostname(Boolean useImageHostname) {
    this.useImageHostname = useImageHostname;
  }


  public SpecGenerator useImageHosts(Boolean useImageHosts) {
    this.useImageHosts = useImageHosts;
    return this;
  }

  /**
   * UseImageHosts indicates that /etc/hosts should not be managed by Podman, and instead sourced from the image. Conflicts with HostAdd. Optional.
   * @return useImageHosts
   */
  @jakarta.annotation.Nullable

  public Boolean getUseImageHosts() {
    return useImageHosts;
  }

  public void setUseImageHosts(Boolean useImageHosts) {
    this.useImageHosts = useImageHosts;
  }


  public SpecGenerator useImageResolveConf(Boolean useImageResolveConf) {
    this.useImageResolveConf = useImageResolveConf;
    return this;
  }

  /**
   * UseImageResolvConf indicates that resolv.conf should not be managed by Podman, but instead sourced from the image. Conflicts with DNSServer, DNSSearch, DNSOption. Optional.
   * @return useImageResolveConf
   */
  @jakarta.annotation.Nullable

  public Boolean getUseImageResolveConf() {
    return useImageResolveConf;
  }

  public void setUseImageResolveConf(Boolean useImageResolveConf) {
    this.useImageResolveConf = useImageResolveConf;
  }


  public SpecGenerator user(String user) {
    this.user = user;
    return this;
  }

  /**
   * User is the user the container will be run as. Can be given as a UID or a username; if a username, it will be resolved within the container, using the container&#39;s /etc/passwd. If unset, the container will be run as root. Optional.
   * @return user
   */
  @jakarta.annotation.Nullable

  public String getUser() {
    return user;
  }

  public void setUser(String user) {
    this.user = user;
  }


  public SpecGenerator userns(Namespace userns) {
    this.userns = userns;
    return this;
  }

  /**
   * Get userns
   * @return userns
   */
  @jakarta.annotation.Nullable
  @Valid

  public Namespace getUserns() {
    return userns;
  }

  public void setUserns(Namespace userns) {
    this.userns = userns;
  }


  public SpecGenerator utsns(Namespace utsns) {
    this.utsns = utsns;
    return this;
  }

  /**
   * Get utsns
   * @return utsns
   */
  @jakarta.annotation.Nullable
  @Valid

  public Namespace getUtsns() {
    return utsns;
  }

  public void setUtsns(Namespace utsns) {
    this.utsns = utsns;
  }


  public SpecGenerator _volatile(Boolean _volatile) {
    this._volatile = _volatile;
    return this;
  }

  /**
   * Volatile specifies whether the container storage can be optimized at the cost of not syncing all the dirty files in memory. Optional.
   * @return _volatile
   */
  @jakarta.annotation.Nullable

  public Boolean getVolatile() {
    return _volatile;
  }

  public void setVolatile(Boolean _volatile) {
    this._volatile = _volatile;
  }


  public SpecGenerator volumes(List<@Valid NamedVolume> volumes) {
    this.volumes = volumes;
    return this;
  }

  public SpecGenerator addVolumesItem(NamedVolume volumesItem) {
    if (this.volumes == null) {
      this.volumes = new ArrayList<>();
    }
    this.volumes.add(volumesItem);
    return this;
  }

  /**
   * Volumes are named volumes that will be added to the container. These will supersede Image Volumes and VolumesFrom volumes where there are conflicts. Optional.
   * @return volumes
   */
  @jakarta.annotation.Nullable
  @Valid

  public List<@Valid NamedVolume> getVolumes() {
    return volumes;
  }

  public void setVolumes(List<@Valid NamedVolume> volumes) {
    this.volumes = volumes;
  }


  public SpecGenerator volumesFrom(List<String> volumesFrom) {
    this.volumesFrom = volumesFrom;
    return this;
  }

  public SpecGenerator addVolumesFromItem(String volumesFromItem) {
    if (this.volumesFrom == null) {
      this.volumesFrom = new ArrayList<>();
    }
    this.volumesFrom.add(volumesFromItem);
    return this;
  }

  /**
   * VolumesFrom is a set of containers whose volumes will be added to this container. The name or ID of the container must be provided, and may optionally be followed by a : and then one or more comma-separated options. Valid options are &#39;ro&#39;, &#39;rw&#39;, and &#39;z&#39;. Options will be used for all volumes sourced from the container. Optional.
   * @return volumesFrom
   */
  @jakarta.annotation.Nullable

  public List<String> getVolumesFrom() {
    return volumesFrom;
  }

  public void setVolumesFrom(List<String> volumesFrom) {
    this.volumesFrom = volumesFrom;
  }


  public SpecGenerator weightDevice(Map<String, LinuxWeightDevice> weightDevice) {
    this.weightDevice = weightDevice;
    return this;
  }

  public SpecGenerator putWeightDeviceItem(String key, LinuxWeightDevice weightDeviceItem) {
    if (this.weightDevice == null) {
      this.weightDevice = new HashMap<>();
    }
    this.weightDevice.put(key, weightDeviceItem);
    return this;
  }

  /**
   * Weight per cgroup per device, can override BlkioWeight
   * @return weightDevice
   */
  @jakarta.annotation.Nullable
  @Valid

  public Map<String, LinuxWeightDevice> getWeightDevice() {
    return weightDevice;
  }

  public void setWeightDevice(Map<String, LinuxWeightDevice> weightDevice) {
    this.weightDevice = weightDevice;
  }


  public SpecGenerator workDir(String workDir) {
    this.workDir = workDir;
    return this;
  }

  /**
   * WorkDir is the container&#39;s working directory. If unset, the default, /, will be used. Optional.
   * @return workDir
   */
  @jakarta.annotation.Nullable

  public String getWorkDir() {
    return workDir;
  }

  public void setWorkDir(String workDir) {
    this.workDir = workDir;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SpecGenerator specGenerator = (SpecGenerator) o;
    return Objects.equals(this.networks, specGenerator.networks) &&
        Objects.equals(this.annotations, specGenerator.annotations) &&
        Objects.equals(this.apparmorProfile, specGenerator.apparmorProfile) &&
        Objects.equals(this.baseHostsFile, specGenerator.baseHostsFile) &&
        Objects.equals(this.capAdd, specGenerator.capAdd) &&
        Objects.equals(this.capDrop, specGenerator.capDrop) &&
        Objects.equals(this.cgroupParent, specGenerator.cgroupParent) &&
        Objects.equals(this.cgroupns, specGenerator.cgroupns) &&
        Objects.equals(this.cgroupsMode, specGenerator.cgroupsMode) &&
        Objects.equals(this.chrootDirectories, specGenerator.chrootDirectories) &&
        Objects.equals(this.cniNetworks, specGenerator.cniNetworks) &&
        Objects.equals(this.command, specGenerator.command) &&
        Objects.equals(this.conmonPidFile, specGenerator.conmonPidFile) &&
        Objects.equals(this.containerCreateCommand, specGenerator.containerCreateCommand) &&
        Objects.equals(this.createWorkingDir, specGenerator.createWorkingDir) &&
        Objects.equals(this.dependencyContainers, specGenerator.dependencyContainers) &&
        Objects.equals(this.deviceCgroupRule, specGenerator.deviceCgroupRule) &&
        Objects.equals(this.devices, specGenerator.devices) &&
        Objects.equals(this.devicesFrom, specGenerator.devicesFrom) &&
        Objects.equals(this.dnsOption, specGenerator.dnsOption) &&
        Objects.equals(this.dnsSearch, specGenerator.dnsSearch) &&
        Objects.equals(this.dnsServer, specGenerator.dnsServer) &&
        Objects.equals(this.entrypoint, specGenerator.entrypoint) &&
        Objects.equals(this.env, specGenerator.env) &&
        Objects.equals(this.envHost, specGenerator.envHost) &&
        Objects.equals(this.envmerge, specGenerator.envmerge) &&
        Objects.equals(this.expose, specGenerator.expose) &&
        Objects.equals(this.groupEntry, specGenerator.groupEntry) &&
        Objects.equals(this.groups, specGenerator.groups) &&
        Objects.equals(this.healthCheckOnFailureAction, specGenerator.healthCheckOnFailureAction) &&
        Objects.equals(this.healthLogDestination, specGenerator.healthLogDestination) &&
        Objects.equals(this.healthMaxLogCount, specGenerator.healthMaxLogCount) &&
        Objects.equals(this.healthMaxLogSize, specGenerator.healthMaxLogSize) &&
        Objects.equals(this.healthconfig, specGenerator.healthconfig) &&
        Objects.equals(this.hostDeviceList, specGenerator.hostDeviceList) &&
        Objects.equals(this.hostadd, specGenerator.hostadd) &&
        Objects.equals(this.hostname, specGenerator.hostname) &&
        Objects.equals(this.hostusers, specGenerator.hostusers) &&
        Objects.equals(this.httpproxy, specGenerator.httpproxy) &&
        Objects.equals(this.idmappings, specGenerator.idmappings) &&
        Objects.equals(this.image, specGenerator.image) &&
        Objects.equals(this.imageArch, specGenerator.imageArch) &&
        Objects.equals(this.imageOs, specGenerator.imageOs) &&
        Objects.equals(this.imageVariant, specGenerator.imageVariant) &&
        Objects.equals(this.imageVolumeMode, specGenerator.imageVolumeMode) &&
        Objects.equals(this.imageVolumes, specGenerator.imageVolumes) &&
        Objects.equals(this.init, specGenerator.init) &&
        Objects.equals(this.initContainerType, specGenerator.initContainerType) &&
        Objects.equals(this.initPath, specGenerator.initPath) &&
        Objects.equals(this.intelRdt, specGenerator.intelRdt) &&
        Objects.equals(this.ipcns, specGenerator.ipcns) &&
        Objects.equals(this.labelNested, specGenerator.labelNested) &&
        Objects.equals(this.labels, specGenerator.labels) &&
        Objects.equals(this.logConfiguration, specGenerator.logConfiguration) &&
        Objects.equals(this.managePassword, specGenerator.managePassword) &&
        Objects.equals(this.mask, specGenerator.mask) &&
        Objects.equals(this.mounts, specGenerator.mounts) &&
        Objects.equals(this.name, specGenerator.name) &&
        Objects.equals(this.netns, specGenerator.netns) &&
        Objects.equals(this.networkOptions, specGenerator.networkOptions) &&
        Objects.equals(this.noNewPrivileges, specGenerator.noNewPrivileges) &&
        Objects.equals(this.ociRuntime, specGenerator.ociRuntime) &&
        Objects.equals(this.oomScoreAdj, specGenerator.oomScoreAdj) &&
        Objects.equals(this.overlayVolumes, specGenerator.overlayVolumes) &&
        Objects.equals(this.passwdEntry, specGenerator.passwdEntry) &&
        Objects.equals(this.personality, specGenerator.personality) &&
        Objects.equals(this.pidns, specGenerator.pidns) &&
        Objects.equals(this.pod, specGenerator.pod) &&
        Objects.equals(this.portmappings, specGenerator.portmappings) &&
        Objects.equals(this.privileged, specGenerator.privileged) &&
        Objects.equals(this.procfsOpts, specGenerator.procfsOpts) &&
        Objects.equals(this.publishImagePorts, specGenerator.publishImagePorts) &&
        Objects.equals(this.rLimits, specGenerator.rLimits) &&
        Objects.equals(this.rawImageName, specGenerator.rawImageName) &&
        Objects.equals(this.readOnlyFilesystem, specGenerator.readOnlyFilesystem) &&
        Objects.equals(this.readWriteTmpfs, specGenerator.readWriteTmpfs) &&
        Objects.equals(this.remove, specGenerator.remove) &&
        Objects.equals(this.removeImage, specGenerator.removeImage) &&
        Objects.equals(this.resourceLimits, specGenerator.resourceLimits) &&
        Objects.equals(this.restartPolicy, specGenerator.restartPolicy) &&
        Objects.equals(this.restartTries, specGenerator.restartTries) &&
        Objects.equals(this.rootfs, specGenerator.rootfs) &&
        Objects.equals(this.rootfsMapping, specGenerator.rootfsMapping) &&
        Objects.equals(this.rootfsOverlay, specGenerator.rootfsOverlay) &&
        Objects.equals(this.rootfsPropagation, specGenerator.rootfsPropagation) &&
        Objects.equals(this.sdnotifyMode, specGenerator.sdnotifyMode) &&
        Objects.equals(this.seccompPolicy, specGenerator.seccompPolicy) &&
        Objects.equals(this.seccompProfilePath, specGenerator.seccompProfilePath) &&
        Objects.equals(this.secretEnv, specGenerator.secretEnv) &&
        Objects.equals(this.secrets, specGenerator.secrets) &&
        Objects.equals(this.selinuxOpts, specGenerator.selinuxOpts) &&
        Objects.equals(this.shmSize, specGenerator.shmSize) &&
        Objects.equals(this.shmSizeSystemd, specGenerator.shmSizeSystemd) &&
        Objects.equals(this.startupHealthConfig, specGenerator.startupHealthConfig) &&
        Objects.equals(this.stdin, specGenerator.stdin) &&
        Objects.equals(this.stopSignal, specGenerator.stopSignal) &&
        Objects.equals(this.stopTimeout, specGenerator.stopTimeout) &&
        Objects.equals(this.storageOpts, specGenerator.storageOpts) &&
        Objects.equals(this.sysctl, specGenerator.sysctl) &&
        Objects.equals(this.systemd, specGenerator.systemd) &&
        Objects.equals(this.terminal, specGenerator.terminal) &&
        Objects.equals(this.throttleReadBpsDevice, specGenerator.throttleReadBpsDevice) &&
        Objects.equals(this.throttleReadIOPSDevice, specGenerator.throttleReadIOPSDevice) &&
        Objects.equals(this.throttleWriteBpsDevice, specGenerator.throttleWriteBpsDevice) &&
        Objects.equals(this.throttleWriteIOPSDevice, specGenerator.throttleWriteIOPSDevice) &&
        Objects.equals(this.timeout, specGenerator.timeout) &&
        Objects.equals(this.timezone, specGenerator.timezone) &&
        Objects.equals(this.umask, specGenerator.umask) &&
        Objects.equals(this.unified, specGenerator.unified) &&
        Objects.equals(this.unmask, specGenerator.unmask) &&
        Objects.equals(this.unsetenv, specGenerator.unsetenv) &&
        Objects.equals(this.unsetenvall, specGenerator.unsetenvall) &&
        Objects.equals(this.useImageHostname, specGenerator.useImageHostname) &&
        Objects.equals(this.useImageHosts, specGenerator.useImageHosts) &&
        Objects.equals(this.useImageResolveConf, specGenerator.useImageResolveConf) &&
        Objects.equals(this.user, specGenerator.user) &&
        Objects.equals(this.userns, specGenerator.userns) &&
        Objects.equals(this.utsns, specGenerator.utsns) &&
        Objects.equals(this._volatile, specGenerator._volatile) &&
        Objects.equals(this.volumes, specGenerator.volumes) &&
        Objects.equals(this.volumesFrom, specGenerator.volumesFrom) &&
        Objects.equals(this.weightDevice, specGenerator.weightDevice) &&
        Objects.equals(this.workDir, specGenerator.workDir);
  }

  @Override
  public int hashCode() {
    return Objects.hash(networks, annotations, apparmorProfile, baseHostsFile, capAdd, capDrop, cgroupParent, cgroupns, cgroupsMode, chrootDirectories, cniNetworks, command, conmonPidFile, containerCreateCommand, createWorkingDir, dependencyContainers, deviceCgroupRule, devices, devicesFrom, dnsOption, dnsSearch, dnsServer, entrypoint, env, envHost, envmerge, expose, groupEntry, groups, healthCheckOnFailureAction, healthLogDestination, healthMaxLogCount, healthMaxLogSize, healthconfig, hostDeviceList, hostadd, hostname, hostusers, httpproxy, idmappings, image, imageArch, imageOs, imageVariant, imageVolumeMode, imageVolumes, init, initContainerType, initPath, intelRdt, ipcns, labelNested, labels, logConfiguration, managePassword, mask, mounts, name, netns, networkOptions, noNewPrivileges, ociRuntime, oomScoreAdj, overlayVolumes, passwdEntry, personality, pidns, pod, portmappings, privileged, procfsOpts, publishImagePorts, rLimits, rawImageName, readOnlyFilesystem, readWriteTmpfs, remove, removeImage, resourceLimits, restartPolicy, restartTries, rootfs, rootfsMapping, rootfsOverlay, rootfsPropagation, sdnotifyMode, seccompPolicy, seccompProfilePath, secretEnv, secrets, selinuxOpts, shmSize, shmSizeSystemd, startupHealthConfig, stdin, stopSignal, stopTimeout, storageOpts, sysctl, systemd, terminal, throttleReadBpsDevice, throttleReadIOPSDevice, throttleWriteBpsDevice, throttleWriteIOPSDevice, timeout, timezone, umask, unified, unmask, unsetenv, unsetenvall, useImageHostname, useImageHosts, useImageResolveConf, user, userns, utsns, _volatile, volumes, volumesFrom, weightDevice, workDir);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SpecGenerator {\n");
    sb.append("    networks: ").append(toIndentedString(networks)).append("\n");
    sb.append("    annotations: ").append(toIndentedString(annotations)).append("\n");
    sb.append("    apparmorProfile: ").append(toIndentedString(apparmorProfile)).append("\n");
    sb.append("    baseHostsFile: ").append(toIndentedString(baseHostsFile)).append("\n");
    sb.append("    capAdd: ").append(toIndentedString(capAdd)).append("\n");
    sb.append("    capDrop: ").append(toIndentedString(capDrop)).append("\n");
    sb.append("    cgroupParent: ").append(toIndentedString(cgroupParent)).append("\n");
    sb.append("    cgroupns: ").append(toIndentedString(cgroupns)).append("\n");
    sb.append("    cgroupsMode: ").append(toIndentedString(cgroupsMode)).append("\n");
    sb.append("    chrootDirectories: ").append(toIndentedString(chrootDirectories)).append("\n");
    sb.append("    cniNetworks: ").append(toIndentedString(cniNetworks)).append("\n");
    sb.append("    command: ").append(toIndentedString(command)).append("\n");
    sb.append("    conmonPidFile: ").append(toIndentedString(conmonPidFile)).append("\n");
    sb.append("    containerCreateCommand: ").append(toIndentedString(containerCreateCommand)).append("\n");
    sb.append("    createWorkingDir: ").append(toIndentedString(createWorkingDir)).append("\n");
    sb.append("    dependencyContainers: ").append(toIndentedString(dependencyContainers)).append("\n");
    sb.append("    deviceCgroupRule: ").append(toIndentedString(deviceCgroupRule)).append("\n");
    sb.append("    devices: ").append(toIndentedString(devices)).append("\n");
    sb.append("    devicesFrom: ").append(toIndentedString(devicesFrom)).append("\n");
    sb.append("    dnsOption: ").append(toIndentedString(dnsOption)).append("\n");
    sb.append("    dnsSearch: ").append(toIndentedString(dnsSearch)).append("\n");
    sb.append("    dnsServer: ").append(toIndentedString(dnsServer)).append("\n");
    sb.append("    entrypoint: ").append(toIndentedString(entrypoint)).append("\n");
    sb.append("    env: ").append(toIndentedString(env)).append("\n");
    sb.append("    envHost: ").append(toIndentedString(envHost)).append("\n");
    sb.append("    envmerge: ").append(toIndentedString(envmerge)).append("\n");
    sb.append("    expose: ").append(toIndentedString(expose)).append("\n");
    sb.append("    groupEntry: ").append(toIndentedString(groupEntry)).append("\n");
    sb.append("    groups: ").append(toIndentedString(groups)).append("\n");
    sb.append("    healthCheckOnFailureAction: ").append(toIndentedString(healthCheckOnFailureAction)).append("\n");
    sb.append("    healthLogDestination: ").append(toIndentedString(healthLogDestination)).append("\n");
    sb.append("    healthMaxLogCount: ").append(toIndentedString(healthMaxLogCount)).append("\n");
    sb.append("    healthMaxLogSize: ").append(toIndentedString(healthMaxLogSize)).append("\n");
    sb.append("    healthconfig: ").append(toIndentedString(healthconfig)).append("\n");
    sb.append("    hostDeviceList: ").append(toIndentedString(hostDeviceList)).append("\n");
    sb.append("    hostadd: ").append(toIndentedString(hostadd)).append("\n");
    sb.append("    hostname: ").append(toIndentedString(hostname)).append("\n");
    sb.append("    hostusers: ").append(toIndentedString(hostusers)).append("\n");
    sb.append("    httpproxy: ").append(toIndentedString(httpproxy)).append("\n");
    sb.append("    idmappings: ").append(toIndentedString(idmappings)).append("\n");
    sb.append("    image: ").append(toIndentedString(image)).append("\n");
    sb.append("    imageArch: ").append(toIndentedString(imageArch)).append("\n");
    sb.append("    imageOs: ").append(toIndentedString(imageOs)).append("\n");
    sb.append("    imageVariant: ").append(toIndentedString(imageVariant)).append("\n");
    sb.append("    imageVolumeMode: ").append(toIndentedString(imageVolumeMode)).append("\n");
    sb.append("    imageVolumes: ").append(toIndentedString(imageVolumes)).append("\n");
    sb.append("    init: ").append(toIndentedString(init)).append("\n");
    sb.append("    initContainerType: ").append(toIndentedString(initContainerType)).append("\n");
    sb.append("    initPath: ").append(toIndentedString(initPath)).append("\n");
    sb.append("    intelRdt: ").append(toIndentedString(intelRdt)).append("\n");
    sb.append("    ipcns: ").append(toIndentedString(ipcns)).append("\n");
    sb.append("    labelNested: ").append(toIndentedString(labelNested)).append("\n");
    sb.append("    labels: ").append(toIndentedString(labels)).append("\n");
    sb.append("    logConfiguration: ").append(toIndentedString(logConfiguration)).append("\n");
    sb.append("    managePassword: ").append(toIndentedString(managePassword)).append("\n");
    sb.append("    mask: ").append(toIndentedString(mask)).append("\n");
    sb.append("    mounts: ").append(toIndentedString(mounts)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    netns: ").append(toIndentedString(netns)).append("\n");
    sb.append("    networkOptions: ").append(toIndentedString(networkOptions)).append("\n");
    sb.append("    noNewPrivileges: ").append(toIndentedString(noNewPrivileges)).append("\n");
    sb.append("    ociRuntime: ").append(toIndentedString(ociRuntime)).append("\n");
    sb.append("    oomScoreAdj: ").append(toIndentedString(oomScoreAdj)).append("\n");
    sb.append("    overlayVolumes: ").append(toIndentedString(overlayVolumes)).append("\n");
    sb.append("    passwdEntry: ").append(toIndentedString(passwdEntry)).append("\n");
    sb.append("    personality: ").append(toIndentedString(personality)).append("\n");
    sb.append("    pidns: ").append(toIndentedString(pidns)).append("\n");
    sb.append("    pod: ").append(toIndentedString(pod)).append("\n");
    sb.append("    portmappings: ").append(toIndentedString(portmappings)).append("\n");
    sb.append("    privileged: ").append(toIndentedString(privileged)).append("\n");
    sb.append("    procfsOpts: ").append(toIndentedString(procfsOpts)).append("\n");
    sb.append("    publishImagePorts: ").append(toIndentedString(publishImagePorts)).append("\n");
    sb.append("    rLimits: ").append(toIndentedString(rLimits)).append("\n");
    sb.append("    rawImageName: ").append(toIndentedString(rawImageName)).append("\n");
    sb.append("    readOnlyFilesystem: ").append(toIndentedString(readOnlyFilesystem)).append("\n");
    sb.append("    readWriteTmpfs: ").append(toIndentedString(readWriteTmpfs)).append("\n");
    sb.append("    remove: ").append(toIndentedString(remove)).append("\n");
    sb.append("    removeImage: ").append(toIndentedString(removeImage)).append("\n");
    sb.append("    resourceLimits: ").append(toIndentedString(resourceLimits)).append("\n");
    sb.append("    restartPolicy: ").append(toIndentedString(restartPolicy)).append("\n");
    sb.append("    restartTries: ").append(toIndentedString(restartTries)).append("\n");
    sb.append("    rootfs: ").append(toIndentedString(rootfs)).append("\n");
    sb.append("    rootfsMapping: ").append(toIndentedString(rootfsMapping)).append("\n");
    sb.append("    rootfsOverlay: ").append(toIndentedString(rootfsOverlay)).append("\n");
    sb.append("    rootfsPropagation: ").append(toIndentedString(rootfsPropagation)).append("\n");
    sb.append("    sdnotifyMode: ").append(toIndentedString(sdnotifyMode)).append("\n");
    sb.append("    seccompPolicy: ").append(toIndentedString(seccompPolicy)).append("\n");
    sb.append("    seccompProfilePath: ").append(toIndentedString(seccompProfilePath)).append("\n");
    sb.append("    secretEnv: ").append(toIndentedString(secretEnv)).append("\n");
    sb.append("    secrets: ").append(toIndentedString(secrets)).append("\n");
    sb.append("    selinuxOpts: ").append(toIndentedString(selinuxOpts)).append("\n");
    sb.append("    shmSize: ").append(toIndentedString(shmSize)).append("\n");
    sb.append("    shmSizeSystemd: ").append(toIndentedString(shmSizeSystemd)).append("\n");
    sb.append("    startupHealthConfig: ").append(toIndentedString(startupHealthConfig)).append("\n");
    sb.append("    stdin: ").append(toIndentedString(stdin)).append("\n");
    sb.append("    stopSignal: ").append(toIndentedString(stopSignal)).append("\n");
    sb.append("    stopTimeout: ").append(toIndentedString(stopTimeout)).append("\n");
    sb.append("    storageOpts: ").append(toIndentedString(storageOpts)).append("\n");
    sb.append("    sysctl: ").append(toIndentedString(sysctl)).append("\n");
    sb.append("    systemd: ").append(toIndentedString(systemd)).append("\n");
    sb.append("    terminal: ").append(toIndentedString(terminal)).append("\n");
    sb.append("    throttleReadBpsDevice: ").append(toIndentedString(throttleReadBpsDevice)).append("\n");
    sb.append("    throttleReadIOPSDevice: ").append(toIndentedString(throttleReadIOPSDevice)).append("\n");
    sb.append("    throttleWriteBpsDevice: ").append(toIndentedString(throttleWriteBpsDevice)).append("\n");
    sb.append("    throttleWriteIOPSDevice: ").append(toIndentedString(throttleWriteIOPSDevice)).append("\n");
    sb.append("    timeout: ").append(toIndentedString(timeout)).append("\n");
    sb.append("    timezone: ").append(toIndentedString(timezone)).append("\n");
    sb.append("    umask: ").append(toIndentedString(umask)).append("\n");
    sb.append("    unified: ").append(toIndentedString(unified)).append("\n");
    sb.append("    unmask: ").append(toIndentedString(unmask)).append("\n");
    sb.append("    unsetenv: ").append(toIndentedString(unsetenv)).append("\n");
    sb.append("    unsetenvall: ").append(toIndentedString(unsetenvall)).append("\n");
    sb.append("    useImageHostname: ").append(toIndentedString(useImageHostname)).append("\n");
    sb.append("    useImageHosts: ").append(toIndentedString(useImageHosts)).append("\n");
    sb.append("    useImageResolveConf: ").append(toIndentedString(useImageResolveConf)).append("\n");
    sb.append("    user: ").append(toIndentedString(user)).append("\n");
    sb.append("    userns: ").append(toIndentedString(userns)).append("\n");
    sb.append("    utsns: ").append(toIndentedString(utsns)).append("\n");
    sb.append("    _volatile: ").append(toIndentedString(_volatile)).append("\n");
    sb.append("    volumes: ").append(toIndentedString(volumes)).append("\n");
    sb.append("    volumesFrom: ").append(toIndentedString(volumesFrom)).append("\n");
    sb.append("    weightDevice: ").append(toIndentedString(weightDevice)).append("\n");
    sb.append("    workDir: ").append(toIndentedString(workDir)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("Networks");
    openapiFields.add("annotations");
    openapiFields.add("apparmor_profile");
    openapiFields.add("base_hosts_file");
    openapiFields.add("cap_add");
    openapiFields.add("cap_drop");
    openapiFields.add("cgroup_parent");
    openapiFields.add("cgroupns");
    openapiFields.add("cgroups_mode");
    openapiFields.add("chroot_directories");
    openapiFields.add("cni_networks");
    openapiFields.add("command");
    openapiFields.add("conmon_pid_file");
    openapiFields.add("containerCreateCommand");
    openapiFields.add("create_working_dir");
    openapiFields.add("dependencyContainers");
    openapiFields.add("device_cgroup_rule");
    openapiFields.add("devices");
    openapiFields.add("devices_from");
    openapiFields.add("dns_option");
    openapiFields.add("dns_search");
    openapiFields.add("dns_server");
    openapiFields.add("entrypoint");
    openapiFields.add("env");
    openapiFields.add("env_host");
    openapiFields.add("envmerge");
    openapiFields.add("expose");
    openapiFields.add("group_entry");
    openapiFields.add("groups");
    openapiFields.add("health_check_on_failure_action");
    openapiFields.add("healthLogDestination");
    openapiFields.add("healthMaxLogCount");
    openapiFields.add("healthMaxLogSize");
    openapiFields.add("healthconfig");
    openapiFields.add("host_device_list");
    openapiFields.add("hostadd");
    openapiFields.add("hostname");
    openapiFields.add("hostusers");
    openapiFields.add("httpproxy");
    openapiFields.add("idmappings");
    openapiFields.add("image");
    openapiFields.add("image_arch");
    openapiFields.add("image_os");
    openapiFields.add("image_variant");
    openapiFields.add("image_volume_mode");
    openapiFields.add("image_volumes");
    openapiFields.add("init");
    openapiFields.add("init_container_type");
    openapiFields.add("init_path");
    openapiFields.add("intelRdt");
    openapiFields.add("ipcns");
    openapiFields.add("label_nested");
    openapiFields.add("labels");
    openapiFields.add("log_configuration");
    openapiFields.add("manage_password");
    openapiFields.add("mask");
    openapiFields.add("mounts");
    openapiFields.add("name");
    openapiFields.add("netns");
    openapiFields.add("network_options");
    openapiFields.add("no_new_privileges");
    openapiFields.add("oci_runtime");
    openapiFields.add("oom_score_adj");
    openapiFields.add("overlay_volumes");
    openapiFields.add("passwd_entry");
    openapiFields.add("personality");
    openapiFields.add("pidns");
    openapiFields.add("pod");
    openapiFields.add("portmappings");
    openapiFields.add("privileged");
    openapiFields.add("procfs_opts");
    openapiFields.add("publish_image_ports");
    openapiFields.add("r_limits");
    openapiFields.add("raw_image_name");
    openapiFields.add("read_only_filesystem");
    openapiFields.add("read_write_tmpfs");
    openapiFields.add("remove");
    openapiFields.add("removeImage");
    openapiFields.add("resource_limits");
    openapiFields.add("restart_policy");
    openapiFields.add("restart_tries");
    openapiFields.add("rootfs");
    openapiFields.add("rootfs_mapping");
    openapiFields.add("rootfs_overlay");
    openapiFields.add("rootfs_propagation");
    openapiFields.add("sdnotifyMode");
    openapiFields.add("seccomp_policy");
    openapiFields.add("seccomp_profile_path");
    openapiFields.add("secret_env");
    openapiFields.add("secrets");
    openapiFields.add("selinux_opts");
    openapiFields.add("shm_size");
    openapiFields.add("shm_size_systemd");
    openapiFields.add("startupHealthConfig");
    openapiFields.add("stdin");
    openapiFields.add("stop_signal");
    openapiFields.add("stop_timeout");
    openapiFields.add("storage_opts");
    openapiFields.add("sysctl");
    openapiFields.add("systemd");
    openapiFields.add("terminal");
    openapiFields.add("throttleReadBpsDevice");
    openapiFields.add("throttleReadIOPSDevice");
    openapiFields.add("throttleWriteBpsDevice");
    openapiFields.add("throttleWriteIOPSDevice");
    openapiFields.add("timeout");
    openapiFields.add("timezone");
    openapiFields.add("umask");
    openapiFields.add("unified");
    openapiFields.add("unmask");
    openapiFields.add("unsetenv");
    openapiFields.add("unsetenvall");
    openapiFields.add("use_image_hostname");
    openapiFields.add("use_image_hosts");
    openapiFields.add("use_image_resolve_conf");
    openapiFields.add("user");
    openapiFields.add("userns");
    openapiFields.add("utsns");
    openapiFields.add("volatile");
    openapiFields.add("volumes");
    openapiFields.add("volumes_from");
    openapiFields.add("weightDevice");
    openapiFields.add("work_dir");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

  /**
   * Validates the JSON Element and throws an exception if issues found
   *
   * @param jsonElement JSON Element
   * @throws IOException if the JSON Element is invalid with respect to SpecGenerator
   */
  public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (jsonElement == null) {
        if (!SpecGenerator.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in SpecGenerator is not found in the empty JSON string", SpecGenerator.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!SpecGenerator.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `SpecGenerator` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if ((jsonObj.get("apparmor_profile") != null && !jsonObj.get("apparmor_profile").isJsonNull()) && !jsonObj.get("apparmor_profile").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `apparmor_profile` to be a primitive type in the JSON string but got `%s`", jsonObj.get("apparmor_profile").toString()));
      }
      if ((jsonObj.get("base_hosts_file") != null && !jsonObj.get("base_hosts_file").isJsonNull()) && !jsonObj.get("base_hosts_file").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `base_hosts_file` to be a primitive type in the JSON string but got `%s`", jsonObj.get("base_hosts_file").toString()));
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("cap_add") != null && !jsonObj.get("cap_add").isJsonNull() && !jsonObj.get("cap_add").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `cap_add` to be an array in the JSON string but got `%s`", jsonObj.get("cap_add").toString()));
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("cap_drop") != null && !jsonObj.get("cap_drop").isJsonNull() && !jsonObj.get("cap_drop").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `cap_drop` to be an array in the JSON string but got `%s`", jsonObj.get("cap_drop").toString()));
      }
      if ((jsonObj.get("cgroup_parent") != null && !jsonObj.get("cgroup_parent").isJsonNull()) && !jsonObj.get("cgroup_parent").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `cgroup_parent` to be a primitive type in the JSON string but got `%s`", jsonObj.get("cgroup_parent").toString()));
      }
      // validate the optional field `cgroupns`
      if (jsonObj.get("cgroupns") != null && !jsonObj.get("cgroupns").isJsonNull()) {
        Namespace.validateJsonElement(jsonObj.get("cgroupns"));
      }
      if ((jsonObj.get("cgroups_mode") != null && !jsonObj.get("cgroups_mode").isJsonNull()) && !jsonObj.get("cgroups_mode").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `cgroups_mode` to be a primitive type in the JSON string but got `%s`", jsonObj.get("cgroups_mode").toString()));
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("chroot_directories") != null && !jsonObj.get("chroot_directories").isJsonNull() && !jsonObj.get("chroot_directories").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `chroot_directories` to be an array in the JSON string but got `%s`", jsonObj.get("chroot_directories").toString()));
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("cni_networks") != null && !jsonObj.get("cni_networks").isJsonNull() && !jsonObj.get("cni_networks").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `cni_networks` to be an array in the JSON string but got `%s`", jsonObj.get("cni_networks").toString()));
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("command") != null && !jsonObj.get("command").isJsonNull() && !jsonObj.get("command").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `command` to be an array in the JSON string but got `%s`", jsonObj.get("command").toString()));
      }
      if ((jsonObj.get("conmon_pid_file") != null && !jsonObj.get("conmon_pid_file").isJsonNull()) && !jsonObj.get("conmon_pid_file").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `conmon_pid_file` to be a primitive type in the JSON string but got `%s`", jsonObj.get("conmon_pid_file").toString()));
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("containerCreateCommand") != null && !jsonObj.get("containerCreateCommand").isJsonNull() && !jsonObj.get("containerCreateCommand").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `containerCreateCommand` to be an array in the JSON string but got `%s`", jsonObj.get("containerCreateCommand").toString()));
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("dependencyContainers") != null && !jsonObj.get("dependencyContainers").isJsonNull() && !jsonObj.get("dependencyContainers").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `dependencyContainers` to be an array in the JSON string but got `%s`", jsonObj.get("dependencyContainers").toString()));
      }
      if (jsonObj.get("device_cgroup_rule") != null && !jsonObj.get("device_cgroup_rule").isJsonNull()) {
        JsonArray jsonArraydeviceCgroupRule = jsonObj.getAsJsonArray("device_cgroup_rule");
        if (jsonArraydeviceCgroupRule != null) {
          // ensure the json data is an array
          if (!jsonObj.get("device_cgroup_rule").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `device_cgroup_rule` to be an array in the JSON string but got `%s`", jsonObj.get("device_cgroup_rule").toString()));
          }

          // validate the optional field `device_cgroup_rule` (array)
          for (int i = 0; i < jsonArraydeviceCgroupRule.size(); i++) {
            LinuxDeviceCgroup.validateJsonElement(jsonArraydeviceCgroupRule.get(i));
          };
        }
      }
      if (jsonObj.get("devices") != null && !jsonObj.get("devices").isJsonNull()) {
        JsonArray jsonArraydevices = jsonObj.getAsJsonArray("devices");
        if (jsonArraydevices != null) {
          // ensure the json data is an array
          if (!jsonObj.get("devices").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `devices` to be an array in the JSON string but got `%s`", jsonObj.get("devices").toString()));
          }

          // validate the optional field `devices` (array)
          for (int i = 0; i < jsonArraydevices.size(); i++) {
            LinuxDevice.validateJsonElement(jsonArraydevices.get(i));
          };
        }
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("devices_from") != null && !jsonObj.get("devices_from").isJsonNull() && !jsonObj.get("devices_from").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `devices_from` to be an array in the JSON string but got `%s`", jsonObj.get("devices_from").toString()));
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("dns_option") != null && !jsonObj.get("dns_option").isJsonNull() && !jsonObj.get("dns_option").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `dns_option` to be an array in the JSON string but got `%s`", jsonObj.get("dns_option").toString()));
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("dns_search") != null && !jsonObj.get("dns_search").isJsonNull() && !jsonObj.get("dns_search").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `dns_search` to be an array in the JSON string but got `%s`", jsonObj.get("dns_search").toString()));
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("dns_server") != null && !jsonObj.get("dns_server").isJsonNull() && !jsonObj.get("dns_server").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `dns_server` to be an array in the JSON string but got `%s`", jsonObj.get("dns_server").toString()));
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("entrypoint") != null && !jsonObj.get("entrypoint").isJsonNull() && !jsonObj.get("entrypoint").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `entrypoint` to be an array in the JSON string but got `%s`", jsonObj.get("entrypoint").toString()));
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("envmerge") != null && !jsonObj.get("envmerge").isJsonNull() && !jsonObj.get("envmerge").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `envmerge` to be an array in the JSON string but got `%s`", jsonObj.get("envmerge").toString()));
      }
      if ((jsonObj.get("group_entry") != null && !jsonObj.get("group_entry").isJsonNull()) && !jsonObj.get("group_entry").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `group_entry` to be a primitive type in the JSON string but got `%s`", jsonObj.get("group_entry").toString()));
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("groups") != null && !jsonObj.get("groups").isJsonNull() && !jsonObj.get("groups").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `groups` to be an array in the JSON string but got `%s`", jsonObj.get("groups").toString()));
      }
      if ((jsonObj.get("healthLogDestination") != null && !jsonObj.get("healthLogDestination").isJsonNull()) && !jsonObj.get("healthLogDestination").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `healthLogDestination` to be a primitive type in the JSON string but got `%s`", jsonObj.get("healthLogDestination").toString()));
      }
      // validate the optional field `healthconfig`
      if (jsonObj.get("healthconfig") != null && !jsonObj.get("healthconfig").isJsonNull()) {
        Schema2HealthConfig.validateJsonElement(jsonObj.get("healthconfig"));
      }
      if (jsonObj.get("host_device_list") != null && !jsonObj.get("host_device_list").isJsonNull()) {
        JsonArray jsonArrayhostDeviceList = jsonObj.getAsJsonArray("host_device_list");
        if (jsonArrayhostDeviceList != null) {
          // ensure the json data is an array
          if (!jsonObj.get("host_device_list").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `host_device_list` to be an array in the JSON string but got `%s`", jsonObj.get("host_device_list").toString()));
          }

          // validate the optional field `host_device_list` (array)
          for (int i = 0; i < jsonArrayhostDeviceList.size(); i++) {
            LinuxDevice.validateJsonElement(jsonArrayhostDeviceList.get(i));
          };
        }
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("hostadd") != null && !jsonObj.get("hostadd").isJsonNull() && !jsonObj.get("hostadd").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `hostadd` to be an array in the JSON string but got `%s`", jsonObj.get("hostadd").toString()));
      }
      if ((jsonObj.get("hostname") != null && !jsonObj.get("hostname").isJsonNull()) && !jsonObj.get("hostname").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `hostname` to be a primitive type in the JSON string but got `%s`", jsonObj.get("hostname").toString()));
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("hostusers") != null && !jsonObj.get("hostusers").isJsonNull() && !jsonObj.get("hostusers").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `hostusers` to be an array in the JSON string but got `%s`", jsonObj.get("hostusers").toString()));
      }
      // validate the optional field `idmappings`
      if (jsonObj.get("idmappings") != null && !jsonObj.get("idmappings").isJsonNull()) {
        IDMappingOptions.validateJsonElement(jsonObj.get("idmappings"));
      }
      if ((jsonObj.get("image") != null && !jsonObj.get("image").isJsonNull()) && !jsonObj.get("image").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `image` to be a primitive type in the JSON string but got `%s`", jsonObj.get("image").toString()));
      }
      if ((jsonObj.get("image_arch") != null && !jsonObj.get("image_arch").isJsonNull()) && !jsonObj.get("image_arch").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `image_arch` to be a primitive type in the JSON string but got `%s`", jsonObj.get("image_arch").toString()));
      }
      if ((jsonObj.get("image_os") != null && !jsonObj.get("image_os").isJsonNull()) && !jsonObj.get("image_os").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `image_os` to be a primitive type in the JSON string but got `%s`", jsonObj.get("image_os").toString()));
      }
      if ((jsonObj.get("image_variant") != null && !jsonObj.get("image_variant").isJsonNull()) && !jsonObj.get("image_variant").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `image_variant` to be a primitive type in the JSON string but got `%s`", jsonObj.get("image_variant").toString()));
      }
      if ((jsonObj.get("image_volume_mode") != null && !jsonObj.get("image_volume_mode").isJsonNull()) && !jsonObj.get("image_volume_mode").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `image_volume_mode` to be a primitive type in the JSON string but got `%s`", jsonObj.get("image_volume_mode").toString()));
      }
      if (jsonObj.get("image_volumes") != null && !jsonObj.get("image_volumes").isJsonNull()) {
        JsonArray jsonArrayimageVolumes = jsonObj.getAsJsonArray("image_volumes");
        if (jsonArrayimageVolumes != null) {
          // ensure the json data is an array
          if (!jsonObj.get("image_volumes").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `image_volumes` to be an array in the JSON string but got `%s`", jsonObj.get("image_volumes").toString()));
          }

          // validate the optional field `image_volumes` (array)
          for (int i = 0; i < jsonArrayimageVolumes.size(); i++) {
            ImageVolume.validateJsonElement(jsonArrayimageVolumes.get(i));
          };
        }
      }
      if ((jsonObj.get("init_container_type") != null && !jsonObj.get("init_container_type").isJsonNull()) && !jsonObj.get("init_container_type").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `init_container_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get("init_container_type").toString()));
      }
      if ((jsonObj.get("init_path") != null && !jsonObj.get("init_path").isJsonNull()) && !jsonObj.get("init_path").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `init_path` to be a primitive type in the JSON string but got `%s`", jsonObj.get("init_path").toString()));
      }
      // validate the optional field `intelRdt`
      if (jsonObj.get("intelRdt") != null && !jsonObj.get("intelRdt").isJsonNull()) {
        LinuxIntelRdt.validateJsonElement(jsonObj.get("intelRdt"));
      }
      // validate the optional field `ipcns`
      if (jsonObj.get("ipcns") != null && !jsonObj.get("ipcns").isJsonNull()) {
        Namespace.validateJsonElement(jsonObj.get("ipcns"));
      }
      // validate the optional field `log_configuration`
      if (jsonObj.get("log_configuration") != null && !jsonObj.get("log_configuration").isJsonNull()) {
        LogConfigLibpod.validateJsonElement(jsonObj.get("log_configuration"));
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("mask") != null && !jsonObj.get("mask").isJsonNull() && !jsonObj.get("mask").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `mask` to be an array in the JSON string but got `%s`", jsonObj.get("mask").toString()));
      }
      if (jsonObj.get("mounts") != null && !jsonObj.get("mounts").isJsonNull()) {
        JsonArray jsonArraymounts = jsonObj.getAsJsonArray("mounts");
        if (jsonArraymounts != null) {
          // ensure the json data is an array
          if (!jsonObj.get("mounts").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `mounts` to be an array in the JSON string but got `%s`", jsonObj.get("mounts").toString()));
          }

          // validate the optional field `mounts` (array)
          for (int i = 0; i < jsonArraymounts.size(); i++) {
            Mount.validateJsonElement(jsonArraymounts.get(i));
          };
        }
      }
      if ((jsonObj.get("name") != null && !jsonObj.get("name").isJsonNull()) && !jsonObj.get("name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("name").toString()));
      }
      // validate the optional field `netns`
      if (jsonObj.get("netns") != null && !jsonObj.get("netns").isJsonNull()) {
        Namespace.validateJsonElement(jsonObj.get("netns"));
      }
      if ((jsonObj.get("oci_runtime") != null && !jsonObj.get("oci_runtime").isJsonNull()) && !jsonObj.get("oci_runtime").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `oci_runtime` to be a primitive type in the JSON string but got `%s`", jsonObj.get("oci_runtime").toString()));
      }
      if (jsonObj.get("overlay_volumes") != null && !jsonObj.get("overlay_volumes").isJsonNull()) {
        JsonArray jsonArrayoverlayVolumes = jsonObj.getAsJsonArray("overlay_volumes");
        if (jsonArrayoverlayVolumes != null) {
          // ensure the json data is an array
          if (!jsonObj.get("overlay_volumes").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `overlay_volumes` to be an array in the JSON string but got `%s`", jsonObj.get("overlay_volumes").toString()));
          }

          // validate the optional field `overlay_volumes` (array)
          for (int i = 0; i < jsonArrayoverlayVolumes.size(); i++) {
            OverlayVolume.validateJsonElement(jsonArrayoverlayVolumes.get(i));
          };
        }
      }
      if ((jsonObj.get("passwd_entry") != null && !jsonObj.get("passwd_entry").isJsonNull()) && !jsonObj.get("passwd_entry").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `passwd_entry` to be a primitive type in the JSON string but got `%s`", jsonObj.get("passwd_entry").toString()));
      }
      // validate the optional field `personality`
      if (jsonObj.get("personality") != null && !jsonObj.get("personality").isJsonNull()) {
        LinuxPersonality.validateJsonElement(jsonObj.get("personality"));
      }
      // validate the optional field `pidns`
      if (jsonObj.get("pidns") != null && !jsonObj.get("pidns").isJsonNull()) {
        Namespace.validateJsonElement(jsonObj.get("pidns"));
      }
      if ((jsonObj.get("pod") != null && !jsonObj.get("pod").isJsonNull()) && !jsonObj.get("pod").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `pod` to be a primitive type in the JSON string but got `%s`", jsonObj.get("pod").toString()));
      }
      if (jsonObj.get("portmappings") != null && !jsonObj.get("portmappings").isJsonNull()) {
        JsonArray jsonArrayportmappings = jsonObj.getAsJsonArray("portmappings");
        if (jsonArrayportmappings != null) {
          // ensure the json data is an array
          if (!jsonObj.get("portmappings").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `portmappings` to be an array in the JSON string but got `%s`", jsonObj.get("portmappings").toString()));
          }

          // validate the optional field `portmappings` (array)
          for (int i = 0; i < jsonArrayportmappings.size(); i++) {
            PortMapping.validateJsonElement(jsonArrayportmappings.get(i));
          };
        }
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("procfs_opts") != null && !jsonObj.get("procfs_opts").isJsonNull() && !jsonObj.get("procfs_opts").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `procfs_opts` to be an array in the JSON string but got `%s`", jsonObj.get("procfs_opts").toString()));
      }
      if (jsonObj.get("r_limits") != null && !jsonObj.get("r_limits").isJsonNull()) {
        JsonArray jsonArrayrLimits = jsonObj.getAsJsonArray("r_limits");
        if (jsonArrayrLimits != null) {
          // ensure the json data is an array
          if (!jsonObj.get("r_limits").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `r_limits` to be an array in the JSON string but got `%s`", jsonObj.get("r_limits").toString()));
          }

          // validate the optional field `r_limits` (array)
          for (int i = 0; i < jsonArrayrLimits.size(); i++) {
            POSIXRlimit.validateJsonElement(jsonArrayrLimits.get(i));
          };
        }
      }
      if ((jsonObj.get("raw_image_name") != null && !jsonObj.get("raw_image_name").isJsonNull()) && !jsonObj.get("raw_image_name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `raw_image_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("raw_image_name").toString()));
      }
      // validate the optional field `resource_limits`
      if (jsonObj.get("resource_limits") != null && !jsonObj.get("resource_limits").isJsonNull()) {
        LinuxResources.validateJsonElement(jsonObj.get("resource_limits"));
      }
      if ((jsonObj.get("restart_policy") != null && !jsonObj.get("restart_policy").isJsonNull()) && !jsonObj.get("restart_policy").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `restart_policy` to be a primitive type in the JSON string but got `%s`", jsonObj.get("restart_policy").toString()));
      }
      if ((jsonObj.get("rootfs") != null && !jsonObj.get("rootfs").isJsonNull()) && !jsonObj.get("rootfs").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `rootfs` to be a primitive type in the JSON string but got `%s`", jsonObj.get("rootfs").toString()));
      }
      if ((jsonObj.get("rootfs_mapping") != null && !jsonObj.get("rootfs_mapping").isJsonNull()) && !jsonObj.get("rootfs_mapping").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `rootfs_mapping` to be a primitive type in the JSON string but got `%s`", jsonObj.get("rootfs_mapping").toString()));
      }
      if ((jsonObj.get("rootfs_propagation") != null && !jsonObj.get("rootfs_propagation").isJsonNull()) && !jsonObj.get("rootfs_propagation").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `rootfs_propagation` to be a primitive type in the JSON string but got `%s`", jsonObj.get("rootfs_propagation").toString()));
      }
      if ((jsonObj.get("sdnotifyMode") != null && !jsonObj.get("sdnotifyMode").isJsonNull()) && !jsonObj.get("sdnotifyMode").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `sdnotifyMode` to be a primitive type in the JSON string but got `%s`", jsonObj.get("sdnotifyMode").toString()));
      }
      if ((jsonObj.get("seccomp_policy") != null && !jsonObj.get("seccomp_policy").isJsonNull()) && !jsonObj.get("seccomp_policy").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `seccomp_policy` to be a primitive type in the JSON string but got `%s`", jsonObj.get("seccomp_policy").toString()));
      }
      if ((jsonObj.get("seccomp_profile_path") != null && !jsonObj.get("seccomp_profile_path").isJsonNull()) && !jsonObj.get("seccomp_profile_path").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `seccomp_profile_path` to be a primitive type in the JSON string but got `%s`", jsonObj.get("seccomp_profile_path").toString()));
      }
      if (jsonObj.get("secrets") != null && !jsonObj.get("secrets").isJsonNull()) {
        JsonArray jsonArraysecrets = jsonObj.getAsJsonArray("secrets");
        if (jsonArraysecrets != null) {
          // ensure the json data is an array
          if (!jsonObj.get("secrets").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `secrets` to be an array in the JSON string but got `%s`", jsonObj.get("secrets").toString()));
          }

          // validate the optional field `secrets` (array)
          for (int i = 0; i < jsonArraysecrets.size(); i++) {
            Secret.validateJsonElement(jsonArraysecrets.get(i));
          };
        }
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("selinux_opts") != null && !jsonObj.get("selinux_opts").isJsonNull() && !jsonObj.get("selinux_opts").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `selinux_opts` to be an array in the JSON string but got `%s`", jsonObj.get("selinux_opts").toString()));
      }
      // validate the optional field `startupHealthConfig`
      if (jsonObj.get("startupHealthConfig") != null && !jsonObj.get("startupHealthConfig").isJsonNull()) {
        StartupHealthCheck.validateJsonElement(jsonObj.get("startupHealthConfig"));
      }
      if ((jsonObj.get("systemd") != null && !jsonObj.get("systemd").isJsonNull()) && !jsonObj.get("systemd").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `systemd` to be a primitive type in the JSON string but got `%s`", jsonObj.get("systemd").toString()));
      }
      if ((jsonObj.get("timezone") != null && !jsonObj.get("timezone").isJsonNull()) && !jsonObj.get("timezone").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `timezone` to be a primitive type in the JSON string but got `%s`", jsonObj.get("timezone").toString()));
      }
      if ((jsonObj.get("umask") != null && !jsonObj.get("umask").isJsonNull()) && !jsonObj.get("umask").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `umask` to be a primitive type in the JSON string but got `%s`", jsonObj.get("umask").toString()));
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("unmask") != null && !jsonObj.get("unmask").isJsonNull() && !jsonObj.get("unmask").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `unmask` to be an array in the JSON string but got `%s`", jsonObj.get("unmask").toString()));
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("unsetenv") != null && !jsonObj.get("unsetenv").isJsonNull() && !jsonObj.get("unsetenv").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `unsetenv` to be an array in the JSON string but got `%s`", jsonObj.get("unsetenv").toString()));
      }
      if ((jsonObj.get("user") != null && !jsonObj.get("user").isJsonNull()) && !jsonObj.get("user").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `user` to be a primitive type in the JSON string but got `%s`", jsonObj.get("user").toString()));
      }
      // validate the optional field `userns`
      if (jsonObj.get("userns") != null && !jsonObj.get("userns").isJsonNull()) {
        Namespace.validateJsonElement(jsonObj.get("userns"));
      }
      // validate the optional field `utsns`
      if (jsonObj.get("utsns") != null && !jsonObj.get("utsns").isJsonNull()) {
        Namespace.validateJsonElement(jsonObj.get("utsns"));
      }
      if (jsonObj.get("volumes") != null && !jsonObj.get("volumes").isJsonNull()) {
        JsonArray jsonArrayvolumes = jsonObj.getAsJsonArray("volumes");
        if (jsonArrayvolumes != null) {
          // ensure the json data is an array
          if (!jsonObj.get("volumes").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `volumes` to be an array in the JSON string but got `%s`", jsonObj.get("volumes").toString()));
          }

          // validate the optional field `volumes` (array)
          for (int i = 0; i < jsonArrayvolumes.size(); i++) {
            NamedVolume.validateJsonElement(jsonArrayvolumes.get(i));
          };
        }
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("volumes_from") != null && !jsonObj.get("volumes_from").isJsonNull() && !jsonObj.get("volumes_from").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `volumes_from` to be an array in the JSON string but got `%s`", jsonObj.get("volumes_from").toString()));
      }
      if ((jsonObj.get("work_dir") != null && !jsonObj.get("work_dir").isJsonNull()) && !jsonObj.get("work_dir").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `work_dir` to be a primitive type in the JSON string but got `%s`", jsonObj.get("work_dir").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!SpecGenerator.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'SpecGenerator' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<SpecGenerator> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(SpecGenerator.class));

       return (TypeAdapter<T>) new TypeAdapter<SpecGenerator>() {
           @Override
           public void write(JsonWriter out, SpecGenerator value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public SpecGenerator read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

  /**
   * Create an instance of SpecGenerator given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of SpecGenerator
   * @throws IOException if the JSON string is invalid with respect to SpecGenerator
   */
  public static SpecGenerator fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, SpecGenerator.class);
  }

  /**
   * Convert an instance of SpecGenerator to an JSON string
   *
   * @return JSON string
   */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

