/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.github.pod4dev.libpodj.model.Topology;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class Info
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_ACCESSIBLE_TOPOLOGY = "AccessibleTopology";
    @SerializedName(value="AccessibleTopology")
    private List<@Valid Topology> accessibleTopology = new ArrayList<Topology>();
    public static final String SERIALIZED_NAME_CAPACITY_BYTES = "CapacityBytes";
    @SerializedName(value="CapacityBytes")
    private Long capacityBytes;
    public static final String SERIALIZED_NAME_VOLUME_CONTEXT = "VolumeContext";
    @SerializedName(value="VolumeContext")
    private Map<String, String> volumeContext = new HashMap<String, String>();
    public static final String SERIALIZED_NAME_VOLUME_I_D = "VolumeID";
    @SerializedName(value="VolumeID")
    private String volumeID;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Info accessibleTopology(List<@Valid Topology> accessibleTopology) {
        this.accessibleTopology = accessibleTopology;
        return this;
    }

    public Info addAccessibleTopologyItem(Topology accessibleTopologyItem) {
        if (this.accessibleTopology == null) {
            this.accessibleTopology = new ArrayList<Topology>();
        }
        this.accessibleTopology.add(accessibleTopologyItem);
        return this;
    }

    @Nullable
    @Valid
    public @Valid List<@Valid Topology> getAccessibleTopology() {
        return this.accessibleTopology;
    }

    public void setAccessibleTopology(List<@Valid Topology> accessibleTopology) {
        this.accessibleTopology = accessibleTopology;
    }

    public Info capacityBytes(Long capacityBytes) {
        this.capacityBytes = capacityBytes;
        return this;
    }

    @Nullable
    public Long getCapacityBytes() {
        return this.capacityBytes;
    }

    public void setCapacityBytes(Long capacityBytes) {
        this.capacityBytes = capacityBytes;
    }

    public Info volumeContext(Map<String, String> volumeContext) {
        this.volumeContext = volumeContext;
        return this;
    }

    public Info putVolumeContextItem(String key, String volumeContextItem) {
        if (this.volumeContext == null) {
            this.volumeContext = new HashMap<String, String>();
        }
        this.volumeContext.put(key, volumeContextItem);
        return this;
    }

    @Nullable
    public Map<String, String> getVolumeContext() {
        return this.volumeContext;
    }

    public void setVolumeContext(Map<String, String> volumeContext) {
        this.volumeContext = volumeContext;
    }

    public Info volumeID(String volumeID) {
        this.volumeID = volumeID;
        return this;
    }

    @Nullable
    public String getVolumeID() {
        return this.volumeID;
    }

    public void setVolumeID(String volumeID) {
        this.volumeID = volumeID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Info info = (Info)o;
        return Objects.equals(this.accessibleTopology, info.accessibleTopology) && Objects.equals(this.capacityBytes, info.capacityBytes) && Objects.equals(this.volumeContext, info.volumeContext) && Objects.equals(this.volumeID, info.volumeID);
    }

    public int hashCode() {
        return Objects.hash(this.accessibleTopology, this.capacityBytes, this.volumeContext, this.volumeID);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Info {\n");
        sb.append("    accessibleTopology: ").append(this.toIndentedString(this.accessibleTopology)).append("\n");
        sb.append("    capacityBytes: ").append(this.toIndentedString(this.capacityBytes)).append("\n");
        sb.append("    volumeContext: ").append(this.toIndentedString(this.volumeContext)).append("\n");
        sb.append("    volumeID: ").append(this.toIndentedString(this.volumeID)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayaccessibleTopology;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in Info is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Info` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_ACCESSIBLE_TOPOLOGY) != null && !jsonObj.get(SERIALIZED_NAME_ACCESSIBLE_TOPOLOGY).isJsonNull() && (jsonArrayaccessibleTopology = jsonObj.getAsJsonArray(SERIALIZED_NAME_ACCESSIBLE_TOPOLOGY)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ACCESSIBLE_TOPOLOGY).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `AccessibleTopology` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCESSIBLE_TOPOLOGY).toString()));
            }
            for (int i = 0; i < jsonArrayaccessibleTopology.size(); ++i) {
                Topology.validateJsonElement(jsonArrayaccessibleTopology.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_VOLUME_I_D) != null && !jsonObj.get(SERIALIZED_NAME_VOLUME_I_D).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_VOLUME_I_D).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `VolumeID` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VOLUME_I_D).toString()));
        }
    }

    public static Info fromJson(String jsonString) throws IOException {
        return (Info)JSON.getGson().fromJson(jsonString, Info.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACCESSIBLE_TOPOLOGY);
        openapiFields.add(SERIALIZED_NAME_CAPACITY_BYTES);
        openapiFields.add(SERIALIZED_NAME_VOLUME_CONTEXT);
        openapiFields.add(SERIALIZED_NAME_VOLUME_I_D);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Info.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Info.class));
            return new TypeAdapter<Info>(this){

                public void write(JsonWriter out, Info value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Info read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    Info.validateJsonElement(jsonElement);
                    return (Info)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

