/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.github.pod4dev.libpodj.model.LinuxResources;
import io.github.pod4dev.libpodj.model.LinuxThrottleDevice;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class PodResourceConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_CPU_PERIOD = "cpu_period";
    @SerializedName(value="cpu_period")
    private Integer cpuPeriod;
    public static final String SERIALIZED_NAME_CPU_QUOTA = "cpu_quota";
    @SerializedName(value="cpu_quota")
    private Long cpuQuota;
    public static final String SERIALIZED_NAME_RESOURCE_LIMITS = "resource_limits";
    @SerializedName(value="resource_limits")
    private LinuxResources resourceLimits;
    public static final String SERIALIZED_NAME_THROTTLE_READ_BPS_DEVICE = "throttleReadBpsDevice";
    @SerializedName(value="throttleReadBpsDevice")
    private Map<String, LinuxThrottleDevice> throttleReadBpsDevice = new HashMap<String, LinuxThrottleDevice>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public PodResourceConfig cpuPeriod(Integer cpuPeriod) {
        this.cpuPeriod = cpuPeriod;
        return this;
    }

    @Nullable
    public Integer getCpuPeriod() {
        return this.cpuPeriod;
    }

    public void setCpuPeriod(Integer cpuPeriod) {
        this.cpuPeriod = cpuPeriod;
    }

    public PodResourceConfig cpuQuota(Long cpuQuota) {
        this.cpuQuota = cpuQuota;
        return this;
    }

    @Nullable
    public Long getCpuQuota() {
        return this.cpuQuota;
    }

    public void setCpuQuota(Long cpuQuota) {
        this.cpuQuota = cpuQuota;
    }

    public PodResourceConfig resourceLimits(LinuxResources resourceLimits) {
        this.resourceLimits = resourceLimits;
        return this;
    }

    @Nullable
    @Valid
    public LinuxResources getResourceLimits() {
        return this.resourceLimits;
    }

    public void setResourceLimits(LinuxResources resourceLimits) {
        this.resourceLimits = resourceLimits;
    }

    public PodResourceConfig throttleReadBpsDevice(Map<String, LinuxThrottleDevice> throttleReadBpsDevice) {
        this.throttleReadBpsDevice = throttleReadBpsDevice;
        return this;
    }

    public PodResourceConfig putThrottleReadBpsDeviceItem(String key, LinuxThrottleDevice throttleReadBpsDeviceItem) {
        if (this.throttleReadBpsDevice == null) {
            this.throttleReadBpsDevice = new HashMap<String, LinuxThrottleDevice>();
        }
        this.throttleReadBpsDevice.put(key, throttleReadBpsDeviceItem);
        return this;
    }

    @Nullable
    @Valid
    public Map<String, LinuxThrottleDevice> getThrottleReadBpsDevice() {
        return this.throttleReadBpsDevice;
    }

    public void setThrottleReadBpsDevice(Map<String, LinuxThrottleDevice> throttleReadBpsDevice) {
        this.throttleReadBpsDevice = throttleReadBpsDevice;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PodResourceConfig podResourceConfig = (PodResourceConfig)o;
        return Objects.equals(this.cpuPeriod, podResourceConfig.cpuPeriod) && Objects.equals(this.cpuQuota, podResourceConfig.cpuQuota) && Objects.equals(this.resourceLimits, podResourceConfig.resourceLimits) && Objects.equals(this.throttleReadBpsDevice, podResourceConfig.throttleReadBpsDevice);
    }

    public int hashCode() {
        return Objects.hash(this.cpuPeriod, this.cpuQuota, this.resourceLimits, this.throttleReadBpsDevice);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PodResourceConfig {\n");
        sb.append("    cpuPeriod: ").append(this.toIndentedString(this.cpuPeriod)).append("\n");
        sb.append("    cpuQuota: ").append(this.toIndentedString(this.cpuQuota)).append("\n");
        sb.append("    resourceLimits: ").append(this.toIndentedString(this.resourceLimits)).append("\n");
        sb.append("    throttleReadBpsDevice: ").append(this.toIndentedString(this.throttleReadBpsDevice)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in PodResourceConfig is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `PodResourceConfig` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_RESOURCE_LIMITS) != null && !jsonObj.get(SERIALIZED_NAME_RESOURCE_LIMITS).isJsonNull()) {
            LinuxResources.validateJsonElement(jsonObj.get(SERIALIZED_NAME_RESOURCE_LIMITS));
        }
    }

    public static PodResourceConfig fromJson(String jsonString) throws IOException {
        return (PodResourceConfig)JSON.getGson().fromJson(jsonString, PodResourceConfig.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CPU_PERIOD);
        openapiFields.add(SERIALIZED_NAME_CPU_QUOTA);
        openapiFields.add(SERIALIZED_NAME_RESOURCE_LIMITS);
        openapiFields.add(SERIALIZED_NAME_THROTTLE_READ_BPS_DEVICE);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!PodResourceConfig.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(PodResourceConfig.class));
            return new TypeAdapter<PodResourceConfig>(this){

                public void write(JsonWriter out, PodResourceConfig value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public PodResourceConfig read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    PodResourceConfig.validateJsonElement(jsonElement);
                    return (PodResourceConfig)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

