/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.github.pod4dev.libpodj.model.ConfigReference;
import io.github.pod4dev.libpodj.model.EndpointResource;
import io.github.pod4dev.libpodj.model.IPAM;
import io.github.pod4dev.libpodj.model.PeerInfo;
import io.github.pod4dev.libpodj.model.ServiceInfo;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import java.io.IOException;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class Inspect
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_ATTACHABLE = "Attachable";
    @SerializedName(value="Attachable")
    private Boolean attachable;
    public static final String SERIALIZED_NAME_CONFIG_FROM = "ConfigFrom";
    @SerializedName(value="ConfigFrom")
    private ConfigReference configFrom;
    public static final String SERIALIZED_NAME_CONFIG_ONLY = "ConfigOnly";
    @SerializedName(value="ConfigOnly")
    private Boolean configOnly;
    public static final String SERIALIZED_NAME_CONTAINERS = "Containers";
    @SerializedName(value="Containers")
    private Map<String, EndpointResource> containers = new HashMap<String, EndpointResource>();
    public static final String SERIALIZED_NAME_CREATED = "Created";
    @SerializedName(value="Created")
    private OffsetDateTime created;
    public static final String SERIALIZED_NAME_DRIVER = "Driver";
    @SerializedName(value="Driver")
    private String driver;
    public static final String SERIALIZED_NAME_ENABLE_I_PV4 = "EnableIPv4";
    @SerializedName(value="EnableIPv4")
    private Boolean enableIPv4;
    public static final String SERIALIZED_NAME_ENABLE_I_PV6 = "EnableIPv6";
    @SerializedName(value="EnableIPv6")
    private Boolean enableIPv6;
    public static final String SERIALIZED_NAME_I_P_A_M = "IPAM";
    @SerializedName(value="IPAM")
    private IPAM ipam;
    public static final String SERIALIZED_NAME_ID = "Id";
    @SerializedName(value="Id")
    private String id;
    public static final String SERIALIZED_NAME_INGRESS = "Ingress";
    @SerializedName(value="Ingress")
    private Boolean ingress;
    public static final String SERIALIZED_NAME_INTERNAL = "Internal";
    @SerializedName(value="Internal")
    private Boolean internal;
    public static final String SERIALIZED_NAME_LABELS = "Labels";
    @SerializedName(value="Labels")
    private Map<String, String> labels = new HashMap<String, String>();
    public static final String SERIALIZED_NAME_NAME = "Name";
    @SerializedName(value="Name")
    private String name;
    public static final String SERIALIZED_NAME_OPTIONS = "Options";
    @SerializedName(value="Options")
    private Map<String, String> options = new HashMap<String, String>();
    public static final String SERIALIZED_NAME_PEERS = "Peers";
    @SerializedName(value="Peers")
    private List<@Valid PeerInfo> peers = new ArrayList<PeerInfo>();
    public static final String SERIALIZED_NAME_SCOPE = "Scope";
    @SerializedName(value="Scope")
    private String scope;
    public static final String SERIALIZED_NAME_SERVICES = "Services";
    @SerializedName(value="Services")
    private Map<String, ServiceInfo> services = new HashMap<String, ServiceInfo>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Inspect attachable(Boolean attachable) {
        this.attachable = attachable;
        return this;
    }

    @Nullable
    public Boolean getAttachable() {
        return this.attachable;
    }

    public void setAttachable(Boolean attachable) {
        this.attachable = attachable;
    }

    public Inspect configFrom(ConfigReference configFrom) {
        this.configFrom = configFrom;
        return this;
    }

    @Nullable
    @Valid
    public ConfigReference getConfigFrom() {
        return this.configFrom;
    }

    public void setConfigFrom(ConfigReference configFrom) {
        this.configFrom = configFrom;
    }

    public Inspect configOnly(Boolean configOnly) {
        this.configOnly = configOnly;
        return this;
    }

    @Nullable
    public Boolean getConfigOnly() {
        return this.configOnly;
    }

    public void setConfigOnly(Boolean configOnly) {
        this.configOnly = configOnly;
    }

    public Inspect containers(Map<String, EndpointResource> containers) {
        this.containers = containers;
        return this;
    }

    public Inspect putContainersItem(String key, EndpointResource containersItem) {
        if (this.containers == null) {
            this.containers = new HashMap<String, EndpointResource>();
        }
        this.containers.put(key, containersItem);
        return this;
    }

    @Nullable
    @Valid
    public Map<String, EndpointResource> getContainers() {
        return this.containers;
    }

    public void setContainers(Map<String, EndpointResource> containers) {
        this.containers = containers;
    }

    public Inspect created(OffsetDateTime created) {
        this.created = created;
        return this;
    }

    @Nullable
    @Valid
    public OffsetDateTime getCreated() {
        return this.created;
    }

    public void setCreated(OffsetDateTime created) {
        this.created = created;
    }

    public Inspect driver(String driver) {
        this.driver = driver;
        return this;
    }

    @Nullable
    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public Inspect enableIPv4(Boolean enableIPv4) {
        this.enableIPv4 = enableIPv4;
        return this;
    }

    @Nullable
    public Boolean getEnableIPv4() {
        return this.enableIPv4;
    }

    public void setEnableIPv4(Boolean enableIPv4) {
        this.enableIPv4 = enableIPv4;
    }

    public Inspect enableIPv6(Boolean enableIPv6) {
        this.enableIPv6 = enableIPv6;
        return this;
    }

    @Nullable
    public Boolean getEnableIPv6() {
        return this.enableIPv6;
    }

    public void setEnableIPv6(Boolean enableIPv6) {
        this.enableIPv6 = enableIPv6;
    }

    public Inspect ipam(IPAM ipam) {
        this.ipam = ipam;
        return this;
    }

    @Nullable
    @Valid
    public IPAM getIPAM() {
        return this.ipam;
    }

    public void setIPAM(IPAM ipam) {
        this.ipam = ipam;
    }

    public Inspect id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Inspect ingress(Boolean ingress) {
        this.ingress = ingress;
        return this;
    }

    @Nullable
    public Boolean getIngress() {
        return this.ingress;
    }

    public void setIngress(Boolean ingress) {
        this.ingress = ingress;
    }

    public Inspect internal(Boolean internal) {
        this.internal = internal;
        return this;
    }

    @Nullable
    public Boolean getInternal() {
        return this.internal;
    }

    public void setInternal(Boolean internal) {
        this.internal = internal;
    }

    public Inspect labels(Map<String, String> labels) {
        this.labels = labels;
        return this;
    }

    public Inspect putLabelsItem(String key, String labelsItem) {
        if (this.labels == null) {
            this.labels = new HashMap<String, String>();
        }
        this.labels.put(key, labelsItem);
        return this;
    }

    @Nullable
    public Map<String, String> getLabels() {
        return this.labels;
    }

    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
    }

    public Inspect name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Inspect options(Map<String, String> options) {
        this.options = options;
        return this;
    }

    public Inspect putOptionsItem(String key, String optionsItem) {
        if (this.options == null) {
            this.options = new HashMap<String, String>();
        }
        this.options.put(key, optionsItem);
        return this;
    }

    @Nullable
    public Map<String, String> getOptions() {
        return this.options;
    }

    public void setOptions(Map<String, String> options) {
        this.options = options;
    }

    public Inspect peers(List<@Valid PeerInfo> peers) {
        this.peers = peers;
        return this;
    }

    public Inspect addPeersItem(PeerInfo peersItem) {
        if (this.peers == null) {
            this.peers = new ArrayList<PeerInfo>();
        }
        this.peers.add(peersItem);
        return this;
    }

    @Nullable
    @Valid
    public @Valid List<@Valid PeerInfo> getPeers() {
        return this.peers;
    }

    public void setPeers(List<@Valid PeerInfo> peers) {
        this.peers = peers;
    }

    public Inspect scope(String scope) {
        this.scope = scope;
        return this;
    }

    @Nullable
    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public Inspect services(Map<String, ServiceInfo> services) {
        this.services = services;
        return this;
    }

    public Inspect putServicesItem(String key, ServiceInfo servicesItem) {
        if (this.services == null) {
            this.services = new HashMap<String, ServiceInfo>();
        }
        this.services.put(key, servicesItem);
        return this;
    }

    @Nullable
    @Valid
    public Map<String, ServiceInfo> getServices() {
        return this.services;
    }

    public void setServices(Map<String, ServiceInfo> services) {
        this.services = services;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Inspect inspect = (Inspect)o;
        return Objects.equals(this.attachable, inspect.attachable) && Objects.equals(this.configFrom, inspect.configFrom) && Objects.equals(this.configOnly, inspect.configOnly) && Objects.equals(this.containers, inspect.containers) && Objects.equals(this.created, inspect.created) && Objects.equals(this.driver, inspect.driver) && Objects.equals(this.enableIPv4, inspect.enableIPv4) && Objects.equals(this.enableIPv6, inspect.enableIPv6) && Objects.equals(this.ipam, inspect.ipam) && Objects.equals(this.id, inspect.id) && Objects.equals(this.ingress, inspect.ingress) && Objects.equals(this.internal, inspect.internal) && Objects.equals(this.labels, inspect.labels) && Objects.equals(this.name, inspect.name) && Objects.equals(this.options, inspect.options) && Objects.equals(this.peers, inspect.peers) && Objects.equals(this.scope, inspect.scope) && Objects.equals(this.services, inspect.services);
    }

    public int hashCode() {
        return Objects.hash(this.attachable, this.configFrom, this.configOnly, this.containers, this.created, this.driver, this.enableIPv4, this.enableIPv6, this.ipam, this.id, this.ingress, this.internal, this.labels, this.name, this.options, this.peers, this.scope, this.services);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Inspect {\n");
        sb.append("    attachable: ").append(this.toIndentedString(this.attachable)).append("\n");
        sb.append("    configFrom: ").append(this.toIndentedString(this.configFrom)).append("\n");
        sb.append("    configOnly: ").append(this.toIndentedString(this.configOnly)).append("\n");
        sb.append("    containers: ").append(this.toIndentedString(this.containers)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    driver: ").append(this.toIndentedString(this.driver)).append("\n");
        sb.append("    enableIPv4: ").append(this.toIndentedString(this.enableIPv4)).append("\n");
        sb.append("    enableIPv6: ").append(this.toIndentedString(this.enableIPv6)).append("\n");
        sb.append("    ipam: ").append(this.toIndentedString(this.ipam)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    ingress: ").append(this.toIndentedString(this.ingress)).append("\n");
        sb.append("    internal: ").append(this.toIndentedString(this.internal)).append("\n");
        sb.append("    labels: ").append(this.toIndentedString(this.labels)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("    peers: ").append(this.toIndentedString(this.peers)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString(this.scope)).append("\n");
        sb.append("    services: ").append(this.toIndentedString(this.services)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArraypeers;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in Inspect is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Inspect` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_CONFIG_FROM) != null && !jsonObj.get(SERIALIZED_NAME_CONFIG_FROM).isJsonNull()) {
            ConfigReference.validateJsonElement(jsonObj.get(SERIALIZED_NAME_CONFIG_FROM));
        }
        if (jsonObj.get(SERIALIZED_NAME_DRIVER) != null && !jsonObj.get(SERIALIZED_NAME_DRIVER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DRIVER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Driver` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DRIVER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_I_P_A_M) != null && !jsonObj.get(SERIALIZED_NAME_I_P_A_M).isJsonNull()) {
            IPAM.validateJsonElement(jsonObj.get(SERIALIZED_NAME_I_P_A_M));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PEERS) != null && !jsonObj.get(SERIALIZED_NAME_PEERS).isJsonNull() && (jsonArraypeers = jsonObj.getAsJsonArray(SERIALIZED_NAME_PEERS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_PEERS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `Peers` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PEERS).toString()));
            }
            for (int i = 0; i < jsonArraypeers.size(); ++i) {
                PeerInfo.validateJsonElement(jsonArraypeers.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_SCOPE) != null && !jsonObj.get(SERIALIZED_NAME_SCOPE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SCOPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Scope` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SCOPE).toString()));
        }
    }

    public static Inspect fromJson(String jsonString) throws IOException {
        return (Inspect)JSON.getGson().fromJson(jsonString, Inspect.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ATTACHABLE);
        openapiFields.add(SERIALIZED_NAME_CONFIG_FROM);
        openapiFields.add(SERIALIZED_NAME_CONFIG_ONLY);
        openapiFields.add(SERIALIZED_NAME_CONTAINERS);
        openapiFields.add(SERIALIZED_NAME_CREATED);
        openapiFields.add(SERIALIZED_NAME_DRIVER);
        openapiFields.add(SERIALIZED_NAME_ENABLE_I_PV4);
        openapiFields.add(SERIALIZED_NAME_ENABLE_I_PV6);
        openapiFields.add(SERIALIZED_NAME_I_P_A_M);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_INGRESS);
        openapiFields.add(SERIALIZED_NAME_INTERNAL);
        openapiFields.add(SERIALIZED_NAME_LABELS);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_OPTIONS);
        openapiFields.add(SERIALIZED_NAME_PEERS);
        openapiFields.add(SERIALIZED_NAME_SCOPE);
        openapiFields.add(SERIALIZED_NAME_SERVICES);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Inspect.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Inspect.class));
            return new TypeAdapter<Inspect>(){

                public void write(JsonWriter out, Inspect value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Inspect read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    Inspect.validateJsonElement(jsonElement);
                    return (Inspect)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

