/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.servers.Server;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenDiscriminator;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenResponse;
import org.openapitools.codegen.languages.AbstractJavaCodegen;
import org.openapitools.codegen.languages.SchemaGenerator;
import org.openapitools.codegen.languages.features.BeanValidationFeatures;
import org.openapitools.codegen.languages.features.OptionalFeatures;
import org.openapitools.codegen.languages.features.UseGenericResponseFeatures;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.utils.ModelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class SmartDataCodegen
extends AbstractJavaCodegen
implements BeanValidationFeatures,
UseGenericResponseFeatures,
OptionalFeatures {
    public static final String INTROSPECTED = "introspected";
    public static final String DATETIME_RELAXED = "dateTimeRelaxed";
    public static final String SCHEMA_REGISTRY = "schemaRegistry";
    private static final Logger LOG = LoggerFactory.getLogger(SmartDataCodegen.class);
    private String schemaRegistry = "https://smart-data-models.github.io/data-models.test";
    private boolean useBeanValidation = true;
    private boolean useOptional = true;
    private boolean introspected = true;
    private boolean dateTimeRelaxed = true;
    private Map<String, String> fieldNameMapping = new HashMap<String, String>();

    public SmartDataCodegen() {
        this.supportsAdditionalPropertiesWithComposedSchema = true;
        this.useOneOfInterfaces = true;
        this.cliOptions.clear();
        this.cliOptions.add(CliOption.newBoolean((String)"useBeanValidation", (String)"Use bean validation annotations", (boolean)this.useBeanValidation));
        this.cliOptions.add(CliOption.newBoolean((String)"useOptional", (String)"Use Optional<T> instead of @Nullable.", (boolean)this.useOptional));
        this.cliOptions.add(CliOption.newBoolean((String)INTROSPECTED, (String)"Add @Introspected to models", (boolean)this.introspected));
        this.cliOptions.add(CliOption.newBoolean((String)DATETIME_RELAXED, (String)"Relaxed parsing of datetimes.", (boolean)this.dateTimeRelaxed));
        this.cliOptions.add(CliOption.newBoolean((String)"openApiNullable", (String)"Enable OpenAPI Jackson Nullable", (boolean)this.openApiNullable));
        this.cliOptions.add(CliOption.newString((String)"sourceFolder", (String)"source folder for generated code"));
        this.cliOptions.add(CliOption.newString((String)SCHEMA_REGISTRY, (String)"Url of the registry that will host the schemata"));
        this.cliOptions.add(CliOption.newString((String)"testFolder", (String)"test folder for generated code"));
        this.cliOptions.add(CliOption.newString((String)"fieldNameMapping", (String)"Field names to be replaced"));
        this.apiTemplateFiles.clear();
        this.apiDocTemplateFiles.clear();
        this.apiTestTemplateFiles.clear();
        this.modelTemplateFiles.clear();
        this.modelTemplateFiles.put("model.mustache", ".java");
        this.modelDocTemplateFiles.clear();
        this.modelTestTemplateFiles.clear();
        this.additionalProperties.clear();
        this.additionalProperties.put("useBeanValidation", this.useBeanValidation);
        this.additionalProperties.put("useOptional", this.useOptional);
        this.additionalProperties.put(INTROSPECTED, this.introspected);
        this.typeMapping.clear();
        this.typeMapping.put("object", "java.lang.Object");
        this.typeMapping.put("AnyType", "java.lang.Object");
        this.typeMapping.put("date", "java.time.LocalDate");
        this.typeMapping.put("DateTime", "java.time.Instant");
        this.typeMapping.put("array", "java.util.List");
        this.typeMapping.put("map", "java.util.Map");
        this.typeMapping.put("set", "java.util.Set");
        this.typeMapping.put("boolean", "java.lang.Boolean");
        this.typeMapping.put("string", "java.lang.String");
        this.typeMapping.put("int", "java.lang.Integer");
        this.typeMapping.put("integer", "java.lang.Integer");
        this.typeMapping.put("Integer", "java.lang.Integer");
        this.typeMapping.put("long", "java.lang.Long");
        this.typeMapping.put("Long", "java.lang.Long");
        this.typeMapping.put("float", "java.lang.Float");
        this.typeMapping.put("Float", "java.lang.Float");
        this.typeMapping.put("double", "java.lang.Double");
        this.typeMapping.put("Double", "java.lang.Double");
        this.typeMapping.put("number", "java.lang.Double");
        this.typeMapping.put("BigDecimal", "java.lang.Double");
        this.typeMapping.put("UUID", "java.util.UUID");
        this.typeMapping.put("URI", "java.net.URI");
        this.typeMapping.put("URL", "java.net.URL");
        this.typeMapping.put("file", "byte[]");
        this.typeMapping.put("ByteArray", "byte[]");
        this.typeMapping.put("Authentication", "io.micronaut.security.authentication.Authentication");
        this.typeMapping.put("MultipartBody", "io.micronaut.http.client.multipart.MultipartBody");
        this.typeMapping.put("fileUpload", "io.micronaut.http.multipart.CompletedFileUpload");
        this.typeMapping.put("asyncFileUpload", "io.micronaut.http.multipart.StreamingFileUpload");
        this.typeMapping.put("asyncCompletable", "reactor.core.publisher.Mono");
        this.typeMapping.put("asyncSingle", "reactor.core.publisher.Mono");
        this.typeMapping.put("asyncMaybe", "reactor.core.publisher.Mono");
        this.typeMapping.put("asyncFlowable", "reactor.core.publisher.Flux");
        this.typeMapping.put("Generated", "jakarta.annotation.Generated");
        this.typeMapping.put("Nullable", "io.micronaut.core.annotation.Nullable");
        this.typeMapping.put("Nonnull", "io.micronaut.core.annotation.NonNull");
        this.typeMapping.put("Inject", "jakarta.inject.Inject");
        this.typeMapping.put("Singleton", "jakarta.inject.Singleton");
        this.instantiationTypes.clear();
        this.instantiationTypes.put("array", "java.util.ArrayList");
        this.instantiationTypes.put("map", "java.util.HashMap");
        this.instantiationTypes.put("set", "java.util.LinkedHashSet");
        this.importMapping.clear();
        this.reservedWords.remove("file");
        this.reservedWords.remove("list");
        this.reservedWords.add("authentication");
    }

    public String getName() {
        return "smart-data";
    }

    public void postProcess() {
    }

    public void processOpts() {
        BiFunction<String, String, String> getOrDefault = (key, defaultValue) -> (String)this.additionalProperties.computeIfAbsent(key, k -> defaultValue);
        String packageName = getOrDefault.apply("packageName", "changeMe");
        this.apiPackage = getOrDefault.apply("apiPackage", packageName);
        this.modelPackage = getOrDefault.apply("modelPackage", packageName);
        this.invokerPackage = getOrDefault.apply("invokerPackage", packageName);
        this.additionalProperties.put("isModelImport", !this.apiPackage.equals(this.modelPackage));
        if (this.additionalProperties.containsKey("useBeanValidation")) {
            this.useBeanValidation = this.convertPropertyToBooleanAndWriteBack("useBeanValidation");
        }
        if (this.additionalProperties.containsKey("useOptional")) {
            this.useOptional = this.convertPropertyToBooleanAndWriteBack("useOptional");
        }
        if (this.additionalProperties.containsKey(INTROSPECTED)) {
            this.introspected = this.convertPropertyToBooleanAndWriteBack(INTROSPECTED);
        }
        if (this.additionalProperties.containsKey(DATETIME_RELAXED)) {
            this.dateTimeRelaxed = this.convertPropertyToBooleanAndWriteBack(DATETIME_RELAXED);
        }
        if (this.additionalProperties.containsKey("openApiNullable")) {
            this.openApiNullable = this.convertPropertyToBooleanAndWriteBack("openApiNullable");
        }
        this.templateDir = "SmartData";
        this.projectFolder = getOrDefault.apply("projectFolder", "generated-sources");
        this.projectTestFolder = getOrDefault.apply("projectTestFolder", "generated-test-sources");
        this.sourceFolder = getOrDefault.apply("sourceFolder", this.projectFolder + File.separator + "openapi");
        this.testFolder = getOrDefault.apply("testFolder", this.projectTestFolder + File.separator + "openapi");
        this.modelNameSuffix = getOrDefault.apply("modelNameSuffix", this.modelNameSuffix);
        this.additionalProperties.put("type.Authentication", this.typeMapping.get("Authentication"));
        this.additionalProperties.put("type.Nullable", this.typeMapping.get("Nullable"));
        this.additionalProperties.put("type.Nonnull", this.typeMapping.get("Nonnull"));
        this.additionalProperties.put("type.Inject", this.typeMapping.get("Inject"));
        this.additionalProperties.put("type.Singleton", this.typeMapping.get("Singleton"));
        this.additionalProperties.put("type.MultipartBody", this.typeMapping.get("MultipartBody"));
        this.instantiationTypes.forEach((k, v) -> this.additionalProperties.put("instantiationType." + k, v));
        Optional.ofNullable((String)this.typeMapping.get("Generated")).filter(type -> !type.isBlank()).ifPresent(type -> this.additionalProperties.put("type.Generated", type));
        this.fieldNameMapping.putAll(Map.of("@type", "tmForumType", "@schemaLocation", "atSchemaLocation", "@baseType", "atBaseType"));
    }

    public CodegenOperation fromOperation(String path, String httpMethod, Operation source, List<Server> servers) {
        return super.fromOperation(path, httpMethod, source, servers);
    }

    public CodegenResponse fromResponse(String responseCode, ApiResponse response) {
        return super.fromResponse(responseCode, response);
    }

    private boolean isReferenceToEntity(String reference, Map<String, ModelsMap> objs) {
        return Stream.ofNullable(reference).map(path -> path.replace("#/components/schemas/", "")).map(objs::get).map(ModelsMap::getModels).flatMap(Collection::stream).map(ModelMap::getModel).map(CodegenModel::getVars).flatMap(Collection::stream).map(CodegenProperty::getName).anyMatch("id"::equals);
    }

    private void addModellingHint(Map<String, ModelsMap> objs) {
        objs.values().stream().map(ModelsMap::getModels).flatMap(Collection::stream).map(ModelMap::getModel).map(CodegenModel::getVars).flatMap(Collection::stream).filter(a -> a.getRef() != null).filter(a -> !a.isEnumRef).filter(a -> this.isReferenceToEntity(a.getRef(), objs)).forEach(e -> e.getVendorExtensions().put("ngsi_relationship", e.dataType));
        objs.values().stream().map(ModelsMap::getModels).flatMap(Collection::stream).map(ModelMap::getModel).map(CodegenModel::getVars).flatMap(Collection::stream).filter(CodegenProperty::getIsArray).forEach(e -> {
            CodegenProperty items = e.getItems();
            if (this.isReferenceToEntity(items.getRef(), objs)) {
                e.getVendorExtensions().put("ngsi_relationshiplist", items.dataType);
            }
        });
        objs.values().stream().map(ModelsMap::getModels).flatMap(Collection::stream).map(ModelMap::getModel).filter(e -> e.getVars().stream().map(CodegenProperty::getName).anyMatch("id"::equals)).forEach(e -> e.getVendorExtensions().put("ngsi_entityWithId", "true"));
    }

    public Map<String, ModelsMap> updateAllModels(Map<String, ModelsMap> objs) {
        Map superObjs = super.updateAllModels(objs);
        new SchemaGenerator(this.outputFolder(), this.schemaRegistry).writeSchemata(superObjs, this.fieldNameMapping);
        this.addModellingHint(superObjs);
        objs.entrySet().removeIf(e -> ((String)e.getKey()).endsWith("_allOf"));
        Map allModels = this.getAllModels(objs);
        for (CodegenModel model : allModels.values()) {
            CodegenDiscriminator discriminator;
            if (this.supportsAdditionalPropertiesWithComposedSchema && model.getAdditionalProperties() != null) {
                model.getVendorExtensions().put("additionalPropertiesMap", Map.of("keyType", "java.lang.String", "valueType", model.getAdditionalProperties().getDataType()));
            }
            if ((discriminator = model.discriminator) == null) continue;
            model.vars.stream().filter(property -> property.getName().equals(discriminator.getPropertyName())).findAny().ifPresent(property -> {
                discriminator.setPropertyType(property.getDataType());
                model.vars.remove(property);
            });
            block12: for (CodegenDiscriminator.MappedModel mappedModel : discriminator.getMappedModels()) {
                CodegenModel subModel = (CodegenModel)allModels.get(mappedModel.getModelName());
                if (subModel == null) {
                    LOG.warn("{} - model in discriminator {} with name {} not found", new Object[]{model.name, discriminator.getPropertyName(), mappedModel.getModelName()});
                    continue;
                }
                if (subModel.parentModel == null) {
                    subModel.parentModel = model;
                    subModel.parent = model.getClassname();
                    LOG.warn("{} added missing sub model {}", (Object)model.name, (Object)subModel.name);
                }
                subModel.vars.removeIf(property -> property.getName().equals(discriminator.getPropertyName()));
                Map extensions = subModel.getVendorExtensions();
                extensions.put("discriminatorPropertyGetter", discriminator.getPropertyGetter());
                extensions.put("discriminatorPropertyType", discriminator.getPropertyType());
                switch (discriminator.getPropertyType()) {
                    case "java.lang.String": {
                        extensions.put("discriminatorPropertyValue", "\"" + mappedModel.getMappingName() + "\"");
                        continue block12;
                    }
                    case "java.lang.Long": 
                    case "java.lang.Integer": 
                    case "java.lang.Double": 
                    case "java.lang.Float": {
                        extensions.put("discriminatorPropertyValue", mappedModel.getMappingName());
                        continue block12;
                    }
                }
                extensions.put("discriminatorPropertyValue", discriminator.getPropertyType() + "." + this.toEnumVarName(mappedModel.getMappingName(), ""));
            }
        }
        return superObjs;
    }

    public void postProcessParameter(CodegenParameter parameter) {
    }

    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        super.postProcessModelProperty(model, property);
    }

    public boolean isDataTypeString(String dataType) {
        return List.of("java.lang.String", "String").contains(dataType);
    }

    public String toEnumName(CodegenProperty property) {
        return property.nameInCamelCase;
    }

    public String toEnumVarName(String value, String datatype) {
        return super.toEnumVarName(value, datatype.replace("java.lang.", ""));
    }

    public String toEnumValue(String value, String datatype) {
        if (List.of("int", "Integer", "java.lang.Integer").contains(datatype)) {
            return value;
        }
        if (List.of("long", "Long", "java.lang.Long").contains(datatype)) {
            return value + "L";
        }
        if (List.of("float", "Float", "java.lang.Float").contains(datatype)) {
            return value + "F";
        }
        if (List.of("double", "Double", "java.lang.Double").contains(datatype)) {
            return value + "D";
        }
        return super.toEnumValue(value, datatype);
    }

    public void setUseBeanValidation(boolean useBeanValidation) {
        this.useBeanValidation = useBeanValidation;
    }

    public void setUseGenericResponse(boolean useGenericResponse) {
    }

    public void setUseOptional(boolean useOptional) {
        this.useOptional = useOptional;
    }

    public String toDefaultValue(Schema schema) {
        if (ModelUtils.isGenerateAliasAsModel() && schema.get$ref() != null) {
            return "new " + this.getSchemaType(schema) + "()";
        }
        return super.toDefaultValue(schema);
    }

    public String toExampleValue(Schema schema) {
        Optional<Object> value = Optional.ofNullable(schema.getExample()).or(() -> Optional.ofNullable(schema.getDefault())).or(() -> Optional.ofNullable(schema.getEnum()).flatMap(e -> e.stream().findFirst())).map(Object::toString);
        if (ModelUtils.isBooleanSchema((Schema)schema)) {
            return (String)value.orElse("false");
        }
        if (ModelUtils.isLongSchema((Schema)schema)) {
            return (String)value.orElse("100L") + "L";
        }
        if (ModelUtils.isFloatSchema((Schema)schema)) {
            return (String)value.orElse("12.34") + "F";
        }
        if (ModelUtils.isDoubleSchema((Schema)schema)) {
            return (String)value.orElse("43.21") + "D";
        }
        if (ModelUtils.isIntegerSchema((Schema)schema) || ModelUtils.isShortSchema((Schema)schema)) {
            return (String)value.orElse("12");
        }
        if (ModelUtils.isNumberSchema((Schema)schema)) {
            return value.map(v -> "java.lang.Number.valueOf(\"" + v + "\")").orElse("12.34");
        }
        if (ModelUtils.isDateSchema((Schema)schema)) {
            if ("java.time.LocalDate".equals(this.typeMapping.get(schema.getType()))) {
                return "java.time.LocalDate." + value.map(v -> "parse(\"" + v + "\")").orElse("now()");
            }
            return "null";
        }
        if (ModelUtils.isDateTimeSchema((Schema)schema)) {
            if ("java.time.Instant".equals(this.typeMapping.get(schema.getType()))) {
                return "java.time.Instant." + value.map(v -> "parse(\"" + v + "\")").orElse("now()");
            }
            return "null";
        }
        if (ModelUtils.isByteArraySchema((Schema)schema) || ModelUtils.isBinarySchema((Schema)schema)) {
            return (String)value.orElse("\"byteArray\".getBytes()");
        }
        if (ModelUtils.isFileSchema((Schema)schema)) {
            return (String)value.orElse("\"myFile\".getBytes()");
        }
        if (ModelUtils.isUUIDSchema((Schema)schema)) {
            return "java.util.UUID." + value.map(v -> "fromString(\"" + v + "\")").orElse("randomUUID()");
        }
        if (ModelUtils.isURISchema((Schema)schema)) {
            return "java.net.URI.create(\"" + (String)value.orElse("my:uri") + "\")";
        }
        if (ModelUtils.isEmailSchema((Schema)schema)) {
            return "\"" + (String)value.orElse("mail@example.org") + "\"";
        }
        if (ModelUtils.isStringSchema((Schema)schema)) {
            return "\"" + (String)value.orElse("string") + "\"";
        }
        if (ModelUtils.isMapSchema((Schema)schema)) {
            return "java.util.Map." + value.map(v -> (Map)new Yaml().loadAs(v, Map.class)).filter(map -> !map.isEmpty()).map(map -> map.entrySet().stream().map(e -> "new java.util.AbstractMap.SimpleEntry(\"" + e.getKey() + "\", \"" + e.getValue() + "\")").collect(Collectors.joining(", "))).map(map -> "ofEntries(" + map + ")").orElse("of()");
        }
        if (ModelUtils.isSet((Schema)schema)) {
            return "java.util.Set.of(" + value.map(v -> v.substring(1, v.length() - 1)).orElse("") + ")";
        }
        if (ModelUtils.isArraySchema((Schema)schema)) {
            return "java.util.List.of(" + value.map(v -> v.substring(1, v.length() - 1)).orElse("") + ")";
        }
        return "null";
    }
}

