/*
 * Decompiled with CFR 0.152.
 */
package io.queryanalyzer.example.postgres.controller;

import io.queryanalyzer.example.postgres.entity.Order;
import io.queryanalyzer.example.postgres.entity.User;
import io.queryanalyzer.example.postgres.repository.OrderRepository;
import io.queryanalyzer.example.postgres.repository.UserRepository;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/users"})
public class UserController {
    private final UserRepository userRepository;
    private final OrderRepository orderRepository;

    public UserController(UserRepository userRepository, OrderRepository orderRepository) {
        this.userRepository = userRepository;
        this.orderRepository = orderRepository;
    }

    @GetMapping
    @Transactional(readOnly=true)
    public ResponseEntity<List<Map<String, Object>>> getAllUsers() {
        List users = this.userRepository.findAll();
        List response = users.stream().map(arg_0 -> this.convertToMap(arg_0)).collect(Collectors.toList());
        return ResponseEntity.ok(response);
    }

    @GetMapping(value={"/optimized"})
    @Transactional(readOnly=true)
    public ResponseEntity<List<Map<String, Object>>> getAllUsersOptimized() {
        List users = this.userRepository.findAllWithOrders();
        List response = users.stream().map(arg_0 -> this.convertToMap(arg_0)).collect(Collectors.toList());
        return ResponseEntity.ok(response);
    }

    @GetMapping(value={"/examples/bad/n-plus-one"})
    @Transactional(readOnly=true)
    public ResponseEntity<List<Map<String, Object>>> nPlusOneBad() {
        List users = this.userRepository.findAll();
        ArrayList result = new ArrayList();
        for (User user : users) {
            HashMap<String, Object> userData = new HashMap<String, Object>();
            userData.put("id", user.getId());
            userData.put("name", user.getName());
            userData.put("email", user.getEmail());
            userData.put("orderCount", user.getOrders().size());
            result.add(userData);
        }
        return ResponseEntity.ok(result);
    }

    @GetMapping(value={"/examples/good/n-plus-one-fixed"})
    @Transactional(readOnly=true)
    public ResponseEntity<List<Map<String, Object>>> nPlusOneGood() {
        List users = this.userRepository.findAllWithOrders();
        ArrayList result = new ArrayList();
        for (User user : users) {
            HashMap<String, Object> userData = new HashMap<String, Object>();
            userData.put("id", user.getId());
            userData.put("name", user.getName());
            userData.put("email", user.getEmail());
            userData.put("orderCount", user.getOrders().size());
            result.add(userData);
        }
        return ResponseEntity.ok(result);
    }

    @GetMapping(value={"/examples/bad/multiple-n-plus-one"})
    @Transactional(readOnly=true)
    public ResponseEntity<List<Map<String, Object>>> multipleNPlusOne() {
        List users = this.userRepository.findAll();
        ArrayList result = new ArrayList();
        for (User user : users) {
            HashMap<String, Object> userData = new HashMap<String, Object>();
            userData.put("id", user.getId());
            userData.put("name", user.getName());
            userData.put("orderCount", user.getOrders().size());
            ArrayList<String> products = new ArrayList<String>();
            for (Order order : user.getOrders()) {
                products.add(order.getProductName());
            }
            userData.put("products", products);
            result.add(userData);
        }
        return ResponseEntity.ok(result);
    }

    @GetMapping(value={"/examples/bad/query-in-loop"})
    @Transactional(readOnly=true)
    public ResponseEntity<List<Map<String, Object>>> queryInLoop() {
        List users = this.userRepository.findAll();
        ArrayList result = new ArrayList();
        for (User user : users) {
            List orders = this.orderRepository.findByUserId(user.getId());
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("userId", user.getId());
            data.put("userName", user.getName());
            data.put("orderCount", orders.size());
            result.add(data);
        }
        return ResponseEntity.ok(result);
    }

    @GetMapping(value={"/examples/good/query-in-loop-fixed"})
    @Transactional(readOnly=true)
    public ResponseEntity<List<Map<String, Object>>> queryInLoopFixed() {
        List users = this.userRepository.findAll();
        List userIds = users.stream().map(User::getId).collect(Collectors.toList());
        List allOrders = this.orderRepository.findByUserIdIn(userIds);
        HashMap ordersByUser = new HashMap();
        for (Order order : allOrders) {
            ordersByUser.computeIfAbsent(order.getUser().getId(), k -> new ArrayList()).add(order);
        }
        ArrayList result = new ArrayList();
        for (User user : users) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("userId", user.getId());
            data.put("userName", user.getName());
            List userOrders = ordersByUser.getOrDefault(user.getId(), List.of());
            data.put("orderCount", userOrders.size());
            result.add(data);
        }
        return ResponseEntity.ok(result);
    }

    @GetMapping(value={"/examples/good/best-practices"})
    @Transactional(readOnly=true)
    public ResponseEntity<List<Map<String, Object>>> bestPractices() {
        List users = this.userRepository.findAllWithOrders();
        ArrayList result = new ArrayList();
        for (User user : users) {
            HashMap<String, Object> userData = new HashMap<String, Object>();
            userData.put("id", user.getId());
            userData.put("name", user.getName());
            userData.put("email", user.getEmail());
            List orders = user.getOrders();
            userData.put("orderCount", orders.size());
            List products = orders.stream().map(Order::getProductName).collect(Collectors.toList());
            userData.put("products", products);
            result.add(userData);
        }
        return ResponseEntity.ok(result);
    }

    private Map<String, Object> convertToMap(User user) {
        List productNames = user.getOrders().stream().map(Order::getProductName).collect(Collectors.toList());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", user.getId());
        map.put("name", user.getName());
        map.put("email", user.getEmail());
        map.put("orderCount", user.getOrders().size());
        map.put("products", productNames);
        return map;
    }
}

