/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.asm.asyncsupport;

import scouter.agent.asm.asyncsupport.FacotoryMV;
import scouter.agent.asm.asyncsupport.LambdaMV;
import scouter.agent.asm.util.AsmUtil;
import scouter.org.objectweb.asm.ClassVisitor;
import scouter.org.objectweb.asm.MethodVisitor;
import scouter.org.objectweb.asm.Opcodes;
import scouter.org.objectweb.asm.Type;

class LambdaFormCV
extends ClassVisitor
implements Opcodes {
    String className;
    String lambdaMethodName;
    String lambdaMethodDesc;
    String factoryMethodName;
    String factoryMethodDesc;

    public LambdaFormCV(ClassVisitor cv, String className, String lambdaMethodName, String lambdaMethodDesc, String factoryMethodName, String factoryMethodDesc) {
        super(524288, cv);
        this.className = className;
        this.lambdaMethodName = lambdaMethodName;
        this.lambdaMethodDesc = lambdaMethodDesc;
        this.factoryMethodName = factoryMethodName;
        this.factoryMethodDesc = factoryMethodDesc;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (name.equals(this.lambdaMethodName) && desc.equals(this.lambdaMethodDesc)) {
            String fullName = AsmUtil.makeMethodFullName(this.className, name, desc);
            if ((access & 8) != 0) {
                return mv;
            }
            return new LambdaMV(access, name, desc, mv, fullName, Type.getArgumentTypes(desc), this.className);
        }
        if (name.equals(this.factoryMethodName) && desc.equals(this.factoryMethodDesc)) {
            return new FacotoryMV(access, name, desc, mv);
        }
        return mv;
    }
}

