/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.trace;

import scouter.agent.Configure;
import scouter.agent.Logger;
import scouter.agent.counter.meter.MeterInteraction;
import scouter.agent.counter.meter.MeterInteractionManager;
import scouter.agent.netio.data.DataProxy;
import scouter.agent.proxy.ElasticSearchTraceFactory;
import scouter.agent.proxy.IElasticSearchTracer;
import scouter.agent.trace.StepTransferMap;
import scouter.agent.trace.TraceContext;
import scouter.agent.trace.TraceContextManager;
import scouter.lang.enumeration.ParameterizedMessageLevel;
import scouter.lang.step.ParameterizedMessageStep;
import scouter.util.StringUtil;

public class TraceElasticSearch {
    private static String ES_COMMAND_MSG = "[ElasticSearch] %s";
    private static String ES_COMMAND_ERROR_MSG = "[ElasticSearch] %s\n[Exception:%s] %s";
    static IElasticSearchTracer tracer;
    static Configure conf;

    public static void startRequest(Object httpRequestBase) {
        TraceContext ctx = TraceContextManager.getContext();
        if (ctx == null) {
            return;
        }
        if (tracer == null) {
            tracer = ElasticSearchTraceFactory.create(httpRequestBase.getClass().getClassLoader());
        }
        try {
            String esRequestDesc = tracer.getRequestDescription(ctx, httpRequestBase);
            ParameterizedMessageStep step = new ParameterizedMessageStep();
            step.start_time = (int)(System.currentTimeMillis() - ctx.startTime);
            step.putTempMessage("desc", esRequestDesc);
            ctx.profile.add(step);
            StepTransferMap.put(System.identityHashCode(httpRequestBase), ctx, step);
        }
        catch (Throwable e) {
            Logger.println("ES001", e.getMessage(), e);
        }
    }

    public static void endRequest(Object httpUriRequest, Object httpHost, Object httpResponse) {
        TraceElasticSearch.endRequestFinal(httpUriRequest, httpResponse, httpHost, null);
    }

    public static void endFailRequest(Object httpUriRequest, Object node, Exception exception) {
        TraceElasticSearch.endRequestFinal(httpUriRequest, null, node, exception);
    }

    private static void endRequestFinal(Object httpRequestBase, Object httpResponseBase, Object hostOrNode, Throwable throwable) {
        if (httpRequestBase == null) {
            return;
        }
        try {
            int requestBaseHash = System.identityHashCode(httpRequestBase);
            StepTransferMap.ID id = StepTransferMap.get(requestBaseHash);
            if (id == null) {
                return;
            }
            StepTransferMap.remove(requestBaseHash);
            TraceContext ctx = id.ctx;
            ParameterizedMessageStep step = (ParameterizedMessageStep)id.step;
            if (ctx == null || step == null) {
                return;
            }
            if (tracer == null) {
                tracer = ElasticSearchTraceFactory.create(httpRequestBase.getClass().getClassLoader());
            }
            if (throwable == null && httpResponseBase != null) {
                throwable = tracer.getResponseError(httpRequestBase, httpResponseBase);
            }
            int elapsed = (int)(System.currentTimeMillis() - ctx.startTime) - step.start_time;
            step.setElapsed(elapsed);
            String desc = step.getTempMessage("desc");
            if (StringUtil.isEmpty(desc)) {
                desc = "-";
            }
            if (throwable == null) {
                step.setMessage(DataProxy.sendHashedMessage(ES_COMMAND_MSG), desc);
                step.setLevel(ParameterizedMessageLevel.INFO);
            } else {
                String msg = throwable.toString();
                step.setMessage(DataProxy.sendHashedMessage(ES_COMMAND_ERROR_MSG), desc, throwable.getClass().getName(), msg);
                step.setLevel(ParameterizedMessageLevel.ERROR);
                if (ctx.error == 0 && TraceElasticSearch.conf.xlog_error_on_elasticsearch_exception_enabled) {
                    ctx.error = DataProxy.sendError(msg);
                }
            }
            if (TraceElasticSearch.conf.counter_interaction_enabled) {
                String node = tracer.getNode(ctx, hostOrNode);
                int nodeHash = DataProxy.sendObjName(node);
                MeterInteraction meterInteraction = MeterInteractionManager.getInstance().getElasticSearchCallMeter(conf.getObjHash(), nodeHash);
                if (meterInteraction != null) {
                    meterInteraction.add(elapsed, throwable != null);
                }
            }
        }
        catch (Throwable e) {
            Logger.println("ES002", e.getMessage(), e);
        }
    }

    static {
        conf = Configure.getInstance();
    }
}

