/*
 * Decompiled with CFR 0.152.
 */
package scouter.util.scan;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import scouter.util.StringUtil;

public class Scanner {
    private String prefix;

    public Scanner(String prefix) {
        this.prefix = StringUtil.isEmpty(prefix) ? null : prefix.replace('.', '/');
    }

    public Set<String> process() {
        return this.process(Thread.currentThread().getContextClassLoader());
    }

    public Set<String> process(ClassLoader loader) {
        TreeSet<String> mainSet = new TreeSet<String>();
        if (this.prefix == null) {
            return mainSet;
        }
        try {
            Set<File> files = this.getRoot(loader);
            Iterator<File> itr = files.iterator();
            while (itr.hasNext()) {
                Set<String> classes = this.listUp(itr.next());
                mainSet.addAll(classes);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return mainSet;
    }

    public Set<File> getRoot() throws IOException {
        HashSet<File> files = new HashSet<File>();
        if (this.prefix != null) {
            Enumeration<URL> en = Thread.currentThread().getContextClassLoader().getResources(this.prefix);
            while (en.hasMoreElements()) {
                File file = this.parse(en.nextElement());
                files.add(file);
            }
        }
        return files;
    }

    public Set<File> getRoot(ClassLoader loader) throws IOException {
        HashSet<File> files = new HashSet<File>();
        if (this.prefix != null) {
            Enumeration<URL> en = loader.getResources(this.prefix);
            while (en.hasMoreElements()) {
                File file = this.parse(en.nextElement());
                files.add(file);
            }
        }
        return files;
    }

    private File parse(URL res) {
        String file = res.getFile();
        int x = file.indexOf("!");
        if (x > 0) {
            return new File(file.substring(file.indexOf("/"), x));
        }
        return new File(file.substring(file.indexOf("/"), file.length() - this.prefix.length()));
    }

    public Set<String> listUp(File root) {
        HashSet<String> classes = new HashSet<String>();
        if (this.prefix != null) {
            if (root.isDirectory()) {
                this.listUp(classes, new File(root, this.prefix), root.getAbsolutePath());
            } else {
                try {
                    this.listUp(classes, new JarFile(root));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return classes;
    }

    public static Set<String> getClassesInJar(String jarName) {
        HashSet<String> classes = new HashSet<String>();
        try {
            if (jarName == null) {
                return classes;
            }
            JarFile file = new JarFile(jarName);
            Enumeration<JarEntry> en = file.entries();
            while (en.hasMoreElements()) {
                JarEntry entry = en.nextElement();
                if (!entry.getName().toLowerCase().endsWith(".class")) continue;
                classes.add(Scanner.getClassName(entry.getName()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return classes;
    }

    public void listUp(Set<String> classes, JarFile file) {
        if (this.prefix == null) {
            return;
        }
        Enumeration<JarEntry> en = file.entries();
        while (en.hasMoreElements()) {
            JarEntry entry = en.nextElement();
            if (!entry.getName().startsWith(this.prefix) || !entry.getName().toLowerCase().endsWith(".class")) continue;
            classes.add(Scanner.getClassName(entry.getName()));
        }
    }

    private void listUp(Set<String> classes, File file, String root) {
        if (!file.isDirectory()) {
            return;
        }
        File[] sub = file.listFiles();
        for (int i = 0; i < sub.length; ++i) {
            if (sub[i].getName().toLowerCase().endsWith(".class")) {
                String name = sub[i].getAbsolutePath().substring(root.length());
                if ((name = name.replace('\\', '/')).startsWith("/")) {
                    name = name.substring(1);
                }
                classes.add(Scanner.getClassName(name));
            }
            if (sub[i].getName().startsWith(".") || !sub[i].isDirectory()) continue;
            this.listUp(classes, sub[i], root);
        }
    }

    public static String getClassName(String name) {
        return name.substring(0, name.length() - 6).replace('/', '.');
    }

    public static String cutOutLast(String name, String seperator) {
        int x = name.lastIndexOf(seperator);
        if (x < 0) {
            return name;
        }
        return name.substring(0, x);
    }
}

