/*
 * Decompiled with CFR 0.152.
 */
package scouter;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import scouter.util.FileUtil;

public class Version {
    public static String getVersion() {
        Properties properties = Version.getProperties();
        if (properties != null) {
            return properties.get("VERSION").toString();
        }
        return "";
    }

    public static String getBuildVer() {
        Properties properties = Version.getProperties();
        if (properties != null) {
            return properties.get("BUILD").toString();
        }
        return "";
    }

    public static String getAgentFullVersion() {
        return Version.getVersion() + " " + Version.getBuildVer();
    }

    public static String getServerFullVersion() {
        return Version.getVersion() + " " + Version.getBuildVer();
    }

    public static String getServerRecommendedClientVersion() {
        Properties properties = Version.getProperties();
        if (properties != null) {
            return properties.getProperty("CLIENT_VERSION", "");
        }
        return "";
    }

    public static String getClientFullVersion() {
        return Version.getVersion() + " " + Version.getBuildVer();
    }

    public static void main(String[] args) {
        System.out.println("Agent Ver. = " + Version.getAgentFullVersion());
        System.out.println("Server Ver. = " + Version.getServerFullVersion());
        System.out.println("Client Ver. = " + Version.getClientFullVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getProperties() {
        Properties properties = new Properties();
        InputStream is = null;
        try {
            is = Version.class.getResourceAsStream("/scouter/v.properties");
            properties.load(is);
        }
        catch (IOException e) {
            Properties properties2 = null;
            return properties2;
        }
        finally {
            FileUtil.close(is);
        }
        return properties;
    }

    public static int versionCompare(String str1, String str2) {
        if (str1 == null && str2 == null) {
            return 0;
        }
        if (str1 == null) {
            return -1;
        }
        if (str2 == null) {
            return 1;
        }
        str1 = Version.numonly(str1);
        str2 = Version.numonly(str2);
        String[] thisParts = str1.split("\\.");
        String[] thatParts = str2.split("\\.");
        int length = Math.max(thisParts.length, thatParts.length);
        for (int i = 0; i < length; ++i) {
            long thatPart;
            long thisPart = i < thisParts.length ? Long.parseLong(thisParts[i]) : 0L;
            long l = thatPart = i < thatParts.length ? Long.parseLong(thatParts[i]) : 0L;
            if (thisPart < thatPart) {
                return -1;
            }
            if (thisPart <= thatPart) continue;
            return 1;
        }
        return 0;
    }

    private static String numonly(String t) {
        char[] c = t.toCharArray();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < c.length; ++i) {
            switch (c[i]) {
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    sb.append(c[i]);
                }
            }
        }
        return sb.toString();
    }
}

