/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent;

import java.io.File;
import scouter.agent.ClassDesc;
import scouter.agent.Configure;
import scouter.org.objectweb.asm.ClassReader;
import scouter.org.objectweb.asm.ClassVisitor;
import scouter.util.FileUtil;
import scouter.util.StringKeyLinkedMap;
import scouter.util.StringUtil;

public class DirectPatch {
    static StringKeyLinkedMap<byte[]> classPatchMap = new StringKeyLinkedMap();

    private static String getClassName(byte[] bytes) {
        try {
            final ClassDesc classDesc = new ClassDesc();
            ClassReader cr = new ClassReader(bytes);
            cr.accept(new ClassVisitor(524288){

                @Override
                public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                    classDesc.set(version, access, name, signature, superName, interfaces);
                }
            }, 0);
            return classDesc.name.replace('.', '/');
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static byte[] patch(String name, byte[] org) {
        byte[] patchClass = classPatchMap.get(name);
        return patchClass != null ? patchClass : org;
    }

    static {
        try {
            String patch = Configure.getInstance()._hook_direct_patch_classes;
            String[] files = StringUtil.tokenizer(patch, ",;");
            for (int i = 0; files != null && i < files.length; ++i) {
                String classname;
                byte[] bytes = FileUtil.readAll(new File(files[i]));
                if (bytes == null || (classname = DirectPatch.getClassName(bytes)) == null) continue;
                classPatchMap.put(classname, bytes);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

