/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.asm;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import scouter.agent.ClassDesc;
import scouter.agent.Configure;
import scouter.agent.asm.ApicallInfoCV;
import scouter.agent.asm.IASM;
import scouter.agent.asm.util.AsmUtil;
import scouter.agent.asm.util.HookingSet;
import scouter.org.objectweb.asm.ClassVisitor;
import scouter.org.objectweb.asm.Opcodes;

public class ApicallInfoASM
implements IASM,
Opcodes {
    private List<HookingSet> target;
    private Map<String, HookingSet> reserved;

    public ApicallInfoASM() {
        this.target = HookingSet.getHookingMethodSet(Configure.getInstance().hook_apicall_info_patterns);
        this.reserved = new HashMap<String, HookingSet>();
        AsmUtil.add(this.reserved, "io/reactivex/netty/protocol/http/client/HttpClientRequest", "setDynamicUriParts");
    }

    @Override
    public ClassVisitor transform(ClassVisitor cv, String className, ClassDesc classDesc) {
        if (!Configure.getInstance()._hook_apicall_enabled) {
            return cv;
        }
        HookingSet mset = this.reserved.get(className);
        if (mset != null) {
            return new ApicallInfoCV(cv, mset, className);
        }
        for (int i = 0; i < this.target.size(); ++i) {
            mset = this.target.get(i);
            if (!mset.classMatch.include(className)) continue;
            return new ApicallInfoCV(cv, mset, className);
        }
        return cv;
    }
}

