/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.counter.meter;

import scouter.lang.ref.INT;
import scouter.lang.ref.LONG;
import scouter.util.MeteringUtil;

public class MeterService {
    private static MeterService inst = new MeterService();
    static final int PCT_MAX_TIME = 10000;
    static final int PCT_UNIT_TIME = 200;
    static final int PCT_BUCKET = 50;
    private MeteringUtil<Bucket> meter = new MeteringUtil<Bucket>(){

        @Override
        protected Bucket create() {
            return new Bucket();
        }

        @Override
        protected void clear(Bucket o) {
            o.count = 0;
            o.error = 0;
            o.elapsedTime = 0L;
            o.sqlTimeByService = 0L;
            o.apiTmeByService = 0L;
            o.queuingTime = 0L;
            for (int i = 0; i < 50; ++i) {
                o.pct90[i] = 0;
            }
        }
    };

    public static MeterService getInstance() {
        return inst;
    }

    public synchronized void add(long elapsed, int sqlTime, int apiTime, int queuingTime, boolean err) {
        if (elapsed < 0L) {
            elapsed = 0L;
        }
        Bucket b = this.meter.getCurrentBucket();
        ++b.count;
        b.elapsedTime += elapsed;
        b.sqlTimeByService += (long)sqlTime;
        b.apiTmeByService += (long)apiTime;
        b.queuingTime += (long)queuingTime;
        if (err) {
            ++b.error;
        }
        if (elapsed < 10000L) {
            int x;
            int n = x = (int)(elapsed / 200L);
            b.pct90[n] = (short)(b.pct90[n] + 1);
        }
    }

    public float getTPS(int period) {
        final INT sum = new INT();
        period = this.meter.search(period, new MeteringUtil.Handler<Bucket>(){

            @Override
            public void process(Bucket b) {
                sum.value += b.count;
            }
        });
        return (float)((double)sum.value / (double)period);
    }

    public int getElapsedTime(int period) {
        final LONG sum = new LONG();
        final INT cnt = new INT();
        this.meter.search(period, new MeteringUtil.Handler<Bucket>(){

            @Override
            public void process(Bucket b) {
                sum.value += b.elapsedTime;
                cnt.value += b.count;
            }
        });
        return (int)(cnt.value == 0 ? 0L : sum.value / (long)cnt.value);
    }

    public int getElapsed90Pct(int period) {
        final LONG sum = new LONG();
        final INT cnt = new INT();
        this.meter.search(period, new MeteringUtil.Handler<Bucket>(){

            @Override
            public void process(Bucket b) {
                int total = (int)((double)b.count * 0.9);
                if (total == 0) {
                    return;
                }
                for (int timeInx = 0; timeInx < 50; ++timeInx) {
                    if (total >= b.pct90[timeInx]) {
                        total -= b.pct90[timeInx];
                        continue;
                    }
                    sum.value += (long)(timeInx * 200);
                    ++cnt.value;
                    return;
                }
                sum.value += 10000L;
                ++cnt.value;
            }
        });
        return (int)(cnt.value == 0 ? 0L : sum.value / (long)cnt.value);
    }

    public int getSqlTime(int period) {
        final LONG sum = new LONG();
        final INT cnt = new INT();
        this.meter.search(period, new MeteringUtil.Handler<Bucket>(){

            @Override
            public void process(Bucket b) {
                sum.value += b.sqlTimeByService;
                cnt.value += b.count;
            }
        });
        return (int)(cnt.value == 0 ? 0L : sum.value / (long)cnt.value);
    }

    public int getApiTime(int period) {
        final LONG sum = new LONG();
        final INT cnt = new INT();
        this.meter.search(period, new MeteringUtil.Handler<Bucket>(){

            @Override
            public void process(Bucket b) {
                sum.value += b.apiTmeByService;
                cnt.value += b.count;
            }
        });
        return (int)(cnt.value == 0 ? 0L : sum.value / (long)cnt.value);
    }

    public int getQueuingTime(int period) {
        final LONG sum = new LONG();
        final INT cnt = new INT();
        this.meter.search(period, new MeteringUtil.Handler<Bucket>(){

            @Override
            public void process(Bucket b) {
                sum.value += b.queuingTime;
                cnt.value += b.count;
            }
        });
        return (int)(cnt.value == 0 ? 0L : sum.value / (long)cnt.value);
    }

    public float getErrorRate(int period) {
        final INT cnt = new INT();
        final INT err = new INT();
        this.meter.search(period, new MeteringUtil.Handler<Bucket>(){

            @Override
            public void process(Bucket b) {
                cnt.value += b.count;
                err.value += b.error;
            }
        });
        return (float)(cnt.value == 0 ? 0.0 : (double)err.value / (double)cnt.value * 100.0);
    }

    public int getServiceCount(int period) {
        final INT sum = new INT();
        this.meter.search(period, new MeteringUtil.Handler<Bucket>(){

            @Override
            public void process(Bucket b) {
                sum.value += b.count;
            }
        });
        return sum.value;
    }

    public int getServiceError(int period) {
        final INT sum = new INT();
        this.meter.search(period, new MeteringUtil.Handler<Bucket>(){

            @Override
            public void process(Bucket b) {
                sum.value += b.error;
            }
        });
        return sum.value;
    }

    static final class Bucket {
        final short[] pct90 = new short[50];
        int count;
        long elapsedTime;
        long sqlTimeByService;
        long apiTmeByService;
        long queuingTime;
        int error;

        Bucket() {
        }
    }
}

