/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.counter.task;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.List;
import scouter.agent.Configure;
import scouter.agent.counter.CounterBasket;
import scouter.agent.counter.anotation.Counter;
import scouter.agent.counter.meter.MeterResource;
import scouter.agent.trace.AlertProxy;
import scouter.lang.pack.PerfCounterPack;
import scouter.lang.value.FloatValue;

public class PermGen {
    MemoryPoolMXBean permGenBean;
    public MeterResource meter = new MeterResource();

    @Counter
    public void getPermGen(CounterBasket pw) {
        if (this.permGenBean == null) {
            try {
                List<MemoryPoolMXBean> beans = ManagementFactory.getMemoryPoolMXBeans();
                for (MemoryPoolMXBean bean : beans) {
                    if (bean.getName().toUpperCase().contains("PERM GEN")) {
                        this.permGenBean = bean;
                    } else {
                        if (!bean.getName().toUpperCase().contains("METASPACE")) continue;
                        this.permGenBean = bean;
                    }
                    break;
                }
            }
            catch (Throwable beans) {
                // empty catch block
            }
        }
        if (this.permGenBean == null) {
            return;
        }
        MemoryUsage usage = this.permGenBean.getUsage();
        long used = usage.getUsed();
        this.meter.add(used);
        float usedM = (float)used / 1024.0f / 1024.0f;
        float max = (float)usage.getMax() / 1024.0f / 1024.0f;
        PerfCounterPack p = pw.getPack((byte)1);
        p.put("PermUsed", new FloatValue(usedM));
        if (usage.getMax() != -1L) {
            p.put("PermPercent", new FloatValue(usedM * 100.0f / max));
            Configure conf = Configure.getInstance();
            float rate = used * 100L / usage.getMax();
            if (rate >= (float)conf.alert_perm_warning_pct) {
                AlertProxy.sendAlert((byte)1, "WARNING_MEMORY_HIGH", "warning perm usage used=" + used / 1024L / 1024L + "MB rate=" + rate + "%");
            }
        }
        p = pw.getPack((byte)3);
        p.put("PermUsed", new FloatValue((float)(this.meter.getAvg(300) / 1024.0 / 1024.0)));
    }
}

