/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.netio.request;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import scouter.agent.Logger;
import scouter.agent.netio.request.anotation.RequestHandler;
import scouter.io.DataInputX;
import scouter.io.DataOutputX;
import scouter.lang.pack.Pack;
import scouter.util.scan.Scanner;

public class ReqestHandlingProxy {
    protected static HashMap<String, Invocation> handlers = new HashMap();

    public static void load(Class cls) {
        String pkg = Scanner.cutOutLast(cls.getName(), ".");
        Set<String> classes = new Scanner(pkg).process();
        Set<String> custom = new Scanner(System.getProperty("scouter.handler")).process();
        classes.addAll(custom);
        Iterator<String> itr = classes.iterator();
        while (itr.hasNext()) {
            try {
                Class<?> c = Class.forName(itr.next());
                if (!Modifier.isPublic(c.getModifiers())) continue;
                try {
                    Method[] m = c.getDeclaredMethods();
                    for (int i = 0; i < m.length; ++i) {
                        RequestHandler mapAn = m[i].getAnnotation(RequestHandler.class);
                        if (mapAn == null) continue;
                        String key = mapAn.value();
                        Invocation news = new Invocation(c.newInstance(), m[i], m[i].getParameterTypes());
                        Invocation olds = handlers.get(key);
                        if (olds != null) {
                            Logger.println("A129", "Warning duplicated Handler key=" + key + " " + olds + " <-> " + news);
                        }
                        handlers.put(key, news);
                    }
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public static Pack process(String cmd, Pack req, DataInputX in, DataOutputX out) {
        if ("KEEP_ALIVE".equals(cmd)) {
            return null;
        }
        Invocation handler = handlers.get(cmd);
        if (handler != null) {
            return handler.exec(req, in, out);
        }
        Logger.println("A130", "TCP unknown cmd=" + cmd);
        return null;
    }

    public static void main(String[] args) {
        ReqestHandlingProxy.load(ReqestHandlingProxy.class);
    }

    protected static class Invocation {
        Object object;
        Method method;
        Class[] pTypes;

        public Invocation(Object object, Method method, Class[] paramter) {
            this.object = object;
            this.method = method;
            this.pTypes = paramter;
        }

        public Pack exec(Pack p, DataInputX in, DataOutputX out) {
            try {
                switch (this.pTypes.length) {
                    case 3: {
                        return (Pack)this.method.invoke(this.object, p, in, out);
                    }
                }
                return (Pack)this.method.invoke(this.object, p);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public String toString() {
            return this.object.getClass().getName() + "." + this.method.getName();
        }
    }
}

