/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.trace.api;

import scouter.agent.Configure;
import scouter.agent.Logger;
import scouter.agent.plugin.PluginHttpCallTrace;
import scouter.agent.proxy.HttpClient43Factory;
import scouter.agent.proxy.IHttpClient;
import scouter.agent.trace.HookArgs;
import scouter.agent.trace.TraceContext;
import scouter.agent.trace.api.ApiCallTraceHelper;
import scouter.lang.step.ApiCallStep;
import scouter.util.Hexa32;
import scouter.util.IntKeyLinkedMap;
import scouter.util.KeyGen;

public class ForHttpClient40
implements ApiCallTraceHelper.IHelper {
    private boolean ok = true;
    private static IntKeyLinkedMap<IHttpClient> httpclients = new IntKeyLinkedMap().setMax(5);

    @Override
    public ApiCallStep process(TraceContext ctx, HookArgs hookPoint) {
        ApiCallStep step = new ApiCallStep();
        try {
            if (!this.ok) {
                ctx.apicall_name = hookPoint.class1 + "." + hookPoint.method;
            }
            if (hookPoint.args != null && hookPoint.args.length >= 2) {
                IHttpClient httpclient = this.getProxy(hookPoint);
                step.txid = KeyGen.next();
                this.transfer(httpclient, ctx, hookPoint.args[0], hookPoint.args[1], step.txid);
                String host = httpclient.getHost(hookPoint.args[0]);
                step.opt = 1;
                step.address = host;
                if (host != null) {
                    ctx.apicall_target = host;
                }
                ctx.apicall_name = httpclient.getURI(hookPoint.args[1]);
            }
        }
        catch (Exception e) {
            this.ok = false;
            ctx.apicall_name = e.toString();
        }
        if (ctx.apicall_name == null) {
            ctx.apicall_name = hookPoint.class1;
        }
        return step;
    }

    @Override
    public void processEnd(TraceContext ctx, ApiCallStep step, Object rtn, HookArgs hookPoint) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IHttpClient getProxy(HookArgs hookPoint) {
        int key = System.identityHashCode(hookPoint.this1.getClass());
        IHttpClient httpclient = httpclients.get(key);
        if (httpclient == null) {
            ForHttpClient40 forHttpClient40 = this;
            synchronized (forHttpClient40) {
                httpclient = HttpClient43Factory.create(hookPoint.this1.getClass().getClassLoader());
                httpclients.put(key, httpclient);
            }
        }
        return httpclient;
    }

    private void transfer(IHttpClient httpclient, TraceContext ctx, Object host, Object req, long calleeTxid) {
        Configure conf = Configure.getInstance();
        if (conf.trace_interservice_enabled) {
            try {
                if (ctx.gxid == 0L) {
                    ctx.gxid = ctx.txid;
                }
                httpclient.addHeader(req, conf._trace_interservice_gxid_header_key, Hexa32.toString32(ctx.gxid));
                httpclient.addHeader(req, conf._trace_interservice_caller_header_key, Hexa32.toString32(ctx.txid));
                httpclient.addHeader(req, conf._trace_interservice_callee_header_key, Hexa32.toString32(calleeTxid));
                httpclient.addHeader(req, conf._trace_interservice_caller_obj_header_key, String.valueOf(conf.getObjHash()));
                httpclient.addHeader(req, "x-b3-traceid", Hexa32.toUnsignedLongHex(ctx.gxid));
                httpclient.addHeader(req, "x-b3-parentspanid", Hexa32.toUnsignedLongHex(ctx.txid));
                httpclient.addHeader(req, "x-b3-spanid", Hexa32.toUnsignedLongHex(calleeTxid));
                PluginHttpCallTrace.call(ctx, req);
            }
            catch (Throwable e) {
                Logger.println("A001", e);
                this.ok = false;
            }
        }
    }
}

