/*
 * Decompiled with CFR 0.152.
 */
package scouter.io;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import scouter.lang.pack.Pack;
import scouter.lang.step.Step;
import scouter.lang.value.NullValue;
import scouter.lang.value.Value;

public class DataOutputX {
    public static final int INT3_MIN_VALUE = -8388608;
    public static final int INT3_MAX_VALUE = 0x7FFFFF;
    public static final long LONG5_MIN_VALUE = -549755813888L;
    public static final long LONG5_MAX_VALUE = 0x7FFFFFFFFFL;
    private int written;
    private DataOutput inner;
    private ByteArrayOutputStream bout;

    public DataOutputX(int size) {
        this(new ByteArrayOutputStream(size));
    }

    public DataOutputX() {
        this(new ByteArrayOutputStream());
    }

    public byte[] toByteArray() {
        if (this.bout != null) {
            return this.bout.toByteArray();
        }
        return null;
    }

    public DataOutputX(ByteArrayOutputStream byteout) {
        this.bout = byteout;
        this.inner = new DataOutputStream(byteout);
    }

    public DataOutputX(BufferedOutputStream anyout) {
        this.inner = new DataOutputStream(anyout);
    }

    public DataOutputX(DataOutputStream out) {
        this.inner = out;
    }

    public DataOutputX(RandomAccessFile out) {
        this.inner = out;
    }

    public DataOutputX writeIntBytes(byte[] b) throws IOException {
        this.writeInt(b.length);
        this.write(b);
        return this;
    }

    public DataOutputX writeShortBytes(byte[] b) throws IOException {
        this.writeShort(b.length);
        this.write(b);
        return this;
    }

    public DataOutputX writeBlob(byte[] value, int offset, int length) throws IOException {
        if (value == null || value.length == 0) {
            this.writeByte(0);
        } else {
            int len = Math.min(length, value.length - offset);
            if (len <= 253) {
                this.writeByte((byte)len);
                this.write(value, offset, len);
            } else if (len <= 65535) {
                byte[] buff = new byte[3];
                buff[0] = -1;
                this.write(DataOutputX.toBytes(buff, 1, (short)len));
                this.write(value, offset, len);
            } else {
                byte[] buff = new byte[5];
                buff[0] = -2;
                this.write(DataOutputX.toBytes(buff, 1, len));
                this.write(value, offset, len);
            }
        }
        return this;
    }

    public DataOutputX writeBlob(byte[] value) throws IOException {
        if (value == null || value.length == 0) {
            this.writeByte(0);
        } else {
            int len = value.length;
            if (len <= 253) {
                this.writeByte((byte)len);
                this.write(value);
            } else if (len <= 65535) {
                byte[] buff = new byte[3];
                buff[0] = -1;
                this.write(DataOutputX.toBytes(buff, 1, (short)len));
                this.write(value);
            } else {
                byte[] buff = new byte[5];
                buff[0] = -2;
                this.write(DataOutputX.toBytes(buff, 1, len));
                this.write(value);
            }
        }
        return this;
    }

    public DataOutputX writeText(String s) throws IOException {
        if (s == null) {
            this.writeByte(0);
        } else {
            this.writeBlob(s.getBytes("UTF8"));
        }
        return this;
    }

    public DataOutputX writeText(StringBuffer s) throws IOException {
        if (s == null) {
            this.writeByte(0);
        } else {
            this.writeBlob(s.toString().getBytes("UTF8"));
        }
        return this;
    }

    public DataOutputX writeInt3(int v) throws IOException {
        this.write(DataOutputX.toBytes3(v), 0, 3);
        return this;
    }

    public DataOutputX writeLong5(long v) throws IOException {
        this.write(DataOutputX.toBytes5(v), 0, 5);
        return this;
    }

    public DataOutputX writeDecimal(long v) throws IOException {
        if (v == 0L) {
            this.writeByte(0);
        } else if (-128L <= v && v <= 127L) {
            byte[] b = new byte[]{1, (byte)v};
            this.write(b);
        } else if (-32768L <= v && v <= 32767L) {
            byte[] b = new byte[3];
            b[0] = 2;
            DataOutputX.toBytes(b, 1, (short)v);
            this.write(b);
        } else if (-8388608L <= v && v <= 0x7FFFFFL) {
            byte[] b = new byte[4];
            b[0] = 3;
            this.write(DataOutputX.toBytes3(b, 1, (int)v), 0, 4);
        } else if (Integer.MIN_VALUE <= v && v <= Integer.MAX_VALUE) {
            byte[] b = new byte[5];
            b[0] = 4;
            this.write(DataOutputX.toBytes(b, 1, (int)v), 0, 5);
        } else if (-549755813888L <= v && v <= 0x7FFFFFFFFFL) {
            byte[] b = new byte[6];
            b[0] = 5;
            this.write(DataOutputX.toBytes5(b, 1, v), 0, 6);
        } else if (Long.MIN_VALUE <= v && v <= Long.MAX_VALUE) {
            byte[] b = new byte[9];
            b[0] = 8;
            this.write(DataOutputX.toBytes(b, 1, v), 0, 9);
        }
        return this;
    }

    public DataOutputX wrttenDecimal(long v) throws IOException {
        this.writeDecimal(v);
        this.flush();
        return this;
    }

    public static byte[] toBytes(short v) {
        byte[] buf = new byte[]{(byte)(v >>> 8 & 0xFF), (byte)(v >>> 0 & 0xFF)};
        return buf;
    }

    public static byte[] toBytes(byte[] buf, int off, short v) {
        buf[off] = (byte)(v >>> 8 & 0xFF);
        buf[off + 1] = (byte)(v >>> 0 & 0xFF);
        return buf;
    }

    public static byte[] toBytes(int v) {
        byte[] buf = new byte[]{(byte)(v >>> 24 & 0xFF), (byte)(v >>> 16 & 0xFF), (byte)(v >>> 8 & 0xFF), (byte)(v >>> 0 & 0xFF)};
        return buf;
    }

    public static byte[] toBytes(byte[] buf, int off, int v) {
        buf[off] = (byte)(v >>> 24 & 0xFF);
        buf[off + 1] = (byte)(v >>> 16 & 0xFF);
        buf[off + 2] = (byte)(v >>> 8 & 0xFF);
        buf[off + 3] = (byte)(v >>> 0 & 0xFF);
        return buf;
    }

    public static byte[] toBytes3(int v) {
        byte[] buf = new byte[]{(byte)(v >>> 16 & 0xFF), (byte)(v >>> 8 & 0xFF), (byte)(v >>> 0 & 0xFF)};
        return buf;
    }

    public static byte[] toBytes3(byte[] buf, int off, int v) {
        buf[off] = (byte)(v >>> 16 & 0xFF);
        buf[off + 1] = (byte)(v >>> 8 & 0xFF);
        buf[off + 2] = (byte)(v >>> 0 & 0xFF);
        return buf;
    }

    public static byte[] toBytes(long v) {
        byte[] buf = new byte[]{(byte)(v >>> 56), (byte)(v >>> 48), (byte)(v >>> 40), (byte)(v >>> 32), (byte)(v >>> 24), (byte)(v >>> 16), (byte)(v >>> 8), (byte)(v >>> 0)};
        return buf;
    }

    public static byte[] toBytes(byte[] buf, int off, long v) {
        buf[off] = (byte)(v >>> 56);
        buf[off + 1] = (byte)(v >>> 48);
        buf[off + 2] = (byte)(v >>> 40);
        buf[off + 3] = (byte)(v >>> 32);
        buf[off + 4] = (byte)(v >>> 24);
        buf[off + 5] = (byte)(v >>> 16);
        buf[off + 6] = (byte)(v >>> 8);
        buf[off + 7] = (byte)(v >>> 0);
        return buf;
    }

    public static byte[] toBytes5(long v) {
        byte[] writeBuffer = new byte[]{(byte)(v >>> 32), (byte)(v >>> 24), (byte)(v >>> 16), (byte)(v >>> 8), (byte)(v >>> 0)};
        return writeBuffer;
    }

    public static byte[] toBytes5(byte[] buf, int off, long v) {
        buf[off] = (byte)(v >>> 32);
        buf[off + 1] = (byte)(v >>> 24);
        buf[off + 2] = (byte)(v >>> 16);
        buf[off + 3] = (byte)(v >>> 8);
        buf[off + 4] = (byte)(v >>> 0);
        return buf;
    }

    public static byte[] toBytes(boolean b) {
        if (b) {
            return new byte[]{1};
        }
        return new byte[]{0};
    }

    public static byte[] toBytes(byte[] buf, int off, boolean b) {
        buf[off] = b ? (byte)1 : 0;
        return buf;
    }

    public static byte[] toBytes(float v) {
        return DataOutputX.toBytes(Float.floatToIntBits(v));
    }

    public static byte[] toBytes(byte[] buf, int off, float v) {
        return DataOutputX.toBytes(buf, off, Float.floatToIntBits(v));
    }

    public static byte[] toBytes(double v) {
        return DataOutputX.toBytes(Double.doubleToLongBits(v));
    }

    public static byte[] toBytes(byte[] buf, int off, double v) {
        return DataOutputX.toBytes(buf, off, Double.doubleToLongBits(v));
    }

    public static byte[] set(byte[] dest, int pos, byte[] src) {
        System.arraycopy(src, 0, dest, pos, src.length);
        return dest;
    }

    public DataOutputX writeDecimalArray(int[] v) throws IOException {
        if (v == null) {
            this.writeDecimal(0L);
        } else {
            this.writeDecimal(v.length);
            for (int i = 0; i < v.length; ++i) {
                this.writeDecimal(v[i]);
            }
        }
        return this;
    }

    public DataOutputX writeDecimalArray(long[] v) throws IOException {
        if (v == null) {
            this.writeDecimal(0L);
        } else {
            this.writeDecimal(v.length);
            for (int i = 0; i < v.length; ++i) {
                this.writeDecimal(v[i]);
            }
        }
        return this;
    }

    public DataOutputX writeArray(long[] v) throws IOException {
        if (v == null) {
            this.writeShort(0);
        } else {
            this.writeShort(v.length);
            for (int i = 0; i < v.length; ++i) {
                this.writeLong(v[i]);
            }
        }
        return this;
    }

    public DataOutputX writeArray(int[] v) throws IOException {
        if (v == null) {
            this.writeShort(0);
        } else {
            this.writeShort(v.length);
            for (int i = 0; i < v.length; ++i) {
                this.writeInt(v[i]);
            }
        }
        return this;
    }

    public DataOutputX writeArray(float[] v) throws IOException {
        if (v == null) {
            this.writeShort(0);
        } else {
            this.writeShort(v.length);
            for (int i = 0; i < v.length; ++i) {
                this.writeFloat(v[i]);
            }
        }
        return this;
    }

    public DataOutputX writeValue(Value value) throws IOException {
        if (value == null) {
            value = NullValue.value;
        }
        this.writeByte(value.getValueType());
        value.write(this);
        return this;
    }

    public DataOutputX writeStep(Step step) throws IOException {
        this.writeByte(step.getStepType());
        step.write(this);
        return this;
    }

    public DataOutputX writePack(Pack packet) throws IOException {
        this.writeByte(packet.getPackType());
        packet.write(this);
        return this;
    }

    public DataOutputX write(byte[] b) throws IOException {
        this.written += b.length;
        this.inner.write(b);
        return this;
    }

    public DataOutputX write(byte[] b, int off, int len) throws IOException {
        this.written += len;
        this.inner.write(b, off, len);
        return this;
    }

    public DataOutputX writeBoolean(boolean v) throws IOException {
        ++this.written;
        this.inner.writeBoolean(v);
        return this;
    }

    public DataOutputX writeByte(int v) throws IOException {
        ++this.written;
        this.inner.writeByte((byte)v);
        return this;
    }

    public DataOutputX writeShort(int v) throws IOException {
        this.written += 2;
        this.inner.write(DataOutputX.toBytes((short)v));
        return this;
    }

    public DataOutputX writeChar(int v) throws IOException {
        this.written += 2;
        this.inner.writeChar(v);
        return this;
    }

    public DataOutputX writeInt(int v) throws IOException {
        this.written += 4;
        this.inner.write(DataOutputX.toBytes(v));
        return this;
    }

    public DataOutputX writeLong(long v) throws IOException {
        this.written += 8;
        this.inner.write(DataOutputX.toBytes(v));
        return this;
    }

    public DataOutputX writeFloat(float v) throws IOException {
        this.written += 4;
        this.inner.write(DataOutputX.toBytes(v));
        return this;
    }

    public DataOutputX writeDouble(double v) throws IOException {
        this.written += 8;
        this.inner.write(DataOutputX.toBytes(v));
        return this;
    }

    public int size() {
        return this.written;
    }

    public int getWriteSize() {
        return this.written;
    }

    public void close() throws IOException {
        if (this.inner instanceof RandomAccessFile) {
            ((RandomAccessFile)this.inner).close();
        } else if (this.inner instanceof OutputStream) {
            ((OutputStream)((Object)this.inner)).close();
        }
    }

    public void flush() throws IOException {
        if (this.inner instanceof OutputStream) {
            ((OutputStream)((Object)this.inner)).flush();
        }
    }
}

