/*
 * Decompiled with CFR 0.152.
 */
package scouter.lang.pack;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import scouter.io.DataInputX;
import scouter.io.DataOutputX;
import scouter.lang.pack.Pack;
import scouter.lang.value.ListValue;
import scouter.lang.value.MapValue;
import scouter.util.IPUtil;

public class SpanPack
implements Pack {
    public long gxid;
    public long txid;
    public long caller;
    public long timestamp;
    public int elapsed;
    public byte spanType;
    public int name;
    public int objHash;
    public int error;
    public int localEndpointServiceName;
    public byte[] localEndpointIp;
    public short localEndpointPort;
    public int remoteEndpointServiceName;
    public byte[] remoteEndpointIp;
    public short remoteEndpointPort;
    public boolean debug;
    public boolean shared;
    public ListValue annotationTimestamps;
    public ListValue annotationValues;
    public MapValue tags;

    @Override
    public byte getPackType() {
        return 31;
    }

    public String toString() {
        return "SpanPack{gxid=" + this.gxid + ", txid=" + this.txid + ", caller=" + this.caller + ", timestamp=" + this.timestamp + ", elapsed=" + this.elapsed + ", spanType=" + this.spanType + ", name=" + this.name + ", objHash=" + this.objHash + ", error=" + this.error + ", localEndpointServiceName=" + this.localEndpointServiceName + ", localEndpointIp=" + IPUtil.toString(this.localEndpointIp) + ", localEndpointPort=" + this.localEndpointPort + ", remoteEndpointServiceName=" + this.remoteEndpointServiceName + ", remoteEndpointIp=" + IPUtil.toString(this.remoteEndpointIp) + ", remoteEndpointPort=" + this.remoteEndpointPort + ", debug=" + this.debug + ", shared=" + this.shared + ", annotationTimestamps=" + this.annotationTimestamps + ", annotationValues=" + this.annotationValues + ", tags=" + this.tags + '}';
    }

    @Override
    public void write(DataOutputX dout) throws IOException {
        dout.writeLong(this.gxid);
        dout.writeLong(this.txid);
        dout.writeLong(this.caller);
        dout.writeLong(this.timestamp);
        dout.writeDecimal(this.elapsed);
        dout.writeByte(this.spanType);
        dout.writeDecimal(this.name);
        dout.writeDecimal(this.objHash);
        dout.writeDecimal(this.error);
        dout.writeDecimal(this.localEndpointServiceName);
        dout.writeBlob(this.localEndpointIp);
        dout.writeShort(this.localEndpointPort);
        dout.writeDecimal(this.remoteEndpointServiceName);
        dout.writeBlob(this.remoteEndpointIp);
        dout.writeShort(this.remoteEndpointPort);
        dout.writeBoolean(this.debug);
        dout.writeBoolean(this.shared);
        dout.writeValue(this.annotationTimestamps);
        dout.writeValue(this.annotationValues);
        dout.writeValue(this.tags);
    }

    @Override
    public Pack read(DataInputX din) throws IOException {
        this.gxid = din.readLong();
        this.txid = din.readLong();
        this.caller = din.readLong();
        this.timestamp = din.readLong();
        this.elapsed = (int)din.readDecimal();
        this.spanType = din.readByte();
        this.name = (int)din.readDecimal();
        this.objHash = (int)din.readDecimal();
        this.error = (int)din.readDecimal();
        this.localEndpointServiceName = (int)din.readDecimal();
        this.localEndpointIp = din.readBlob();
        this.localEndpointPort = din.readShort();
        this.remoteEndpointServiceName = (int)din.readDecimal();
        this.remoteEndpointIp = din.readBlob();
        this.remoteEndpointPort = din.readShort();
        this.debug = din.readBoolean();
        this.shared = din.readBoolean();
        this.annotationTimestamps = (ListValue)din.readValue();
        this.annotationValues = (ListValue)din.readValue();
        this.tags = (MapValue)din.readValue();
        return this;
    }

    public static byte[] toBytes(SpanPack[] pack) {
        if (pack == null) {
            return null;
        }
        try {
            DataOutputX dout = new DataOutputX(pack.length * 300);
            for (int i = 0; i < pack.length; ++i) {
                dout.writePack(pack[i]);
            }
            return dout.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static byte[] toBytes(List<SpanPack> packs) {
        if (packs == null) {
            return null;
        }
        try {
            int size = packs.size();
            DataOutputX dout = new DataOutputX(size * 300);
            for (int i = 0; i < size; ++i) {
                dout.writePack(packs.get(i));
            }
            return dout.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static List<byte[]> toBytesList(List<SpanPack> packs, int maxBytes) {
        if (packs == null) {
            return null;
        }
        try {
            ArrayList<byte[]> byteResultList = new ArrayList<byte[]>();
            int maxLen = Math.max(maxBytes - 18000, 18000);
            int size = packs.size();
            DataOutputX dout = new DataOutputX(Math.min(size * 500, maxBytes));
            for (SpanPack pack : packs) {
                dout.writePack(pack);
                if (dout.getWriteSize() <= maxLen) continue;
                byteResultList.add(dout.toByteArray());
                dout = new DataOutputX(Math.min(size * 500, maxBytes));
            }
            if (dout.getWriteSize() > 0) {
                byteResultList.add(dout.toByteArray());
            }
            return byteResultList;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static SpanPack[] toObjects(byte[] buff) throws IOException {
        if (buff == null) {
            return null;
        }
        ArrayList<SpanPack> arr = new ArrayList<SpanPack>();
        DataInputX din = new DataInputX(buff);
        while (din.available() > 0) {
            arr.add((SpanPack)din.readPack());
        }
        return arr.toArray(new SpanPack[arr.size()]);
    }

    public static List<SpanPack> toObjectList(byte[] buff) {
        if (buff == null) {
            return null;
        }
        ArrayList<SpanPack> arr = new ArrayList<SpanPack>();
        DataInputX din = new DataInputX(buff);
        try {
            while (din.available() > 0) {
                arr.add((SpanPack)din.readPack());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return arr;
    }
}

