/*
 * Decompiled with CFR 0.152.
 */
package scouter.util;

import scouter.io.DataOutputX;
import scouter.util.StringUtil;

public class IPUtil {
    private static byte[] empty = new byte[]{0, 0, 0, 0};

    public static String toString(int ip) {
        return IPUtil.toString(DataOutputX.toBytes(ip));
    }

    public static String toString(byte[] ip) {
        if (ip == null) {
            return "0.0.0.0";
        }
        try {
            StringBuffer sb = new StringBuffer();
            sb.append(ip[0] & 0xFF);
            sb.append(".");
            sb.append(ip[1] & 0xFF);
            sb.append(".");
            sb.append(ip[2] & 0xFF);
            sb.append(".");
            sb.append(ip[3] & 0xFF);
            return sb.toString();
        }
        catch (Throwable e) {
            return "0.0.0.0";
        }
    }

    public static byte[] toBytes(String ip) {
        if (ip == null) {
            return empty;
        }
        byte[] result = new byte[4];
        String[] s = StringUtil.split(ip, '.');
        try {
            if (s.length != 4) {
                return empty;
            }
            for (int i = 0; i < 4; ++i) {
                long val = Integer.parseInt(s[i]);
                if (val < 0L || val > 255L) {
                    return null;
                }
                result[i] = (byte)(val & 0xFFL);
            }
        }
        catch (Throwable e) {
            return empty;
        }
        return result;
    }

    public static boolean isOK(byte[] ip) {
        return ip != null && ip.length == 4;
    }

    public static boolean isNotLocal(byte[] ip) {
        return IPUtil.isOK(ip) && (ip[0] & 0xFF) != 127;
    }

    public static void main(String[] args) {
        String[] s = StringUtil.split("127.0.0.1", '.');
        System.out.println(s[0]);
        System.out.println(s[1]);
        System.out.println(s[2]);
        System.out.println(s[3]);
    }
}

