/*
 *  Copyright 2015 the original author or authors.
 *  @https://github.com/scouter-project/scouter
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */

package scouter.lang.constants;

/**
 * @author Gun Lee (gunlee01@gmail.com) on 2017. 8. 28.
 */
public class ParamConstant {
    public static final String USER_ID = "id";
    public static final String USER_PASSWROD = "pass";

    public static final String OBJ_TYPE = "objType";
    public static final String OBJ_HASH = "objHash";
    public static final String COUNTER = "counter";
    public static final String KEY = "key";
    public static final String VALUE = "value";
    public static final String KEY_SPACE = "keySpace";
    public static final String KEY_VALUE = "kv";

    public static final String TTL = "ttl";
    public static final Long TTL_PERMANENT = -1L;

    public static final String DATE = "date";
    public static final String TIME = "time";
    public static final String SDATE = "sDate";
    public static final String EDATE = "eDate";
    public static final String STIME = "stime";
    public static final String ETIME = "etime";
    public static final String HASH = "hash";
    public static final String TYPE = "type";

    public static final String OFFSET_LOOP = "loop";
    public static final String OFFSET_INDEX = "index";

    public static final String XLOG_COUNT = "count";
    public static final String XLOG_MAX_COUNT = "max";
    public static final String XLOG_START_TIME = "stime";
    public static final String XLOG_END_TIME = "etime";
    public static final String XLOG_LAST_BUCKET_TIME = "lastBucketTime";
    public static final String XLOG_PAGE_COUNT = "pageCount";
    public static final String XLOG_SERVICE="service";
    public static final String XLOG_LOGIN="login";
    public static final String XLOG_IP="ip";
    public static final String XLOG_DESC="desc";
    public static final String XLOG_TEXT_1="text1";
    public static final String XLOG_TEXT_2="text2";
    public static final String XLOG_TEXT_3="text3";
    public static final String XLOG_TEXT_4="text4";
    public static final String XLOG_TEXT_5="text5";
    
    public static final String XLOG_TXID = "txid";
    public static final String XLOG_GXID = "gxid";
    public static final String PROFILE_MAX = "max";

    public static final String XLOG_RESULT_LAST_TIME = "lastXLogTime";
    public static final String XLOG_RESULT_LAST_TXID = "lastTxid";
    public static final String XLOG_RESULT_HAS_MORE = "hasMore";

    public static final String ACTIVE_SERVICE_STEP1 = "act1";
    public static final String ACTIVE_SERVICE_STEP2 = "act2";
    public static final String ACTIVE_SERVICE_STEP3 = "act3";

    public static final String TEXT_TYPE = "type";
    public static final String TEXT_DICTKEY = "hash";


}
