/*
 * Decompiled with CFR 0.152.
 */
package com.gugusong.sqlmapper.db.mysql;

import com.google.common.base.Joiner;
import com.gugusong.sqlmapper.common.beans.BeanJoin;
import com.gugusong.sqlmapper.common.beans.BeanWrapper;
import com.gugusong.sqlmapper.common.util.TextUtil;
import com.gugusong.sqlmapper.db.ISqlHelp;
import com.gugusong.sqlmapper.strategy.GenerationType;
import java.util.Map;
import lombok.NonNull;

public class MysqlSqlHelp
implements ISqlHelp {
    private static final String SQL_SELECT_METHOD = "getSqlToSelect";
    private static final String SQL_SELECT_ID_METHOD = "getSqlToSelectId";
    private static final String SQL_SELECT_COUNT_METHOD = "getSqlToSelectCount";
    private static final String SQL_SELECT_BY_ID_METHOD = "getSqlToSelectById";
    private static final String SQL_UPDATE_METHOD = "getSqlToUpdate";
    private static final String SQL_INSERT_METHOD = "getSqlToInsert";
    private static final String SQL_DELETE_METHOD = "getSqlToDelete";
    private static final String SQL_DELETE_BY_ID_METHOD = "getSqlToDeleteById";
    private static final String SQL_CREATE_METHOD = "getSqlToCreateTable";

    @Override
    public String getSqlToSelect(BeanWrapper poClazz, boolean hasFormat) throws Exception {
        String sql = poClazz.getSql(SQL_SELECT_METHOD);
        if (sql != null) {
            return sql;
        }
        StringBuilder sqlSb = new StringBuilder();
        if (poClazz.getBeanType() == "po") {
            sqlSb.append("select");
            sqlSb.append(" ");
            sqlSb.append(Joiner.on((String)", ").join(poClazz.getColumns().stream().map(c -> c.getName()).toArray()));
            sqlSb.append(" ");
            sqlSb.append("from");
            sqlSb.append(" ");
            sqlSb.append(poClazz.getTableName());
        } else if (poClazz.getBeanType() == "vo") {
            BeanWrapper joinBeanWrapper;
            BeanJoin beanJoin;
            String joinTableAlias;
            sqlSb.append("select");
            sqlSb.append(" ");
            sqlSb.append(poClazz.getTableAliasName() + ".");
            sqlSb.append(Joiner.on((String)("," + poClazz.getTableAliasName() + ".")).join(poClazz.getMainWrapper().getColumns().stream().map(c -> {
                StringBuilder selectSb = new StringBuilder();
                selectSb.append(c.getName()).append(" ").append(poClazz.getTableAliasName()).append("_").append(c.getName());
                return selectSb.toString();
            }).toArray()));
            for (Map.Entry<String, BeanJoin> entry : poClazz.getJoinBeans().entrySet()) {
                joinTableAlias = entry.getKey();
                beanJoin = entry.getValue();
                joinBeanWrapper = beanJoin.getJoinBeanWrapper();
                sqlSb.append("," + joinTableAlias + ".");
                sqlSb.append(Joiner.on((String)("," + joinTableAlias + ".")).join(joinBeanWrapper.getColumns().stream().map(c -> {
                    StringBuilder selectSb = new StringBuilder();
                    selectSb.append(c.getName()).append(" ").append(joinTableAlias).append("_").append(c.getName());
                    return selectSb.toString();
                }).toArray()));
            }
            if (poClazz.getFuncColumns() != null && poClazz.getFuncColumns().size() > 0) {
                sqlSb.append(",");
                sqlSb.append(Joiner.on((String)",").join(poClazz.getFuncColumns().stream().map(c -> {
                    StringBuilder selectSb = new StringBuilder();
                    selectSb.append(c.getFunction()).append(" ").append(c.getAliasName());
                    return selectSb.toString();
                }).toArray()));
            }
            sqlSb.append(" ");
            sqlSb.append("from");
            sqlSb.append(" ");
            sqlSb.append(poClazz.getTableName());
            sqlSb.append(" ");
            sqlSb.append(poClazz.getTableAliasName());
            for (Map.Entry<String, BeanJoin> entry : poClazz.getJoinBeans().entrySet()) {
                sqlSb.append(" ");
                joinTableAlias = entry.getKey();
                beanJoin = entry.getValue();
                joinBeanWrapper = beanJoin.getJoinBeanWrapper();
                sqlSb.append(beanJoin.getToken());
                sqlSb.append(" ");
                sqlSb.append(joinBeanWrapper.getTableName());
                sqlSb.append(" ");
                sqlSb.append(joinTableAlias);
                sqlSb.append(" ");
                sqlSb.append("on(");
                sqlSb.append(TextUtil.replaceTemplateParams(beanJoin.getConditions(), paramName -> {
                    @NonNull String columnName = poClazz.getColumnNameByPropertyName((String)paramName);
                    return columnName;
                }));
                sqlSb.append(")");
                sqlSb.append(" ");
            }
        } else {
            throw new RuntimeException("\u8be5Bean\u7c7b\u4e0d\u652f\u6301\u67e5\u8be2\uff0c\u67e5\u8be2\u64cd\u4f5c\u53ea\u652f\u6301VO/PO\u7c7b!");
        }
        poClazz.putSql(SQL_SELECT_METHOD, sqlSb.toString());
        return sqlSb.toString();
    }

    @Override
    public String getSqlToSelectId(BeanWrapper poClazz, boolean hasFormat) throws Exception {
        String sql = poClazz.getSql(SQL_SELECT_ID_METHOD);
        if (sql != null) {
            return sql;
        }
        StringBuilder sqlSb = new StringBuilder();
        if (poClazz.getBeanType() == "po") {
            sqlSb.append("select");
            sqlSb.append(" ");
            sqlSb.append(poClazz.getIdColumn().getName());
            sqlSb.append(" ");
            sqlSb.append("from");
            sqlSb.append(" ");
            sqlSb.append(poClazz.getTableName());
        } else if (poClazz.getBeanType() == "vo") {
            sqlSb.append("select");
            sqlSb.append(" ");
            sqlSb.append(poClazz.getTableAliasName());
            sqlSb.append(".");
            sqlSb.append(poClazz.getMainWrapper().getIdColumn().getName());
            sqlSb.append(" ");
            sqlSb.append("from");
            sqlSb.append(" ");
            sqlSb.append(poClazz.getTableName());
            sqlSb.append(" ");
            sqlSb.append(poClazz.getTableAliasName());
            for (Map.Entry<String, BeanJoin> entry : poClazz.getJoinBeans().entrySet()) {
                sqlSb.append(" ");
                String joinTableAlias = entry.getKey();
                BeanJoin beanJoin = entry.getValue();
                BeanWrapper joinBeanWrapper = beanJoin.getJoinBeanWrapper();
                sqlSb.append(beanJoin.getToken());
                sqlSb.append(" ");
                sqlSb.append(joinBeanWrapper.getTableName());
                sqlSb.append(" ");
                sqlSb.append(joinTableAlias);
                sqlSb.append(" ");
                sqlSb.append("on(");
                sqlSb.append(TextUtil.replaceTemplateParams(beanJoin.getConditions(), paramName -> {
                    @NonNull String columnName = poClazz.getColumnNameByPropertyName((String)paramName);
                    return columnName;
                }));
                sqlSb.append(")");
                sqlSb.append(" ");
            }
        } else {
            throw new RuntimeException("\u8be5Bean\u7c7b\u4e0d\u652f\u6301\u67e5\u8be2\uff0c\u67e5\u8be2\u64cd\u4f5c\u53ea\u652f\u6301VO/PO\u7c7b!");
        }
        poClazz.putSql(SQL_SELECT_ID_METHOD, sqlSb.toString());
        return sqlSb.toString();
    }

    @Override
    public String getSqlToSelectById(BeanWrapper poClazz, boolean hasFormat) throws Exception {
        String sql = poClazz.getSql(SQL_SELECT_BY_ID_METHOD);
        if (sql != null) {
            return sql;
        }
        StringBuilder sqlSb = new StringBuilder();
        if (poClazz.getBeanType() == "po") {
            sqlSb.append("select");
            sqlSb.append(" ");
            sqlSb.append(Joiner.on((String)", ").join(poClazz.getColumns().stream().map(c -> c.getName()).toArray()));
            sqlSb.append(" ");
            sqlSb.append("from");
            sqlSb.append(" ");
            sqlSb.append(poClazz.getTableName());
            sqlSb.append(" ");
            sqlSb.append("where");
            sqlSb.append(" ");
            sqlSb.append(poClazz.getIdColumn().getName());
            sqlSb.append(" ");
            sqlSb.append("=");
            sqlSb.append(" ");
            sqlSb.append("?");
        } else if (poClazz.getBeanType() == "vo") {
            BeanWrapper joinBeanWrapper;
            BeanJoin beanJoin;
            String joinTableAlias;
            sqlSb.append("select");
            sqlSb.append(" ");
            sqlSb.append(poClazz.getTableAliasName() + ".");
            sqlSb.append(Joiner.on((String)("," + poClazz.getTableAliasName() + ".")).join(poClazz.getMainWrapper().getColumns().stream().map(c -> {
                StringBuilder selectSb = new StringBuilder();
                selectSb.append(c.getName()).append(" ").append(poClazz.getTableAliasName()).append("_").append(c.getName());
                return selectSb.toString();
            }).toArray()));
            for (Map.Entry<String, BeanJoin> entry : poClazz.getJoinBeans().entrySet()) {
                joinTableAlias = entry.getKey();
                beanJoin = entry.getValue();
                joinBeanWrapper = beanJoin.getJoinBeanWrapper();
                sqlSb.append("," + joinTableAlias + ".");
                sqlSb.append(Joiner.on((String)("," + joinTableAlias + ".")).join(joinBeanWrapper.getColumns().stream().map(c -> {
                    StringBuilder selectSb = new StringBuilder();
                    selectSb.append(c.getName()).append(" ").append(joinTableAlias).append("_").append(c.getName());
                    return selectSb.toString();
                }).toArray()));
            }
            if (poClazz.getFuncColumns() != null && poClazz.getFuncColumns().size() > 0) {
                sqlSb.append(",");
                sqlSb.append(Joiner.on((String)",").join(poClazz.getFuncColumns().stream().map(c -> {
                    StringBuilder selectSb = new StringBuilder();
                    selectSb.append(c.getFunction()).append(" ").append(c.getAliasName());
                    return selectSb.toString();
                }).toArray()));
            }
            sqlSb.append(" ");
            sqlSb.append("from");
            sqlSb.append(" ");
            sqlSb.append(poClazz.getTableName());
            sqlSb.append(" ");
            sqlSb.append(poClazz.getTableAliasName());
            for (Map.Entry<String, BeanJoin> entry : poClazz.getJoinBeans().entrySet()) {
                sqlSb.append(" ");
                joinTableAlias = entry.getKey();
                beanJoin = entry.getValue();
                joinBeanWrapper = beanJoin.getJoinBeanWrapper();
                sqlSb.append(beanJoin.getToken());
                sqlSb.append(" ");
                sqlSb.append(joinBeanWrapper.getTableName());
                sqlSb.append(" ");
                sqlSb.append(joinTableAlias);
                sqlSb.append(" ");
                sqlSb.append("on(");
                sqlSb.append(TextUtil.replaceTemplateParams(beanJoin.getConditions(), paramName -> {
                    @NonNull String columnName = poClazz.getColumnNameByPropertyName((String)paramName);
                    return columnName;
                }));
                sqlSb.append(")");
                sqlSb.append(" ");
            }
            sqlSb.append(" ");
            sqlSb.append("where");
            sqlSb.append(" ");
            sqlSb.append(poClazz.getTableAliasName());
            sqlSb.append(".");
            sqlSb.append(poClazz.getMainWrapper().getIdColumn().getName());
            sqlSb.append(" ");
            sqlSb.append("=");
            sqlSb.append(" ");
            sqlSb.append("?");
            sqlSb.append(" ");
            if (poClazz.getGroupBys() != null && poClazz.getGroupBys().length > 0) {
                sqlSb.append("group by");
                sqlSb.append(" ");
                boolean first = true;
                for (String propertyName : poClazz.getGroupBys()) {
                    if (!first) {
                        sqlSb.append(",");
                    }
                    sqlSb.append(poClazz.getColumnNameByPropertyName(propertyName));
                    first = false;
                }
                sqlSb.append(" ");
            }
        } else {
            throw new RuntimeException("\u8be5Bean\u7c7b\u4e0d\u652f\u6301\u67e5\u8be2\uff0c\u67e5\u8be2\u64cd\u4f5c\u53ea\u652f\u6301VO/PO\u7c7b!");
        }
        poClazz.putSql(SQL_SELECT_BY_ID_METHOD, sqlSb.toString());
        return sqlSb.toString();
    }

    @Override
    public String getSqlToUpdate(BeanWrapper poClazz, boolean hasFormat) {
        String sql = poClazz.getSql(SQL_UPDATE_METHOD);
        if (sql != null) {
            return sql;
        }
        StringBuilder sqlSb = new StringBuilder();
        sqlSb.append("update");
        sqlSb.append(" ");
        sqlSb.append(poClazz.getTableName());
        sqlSb.append(" ");
        sqlSb.append("set");
        sqlSb.append(" ");
        sqlSb.append(Joiner.on((String)" = ?,").join(poClazz.getColumns().stream().filter(c -> !c.isIdFlag()).map(c -> c.getName()).toArray()));
        sqlSb.append(" = ? ");
        sqlSb.append("where");
        sqlSb.append(" ");
        sqlSb.append(poClazz.getIdColumn().getName());
        sqlSb.append(" ");
        sqlSb.append("=");
        sqlSb.append(" ");
        sqlSb.append("?");
        sqlSb.append(" ");
        if (poClazz.isVersion()) {
            sqlSb.append("and");
            sqlSb.append(" ");
            sqlSb.append(poClazz.getVersionColumn().getName());
            sqlSb.append(" ");
            sqlSb.append("=");
            sqlSb.append(" ");
            sqlSb.append("?");
        }
        poClazz.putSql(SQL_UPDATE_METHOD, sqlSb.toString());
        return sqlSb.toString();
    }

    @Override
    public String getSqlToInsert(BeanWrapper poClazz, boolean hasFormat) {
        String sql = poClazz.getSql(SQL_INSERT_METHOD);
        if (sql != null) {
            return sql;
        }
        StringBuilder sqlSb = new StringBuilder();
        sqlSb.append("insert into");
        sqlSb.append(" ");
        sqlSb.append(poClazz.getTableName());
        sqlSb.append("(");
        sqlSb.append(Joiner.on((String)",").join(poClazz.getColumns().stream().filter(c -> !c.isIdFlag() || c.getIdstrategy() != GenerationType.IDENTITY).map(c -> c.getName()).toArray()));
        sqlSb.append(")");
        sqlSb.append(" ");
        sqlSb.append("values");
        sqlSb.append("(");
        sqlSb.append(Joiner.on((String)",").join(poClazz.getColumns().stream().filter(c -> !c.isIdFlag() || c.getIdstrategy() != GenerationType.IDENTITY).map(c -> "?").toArray()));
        sqlSb.append(")");
        poClazz.putSql(SQL_INSERT_METHOD, sqlSb.toString());
        return sqlSb.toString();
    }

    @Override
    public String getSqlToDelete(BeanWrapper poClazz, boolean hasFormat) {
        String sql = poClazz.getSql(SQL_DELETE_METHOD);
        if (sql != null) {
            return sql;
        }
        StringBuilder sqlSb = new StringBuilder();
        sqlSb.append("delete");
        sqlSb.append(" ");
        sqlSb.append("from");
        sqlSb.append(" ");
        sqlSb.append(poClazz.getTableName());
        sqlSb.append(" ");
        poClazz.putSql(SQL_DELETE_METHOD, sqlSb.toString());
        return sqlSb.toString();
    }

    @Override
    public String getSqlToDeleteById(BeanWrapper poClazz, boolean hasFormat) {
        String sql = poClazz.getSql(SQL_DELETE_BY_ID_METHOD);
        if (sql != null) {
            return sql;
        }
        StringBuilder sqlSb = new StringBuilder();
        sqlSb.append("delete");
        sqlSb.append(" ");
        sqlSb.append("from");
        sqlSb.append(" ");
        sqlSb.append(poClazz.getTableName());
        sqlSb.append(" ");
        sqlSb.append("where");
        sqlSb.append(" ");
        sqlSb.append(poClazz.getIdColumn().getName());
        sqlSb.append(" ");
        sqlSb.append("=");
        sqlSb.append(" ");
        sqlSb.append("?");
        poClazz.putSql(SQL_DELETE_BY_ID_METHOD, sqlSb.toString());
        return sqlSb.toString();
    }

    @Override
    public String getSqlToSelectCount(BeanWrapper poClazz, boolean hasFormat) throws Exception {
        String sql = poClazz.getSql(SQL_SELECT_COUNT_METHOD);
        if (sql != null) {
            return sql;
        }
        StringBuilder sqlSb = new StringBuilder();
        if (poClazz.getBeanType() == "po") {
            sqlSb.append("select");
            sqlSb.append(" ");
            sqlSb.append("count(*)");
            sqlSb.append(" ");
            sqlSb.append("from");
            sqlSb.append(" ");
            sqlSb.append(poClazz.getTableName());
            sqlSb.append(" ");
            sqlSb.append("{where}");
        } else if (poClazz.getBeanType() == "vo") {
            sqlSb.append("select");
            sqlSb.append(" ");
            sqlSb.append("count(*)");
            sqlSb.append(" ");
            sqlSb.append("from");
            sqlSb.append(" ");
            sqlSb.append("(");
            sqlSb.append("select");
            sqlSb.append(" ");
            sqlSb.append(poClazz.getTableAliasName());
            sqlSb.append(".");
            sqlSb.append(poClazz.getMainWrapper().getIdColumn().getName());
            sqlSb.append(" ");
            sqlSb.append("from");
            sqlSb.append(" ");
            sqlSb.append(poClazz.getTableName());
            sqlSb.append(" ");
            sqlSb.append(poClazz.getTableAliasName());
            for (Map.Entry<String, BeanJoin> entry : poClazz.getJoinBeans().entrySet()) {
                sqlSb.append(" ");
                String joinTableAlias = entry.getKey();
                BeanJoin beanJoin = entry.getValue();
                BeanWrapper joinBeanWrapper = beanJoin.getJoinBeanWrapper();
                sqlSb.append(beanJoin.getToken());
                sqlSb.append(" ");
                sqlSb.append(joinBeanWrapper.getTableName());
                sqlSb.append(" ");
                sqlSb.append(joinTableAlias);
                sqlSb.append(" ");
                sqlSb.append("on(");
                sqlSb.append(TextUtil.replaceTemplateParams(beanJoin.getConditions(), paramName -> {
                    @NonNull String columnName = poClazz.getColumnNameByPropertyName((String)paramName);
                    return columnName;
                }));
                sqlSb.append(")");
                sqlSb.append(" ");
            }
            sqlSb.append(" ");
            sqlSb.append("{where}");
            sqlSb.append(" ");
            if (poClazz.isPageSubSql()) {
                sqlSb.append("group by");
                sqlSb.append(" ");
                sqlSb.append(poClazz.getTableAliasName());
                sqlSb.append(".");
                sqlSb.append(poClazz.getMainWrapper().getIdColumn().getName());
            } else if (poClazz.getGroupBys() != null && poClazz.getGroupBys().length > 0) {
                sqlSb.append("group by");
                sqlSb.append(" ");
                boolean first = true;
                for (String propertyName : poClazz.getGroupBys()) {
                    if (!first) {
                        sqlSb.append(",");
                    }
                    sqlSb.append(poClazz.getColumnNameByPropertyName(propertyName));
                    first = false;
                }
                sqlSb.append(" ");
            }
            sqlSb.append(")");
            sqlSb.append(" ");
            sqlSb.append("buffer");
        } else {
            throw new RuntimeException("\u8be5Bean\u7c7b\u4e0d\u652f\u6301\u67e5\u8be2\uff0c\u67e5\u8be2\u64cd\u4f5c\u53ea\u652f\u6301VO/PO\u7c7b!");
        }
        poClazz.putSql(SQL_SELECT_COUNT_METHOD, sqlSb.toString());
        return sqlSb.toString();
    }
}

