/*
 * Decompiled with CFR 0.152.
 */
package com.gugusong.sqlmapper.common.util;

public class SnowFlake {
    private static final long START_STMP = 1608088657109L;
    private static final long SEQUENCE_BIT = 12L;
    private static final long MACHINE_BIT = 5L;
    private static final long DATA_CENTER_BIT = 5L;
    private static final long MAX_DATACENTER_NUM = 31L;
    private static final long MAX_MACHINE_NUM = 31L;
    private static final long MAX_SEQUENCE = 4095L;
    private static final long MACHINE_LEFT = 12L;
    private static final long DATA_CENTER_LEFT = 17L;
    private static final long TIMESTAMP_LEFT = 22L;
    private long dataCenterId;
    private long machineId;
    private long sequence = 0L;
    private long lastStamp = -1L;

    public SnowFlake(long dataCenterId, long machineId) {
        if (dataCenterId > 31L || dataCenterId < 0L) {
            throw new IllegalArgumentException("\u6570\u636e\u4e2d\u5fc3\u7f16\u53f7\u9519\u8bef\uff0c\u9700\u5927\u4e8e\u7b49\u4e8e0\u4e14\u5c0f\u4e8eMAX_DATACENTER_NUM");
        }
        if (machineId > 31L || machineId < 0L) {
            throw new IllegalArgumentException("\u673a\u5668\u7f16\u53f7\u9519\u8bef\uff0c\u9700\u5927\u4e8e\u7b49\u4e8e0\u4e14\u5c0f\u4e8eMAX_MACHINE_NUM");
        }
        this.dataCenterId = dataCenterId;
        this.machineId = machineId;
    }

    public synchronized long nextId() {
        long currStmp = this.getNewstmp();
        if (currStmp < this.lastStamp) {
            throw new RuntimeException("Clock moved backwards.  Refusing to generate id");
        }
        if (currStmp == this.lastStamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                currStmp = this.getNextMill();
            }
        } else {
            this.sequence = 0L;
        }
        this.lastStamp = currStmp;
        return currStmp - 1608088657109L << 22 | this.dataCenterId << 17 | this.machineId << 12 | this.sequence;
    }

    private long getNextMill() {
        long mill = this.getNewstmp();
        while (mill <= this.lastStamp) {
            mill = this.getNewstmp();
        }
        return mill;
    }

    private long getNewstmp() {
        return System.currentTimeMillis();
    }

    public static void main(String[] args) {
        SnowFlake snowFlake = new SnowFlake(2L, 3L);
    }
}

