/*
 * Decompiled with CFR 0.152.
 */
package com.seam.api;

import com.seam.api.SeamApiClient;
import com.seam.api.core.ClientOptions;
import com.seam.api.resources.accesscodes.requests.AccessCodesUpdatePutRequest;
import com.seam.api.resources.actionattempts.requests.ActionAttemptsGetRequest;
import com.seam.api.types.AccessCodesUpdatePutResponse;
import com.seam.api.types.ActionAttemptsGetResponse;
import com.seam.api.types.ActionAttemptsGetResponseActionAttemptError;
import com.seam.api.types.ActionAttemptsGetResponseActionAttemptSuccess;
import java.util.Map;

public class AccessCodesClient
extends com.seam.api.resources.accesscodes.AccessCodesClient {
    private final SeamApiClient rootClient;

    public AccessCodesClient(ClientOptions clientOptions, SeamApiClient rootClient) {
        super(clientOptions);
        this.rootClient = rootClient;
    }

    public Object updateAndWaitUntilReady(AccessCodesUpdatePutRequest request) throws InterruptedException {
        String actionAttemptId;
        ActionAttemptsGetResponseActionAttemptSuccess actionAttempt;
        AccessCodesUpdatePutResponse response = this.updatePut(request);
        if (response.getActionAttempt().isSuccess() && (actionAttempt = this.pollUntilReady(actionAttemptId = response.getActionAttempt().getSuccess().get().getActionAttemptId())).getResult().isPresent() && actionAttempt.getResult().get() instanceof Map) {
            Object accessCode = ((Map)actionAttempt.getResult().get()).get("access_code");
            return accessCode;
        }
        throw new RuntimeException("AccessCodeUpdate failed. See response=" + response);
    }

    private ActionAttemptsGetResponseActionAttemptSuccess pollUntilReady(String actionAttemptId) throws InterruptedException {
        ActionAttemptsGetResponse response = null;
        while (response == null || response.getActionAttempt().isPending()) {
            response = this.rootClient.actionAttempts().get(ActionAttemptsGetRequest.builder().actionAttemptId(actionAttemptId).build());
            Thread.sleep(2500L);
        }
        if (response.getActionAttempt().isError()) {
            ActionAttemptsGetResponseActionAttemptError errorResponse = response.getActionAttempt().getError().get();
            throw new ActionAttemptFailedException(errorResponse.getActionAttemptId(), errorResponse.getError().getMessage());
        }
        return response.getActionAttempt().getSuccess().get();
    }

    public static class ActionAttemptFailedException
    extends RuntimeException {
        public final String actionAttemptId;
        public final String errorMessage;

        public ActionAttemptFailedException(String actionAttemptId, String errorMessage) {
            this.actionAttemptId = actionAttemptId;
            this.errorMessage = errorMessage;
        }
    }
}

