/*
 * Decompiled with CFR 0.152.
 */
package com.seam.api.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.seam.api.types.AccessCodesCreateResponseAccessCodeStatus;
import com.seam.api.types.AccessCodesCreateResponseAccessCodeType;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
public final class AccessCodesCreateResponseAccessCode {
    private final Optional<String> commonCodeKey;
    private final AccessCodesCreateResponseAccessCodeType type;
    private final Optional<Boolean> isWaitingForCodeAssignment;
    private final String accessCodeId;
    private final String deviceId;
    private final Optional<String> name;
    private final Optional<String> code;
    private final String createdAt;
    private final Optional<Object> errors;
    private final Optional<Object> warnings;
    private final String isManaged;
    private final Optional<String> startsAt;
    private final Optional<String> endsAt;
    private final AccessCodesCreateResponseAccessCodeStatus status;
    private int _cachedHashCode;

    AccessCodesCreateResponseAccessCode(Optional<String> commonCodeKey, AccessCodesCreateResponseAccessCodeType type, Optional<Boolean> isWaitingForCodeAssignment, String accessCodeId, String deviceId, Optional<String> name, Optional<String> code, String createdAt, Optional<Object> errors, Optional<Object> warnings, String isManaged, Optional<String> startsAt, Optional<String> endsAt, AccessCodesCreateResponseAccessCodeStatus status) {
        this.commonCodeKey = commonCodeKey;
        this.type = type;
        this.isWaitingForCodeAssignment = isWaitingForCodeAssignment;
        this.accessCodeId = accessCodeId;
        this.deviceId = deviceId;
        this.name = name;
        this.code = code;
        this.createdAt = createdAt;
        this.errors = errors;
        this.warnings = warnings;
        this.isManaged = isManaged;
        this.startsAt = startsAt;
        this.endsAt = endsAt;
        this.status = status;
    }

    @JsonProperty(value="common_code_key")
    public Optional<String> getCommonCodeKey() {
        return this.commonCodeKey;
    }

    @JsonProperty(value="type")
    public AccessCodesCreateResponseAccessCodeType getType() {
        return this.type;
    }

    @JsonProperty(value="is_waiting_for_code_assignment")
    public Optional<Boolean> getIsWaitingForCodeAssignment() {
        return this.isWaitingForCodeAssignment;
    }

    @JsonProperty(value="access_code_id")
    public String getAccessCodeId() {
        return this.accessCodeId;
    }

    @JsonProperty(value="device_id")
    public String getDeviceId() {
        return this.deviceId;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="code")
    public Optional<String> getCode() {
        return this.code;
    }

    @JsonProperty(value="created_at")
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="errors")
    public Optional<Object> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="warnings")
    public Optional<Object> getWarnings() {
        return this.warnings;
    }

    @JsonProperty(value="is_managed")
    public String getIsManaged() {
        return this.isManaged;
    }

    @JsonProperty(value="starts_at")
    public Optional<String> getStartsAt() {
        return this.startsAt;
    }

    @JsonProperty(value="ends_at")
    public Optional<String> getEndsAt() {
        return this.endsAt;
    }

    @JsonProperty(value="status")
    public AccessCodesCreateResponseAccessCodeStatus getStatus() {
        return this.status;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof AccessCodesCreateResponseAccessCode && this.equalTo((AccessCodesCreateResponseAccessCode)other);
    }

    private boolean equalTo(AccessCodesCreateResponseAccessCode other) {
        return this.commonCodeKey.equals(other.commonCodeKey) && this.type.equals((Object)other.type) && this.isWaitingForCodeAssignment.equals(other.isWaitingForCodeAssignment) && this.accessCodeId.equals(other.accessCodeId) && this.deviceId.equals(other.deviceId) && this.name.equals(other.name) && this.code.equals(other.code) && this.createdAt.equals(other.createdAt) && this.errors.equals(other.errors) && this.warnings.equals(other.warnings) && this.isManaged.equals(other.isManaged) && this.startsAt.equals(other.startsAt) && this.endsAt.equals(other.endsAt) && this.status.equals((Object)other.status);
    }

    public int hashCode() {
        if (this._cachedHashCode == 0) {
            this._cachedHashCode = Objects.hash(new Object[]{this.commonCodeKey, this.type, this.isWaitingForCodeAssignment, this.accessCodeId, this.deviceId, this.name, this.code, this.createdAt, this.errors, this.warnings, this.isManaged, this.startsAt, this.endsAt, this.status});
        }
        return this._cachedHashCode;
    }

    public String toString() {
        return "AccessCodesCreateResponseAccessCode{commonCodeKey: " + this.commonCodeKey + ", type: " + this.type + ", isWaitingForCodeAssignment: " + this.isWaitingForCodeAssignment + ", accessCodeId: " + this.accessCodeId + ", deviceId: " + this.deviceId + ", name: " + this.name + ", code: " + this.code + ", createdAt: " + this.createdAt + ", errors: " + this.errors + ", warnings: " + this.warnings + ", isManaged: " + this.isManaged + ", startsAt: " + this.startsAt + ", endsAt: " + this.endsAt + ", status: " + this.status + "}";
    }

    public static TypeStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TypeStage,
    AccessCodeIdStage,
    DeviceIdStage,
    CreatedAtStage,
    IsManagedStage,
    StatusStage,
    _FinalStage {
        private AccessCodesCreateResponseAccessCodeType type;
        private String accessCodeId;
        private String deviceId;
        private String createdAt;
        private String isManaged;
        private AccessCodesCreateResponseAccessCodeStatus status;
        private Optional<String> endsAt = Optional.empty();
        private Optional<String> startsAt = Optional.empty();
        private Optional<Object> warnings = Optional.empty();
        private Optional<Object> errors = Optional.empty();
        private Optional<String> code = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<Boolean> isWaitingForCodeAssignment = Optional.empty();
        private Optional<String> commonCodeKey = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(AccessCodesCreateResponseAccessCode other) {
            this.commonCodeKey(other.getCommonCodeKey());
            this.type(other.getType());
            this.isWaitingForCodeAssignment(other.getIsWaitingForCodeAssignment());
            this.accessCodeId(other.getAccessCodeId());
            this.deviceId(other.getDeviceId());
            this.name(other.getName());
            this.code(other.getCode());
            this.createdAt(other.getCreatedAt());
            this.errors(other.getErrors());
            this.warnings(other.getWarnings());
            this.isManaged(other.getIsManaged());
            this.startsAt(other.getStartsAt());
            this.endsAt(other.getEndsAt());
            this.status(other.getStatus());
            return this;
        }

        @Override
        @JsonSetter(value="type")
        public AccessCodeIdStage type(AccessCodesCreateResponseAccessCodeType type) {
            this.type = type;
            return this;
        }

        @Override
        @JsonSetter(value="access_code_id")
        public DeviceIdStage accessCodeId(String accessCodeId) {
            this.accessCodeId = accessCodeId;
            return this;
        }

        @Override
        @JsonSetter(value="device_id")
        public CreatedAtStage deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public IsManagedStage createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        @JsonSetter(value="is_managed")
        public StatusStage isManaged(String isManaged) {
            this.isManaged = isManaged;
            return this;
        }

        @Override
        @JsonSetter(value="status")
        public _FinalStage status(AccessCodesCreateResponseAccessCodeStatus status) {
            this.status = status;
            return this;
        }

        @Override
        public _FinalStage endsAt(String endsAt) {
            this.endsAt = Optional.of(endsAt);
            return this;
        }

        @Override
        @JsonSetter(value="ends_at", nulls=Nulls.SKIP)
        public _FinalStage endsAt(Optional<String> endsAt) {
            this.endsAt = endsAt;
            return this;
        }

        @Override
        public _FinalStage startsAt(String startsAt) {
            this.startsAt = Optional.of(startsAt);
            return this;
        }

        @Override
        @JsonSetter(value="starts_at", nulls=Nulls.SKIP)
        public _FinalStage startsAt(Optional<String> startsAt) {
            this.startsAt = startsAt;
            return this;
        }

        @Override
        public _FinalStage warnings(Object warnings) {
            this.warnings = Optional.of(warnings);
            return this;
        }

        @Override
        @JsonSetter(value="warnings", nulls=Nulls.SKIP)
        public _FinalStage warnings(Optional<Object> warnings) {
            this.warnings = warnings;
            return this;
        }

        @Override
        public _FinalStage errors(Object errors) {
            this.errors = Optional.of(errors);
            return this;
        }

        @Override
        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public _FinalStage errors(Optional<Object> errors) {
            this.errors = errors;
            return this;
        }

        @Override
        public _FinalStage code(String code) {
            this.code = Optional.of(code);
            return this;
        }

        @Override
        @JsonSetter(value="code", nulls=Nulls.SKIP)
        public _FinalStage code(Optional<String> code) {
            this.code = code;
            return this;
        }

        @Override
        public _FinalStage name(String name) {
            this.name = Optional.of(name);
            return this;
        }

        @Override
        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public _FinalStage name(Optional<String> name) {
            this.name = name;
            return this;
        }

        @Override
        public _FinalStage isWaitingForCodeAssignment(Boolean isWaitingForCodeAssignment) {
            this.isWaitingForCodeAssignment = Optional.of(isWaitingForCodeAssignment);
            return this;
        }

        @Override
        @JsonSetter(value="is_waiting_for_code_assignment", nulls=Nulls.SKIP)
        public _FinalStage isWaitingForCodeAssignment(Optional<Boolean> isWaitingForCodeAssignment) {
            this.isWaitingForCodeAssignment = isWaitingForCodeAssignment;
            return this;
        }

        @Override
        public _FinalStage commonCodeKey(String commonCodeKey) {
            this.commonCodeKey = Optional.of(commonCodeKey);
            return this;
        }

        @Override
        @JsonSetter(value="common_code_key", nulls=Nulls.SKIP)
        public _FinalStage commonCodeKey(Optional<String> commonCodeKey) {
            this.commonCodeKey = commonCodeKey;
            return this;
        }

        @Override
        public AccessCodesCreateResponseAccessCode build() {
            return new AccessCodesCreateResponseAccessCode(this.commonCodeKey, this.type, this.isWaitingForCodeAssignment, this.accessCodeId, this.deviceId, this.name, this.code, this.createdAt, this.errors, this.warnings, this.isManaged, this.startsAt, this.endsAt, this.status);
        }
    }

    public static interface _FinalStage {
        public AccessCodesCreateResponseAccessCode build();

        public _FinalStage commonCodeKey(Optional<String> var1);

        public _FinalStage commonCodeKey(String var1);

        public _FinalStage isWaitingForCodeAssignment(Optional<Boolean> var1);

        public _FinalStage isWaitingForCodeAssignment(Boolean var1);

        public _FinalStage name(Optional<String> var1);

        public _FinalStage name(String var1);

        public _FinalStage code(Optional<String> var1);

        public _FinalStage code(String var1);

        public _FinalStage errors(Optional<Object> var1);

        public _FinalStage errors(Object var1);

        public _FinalStage warnings(Optional<Object> var1);

        public _FinalStage warnings(Object var1);

        public _FinalStage startsAt(Optional<String> var1);

        public _FinalStage startsAt(String var1);

        public _FinalStage endsAt(Optional<String> var1);

        public _FinalStage endsAt(String var1);
    }

    public static interface StatusStage {
        public _FinalStage status(AccessCodesCreateResponseAccessCodeStatus var1);
    }

    public static interface IsManagedStage {
        public StatusStage isManaged(String var1);
    }

    public static interface CreatedAtStage {
        public IsManagedStage createdAt(String var1);
    }

    public static interface DeviceIdStage {
        public CreatedAtStage deviceId(String var1);
    }

    public static interface AccessCodeIdStage {
        public DeviceIdStage accessCodeId(String var1);
    }

    public static interface TypeStage {
        public AccessCodeIdStage type(AccessCodesCreateResponseAccessCodeType var1);

        public Builder from(AccessCodesCreateResponseAccessCode var1);
    }
}

