/*
 * Decompiled with CFR 0.152.
 */
package com.seam.api.resources.accesscodes.requests;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
public final class AccessCodesDeleteRequest {
    private final Optional<String> deviceId;
    private final String accessCodeId;
    private final Optional<Boolean> sync;

    private AccessCodesDeleteRequest(Optional<String> deviceId, String accessCodeId, Optional<Boolean> sync) {
        this.deviceId = deviceId;
        this.accessCodeId = accessCodeId;
        this.sync = sync;
    }

    @JsonProperty(value="device_id")
    public Optional<String> getDeviceId() {
        return this.deviceId;
    }

    @JsonProperty(value="access_code_id")
    public String getAccessCodeId() {
        return this.accessCodeId;
    }

    @JsonProperty(value="sync")
    public Optional<Boolean> getSync() {
        return this.sync;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof AccessCodesDeleteRequest && this.equalTo((AccessCodesDeleteRequest)other);
    }

    private boolean equalTo(AccessCodesDeleteRequest other) {
        return this.deviceId.equals(other.deviceId) && this.accessCodeId.equals(other.accessCodeId) && this.sync.equals(other.sync);
    }

    public int hashCode() {
        return Objects.hash(this.deviceId, this.accessCodeId, this.sync);
    }

    public String toString() {
        return "AccessCodesDeleteRequest{deviceId: " + this.deviceId + ", accessCodeId: " + this.accessCodeId + ", sync: " + this.sync + "}";
    }

    public static AccessCodeIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements AccessCodeIdStage,
    _FinalStage {
        private String accessCodeId;
        private Optional<Boolean> sync = Optional.empty();
        private Optional<String> deviceId = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(AccessCodesDeleteRequest other) {
            this.deviceId(other.getDeviceId());
            this.accessCodeId(other.getAccessCodeId());
            this.sync(other.getSync());
            return this;
        }

        @Override
        @JsonSetter(value="access_code_id")
        public _FinalStage accessCodeId(String accessCodeId) {
            this.accessCodeId = accessCodeId;
            return this;
        }

        @Override
        public _FinalStage sync(Boolean sync) {
            this.sync = Optional.of(sync);
            return this;
        }

        @Override
        @JsonSetter(value="sync", nulls=Nulls.SKIP)
        public _FinalStage sync(Optional<Boolean> sync) {
            this.sync = sync;
            return this;
        }

        @Override
        public _FinalStage deviceId(String deviceId) {
            this.deviceId = Optional.of(deviceId);
            return this;
        }

        @Override
        @JsonSetter(value="device_id", nulls=Nulls.SKIP)
        public _FinalStage deviceId(Optional<String> deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        @Override
        public AccessCodesDeleteRequest build() {
            return new AccessCodesDeleteRequest(this.deviceId, this.accessCodeId, this.sync);
        }
    }

    public static interface _FinalStage {
        public AccessCodesDeleteRequest build();

        public _FinalStage deviceId(Optional<String> var1);

        public _FinalStage deviceId(String var1);

        public _FinalStage sync(Optional<Boolean> var1);

        public _FinalStage sync(Boolean var1);
    }

    public static interface AccessCodeIdStage {
        public _FinalStage accessCodeId(String var1);

        public Builder from(AccessCodesDeleteRequest var1);
    }
}

