/*
 * Decompiled with CFR 0.152.
 */
package com.seam.api.resources.connectwebviews;

import com.seam.api.core.ClientOptions;
import com.seam.api.core.ObjectMappers;
import com.seam.api.resources.connectwebviews.requests.ConnectWebviewsCreateRequest;
import com.seam.api.resources.connectwebviews.requests.ConnectWebviewsDeleteRequest;
import com.seam.api.resources.connectwebviews.requests.ConnectWebviewsGetRequest;
import com.seam.api.resources.connectwebviews.requests.ConnectWebviewsViewRequest;
import com.seam.api.types.ConnectWebviewsCreateResponse;
import com.seam.api.types.ConnectWebviewsDeleteResponse;
import com.seam.api.types.ConnectWebviewsGetResponse;
import com.seam.api.types.ConnectWebviewsListResponse;
import java.util.HashMap;
import java.util.Optional;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class ConnectWebviewsClient {
    protected final ClientOptions clientOptions;

    public ConnectWebviewsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public ConnectWebviewsCreateResponse create(ConnectWebviewsCreateRequest request) {
        RequestBody _requestBody;
        HttpUrl _httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("connect_webviews/create").build();
        HashMap<String, Optional<Object>> _requestBodyProperties = new HashMap<String, Optional<Object>>();
        _requestBodyProperties.put("device_selection_mode", request.getDeviceSelectionMode());
        _requestBodyProperties.put("custom_redirect_url", request.getCustomRedirectUrl());
        _requestBodyProperties.put("custom_redirect_failure_url", request.getCustomRedirectFailureUrl());
        _requestBodyProperties.put("accepted_providers", request.getAcceptedProviders());
        _requestBodyProperties.put("provider_category", request.getProviderCategory());
        _requestBodyProperties.put("custom_metadata", request.getCustomMetadata());
        try {
            _requestBody = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes(_requestBodyProperties), (MediaType)MediaType.parse((String)"application/json"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(_httpUrl).method("POST", _requestBody).headers(Headers.of(this.clientOptions.headers())).addHeader("Content-Type", "application/json");
        Request _request = _requestBuilder.build();
        try {
            Response _response = this.clientOptions.httpClient().newCall(_request).execute();
            if (_response.isSuccessful()) {
                return (ConnectWebviewsCreateResponse)ObjectMappers.JSON_MAPPER.readValue(_response.body().string(), ConnectWebviewsCreateResponse.class);
            }
            throw new RuntimeException();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ConnectWebviewsDeleteResponse delete(ConnectWebviewsDeleteRequest request) {
        RequestBody _requestBody;
        HttpUrl _httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("connect_webviews/delete").build();
        HashMap<String, String> _requestBodyProperties = new HashMap<String, String>();
        _requestBodyProperties.put("connect_webview_id", request.getConnectWebviewId());
        try {
            _requestBody = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes(_requestBodyProperties), (MediaType)MediaType.parse((String)"application/json"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(_httpUrl).method("POST", _requestBody).headers(Headers.of(this.clientOptions.headers())).addHeader("Content-Type", "application/json");
        Request _request = _requestBuilder.build();
        try {
            Response _response = this.clientOptions.httpClient().newCall(_request).execute();
            if (_response.isSuccessful()) {
                return (ConnectWebviewsDeleteResponse)ObjectMappers.JSON_MAPPER.readValue(_response.body().string(), ConnectWebviewsDeleteResponse.class);
            }
            throw new RuntimeException();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ConnectWebviewsGetResponse get(ConnectWebviewsGetRequest request) {
        RequestBody _requestBody;
        HttpUrl _httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("connect_webviews/get").build();
        HashMap<String, String> _requestBodyProperties = new HashMap<String, String>();
        _requestBodyProperties.put("connect_webview_id", request.getConnectWebviewId());
        try {
            _requestBody = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes(_requestBodyProperties), (MediaType)MediaType.parse((String)"application/json"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(_httpUrl).method("POST", _requestBody).headers(Headers.of(this.clientOptions.headers())).addHeader("Content-Type", "application/json");
        Request _request = _requestBuilder.build();
        try {
            Response _response = this.clientOptions.httpClient().newCall(_request).execute();
            if (_response.isSuccessful()) {
                return (ConnectWebviewsGetResponse)ObjectMappers.JSON_MAPPER.readValue(_response.body().string(), ConnectWebviewsGetResponse.class);
            }
            throw new RuntimeException();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ConnectWebviewsListResponse list() {
        HttpUrl _httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("connect_webviews/list").build();
        Request _request = new Request.Builder().url(_httpUrl).method("POST", null).headers(Headers.of(this.clientOptions.headers())).addHeader("Content-Type", "application/json").build();
        try {
            Response _response = this.clientOptions.httpClient().newCall(_request).execute();
            if (_response.isSuccessful()) {
                return (ConnectWebviewsListResponse)ObjectMappers.JSON_MAPPER.readValue(_response.body().string(), ConnectWebviewsListResponse.class);
            }
            throw new RuntimeException();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void view(ConnectWebviewsViewRequest request) {
        HttpUrl.Builder _httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("connect_webviews/view");
        _httpUrl.addQueryParameter("connect_webview_id", request.getConnectWebviewId());
        _httpUrl.addQueryParameter("auth_token", request.getAuthToken());
        RequestBody _requestBody = null;
        Request.Builder _requestBuilder = new Request.Builder().url(_httpUrl.build()).method("GET", _requestBody).headers(Headers.of(this.clientOptions.headers()));
        Request _request = _requestBuilder.build();
        try {
            Response _response = this.clientOptions.httpClient().newCall(_request).execute();
            if (_response.isSuccessful()) {
                return;
            }
            throw new RuntimeException();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

