/*
 * Decompiled with CFR 0.152.
 */
package com.seam.api.resources.noisesensors.noisethresholds.requests;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
public final class NoiseSensorsNoiseThresholdsCreateRequest {
    private final String deviceId;
    private final Optional<Boolean> sync;
    private final Optional<String> name;
    private final String startsDailyAt;
    private final String endsDailyAt;
    private final Optional<Double> noiseThresholdDecibels;
    private final Optional<Double> noiseThresholdNrs;

    private NoiseSensorsNoiseThresholdsCreateRequest(String deviceId, Optional<Boolean> sync, Optional<String> name, String startsDailyAt, String endsDailyAt, Optional<Double> noiseThresholdDecibels, Optional<Double> noiseThresholdNrs) {
        this.deviceId = deviceId;
        this.sync = sync;
        this.name = name;
        this.startsDailyAt = startsDailyAt;
        this.endsDailyAt = endsDailyAt;
        this.noiseThresholdDecibels = noiseThresholdDecibels;
        this.noiseThresholdNrs = noiseThresholdNrs;
    }

    @JsonProperty(value="device_id")
    public String getDeviceId() {
        return this.deviceId;
    }

    @JsonProperty(value="sync")
    public Optional<Boolean> getSync() {
        return this.sync;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="starts_daily_at")
    public String getStartsDailyAt() {
        return this.startsDailyAt;
    }

    @JsonProperty(value="ends_daily_at")
    public String getEndsDailyAt() {
        return this.endsDailyAt;
    }

    @JsonProperty(value="noise_threshold_decibels")
    public Optional<Double> getNoiseThresholdDecibels() {
        return this.noiseThresholdDecibels;
    }

    @JsonProperty(value="noise_threshold_nrs")
    public Optional<Double> getNoiseThresholdNrs() {
        return this.noiseThresholdNrs;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof NoiseSensorsNoiseThresholdsCreateRequest && this.equalTo((NoiseSensorsNoiseThresholdsCreateRequest)other);
    }

    private boolean equalTo(NoiseSensorsNoiseThresholdsCreateRequest other) {
        return this.deviceId.equals(other.deviceId) && this.sync.equals(other.sync) && this.name.equals(other.name) && this.startsDailyAt.equals(other.startsDailyAt) && this.endsDailyAt.equals(other.endsDailyAt) && this.noiseThresholdDecibels.equals(other.noiseThresholdDecibels) && this.noiseThresholdNrs.equals(other.noiseThresholdNrs);
    }

    public int hashCode() {
        return Objects.hash(this.deviceId, this.sync, this.name, this.startsDailyAt, this.endsDailyAt, this.noiseThresholdDecibels, this.noiseThresholdNrs);
    }

    public String toString() {
        return "NoiseSensorsNoiseThresholdsCreateRequest{deviceId: " + this.deviceId + ", sync: " + this.sync + ", name: " + this.name + ", startsDailyAt: " + this.startsDailyAt + ", endsDailyAt: " + this.endsDailyAt + ", noiseThresholdDecibels: " + this.noiseThresholdDecibels + ", noiseThresholdNrs: " + this.noiseThresholdNrs + "}";
    }

    public static DeviceIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements DeviceIdStage,
    StartsDailyAtStage,
    EndsDailyAtStage,
    _FinalStage {
        private String deviceId;
        private String startsDailyAt;
        private String endsDailyAt;
        private Optional<Double> noiseThresholdNrs = Optional.empty();
        private Optional<Double> noiseThresholdDecibels = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<Boolean> sync = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(NoiseSensorsNoiseThresholdsCreateRequest other) {
            this.deviceId(other.getDeviceId());
            this.sync(other.getSync());
            this.name(other.getName());
            this.startsDailyAt(other.getStartsDailyAt());
            this.endsDailyAt(other.getEndsDailyAt());
            this.noiseThresholdDecibels(other.getNoiseThresholdDecibels());
            this.noiseThresholdNrs(other.getNoiseThresholdNrs());
            return this;
        }

        @Override
        @JsonSetter(value="device_id")
        public StartsDailyAtStage deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        @Override
        @JsonSetter(value="starts_daily_at")
        public EndsDailyAtStage startsDailyAt(String startsDailyAt) {
            this.startsDailyAt = startsDailyAt;
            return this;
        }

        @Override
        @JsonSetter(value="ends_daily_at")
        public _FinalStage endsDailyAt(String endsDailyAt) {
            this.endsDailyAt = endsDailyAt;
            return this;
        }

        @Override
        public _FinalStage noiseThresholdNrs(Double noiseThresholdNrs) {
            this.noiseThresholdNrs = Optional.of(noiseThresholdNrs);
            return this;
        }

        @Override
        @JsonSetter(value="noise_threshold_nrs", nulls=Nulls.SKIP)
        public _FinalStage noiseThresholdNrs(Optional<Double> noiseThresholdNrs) {
            this.noiseThresholdNrs = noiseThresholdNrs;
            return this;
        }

        @Override
        public _FinalStage noiseThresholdDecibels(Double noiseThresholdDecibels) {
            this.noiseThresholdDecibels = Optional.of(noiseThresholdDecibels);
            return this;
        }

        @Override
        @JsonSetter(value="noise_threshold_decibels", nulls=Nulls.SKIP)
        public _FinalStage noiseThresholdDecibels(Optional<Double> noiseThresholdDecibels) {
            this.noiseThresholdDecibels = noiseThresholdDecibels;
            return this;
        }

        @Override
        public _FinalStage name(String name) {
            this.name = Optional.of(name);
            return this;
        }

        @Override
        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public _FinalStage name(Optional<String> name) {
            this.name = name;
            return this;
        }

        @Override
        public _FinalStage sync(Boolean sync) {
            this.sync = Optional.of(sync);
            return this;
        }

        @Override
        @JsonSetter(value="sync", nulls=Nulls.SKIP)
        public _FinalStage sync(Optional<Boolean> sync) {
            this.sync = sync;
            return this;
        }

        @Override
        public NoiseSensorsNoiseThresholdsCreateRequest build() {
            return new NoiseSensorsNoiseThresholdsCreateRequest(this.deviceId, this.sync, this.name, this.startsDailyAt, this.endsDailyAt, this.noiseThresholdDecibels, this.noiseThresholdNrs);
        }
    }

    public static interface _FinalStage {
        public NoiseSensorsNoiseThresholdsCreateRequest build();

        public _FinalStage sync(Optional<Boolean> var1);

        public _FinalStage sync(Boolean var1);

        public _FinalStage name(Optional<String> var1);

        public _FinalStage name(String var1);

        public _FinalStage noiseThresholdDecibels(Optional<Double> var1);

        public _FinalStage noiseThresholdDecibels(Double var1);

        public _FinalStage noiseThresholdNrs(Optional<Double> var1);

        public _FinalStage noiseThresholdNrs(Double var1);
    }

    public static interface EndsDailyAtStage {
        public _FinalStage endsDailyAt(String var1);
    }

    public static interface StartsDailyAtStage {
        public EndsDailyAtStage startsDailyAt(String var1);
    }

    public static interface DeviceIdStage {
        public StartsDailyAtStage deviceId(String var1);

        public Builder from(NoiseSensorsNoiseThresholdsCreateRequest var1);
    }
}

