/*
 * Decompiled with CFR 0.152.
 */
package com.seam.api.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.seam.api.types.ConnectWebviewDeviceSelectionMode;
import com.seam.api.types.ConnectWebviewStatus;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
public final class ConnectWebview {
    private final String connectWebviewId;
    private final Optional<String> connectedAccountId;
    private final String url;
    private final String workspaceId;
    private final ConnectWebviewDeviceSelectionMode deviceSelectionMode;
    private final List<String> acceptedProviders;
    private final List<String> acceptedDevices;
    private final boolean anyProviderAllowed;
    private final boolean anyDeviceAllowed;
    private final OffsetDateTime createdAt;
    private final boolean loginSuccessful;
    private final ConnectWebviewStatus status;

    private ConnectWebview(String connectWebviewId, Optional<String> connectedAccountId, String url, String workspaceId, ConnectWebviewDeviceSelectionMode deviceSelectionMode, List<String> acceptedProviders, List<String> acceptedDevices, boolean anyProviderAllowed, boolean anyDeviceAllowed, OffsetDateTime createdAt, boolean loginSuccessful, ConnectWebviewStatus status) {
        this.connectWebviewId = connectWebviewId;
        this.connectedAccountId = connectedAccountId;
        this.url = url;
        this.workspaceId = workspaceId;
        this.deviceSelectionMode = deviceSelectionMode;
        this.acceptedProviders = acceptedProviders;
        this.acceptedDevices = acceptedDevices;
        this.anyProviderAllowed = anyProviderAllowed;
        this.anyDeviceAllowed = anyDeviceAllowed;
        this.createdAt = createdAt;
        this.loginSuccessful = loginSuccessful;
        this.status = status;
    }

    @JsonProperty(value="connect_webview_id")
    public String getConnectWebviewId() {
        return this.connectWebviewId;
    }

    @JsonProperty(value="connected_account_id")
    public Optional<String> getConnectedAccountId() {
        return this.connectedAccountId;
    }

    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="workspace_id")
    public String getWorkspaceId() {
        return this.workspaceId;
    }

    @JsonProperty(value="device_selection_mode")
    public ConnectWebviewDeviceSelectionMode getDeviceSelectionMode() {
        return this.deviceSelectionMode;
    }

    @JsonProperty(value="accepted_providers")
    public List<String> getAcceptedProviders() {
        return this.acceptedProviders;
    }

    @JsonProperty(value="accepted_devices")
    public List<String> getAcceptedDevices() {
        return this.acceptedDevices;
    }

    @JsonProperty(value="any_provider_allowed")
    public boolean getAnyProviderAllowed() {
        return this.anyProviderAllowed;
    }

    @JsonProperty(value="any_device_allowed")
    public boolean getAnyDeviceAllowed() {
        return this.anyDeviceAllowed;
    }

    @JsonProperty(value="created_at")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="login_successful")
    public boolean getLoginSuccessful() {
        return this.loginSuccessful;
    }

    @JsonProperty(value="status")
    public ConnectWebviewStatus getStatus() {
        return this.status;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ConnectWebview && this.equalTo((ConnectWebview)other);
    }

    private boolean equalTo(ConnectWebview other) {
        return this.connectWebviewId.equals(other.connectWebviewId) && this.connectedAccountId.equals(other.connectedAccountId) && this.url.equals(other.url) && this.workspaceId.equals(other.workspaceId) && this.deviceSelectionMode.equals((Object)other.deviceSelectionMode) && this.acceptedProviders.equals(other.acceptedProviders) && this.acceptedDevices.equals(other.acceptedDevices) && this.anyProviderAllowed == other.anyProviderAllowed && this.anyDeviceAllowed == other.anyDeviceAllowed && this.createdAt.equals(other.createdAt) && this.loginSuccessful == other.loginSuccessful && this.status.equals((Object)other.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.connectWebviewId, this.connectedAccountId, this.url, this.workspaceId, this.deviceSelectionMode, this.acceptedProviders, this.acceptedDevices, this.anyProviderAllowed, this.anyDeviceAllowed, this.createdAt, this.loginSuccessful, this.status});
    }

    public String toString() {
        return "ConnectWebview{connectWebviewId: " + this.connectWebviewId + ", connectedAccountId: " + this.connectedAccountId + ", url: " + this.url + ", workspaceId: " + this.workspaceId + ", deviceSelectionMode: " + this.deviceSelectionMode + ", acceptedProviders: " + this.acceptedProviders + ", acceptedDevices: " + this.acceptedDevices + ", anyProviderAllowed: " + this.anyProviderAllowed + ", anyDeviceAllowed: " + this.anyDeviceAllowed + ", createdAt: " + this.createdAt + ", loginSuccessful: " + this.loginSuccessful + ", status: " + this.status + "}";
    }

    public static ConnectWebviewIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ConnectWebviewIdStage,
    UrlStage,
    WorkspaceIdStage,
    DeviceSelectionModeStage,
    AnyProviderAllowedStage,
    AnyDeviceAllowedStage,
    CreatedAtStage,
    LoginSuccessfulStage,
    StatusStage,
    _FinalStage {
        private String connectWebviewId;
        private String url;
        private String workspaceId;
        private ConnectWebviewDeviceSelectionMode deviceSelectionMode;
        private boolean anyProviderAllowed;
        private boolean anyDeviceAllowed;
        private OffsetDateTime createdAt;
        private boolean loginSuccessful;
        private ConnectWebviewStatus status;
        private List<String> acceptedDevices = new ArrayList<String>();
        private List<String> acceptedProviders = new ArrayList<String>();
        private Optional<String> connectedAccountId = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(ConnectWebview other) {
            this.connectWebviewId(other.getConnectWebviewId());
            this.connectedAccountId(other.getConnectedAccountId());
            this.url(other.getUrl());
            this.workspaceId(other.getWorkspaceId());
            this.deviceSelectionMode(other.getDeviceSelectionMode());
            this.acceptedProviders(other.getAcceptedProviders());
            this.acceptedDevices(other.getAcceptedDevices());
            this.anyProviderAllowed(other.getAnyProviderAllowed());
            this.anyDeviceAllowed(other.getAnyDeviceAllowed());
            this.createdAt(other.getCreatedAt());
            this.loginSuccessful(other.getLoginSuccessful());
            this.status(other.getStatus());
            return this;
        }

        @Override
        @JsonSetter(value="connect_webview_id")
        public UrlStage connectWebviewId(String connectWebviewId) {
            this.connectWebviewId = connectWebviewId;
            return this;
        }

        @Override
        @JsonSetter(value="url")
        public WorkspaceIdStage url(String url) {
            this.url = url;
            return this;
        }

        @Override
        @JsonSetter(value="workspace_id")
        public DeviceSelectionModeStage workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        @Override
        @JsonSetter(value="device_selection_mode")
        public AnyProviderAllowedStage deviceSelectionMode(ConnectWebviewDeviceSelectionMode deviceSelectionMode) {
            this.deviceSelectionMode = deviceSelectionMode;
            return this;
        }

        @Override
        @JsonSetter(value="any_provider_allowed")
        public AnyDeviceAllowedStage anyProviderAllowed(boolean anyProviderAllowed) {
            this.anyProviderAllowed = anyProviderAllowed;
            return this;
        }

        @Override
        @JsonSetter(value="any_device_allowed")
        public CreatedAtStage anyDeviceAllowed(boolean anyDeviceAllowed) {
            this.anyDeviceAllowed = anyDeviceAllowed;
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public LoginSuccessfulStage createdAt(OffsetDateTime createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        @JsonSetter(value="login_successful")
        public StatusStage loginSuccessful(boolean loginSuccessful) {
            this.loginSuccessful = loginSuccessful;
            return this;
        }

        @Override
        @JsonSetter(value="status")
        public _FinalStage status(ConnectWebviewStatus status) {
            this.status = status;
            return this;
        }

        @Override
        public _FinalStage addAllAcceptedDevices(List<String> acceptedDevices) {
            this.acceptedDevices.addAll(acceptedDevices);
            return this;
        }

        @Override
        public _FinalStage addAcceptedDevices(String acceptedDevices) {
            this.acceptedDevices.add(acceptedDevices);
            return this;
        }

        @Override
        @JsonSetter(value="accepted_devices", nulls=Nulls.SKIP)
        public _FinalStage acceptedDevices(List<String> acceptedDevices) {
            this.acceptedDevices.clear();
            this.acceptedDevices.addAll(acceptedDevices);
            return this;
        }

        @Override
        public _FinalStage addAllAcceptedProviders(List<String> acceptedProviders) {
            this.acceptedProviders.addAll(acceptedProviders);
            return this;
        }

        @Override
        public _FinalStage addAcceptedProviders(String acceptedProviders) {
            this.acceptedProviders.add(acceptedProviders);
            return this;
        }

        @Override
        @JsonSetter(value="accepted_providers", nulls=Nulls.SKIP)
        public _FinalStage acceptedProviders(List<String> acceptedProviders) {
            this.acceptedProviders.clear();
            this.acceptedProviders.addAll(acceptedProviders);
            return this;
        }

        @Override
        public _FinalStage connectedAccountId(String connectedAccountId) {
            this.connectedAccountId = Optional.of(connectedAccountId);
            return this;
        }

        @Override
        @JsonSetter(value="connected_account_id", nulls=Nulls.SKIP)
        public _FinalStage connectedAccountId(Optional<String> connectedAccountId) {
            this.connectedAccountId = connectedAccountId;
            return this;
        }

        @Override
        public ConnectWebview build() {
            return new ConnectWebview(this.connectWebviewId, this.connectedAccountId, this.url, this.workspaceId, this.deviceSelectionMode, this.acceptedProviders, this.acceptedDevices, this.anyProviderAllowed, this.anyDeviceAllowed, this.createdAt, this.loginSuccessful, this.status);
        }
    }

    public static interface _FinalStage {
        public ConnectWebview build();

        public _FinalStage connectedAccountId(Optional<String> var1);

        public _FinalStage connectedAccountId(String var1);

        public _FinalStage acceptedProviders(List<String> var1);

        public _FinalStage addAcceptedProviders(String var1);

        public _FinalStage addAllAcceptedProviders(List<String> var1);

        public _FinalStage acceptedDevices(List<String> var1);

        public _FinalStage addAcceptedDevices(String var1);

        public _FinalStage addAllAcceptedDevices(List<String> var1);
    }

    public static interface StatusStage {
        public _FinalStage status(ConnectWebviewStatus var1);
    }

    public static interface LoginSuccessfulStage {
        public StatusStage loginSuccessful(boolean var1);
    }

    public static interface CreatedAtStage {
        public LoginSuccessfulStage createdAt(OffsetDateTime var1);
    }

    public static interface AnyDeviceAllowedStage {
        public CreatedAtStage anyDeviceAllowed(boolean var1);
    }

    public static interface AnyProviderAllowedStage {
        public AnyDeviceAllowedStage anyProviderAllowed(boolean var1);
    }

    public static interface DeviceSelectionModeStage {
        public AnyProviderAllowedStage deviceSelectionMode(ConnectWebviewDeviceSelectionMode var1);
    }

    public static interface WorkspaceIdStage {
        public DeviceSelectionModeStage workspaceId(String var1);
    }

    public static interface UrlStage {
        public WorkspaceIdStage url(String var1);
    }

    public static interface ConnectWebviewIdStage {
        public UrlStage connectWebviewId(String var1);

        public Builder from(ConnectWebview var1);
    }
}

