/*
 * Decompiled with CFR 0.152.
 */
package com.seam.api.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.seam.api.types.Device;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class DevicesListResponse {
    private final List<Device> devices;
    private final boolean ok;

    private DevicesListResponse(List<Device> devices, boolean ok) {
        this.devices = devices;
        this.ok = ok;
    }

    @JsonProperty(value="devices")
    public List<Device> getDevices() {
        return this.devices;
    }

    @JsonProperty(value="ok")
    public boolean getOk() {
        return this.ok;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DevicesListResponse && this.equalTo((DevicesListResponse)other);
    }

    private boolean equalTo(DevicesListResponse other) {
        return this.devices.equals(other.devices) && this.ok == other.ok;
    }

    public int hashCode() {
        return Objects.hash(this.devices, this.ok);
    }

    public String toString() {
        return "DevicesListResponse{devices: " + this.devices + ", ok: " + this.ok + "}";
    }

    public static OkStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements OkStage,
    _FinalStage {
        private boolean ok;
        private List<Device> devices = new ArrayList<Device>();

        private Builder() {
        }

        @Override
        public Builder from(DevicesListResponse other) {
            this.devices(other.getDevices());
            this.ok(other.getOk());
            return this;
        }

        @Override
        @JsonSetter(value="ok")
        public _FinalStage ok(boolean ok) {
            this.ok = ok;
            return this;
        }

        @Override
        public _FinalStage addAllDevices(List<Device> devices) {
            this.devices.addAll(devices);
            return this;
        }

        @Override
        public _FinalStage addDevices(Device devices) {
            this.devices.add(devices);
            return this;
        }

        @Override
        @JsonSetter(value="devices", nulls=Nulls.SKIP)
        public _FinalStage devices(List<Device> devices) {
            this.devices.clear();
            this.devices.addAll(devices);
            return this;
        }

        @Override
        public DevicesListResponse build() {
            return new DevicesListResponse(this.devices, this.ok);
        }
    }

    public static interface _FinalStage {
        public DevicesListResponse build();

        public _FinalStage devices(List<Device> var1);

        public _FinalStage addDevices(Device var1);

        public _FinalStage addAllDevices(List<Device> var1);
    }

    public static interface OkStage {
        public _FinalStage ok(boolean var1);

        public Builder from(DevicesListResponse var1);
    }
}

