/*
 * Decompiled with CFR 0.152.
 */
package com.seam.api.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.seam.api.types.Event;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
public final class EventsListResponse {
    private final Optional<List<Event>> events;
    private final Optional<String> message;
    private final boolean ok;

    private EventsListResponse(Optional<List<Event>> events, Optional<String> message, boolean ok) {
        this.events = events;
        this.message = message;
        this.ok = ok;
    }

    @JsonProperty(value="events")
    public Optional<List<Event>> getEvents() {
        return this.events;
    }

    @JsonProperty(value="message")
    public Optional<String> getMessage() {
        return this.message;
    }

    @JsonProperty(value="ok")
    public boolean getOk() {
        return this.ok;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof EventsListResponse && this.equalTo((EventsListResponse)other);
    }

    private boolean equalTo(EventsListResponse other) {
        return this.events.equals(other.events) && this.message.equals(other.message) && this.ok == other.ok;
    }

    public int hashCode() {
        return Objects.hash(this.events, this.message, this.ok);
    }

    public String toString() {
        return "EventsListResponse{events: " + this.events + ", message: " + this.message + ", ok: " + this.ok + "}";
    }

    public static OkStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements OkStage,
    _FinalStage {
        private boolean ok;
        private Optional<String> message = Optional.empty();
        private Optional<List<Event>> events = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(EventsListResponse other) {
            this.events(other.getEvents());
            this.message(other.getMessage());
            this.ok(other.getOk());
            return this;
        }

        @Override
        @JsonSetter(value="ok")
        public _FinalStage ok(boolean ok) {
            this.ok = ok;
            return this;
        }

        @Override
        public _FinalStage message(String message) {
            this.message = Optional.of(message);
            return this;
        }

        @Override
        @JsonSetter(value="message", nulls=Nulls.SKIP)
        public _FinalStage message(Optional<String> message) {
            this.message = message;
            return this;
        }

        @Override
        public _FinalStage events(List<Event> events) {
            this.events = Optional.of(events);
            return this;
        }

        @Override
        @JsonSetter(value="events", nulls=Nulls.SKIP)
        public _FinalStage events(Optional<List<Event>> events) {
            this.events = events;
            return this;
        }

        @Override
        public EventsListResponse build() {
            return new EventsListResponse(this.events, this.message, this.ok);
        }
    }

    public static interface _FinalStage {
        public EventsListResponse build();

        public _FinalStage events(Optional<List<Event>> var1);

        public _FinalStage events(List<Event> var1);

        public _FinalStage message(Optional<String> var1);

        public _FinalStage message(String var1);
    }

    public static interface OkStage {
        public _FinalStage ok(boolean var1);

        public Builder from(EventsListResponse var1);
    }
}

