/*
 * Decompiled with CFR 0.152.
 */
package com.seam.api.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.seam.api.types.ServiceHealth;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
public final class HealthGetHealthResponse {
    private final boolean ok;
    private final Optional<String> lastServiceEvaluationAt;
    private final List<ServiceHealth> serviceHealthStatuses;

    private HealthGetHealthResponse(boolean ok, Optional<String> lastServiceEvaluationAt, List<ServiceHealth> serviceHealthStatuses) {
        this.ok = ok;
        this.lastServiceEvaluationAt = lastServiceEvaluationAt;
        this.serviceHealthStatuses = serviceHealthStatuses;
    }

    @JsonProperty(value="ok")
    public boolean getOk() {
        return this.ok;
    }

    @JsonProperty(value="msg")
    public String getMsg() {
        return "I\u2019m one with the Force. The Force is with me.";
    }

    @JsonProperty(value="last_service_evaluation_at")
    public Optional<String> getLastServiceEvaluationAt() {
        return this.lastServiceEvaluationAt;
    }

    @JsonProperty(value="service_health_statuses")
    public List<ServiceHealth> getServiceHealthStatuses() {
        return this.serviceHealthStatuses;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof HealthGetHealthResponse && this.equalTo((HealthGetHealthResponse)other);
    }

    private boolean equalTo(HealthGetHealthResponse other) {
        return this.ok == other.ok && this.lastServiceEvaluationAt.equals(other.lastServiceEvaluationAt) && this.serviceHealthStatuses.equals(other.serviceHealthStatuses);
    }

    public int hashCode() {
        return Objects.hash(this.ok, this.lastServiceEvaluationAt, this.serviceHealthStatuses);
    }

    public String toString() {
        return "HealthGetHealthResponse{ok: " + this.ok + ", lastServiceEvaluationAt: " + this.lastServiceEvaluationAt + ", serviceHealthStatuses: " + this.serviceHealthStatuses + "}";
    }

    public static OkStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements OkStage,
    _FinalStage {
        private boolean ok;
        private List<ServiceHealth> serviceHealthStatuses = new ArrayList<ServiceHealth>();
        private Optional<String> lastServiceEvaluationAt = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(HealthGetHealthResponse other) {
            this.ok(other.getOk());
            this.lastServiceEvaluationAt(other.getLastServiceEvaluationAt());
            this.serviceHealthStatuses(other.getServiceHealthStatuses());
            return this;
        }

        @Override
        @JsonSetter(value="ok")
        public _FinalStage ok(boolean ok) {
            this.ok = ok;
            return this;
        }

        @Override
        public _FinalStage addAllServiceHealthStatuses(List<ServiceHealth> serviceHealthStatuses) {
            this.serviceHealthStatuses.addAll(serviceHealthStatuses);
            return this;
        }

        @Override
        public _FinalStage addServiceHealthStatuses(ServiceHealth serviceHealthStatuses) {
            this.serviceHealthStatuses.add(serviceHealthStatuses);
            return this;
        }

        @Override
        @JsonSetter(value="service_health_statuses", nulls=Nulls.SKIP)
        public _FinalStage serviceHealthStatuses(List<ServiceHealth> serviceHealthStatuses) {
            this.serviceHealthStatuses.clear();
            this.serviceHealthStatuses.addAll(serviceHealthStatuses);
            return this;
        }

        @Override
        public _FinalStage lastServiceEvaluationAt(String lastServiceEvaluationAt) {
            this.lastServiceEvaluationAt = Optional.of(lastServiceEvaluationAt);
            return this;
        }

        @Override
        @JsonSetter(value="last_service_evaluation_at", nulls=Nulls.SKIP)
        public _FinalStage lastServiceEvaluationAt(Optional<String> lastServiceEvaluationAt) {
            this.lastServiceEvaluationAt = lastServiceEvaluationAt;
            return this;
        }

        @Override
        public HealthGetHealthResponse build() {
            return new HealthGetHealthResponse(this.ok, this.lastServiceEvaluationAt, this.serviceHealthStatuses);
        }
    }

    public static interface _FinalStage {
        public HealthGetHealthResponse build();

        public _FinalStage lastServiceEvaluationAt(Optional<String> var1);

        public _FinalStage lastServiceEvaluationAt(String var1);

        public _FinalStage serviceHealthStatuses(List<ServiceHealth> var1);

        public _FinalStage addServiceHealthStatuses(ServiceHealth var1);

        public _FinalStage addAllServiceHealthStatuses(List<ServiceHealth> var1);
    }

    public static interface OkStage {
        public _FinalStage ok(boolean var1);

        public Builder from(HealthGetHealthResponse var1);
    }
}

