/*
 * Decompiled with CFR 0.152.
 */
package com.seam.api.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
public final class NoiseThreshold {
    private final String noiseThresholdId;
    private final String deviceId;
    private final String name;
    private final Optional<Double> noiseThresholdNrs;
    private final String startsDailyAt;
    private final String endsDailyAt;
    private final double noiseThresholdDecibels;

    private NoiseThreshold(String noiseThresholdId, String deviceId, String name, Optional<Double> noiseThresholdNrs, String startsDailyAt, String endsDailyAt, double noiseThresholdDecibels) {
        this.noiseThresholdId = noiseThresholdId;
        this.deviceId = deviceId;
        this.name = name;
        this.noiseThresholdNrs = noiseThresholdNrs;
        this.startsDailyAt = startsDailyAt;
        this.endsDailyAt = endsDailyAt;
        this.noiseThresholdDecibels = noiseThresholdDecibels;
    }

    @JsonProperty(value="noise_threshold_id")
    public String getNoiseThresholdId() {
        return this.noiseThresholdId;
    }

    @JsonProperty(value="device_id")
    public String getDeviceId() {
        return this.deviceId;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="noise_threshold_nrs")
    public Optional<Double> getNoiseThresholdNrs() {
        return this.noiseThresholdNrs;
    }

    @JsonProperty(value="starts_daily_at")
    public String getStartsDailyAt() {
        return this.startsDailyAt;
    }

    @JsonProperty(value="ends_daily_at")
    public String getEndsDailyAt() {
        return this.endsDailyAt;
    }

    @JsonProperty(value="noise_threshold_decibels")
    public double getNoiseThresholdDecibels() {
        return this.noiseThresholdDecibels;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof NoiseThreshold && this.equalTo((NoiseThreshold)other);
    }

    private boolean equalTo(NoiseThreshold other) {
        return this.noiseThresholdId.equals(other.noiseThresholdId) && this.deviceId.equals(other.deviceId) && this.name.equals(other.name) && this.noiseThresholdNrs.equals(other.noiseThresholdNrs) && this.startsDailyAt.equals(other.startsDailyAt) && this.endsDailyAt.equals(other.endsDailyAt) && this.noiseThresholdDecibels == other.noiseThresholdDecibels;
    }

    public int hashCode() {
        return Objects.hash(this.noiseThresholdId, this.deviceId, this.name, this.noiseThresholdNrs, this.startsDailyAt, this.endsDailyAt, this.noiseThresholdDecibels);
    }

    public String toString() {
        return "NoiseThreshold{noiseThresholdId: " + this.noiseThresholdId + ", deviceId: " + this.deviceId + ", name: " + this.name + ", noiseThresholdNrs: " + this.noiseThresholdNrs + ", startsDailyAt: " + this.startsDailyAt + ", endsDailyAt: " + this.endsDailyAt + ", noiseThresholdDecibels: " + this.noiseThresholdDecibels + "}";
    }

    public static NoiseThresholdIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements NoiseThresholdIdStage,
    DeviceIdStage,
    NameStage,
    StartsDailyAtStage,
    EndsDailyAtStage,
    NoiseThresholdDecibelsStage,
    _FinalStage {
        private String noiseThresholdId;
        private String deviceId;
        private String name;
        private String startsDailyAt;
        private String endsDailyAt;
        private double noiseThresholdDecibels;
        private Optional<Double> noiseThresholdNrs = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(NoiseThreshold other) {
            this.noiseThresholdId(other.getNoiseThresholdId());
            this.deviceId(other.getDeviceId());
            this.name(other.getName());
            this.noiseThresholdNrs(other.getNoiseThresholdNrs());
            this.startsDailyAt(other.getStartsDailyAt());
            this.endsDailyAt(other.getEndsDailyAt());
            this.noiseThresholdDecibels(other.getNoiseThresholdDecibels());
            return this;
        }

        @Override
        @JsonSetter(value="noise_threshold_id")
        public DeviceIdStage noiseThresholdId(String noiseThresholdId) {
            this.noiseThresholdId = noiseThresholdId;
            return this;
        }

        @Override
        @JsonSetter(value="device_id")
        public NameStage deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public StartsDailyAtStage name(String name) {
            this.name = name;
            return this;
        }

        @Override
        @JsonSetter(value="starts_daily_at")
        public EndsDailyAtStage startsDailyAt(String startsDailyAt) {
            this.startsDailyAt = startsDailyAt;
            return this;
        }

        @Override
        @JsonSetter(value="ends_daily_at")
        public NoiseThresholdDecibelsStage endsDailyAt(String endsDailyAt) {
            this.endsDailyAt = endsDailyAt;
            return this;
        }

        @Override
        @JsonSetter(value="noise_threshold_decibels")
        public _FinalStage noiseThresholdDecibels(double noiseThresholdDecibels) {
            this.noiseThresholdDecibels = noiseThresholdDecibels;
            return this;
        }

        @Override
        public _FinalStage noiseThresholdNrs(Double noiseThresholdNrs) {
            this.noiseThresholdNrs = Optional.of(noiseThresholdNrs);
            return this;
        }

        @Override
        @JsonSetter(value="noise_threshold_nrs", nulls=Nulls.SKIP)
        public _FinalStage noiseThresholdNrs(Optional<Double> noiseThresholdNrs) {
            this.noiseThresholdNrs = noiseThresholdNrs;
            return this;
        }

        @Override
        public NoiseThreshold build() {
            return new NoiseThreshold(this.noiseThresholdId, this.deviceId, this.name, this.noiseThresholdNrs, this.startsDailyAt, this.endsDailyAt, this.noiseThresholdDecibels);
        }
    }

    public static interface _FinalStage {
        public NoiseThreshold build();

        public _FinalStage noiseThresholdNrs(Optional<Double> var1);

        public _FinalStage noiseThresholdNrs(Double var1);
    }

    public static interface NoiseThresholdDecibelsStage {
        public _FinalStage noiseThresholdDecibels(double var1);
    }

    public static interface EndsDailyAtStage {
        public NoiseThresholdDecibelsStage endsDailyAt(String var1);
    }

    public static interface StartsDailyAtStage {
        public EndsDailyAtStage startsDailyAt(String var1);
    }

    public static interface NameStage {
        public StartsDailyAtStage name(String var1);
    }

    public static interface DeviceIdStage {
        public NameStage deviceId(String var1);
    }

    public static interface NoiseThresholdIdStage {
        public DeviceIdStage noiseThresholdId(String var1);

        public Builder from(NoiseThreshold var1);
    }
}

