/*
 * Decompiled with CFR 0.152.
 */
package com.seam.api.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.seam.api.types.UnmanagedDevicePropertiesModel;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
public final class UnmanagedDeviceProperties {
    private final String name;
    private final boolean online;
    private final Optional<String> manufacturer;
    private final Optional<String> imageUrl;
    private final Optional<String> imageAltText;
    private final UnmanagedDevicePropertiesModel model;

    private UnmanagedDeviceProperties(String name, boolean online, Optional<String> manufacturer, Optional<String> imageUrl, Optional<String> imageAltText, UnmanagedDevicePropertiesModel model) {
        this.name = name;
        this.online = online;
        this.manufacturer = manufacturer;
        this.imageUrl = imageUrl;
        this.imageAltText = imageAltText;
        this.model = model;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="online")
    public boolean getOnline() {
        return this.online;
    }

    @JsonProperty(value="manufacturer")
    public Optional<String> getManufacturer() {
        return this.manufacturer;
    }

    @JsonProperty(value="image_url")
    public Optional<String> getImageUrl() {
        return this.imageUrl;
    }

    @JsonProperty(value="image_alt_text")
    public Optional<String> getImageAltText() {
        return this.imageAltText;
    }

    @JsonProperty(value="model")
    public UnmanagedDevicePropertiesModel getModel() {
        return this.model;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UnmanagedDeviceProperties && this.equalTo((UnmanagedDeviceProperties)other);
    }

    private boolean equalTo(UnmanagedDeviceProperties other) {
        return this.name.equals(other.name) && this.online == other.online && this.manufacturer.equals(other.manufacturer) && this.imageUrl.equals(other.imageUrl) && this.imageAltText.equals(other.imageAltText) && this.model.equals(other.model);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.online, this.manufacturer, this.imageUrl, this.imageAltText, this.model);
    }

    public String toString() {
        return "UnmanagedDeviceProperties{name: " + this.name + ", online: " + this.online + ", manufacturer: " + this.manufacturer + ", imageUrl: " + this.imageUrl + ", imageAltText: " + this.imageAltText + ", model: " + this.model + "}";
    }

    public static NameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements NameStage,
    OnlineStage,
    ModelStage,
    _FinalStage {
        private String name;
        private boolean online;
        private UnmanagedDevicePropertiesModel model;
        private Optional<String> imageAltText = Optional.empty();
        private Optional<String> imageUrl = Optional.empty();
        private Optional<String> manufacturer = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(UnmanagedDeviceProperties other) {
            this.name(other.getName());
            this.online(other.getOnline());
            this.manufacturer(other.getManufacturer());
            this.imageUrl(other.getImageUrl());
            this.imageAltText(other.getImageAltText());
            this.model(other.getModel());
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public OnlineStage name(String name) {
            this.name = name;
            return this;
        }

        @Override
        @JsonSetter(value="online")
        public ModelStage online(boolean online) {
            this.online = online;
            return this;
        }

        @Override
        @JsonSetter(value="model")
        public _FinalStage model(UnmanagedDevicePropertiesModel model) {
            this.model = model;
            return this;
        }

        @Override
        public _FinalStage imageAltText(String imageAltText) {
            this.imageAltText = Optional.of(imageAltText);
            return this;
        }

        @Override
        @JsonSetter(value="image_alt_text", nulls=Nulls.SKIP)
        public _FinalStage imageAltText(Optional<String> imageAltText) {
            this.imageAltText = imageAltText;
            return this;
        }

        @Override
        public _FinalStage imageUrl(String imageUrl) {
            this.imageUrl = Optional.of(imageUrl);
            return this;
        }

        @Override
        @JsonSetter(value="image_url", nulls=Nulls.SKIP)
        public _FinalStage imageUrl(Optional<String> imageUrl) {
            this.imageUrl = imageUrl;
            return this;
        }

        @Override
        public _FinalStage manufacturer(String manufacturer) {
            this.manufacturer = Optional.of(manufacturer);
            return this;
        }

        @Override
        @JsonSetter(value="manufacturer", nulls=Nulls.SKIP)
        public _FinalStage manufacturer(Optional<String> manufacturer) {
            this.manufacturer = manufacturer;
            return this;
        }

        @Override
        public UnmanagedDeviceProperties build() {
            return new UnmanagedDeviceProperties(this.name, this.online, this.manufacturer, this.imageUrl, this.imageAltText, this.model);
        }
    }

    public static interface _FinalStage {
        public UnmanagedDeviceProperties build();

        public _FinalStage manufacturer(Optional<String> var1);

        public _FinalStage manufacturer(String var1);

        public _FinalStage imageUrl(Optional<String> var1);

        public _FinalStage imageUrl(String var1);

        public _FinalStage imageAltText(Optional<String> var1);

        public _FinalStage imageAltText(String var1);
    }

    public static interface ModelStage {
        public _FinalStage model(UnmanagedDevicePropertiesModel var1);
    }

    public static interface OnlineStage {
        public ModelStage online(boolean var1);
    }

    public static interface NameStage {
        public OnlineStage name(String var1);

        public Builder from(UnmanagedDeviceProperties var1);
    }
}

