/*
 * Decompiled with CFR 0.152.
 */
package com.seam.api.resources.accesscodes.requests;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.seam.api.types.AccessCodesCreateMultipleRequestBehaviorWhenCodeCannotBeShared;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
public final class AccessCodesCreateMultipleRequest {
    private final List<String> deviceIds;
    private final Optional<AccessCodesCreateMultipleRequestBehaviorWhenCodeCannotBeShared> behaviorWhenCodeCannotBeShared;
    private final Optional<String> name;
    private final Optional<String> startsAt;
    private final Optional<String> endsAt;
    private final Optional<String> code;
    private final Optional<Boolean> attemptForOfflineDevice;
    private final Optional<Boolean> preferNativeScheduling;
    private final Optional<Boolean> useBackupAccessCodePool;

    private AccessCodesCreateMultipleRequest(List<String> deviceIds, Optional<AccessCodesCreateMultipleRequestBehaviorWhenCodeCannotBeShared> behaviorWhenCodeCannotBeShared, Optional<String> name, Optional<String> startsAt, Optional<String> endsAt, Optional<String> code, Optional<Boolean> attemptForOfflineDevice, Optional<Boolean> preferNativeScheduling, Optional<Boolean> useBackupAccessCodePool) {
        this.deviceIds = deviceIds;
        this.behaviorWhenCodeCannotBeShared = behaviorWhenCodeCannotBeShared;
        this.name = name;
        this.startsAt = startsAt;
        this.endsAt = endsAt;
        this.code = code;
        this.attemptForOfflineDevice = attemptForOfflineDevice;
        this.preferNativeScheduling = preferNativeScheduling;
        this.useBackupAccessCodePool = useBackupAccessCodePool;
    }

    @JsonProperty(value="device_ids")
    public List<String> getDeviceIds() {
        return this.deviceIds;
    }

    @JsonProperty(value="behavior_when_code_cannot_be_shared")
    public Optional<AccessCodesCreateMultipleRequestBehaviorWhenCodeCannotBeShared> getBehaviorWhenCodeCannotBeShared() {
        return this.behaviorWhenCodeCannotBeShared;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="starts_at")
    public Optional<String> getStartsAt() {
        return this.startsAt;
    }

    @JsonProperty(value="ends_at")
    public Optional<String> getEndsAt() {
        return this.endsAt;
    }

    @JsonProperty(value="code")
    public Optional<String> getCode() {
        return this.code;
    }

    @JsonProperty(value="attempt_for_offline_device")
    public Optional<Boolean> getAttemptForOfflineDevice() {
        return this.attemptForOfflineDevice;
    }

    @JsonProperty(value="prefer_native_scheduling")
    public Optional<Boolean> getPreferNativeScheduling() {
        return this.preferNativeScheduling;
    }

    @JsonProperty(value="use_backup_access_code_pool")
    public Optional<Boolean> getUseBackupAccessCodePool() {
        return this.useBackupAccessCodePool;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof AccessCodesCreateMultipleRequest && this.equalTo((AccessCodesCreateMultipleRequest)other);
    }

    private boolean equalTo(AccessCodesCreateMultipleRequest other) {
        return this.deviceIds.equals(other.deviceIds) && this.behaviorWhenCodeCannotBeShared.equals(other.behaviorWhenCodeCannotBeShared) && this.name.equals(other.name) && this.startsAt.equals(other.startsAt) && this.endsAt.equals(other.endsAt) && this.code.equals(other.code) && this.attemptForOfflineDevice.equals(other.attemptForOfflineDevice) && this.preferNativeScheduling.equals(other.preferNativeScheduling) && this.useBackupAccessCodePool.equals(other.useBackupAccessCodePool);
    }

    public int hashCode() {
        return Objects.hash(this.deviceIds, this.behaviorWhenCodeCannotBeShared, this.name, this.startsAt, this.endsAt, this.code, this.attemptForOfflineDevice, this.preferNativeScheduling, this.useBackupAccessCodePool);
    }

    public String toString() {
        return "AccessCodesCreateMultipleRequest{deviceIds: " + this.deviceIds + ", behaviorWhenCodeCannotBeShared: " + this.behaviorWhenCodeCannotBeShared + ", name: " + this.name + ", startsAt: " + this.startsAt + ", endsAt: " + this.endsAt + ", code: " + this.code + ", attemptForOfflineDevice: " + this.attemptForOfflineDevice + ", preferNativeScheduling: " + this.preferNativeScheduling + ", useBackupAccessCodePool: " + this.useBackupAccessCodePool + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private List<String> deviceIds = new ArrayList<String>();
        private Optional<AccessCodesCreateMultipleRequestBehaviorWhenCodeCannotBeShared> behaviorWhenCodeCannotBeShared = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<String> startsAt = Optional.empty();
        private Optional<String> endsAt = Optional.empty();
        private Optional<String> code = Optional.empty();
        private Optional<Boolean> attemptForOfflineDevice = Optional.empty();
        private Optional<Boolean> preferNativeScheduling = Optional.empty();
        private Optional<Boolean> useBackupAccessCodePool = Optional.empty();

        private Builder() {
        }

        public Builder from(AccessCodesCreateMultipleRequest other) {
            this.deviceIds(other.getDeviceIds());
            this.behaviorWhenCodeCannotBeShared(other.getBehaviorWhenCodeCannotBeShared());
            this.name(other.getName());
            this.startsAt(other.getStartsAt());
            this.endsAt(other.getEndsAt());
            this.code(other.getCode());
            this.attemptForOfflineDevice(other.getAttemptForOfflineDevice());
            this.preferNativeScheduling(other.getPreferNativeScheduling());
            this.useBackupAccessCodePool(other.getUseBackupAccessCodePool());
            return this;
        }

        @JsonSetter(value="device_ids", nulls=Nulls.SKIP)
        public Builder deviceIds(List<String> deviceIds) {
            this.deviceIds.clear();
            this.deviceIds.addAll(deviceIds);
            return this;
        }

        public Builder addDeviceIds(String deviceIds) {
            this.deviceIds.add(deviceIds);
            return this;
        }

        public Builder addAllDeviceIds(List<String> deviceIds) {
            this.deviceIds.addAll(deviceIds);
            return this;
        }

        @JsonSetter(value="behavior_when_code_cannot_be_shared", nulls=Nulls.SKIP)
        public Builder behaviorWhenCodeCannotBeShared(Optional<AccessCodesCreateMultipleRequestBehaviorWhenCodeCannotBeShared> behaviorWhenCodeCannotBeShared) {
            this.behaviorWhenCodeCannotBeShared = behaviorWhenCodeCannotBeShared;
            return this;
        }

        public Builder behaviorWhenCodeCannotBeShared(AccessCodesCreateMultipleRequestBehaviorWhenCodeCannotBeShared behaviorWhenCodeCannotBeShared) {
            this.behaviorWhenCodeCannotBeShared = Optional.of(behaviorWhenCodeCannotBeShared);
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.of(name);
            return this;
        }

        @JsonSetter(value="starts_at", nulls=Nulls.SKIP)
        public Builder startsAt(Optional<String> startsAt) {
            this.startsAt = startsAt;
            return this;
        }

        public Builder startsAt(String startsAt) {
            this.startsAt = Optional.of(startsAt);
            return this;
        }

        @JsonSetter(value="ends_at", nulls=Nulls.SKIP)
        public Builder endsAt(Optional<String> endsAt) {
            this.endsAt = endsAt;
            return this;
        }

        public Builder endsAt(String endsAt) {
            this.endsAt = Optional.of(endsAt);
            return this;
        }

        @JsonSetter(value="code", nulls=Nulls.SKIP)
        public Builder code(Optional<String> code) {
            this.code = code;
            return this;
        }

        public Builder code(String code) {
            this.code = Optional.of(code);
            return this;
        }

        @JsonSetter(value="attempt_for_offline_device", nulls=Nulls.SKIP)
        public Builder attemptForOfflineDevice(Optional<Boolean> attemptForOfflineDevice) {
            this.attemptForOfflineDevice = attemptForOfflineDevice;
            return this;
        }

        public Builder attemptForOfflineDevice(Boolean attemptForOfflineDevice) {
            this.attemptForOfflineDevice = Optional.of(attemptForOfflineDevice);
            return this;
        }

        @JsonSetter(value="prefer_native_scheduling", nulls=Nulls.SKIP)
        public Builder preferNativeScheduling(Optional<Boolean> preferNativeScheduling) {
            this.preferNativeScheduling = preferNativeScheduling;
            return this;
        }

        public Builder preferNativeScheduling(Boolean preferNativeScheduling) {
            this.preferNativeScheduling = Optional.of(preferNativeScheduling);
            return this;
        }

        @JsonSetter(value="use_backup_access_code_pool", nulls=Nulls.SKIP)
        public Builder useBackupAccessCodePool(Optional<Boolean> useBackupAccessCodePool) {
            this.useBackupAccessCodePool = useBackupAccessCodePool;
            return this;
        }

        public Builder useBackupAccessCodePool(Boolean useBackupAccessCodePool) {
            this.useBackupAccessCodePool = Optional.of(useBackupAccessCodePool);
            return this;
        }

        public AccessCodesCreateMultipleRequest build() {
            return new AccessCodesCreateMultipleRequest(this.deviceIds, this.behaviorWhenCodeCannotBeShared, this.name, this.startsAt, this.endsAt, this.code, this.attemptForOfflineDevice, this.preferNativeScheduling, this.useBackupAccessCodePool);
        }
    }
}

