/*
 * Decompiled with CFR 0.152.
 */
package com.seam.api.resources.events;

import com.seam.api.core.ClientOptions;
import com.seam.api.core.ObjectMappers;
import com.seam.api.resources.events.requests.EventsGetRequest;
import com.seam.api.resources.events.requests.EventsListRequest;
import com.seam.api.types.EventsGetResponse;
import com.seam.api.types.EventsListResponse;
import java.util.HashMap;
import java.util.Optional;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class EventsClient {
    protected final ClientOptions clientOptions;

    public EventsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public EventsGetResponse get(EventsGetRequest request) {
        RequestBody _requestBody;
        HttpUrl _httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("events/get").build();
        HashMap<String, Optional<String>> _requestBodyProperties = new HashMap<String, Optional<String>>();
        _requestBodyProperties.put("event_id", request.getEventId());
        _requestBodyProperties.put("event_type", request.getEventType());
        _requestBodyProperties.put("device_id", request.getDeviceId());
        try {
            _requestBody = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes(_requestBodyProperties), (MediaType)MediaType.parse((String)"application/json"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(_httpUrl).method("POST", _requestBody).headers(Headers.of(this.clientOptions.headers())).addHeader("Content-Type", "application/json");
        Request _request = _requestBuilder.build();
        try {
            Response _response = this.clientOptions.httpClient().newCall(_request).execute();
            if (_response.isSuccessful()) {
                return (EventsGetResponse)ObjectMappers.JSON_MAPPER.readValue(_response.body().string(), EventsGetResponse.class);
            }
            throw new RuntimeException();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public EventsListResponse list(EventsListRequest request) {
        RequestBody _requestBody;
        HttpUrl _httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("events/list").build();
        HashMap<String, Optional<Object>> _requestBodyProperties = new HashMap<String, Optional<Object>>();
        _requestBodyProperties.put("since", request.getSince());
        _requestBodyProperties.put("between", request.getBetween());
        _requestBodyProperties.put("device_id", request.getDeviceId());
        _requestBodyProperties.put("device_ids", request.getDeviceIds());
        _requestBodyProperties.put("access_code_id", request.getAccessCodeId());
        _requestBodyProperties.put("access_code_ids", request.getAccessCodeIds());
        _requestBodyProperties.put("event_type", request.getEventType());
        _requestBodyProperties.put("event_types", request.getEventTypes());
        _requestBodyProperties.put("connected_account_id", request.getConnectedAccountId());
        try {
            _requestBody = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes(_requestBodyProperties), (MediaType)MediaType.parse((String)"application/json"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(_httpUrl).method("POST", _requestBody).headers(Headers.of(this.clientOptions.headers())).addHeader("Content-Type", "application/json");
        Request _request = _requestBuilder.build();
        try {
            Response _response = this.clientOptions.httpClient().newCall(_request).execute();
            if (_response.isSuccessful()) {
                return (EventsListResponse)ObjectMappers.JSON_MAPPER.readValue(_response.body().string(), EventsListResponse.class);
            }
            throw new RuntimeException();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

