/*
 * Decompiled with CFR 0.152.
 */
package com.seam.api.resources.health;

import com.seam.api.core.ClientOptions;
import com.seam.api.core.ObjectMappers;
import com.seam.api.core.Suppliers;
import com.seam.api.resources.health.requests.HealthGetServiceHealthRequest;
import com.seam.api.resources.health.service.ServiceClient;
import com.seam.api.types.HealthGetHealthResponse;
import com.seam.api.types.HealthGetServiceHealthResponse;
import java.util.HashMap;
import java.util.function.Supplier;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class HealthClient {
    protected final ClientOptions clientOptions;
    protected final Supplier<ServiceClient> serviceClient;

    public HealthClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.serviceClient = Suppliers.memoize(() -> new ServiceClient(clientOptions));
    }

    public HealthGetHealthResponse getHealth() {
        HttpUrl _httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("health/get_health").build();
        Request _request = new Request.Builder().url(_httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers())).addHeader("Content-Type", "application/json").build();
        try {
            Response _response = this.clientOptions.httpClient().newCall(_request).execute();
            if (_response.isSuccessful()) {
                return (HealthGetHealthResponse)ObjectMappers.JSON_MAPPER.readValue(_response.body().string(), HealthGetHealthResponse.class);
            }
            throw new RuntimeException();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public HealthGetServiceHealthResponse getServiceHealth(HealthGetServiceHealthRequest request) {
        RequestBody _requestBody;
        HttpUrl _httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("health/get_service_health").build();
        HashMap<String, String> _requestBodyProperties = new HashMap<String, String>();
        _requestBodyProperties.put("service", request.getService());
        try {
            _requestBody = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes(_requestBodyProperties), (MediaType)MediaType.parse((String)"application/json"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(_httpUrl).method("POST", _requestBody).headers(Headers.of(this.clientOptions.headers())).addHeader("Content-Type", "application/json");
        Request _request = _requestBuilder.build();
        try {
            Response _response = this.clientOptions.httpClient().newCall(_request).execute();
            if (_response.isSuccessful()) {
                return (HealthGetServiceHealthResponse)ObjectMappers.JSON_MAPPER.readValue(_response.body().string(), HealthGetServiceHealthResponse.class);
            }
            throw new RuntimeException();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ServiceClient service() {
        return this.serviceClient.get();
    }
}

